#ifndef __G5_H_
#define __G5_H_

#include <glib.h>

#include "coordinate.h"

/* Minimal board size (for it not to mess up) 10x10.
 */
#define BOARD_XSIZE	20
#define BOARD_YSIZE	20

/* Empty Square */
#define NONE		0

typedef struct {
	int starter; /* Which player starts */
	gboolean clear_board; /* Clear board after win */
	gboolean allow_undo; /* Allow undo's and redo's */
} GlobalOptions;

typedef enum {PLAYER_HUMAN = 0, PLAYER_AI} PlayerType;

/* None, 1, or 2 */
typedef char Square;

typedef struct {
	int score;
	char *name; /* The name of the player */
	PlayerType pt;
/*	struct {
	} HumanPlayer;*/
	struct {
		int level;
	} ai_player;
} PlayerOptions;

void game_move_make(Coordinate *move);
void game_square_modify(Coordinate *move, PlayerType mover);
void game_play(void);
void game_init(void);
void game_init_play(void);
void game_restart(void);
void score_init(void);

#endif
