# First draft 05/16/96    Jianjun

#constrct a FitsHeader object
# FitsHeader FitsHeaderObjName FitsFileObjName chdu


class FitsHeader {

    constructor {args} {}
    destructor  {} 

    public method makeHeader {}
    public method refresh {}
    public method closeCmd {}
    public method insertAbove {} 
    public method deleteRec {} 
    public method bringToFront {}
    public method setFileName { fName }

    private method UndoCmd  {}
    private method CopyCmd  {}
    private method CutCmd   {}
    private method PasteCmd {}
    private method ClearCmd {}
    
    private method changeKey {} 
    private method saveAsFile {}
    private method saveHeaderToAscii {} 
    private method clickSelectLine {} 
    private method selectLine {line} 
    private method popTheMenu {x y} 
    private method setEditStatus {}
    private method searchStr {} 
    private method saveFile {}
    private method closeFrWm {w} 
    private method caseSel {}
    private method moveLine {mode} 
    private method cleanEmptyInsert {}
    private method dispKeys {}
    private method updateRestDisps {}
    private method recAction {action}
    private method insKey {pos rec} 
    private method delKey {pos} 
    private method createChecksum {}
    private method verifyChecksum {}
    private method postMenus {}
    private method updateHL {}
    private method highlightValue {}
    
    public variable fFObj
    
    private variable droot
    private variable fileName
    private variable mBar
    private variable allHeader
    private variable ablehighLightColor yellow
    private variable disablehighLightColor tan
    private variable selLine 0
    private variable editStatus "append"
    private variable keyList 
    private variable isFailedToCopy 0
    private variable father
    private variable caseOption "-nocase"
    private variable isRequired 0
    private variable insertDone 1
    private variable chdu
    private variable actionRec {} 
    private variable backUpRec ""

    protected variable isBeingDestroyed 0

    private variable modifiedKey
}

body FitsHeader::constructor {args} {

    #use the FitsFile class to handle the fits files.
    set fFObj [lindex $args 0]
    set fFObj FitsExtension::$fFObj
    set father [lindex $args 1]

    set chdu           [$fFObj cget -chdu]
    set isFailedToCopy [$fFObj cget -isFailedToCopy]
    set fileName       [$fFObj getOrigName]

# Header info
    set allHeader  [eval $fFObj dumpHeader]

    $father addChild $this header
}

body  FitsHeader::destructor {} {

    set isBeingDestroyed 1
    destroy $droot

    $father freeChild $this
}


body FitsHeader::refresh {} {
    set allHeader [eval $fFObj dumpHeader]
# rewrite keys
    dispKeys
# clean up the highlighted keys
    selectLine 1
}


body FitsHeader::setFileName { fName } {
   set fileName $fName
   set rName [urlTail $fName]
   set dName [getFullDirPath $fName]
   .fvwinkeeper signoff  $droot
   .fvwinkeeper register $droot Header $rName $chdu $this
   wm title      $droot "fv: Header of $rName\[[expr $chdu-1]\] in $dName"
}

body FitsHeader::makeHeader {} {
    global isMac isWin

    if { $isMac } {
	set cmdkey "Cmd"
    } else {
	set cmdkey "Alt"
    }
    
    # Display parameter
    catch  {destroy $droot}
    
    set droot .[namespace tail $this]
    powToplevel  $droot .dummy
    setFileName $fileName

    bind $droot <Double-1> {
    }
    bind $droot <Triple-1> {
    }
    bind $droot <B1-Motion> {
    }
# bind <Button-1> for the selection
    bind $droot <Up> [code $this moveLine -1]
    bind $droot <Down> [code $this moveLine 1]
    bind $droot <Destroy> +[code $this closeFrWm %W]
    
    # Bind window to menu events

    bind $droot <<SaveFile>>    [code $this saveFile]
    bind $droot <<SaveFileAs>>  [code $this saveAsFile]
    bind $droot <<Export>>      [code $this saveHeaderToAscii]
    bind $droot <<CloseWindow>> [code $this closeCmd]

    bind $droot <<Undo>>        [code $this UndoCmd]
    bind $droot <<Copy>>        [code $this CopyCmd]
    bind $droot <<Cut>>         [code $this CutCmd]
    bind $droot <<Paste>>       [code $this PasteCmd]
    bind $droot <<Clear>>       [code $this ClearCmd]
    
    bind $droot <<Delete>>      [code $this deleteRec]
    bind $droot <<Insert>>      [code $this insertAbove]
    
    bind $droot <<PostMenus>>   [code $this postMenus]

    bind $droot <<CreateChecksum>>  [code $this createChecksum]
    bind $droot <<VerifyChecksum>>  [code $this verifyChecksum]
    
    # Create toplevel MenuBar

    if { $isMac } {
        set mBar .mbar.header
        set evtWndw ""
    } else {
        set mBar $droot.mbar
        set evtWndw $droot
    }
    $droot config -menu $mBar
    
    if { ![winfo exists $mBar] } {
        menu $mBar
        if { $isMac } {
            $mBar add cascade -menu $mBar.apple
            $mBar add cascade -menu $mBar.file  -label File
            $mBar add cascade -menu $mBar.edit  -label Edit
            $mBar add cascade -menu $mBar.tool  -label Tools
            $mBar add cascade -menu .mbar.wind  -label Windows
            $mBar add cascade -menu $mBar.help  -label Help
            buildApplMenu $mBar.apple
        } else {
            $mBar add cascade -menu $mBar.file -label File
            $mBar add cascade -menu $mBar.edit -label Edit
            $mBar add cascade -menu $mBar.tool -label Tools
            $mBar add cascade -menu $mBar.help -label Help
        }

        # FILE

        if { $isMac } {
            buildFileMenu $mBar.file
            $mBar.file entryconfig "Export" -label "Export as Text..." \
                -state normal
            $mBar.file entryconfig "Save As..." -state normal
            $mBar.file entryconfig "Close"      -state normal
        } else {
            menu $mBar.file -tearoff False
            $mBar.file add command -label "Save" -underline 0 \
                -command "doMenuEvent <<SaveFile>>" -accelerator "$cmdkey+S"
            $mBar.file add command -label "Export as Text..." \
                -command "doMenuEvent <<Export>>"
            $mBar.file add command -label "Close" \
                -command "doMenuEvent <<CloseWindow>>" -accelerator "$cmdkey+W"
        }
        
        # EDIT
            
        buildEditMenu $mBar.edit
        
        $mBar.edit insert "Prefer*" command -label "Insert Key" \
              -command "doMenuEvent <<Insert>>"
        $mBar.edit insert "Prefer*" command -label "Delete Key" \
              -command "doMenuEvent <<Delete>>"
        $mBar.edit insert "Prefer*" separator

        # TOOLS

        menu $mBar.tool -tearoff False
        $mBar.tool add command -label "Create Checksum" \
            -command "doMenuEvent <<CreateChecksum>>"
        $mBar.tool add command -label "Verify Checksum" \
            -command "doMenuEvent <<VerifyChecksum>>"

        # HELP

        buildHelpMenu $mBar.help headerDisplay "Header Display"
        
        # Configure the Post Commands

        if { $isMac || $isWin } {
            
            # The Mac and Windows post all menus at once, so we only need
            # to do the post on the top level
            
            $mBar configure -postcommand "doMenuEvent <<PostMenus>> $evtWndw"

        } else {
            
            # Unix has to post each individual menu

            $mBar.file configure -postcommand \
                    "doMenuEvent <<PostMenus>> $evtWndw"
            $mBar.edit configure -postcommand \
                    "doMenuEvent <<PostMenus>> $evtWndw"
            $mBar.tool configure -postcommand \
                    "doMenuEvent <<PostMenus>> $evtWndw"
        }
    }
    
    frame $droot.toolbar -relief raised -bd 1
    pack  $droot.toolbar -side top -fill x -expand 0
    label $droot.toolbar.lfind -text "Search for:" 
    entry $droot.toolbar.efind 
    button $droot.toolbar.sfind -text "Find"  \
	-command [code $this searchStr] 

    label  $droot.toolbar.casel -text "Case sensitive?"
    button $droot.toolbar.case -text No -command [code $this caseSel]
    pack $droot.toolbar.lfind -side left 
    pack $droot.toolbar.efind -side left
    pack $droot.toolbar.sfind -side left 
    pack $droot.toolbar.casel -side left
    pack $droot.toolbar.case  -side left
#
    bind $droot.toolbar.efind <Return> [code $this searchStr]
#
    text $droot.text -wrap none -width 80 -relief sunken -bd 1 \
	-xscrollcommand "$droot.xscroll set" \
	-yscrollcommand "$droot.scroll set"  -font entryFont

    if { ![winfo exist .popmenu] } {
#       buildEditMenu .popmenu
        menu .popmenu 
        .popmenu add command -label "Undo"   -command "doMenuEvent <<Undo>>"
        .popmenu add command -label "Insert" -command "doMenuEvent <<Insert>>"
        .popmenu add command -label "Delete" -command "doMenuEvent <<Delete>>"
    }

    bind $droot.text <1> +[code $this clickSelectLine]

# bin <Button-3> for the popup menu
    bind $droot.text <3> [code $this popTheMenu %X %Y]    
    bind $droot.text <Control-ButtonPress-1> [code $this popTheMenu %X %Y]    

    scrollbar $droot.scroll -command "$droot.text yview" 
    scrollbar $droot.xscroll -orient horizontal -command "$droot.text xview" 
    
    entry $droot.text2 -width 80   -relief sunken -bd 1 -font entryFont \
	-textvariable [scope modifiedKey]
    pack $droot.text2  -side bottom -fill y -anchor w
    bind $droot.text2 <Return> [code $this changeKey]
    bind $droot.text2 <<Clear>> "[code $this ClearCmd];break"
    
    pack $droot.scroll -side right -fill y -expand 0     
    pack $droot.xscroll -side bottom -fill x -expand 0     
    pack $droot.text  -side left -fill both -expand 1

    dispKeys

}

body FitsHeader::postMenus {} {
   global isMac
   
   setEditStatus
   if { [$fFObj isFileChanged] && ![$fFObj isReadOnly] } {
      $mBar.file entryconfigure Save -state normal
   } else {
      $mBar.file entryconfigure Save -state disabled
   }
   update idle
}


body FitsHeader::bringToFront {} {
   if { ![winfo ismapped $droot] } {
       wm deiconify $droot
   }
   raise $droot
   focus $droot
}


body FitsHeader::dispKeys {} {
    $droot.text configure -state normal
    $droot.text delete 1.0 end 
    $droot.text insert 0.0 $allHeader
    set tmpNumKwds [$droot.text index end]
    $droot.text insert end "END"
    set keyList {}
# there are two blank space needs to be  removed. 
    for {set i 1} { $i< [expr $tmpNumKwds-1]} {incr i} {
	lappend keyList [$droot.text get $i.0 $i.8]
    }
#    $droot.text configure -state disabled
    $droot.text configure -state disabled
# set up a mark for search
    $droot.text mark set smark 1.0    
}

body FitsHeader::caseSel {} {
    if { [$droot.toolbar.case cget  -text] == "Yes"} {
	$droot.toolbar.case configure -text No
	set caseOption "-nocase"
    } else {
	$droot.toolbar.case configure -text Yes
	set caseOption ""

    }
}

body FitsHeader::popTheMenu {x y} {
    setEditStatus
    tk_popup .popmenu $x $y 
}

body FitsHeader::setEditStatus {} {

    #        selLine    isFailed  actionRec   clipboard
    # Undo                           Y
    # Copy     Y
    # Cut      Y           N
    # Paste    Y           N                      Y
    # Clear    Y           N
    # Insert   Y           N
    # Delete   Y           N

    if { [llength $actionRec] == 0 } {
	$mBar.edit entryconfigure Undo  -state disabled
	.popmenu entryconfigure Undo -state disabled
    } else { 
	$mBar.edit entryconfigure Undo  -state normal
	.popmenu entryconfigure Undo -state normal
    }

    if { $selLine == 0 } {
	$mBar.edit entryconfigure "Copy"  -state disabled
    } else {
	$mBar.edit entryconfigure "Copy"  -state normal
    }
    
    if { $selLine != 0 && $isFailedToCopy == 0 } {
	.popmenu entryconfigure Insert -state normal
	.popmenu entryconfigure Delete -state normal
	$mBar.edit entryconfigure "Insert*"  -state normal
	$mBar.edit entryconfigure "Delete*"  -state normal
	$mBar.edit entryconfigure "Cut*"     -state normal
	$mBar.edit entryconfigure "Clear"    -state normal
	if { [lindex [fvClipBoard report] 0]=="keyword" } {
	    $mBar.edit entryconfigure "Paste"  -state normal
	} else {
	    $mBar.edit entryconfigure "Paste"  -state disabled
	}
	
    } else {
	.popmenu entryconfigure Delete -state disabled 
	.popmenu entryconfigure Insert -state disabled  
	$mBar.edit entryconfigure "Delete*" -state disabled
	$mBar.edit entryconfigure "Insert*" -state disabled
	$mBar.edit entryconfigure "Cut*"    -state disabled
	$mBar.edit entryconfigure "Clear"   -state disabled
	$mBar.edit entryconfigure "Paste"   -state disabled
    }
}



body FitsHeader::searchStr {} {
# get the string from entry and find out the line and column number
    set fStr [$droot.toolbar.efind get]
    if { $fStr == ""} return
    set fPos [eval $droot.text search $caseOption -forward {$fStr} smark ]
    if { $fPos == ""} return
    scan $fPos "%d.%d" curLine curCol

    selectLine $curLine
    highlightValue

# if doesn't exist, beep; else highlight
    if { $fPos == "" } {
	bell
    } else {
	$droot.text mark set smark $curLine.[expr $curCol+2]
	$droot.text see smark
	$droot.text tag delete foundStr
	$droot.text tag add foundStr ${curLine}.${curCol} \
	    ${curLine}.[expr $curCol+[string length $fStr]]
	$droot.text tag configure foundStr -background grey -borderwidth 2 \
	    -relief raised
    }
}

body FitsHeader::insertAbove {} {
# delete the previous imcomplete insertion
    cleanEmptyInsert

    if { $isRequired > 1} return

    $droot.text configure -state normal
    $droot.text insert $selLine.0 "                                                                                \n"
    $droot.text configure -state disabled
    selectLine $selLine
    focus $droot.text2
# reset parameters
    set modifiedKey ""
    set insertDone 0
    set editStatus "insert"
}

body FitsHeader::clickSelectLine {} {
    cleanEmptyInsert

    set pos [$droot.text index current]
    set line [lindex [split $pos .] 0]
    selectLine $line
    highlightValue
}    
     
body FitsHeader::cleanEmptyInsert {} {
# if one is inserting a new key, and he moves the highlight. Then the inserting 
# is canceled, clean the blank line
    if { ($insertDone != 0) || ($editStatus != "insert")} {
	return
    } 

    $droot.text configure -state normal
    $droot.text delete $selLine.0 [expr 1+$selLine].0
    $droot.text configure -state disabled
    set insertDone 1
}
   
body FitsHeader::selectLine {line} {

    set selLine $line
    $droot.text mark set smark $line.0
    $droot.text see $line.0
    set key [$droot.text get $line.0 $line.80]
    set backUpRec $key
    set keyRoot [string range $key 0 4]
    set keyName [string range $key 0 7]
    if { $keyName == "" } {
	$droot.text configure -state normal
	$droot.text insert $line.0  "       "
	$droot.text configure -state disabled
    }
    $droot.text tag delete selectedLine
    $droot.text tag add selectedLine $line.0 $line.80
    
#    $droot.text2 delete 0 end 
    if { $fvPref::ifProtectedKeys && (
         ($keyName == "SIMPLE  ") ||
	 ($keyName == "BITPIX  ") ||
	 ($keyRoot == "NAXIS"   ) ||
	 ($keyName == "PCOUNT  ") ||
         ($keyName == "TFIELDS ") ||
	 ($keyName == "GCOUNT  ") 
                                  ) } {
	$droot.text tag configure selectedLine \
	    -background $disablehighLightColor \
	    -borderwidth 2 -relief raised
	set tmpRec [$fFObj getNthKey $line]
	set modifiedKey [lindex $tmpRec 2]
	set isRequired 2
	
    } elseif { 	 $fvPref::ifProtectedKeys && (
		 ($keyName == "XTENSION") ||
		 ($keyRoot == "TBCOL"   ) ||
		 ($keyRoot == "THEAP"   ) ||
		 ($keyRoot == "TFORM"   )
                                          ) } {
	$droot.text tag configure selectedLine \
	    -background $disablehighLightColor \
	    -borderwidth 2 -relief raised
	set tmpRec [$fFObj getNthKey $line]
	set modifiedKey [lindex $tmpRec 2]
	set isRequired 1
    } elseif { $keyName == "END" } {
	set isRequired 1
	$droot.text tag configure selectedLine \
	    -background $disablehighLightColor \
	    -borderwidth 2 -relief raised	
	set modifiedKey ""
    } else {
	$droot.text tag configure selectedLine \
	    -background $ablehighLightColor \
	    -borderwidth 2 -relief raised
	set modifiedKey $key
	set isRequired 0
    }
    focus $droot.text2
}


body FitsHeader::changeKey {} {

    set newRec $modifiedKey

    if { ($newRec == "") && ($editStatus  != "insert") } {
	return
    } 
    
    if { $isFailedToCopy == 0 } {
	if { $editStatus == "insert"} {
	    insKey $selLine $newRec
	    recAction insert
	} else {
	    if {$isRequired >= 1} {
		set oldCard [$fFObj getNthKey $selLine]
		if { $fvPref::ifAutoReformatKeys == 1} {
		    set newRec "[lindex $oldCard 0] [lindex $oldCard 1] $newRec"
		} else {
		    if { $newRec == "" } {
			set newRec { }
		    }
		    set newRec [format "%-8s= %s / %s" [lindex $oldCard 0] \
				    [lindex $oldCard 1] $newRec]
		}
	    } 
	    set card [$fFObj putNthKey $selLine $newRec \
                  $fvPref::ifAutoReformatKeys]
	    set keyName [string range $card 0 7]
	    set tmpPos [expr 1+ [lsearch $keyList $keyName]]
	    
	    if { ($tmpPos == 0) && ($selLine == 0)} {
		set keyPos [$droot.text index end]
		scan $keyPos "%d.%d" tmpLine tmpCol
		$droot.text configure -state normal
		$droot.text insert [expr $tmpLine-1].0 "$card\n"
		$droot.text configure -state disabled
		lappend keyList $keyName
		recAction append
		set selLine $tmpLine
	    } else {	
		$droot.text configure -state normal
		$droot.text delete $selLine.0 $selLine.end
		$droot.text insert $selLine.0 $card
		$droot.text configure -state disabled
		recAction change
	    }
	    set editStatus "append"
	}
	$fFObj changeFile
	updateRestDisps
    }
    selectLine $selLine
}

body FitsHeader::deleteRec {} {
    if { $isRequired >= 1} return
    delKey $selLine 
# record the action
    recAction delete
    $fFObj changeFile
# highlight the next line
    selectLine $selLine
    highlightValue
    updateRestDisps
}

body FitsHeader::saveHeaderToAscii  {} {

   set t [urlTail $fileName]
   set r [file root $t]
   set e [file ext $t]
   if { [lsearch -exact [list .gz .Z .z] $e]!=-1 } {
      set e [file ext $r]
      set r [file root $r]
   }
   set sugName "${r}_h[expr $chdu-1].txt"

# get the file name from the entry
    set asciiFileName [getSelectedFileName $sugName]
    if { $asciiFileName=="" } return
    if { [file exist $asciiFileName] == 1 } {
	set feedback [promptMsg "File $asciiFileName exist\n overwrite?" \
			  return Yes No]
	if { $feedback == "CANCEL"} return
    }
# open the file as write 
    set f [open $asciiFileName w] 
# dump all the headers to the file    
    puts $f [string trimright [$fFObj dumpHeader]]
    puts $f "END"
# flush it
    flush $f
# close it
    close $f
# destroy it    
}

body FitsHeader::saveAsFile { } {
    $fFObj saveAs
}

body FitsHeader::saveFile {} {
    $fFObj save
    updateHL
}

body FitsHeader::updateHL {} {
    if { [lsearch $keyList "EXTNAME "]<0 } {
       $father updateHL EXTNAME NoName
    } else {
       set extVal [lindex [lindex [$fFObj getKeyword EXTNAME] 0] 1]
       $father updateHL EXTNAME [string trim $extVal {' }]
    }
}

body FitsHeader::closeFrWm {w} {
    if { $w == $droot && !$isBeingDestroyed } {
	closeCmd
    }
}

body FitsHeader::closeCmd {} {

    .fvwinkeeper signoff $droot
    updateHL
    delete object $this
}


body FitsHeader::moveLine {mode} {
    if { $selLine == 0 } return 
    
    cleanEmptyInsert

    if { $mode == 1} {
       incr selLine 
	set tmp  [expr 1+[llength $keyList]]
	if {$selLine > $tmp } {
	    set selLine $tmp
	}
    } elseif {$mode == -1 } {
	incr selLine -1
	if { $selLine < 1 } {
	    set selLine 1
	}
    } else {
	error "Unknown move mode (should be 1/-1)"
    }

    selectLine $selLine
    highlightValue
}


body FitsHeader::updateRestDisps {} {
   $father updateDisps $this
}

body FitsHeader::recAction {action} {
# store actions and associated info
    if { $action == "append" } {
	lappend actionRec [list $action [llength $keyList] $backUpRec]
    } else {
	lappend actionRec [list $action $selLine $backUpRec]
    }
}

#####################
#
#  Edit Menu Bindings
#
#####################

body FitsHeader::UndoCmd {} {

    set lastActionRec  [lindex $actionRec end]

    if { $lastActionRec == "" } {
	return
    }
    set actionRec [lreplace $actionRec end end]

    set lastAction    [lindex $lastActionRec 0]
    set lastPosition  [lindex $lastActionRec 1]
    set lastRecord    [lindex $lastActionRec 2]
    switch $lastAction {
	insert {
	    delKey $lastPosition
	}
	delete {
	    $droot.text configure -state normal
	    $droot.text insert $lastPosition.0 "\n"
	    $droot.text configure -state disabled
	    insKey $lastPosition $lastRecord
	}
	append {
	    delKey $lastPosition
	}
	change {
	    delKey $lastPosition
	    $droot.text configure -state normal
	    $droot.text insert $lastPosition.0 "\n"
	    $droot.text configure -state disabled
	    insKey $lastPosition $lastRecord
	}
	default {
	    error "No such action recorded"
	}
    }
    selectLine $lastPosition
    highlightValue
    updateRestDisps
}

body FitsHeader::CopyCmd {} {
    set key [$droot.text get $selLine.0 $selLine.80]
    set keyName [string trimright [lindex $key 0] =]
    if { $keyName=="HIERARCH" } {
	set keyName [string trimright [lindex $key 1] =]
    }
    fvClipBoard register keyword $fileName $keyName $key
}

body FitsHeader::CutCmd {} {
    if {$isRequired >= 1} return

    CopyCmd
    deleteRec
}

body FitsHeader::PasteCmd {} {
    if {$isRequired >= 1} return

    set clipRec [fvClipBoard report]
    if { [lindex $clipRec 0]!="keyword" } return
    insertAbove
    set modifiedKey [lindex $clipRec 2]
    changeKey
}

body FitsHeader::ClearCmd {} {
    if {$isRequired >= 1} return

    deleteRec
    insertAbove
}


body FitsHeader::insKey {pos rec} {

    set card [$fFObj insertKey $pos $rec $fvPref::ifAutoReformatKeys]
    set newKey [string range $card 0 7]
    $droot.text configure -state normal
    $droot.text delete $pos.0 $pos.end
    $droot.text insert $pos.0 $card
    $droot.text configure -state disabled
    set keyList [linsert $keyList $pos $newKey]
    set editStatus "append"
    set insertDone 1
}


body FitsHeader::delKey {pos} {
    $droot.text configure -state normal
    $droot.text delete $pos.0 [expr 1+$pos].0
    $droot.text tag delete selectedLine
    $droot.text configure -state disabled
# need to delete the rec from the file
    $fFObj delNthKey $pos
#
    set modifiedKey ""
    set tmp [expr $pos - 1]
    set keyList [lreplace $keyList $tmp $tmp] 
}

body FitsHeader::createChecksum {} {
   $fFObj updateChecksum 1
   refresh
}

body FitsHeader::verifyChecksum {} {
    set checksumStatus  [$fFObj verifyChecksum]
    switch -- $checksumStatus {
	1 {
	   tk_messageBox -icon info \
		 -message "The CHECKSUM keyword is valid"
	}
	0 {
	   set res [tk_messageBox -icon warning -message \
		 "The CHECKSUM keyword does not exist in this HDU.\n\
		 \nCreate keywords?" -type yesno -default "no"]
	   if { $res=="yes" } {
	      $fFObj updateChecksum 1
	      refresh
	   }
	}
	-1 {
	   set res [tk_messageBox -icon error \
		 -message "The CHECKSUM keyword is invalid!\n\
		 \nUpdate keywords?" -type yesno -default "no"]
	   if { $res=="yes" } {
	      $fFObj updateChecksum 1
	      refresh
	   }
	}
	default { error "Unknown error in checksum varification"}
    }

}

body FitsHeader::highlightValue {} {

   set root [string range $modifiedKey 0 7]
   $droot.text2 selection clear
   if { $isRequired } {

      # Only the comment is present

      $droot.text2 selection range 0 end
      $droot.text2 icursor end

   } elseif { $root=="COMMENT " || $root=="HISTORY " } {

      # Highlight entire field except keyword

      set value [string trimleft [string range $modifiedKey 8 end] { }]
      set idx [string first $value $modifiedKey]
      $droot.text2 selection range $idx end
      $droot.text2 icursor end

   } else {

      # Locate value to hightlight

      set k [$fFObj getNthKey $selLine]
      set val [lindex $k 1]
      if { [string range $val 0 0]=="'" && [string range $val end end]=="'" } {
         set last [string length $val]
         set val [string range $val 1 [expr $last-2]]
      }
      set start [string first = $modifiedKey]
      if { $start==-1 } {
         set start 9
      }
      set idx [string first $val $modifiedKey $start]
      if { $idx==-1 } {
         $droot.text2 icursor end
      } else {
         set last [expr $idx + [string length $val]]
         $droot.text2 selection range $idx $last
         $droot.text2 icursor $last
      }
   }
}
