#!/usr/bin/env python
# -*- coding: UTF-8 -*-

#Freeloader - a download manager for gnome written in python using pygtk
#Copyright (C) 2005 Steven Grafton

#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


import socket
import threading
import os.path
import gtk
import gtk.gdk

class Sockdae(threading.Thread):
	def __init__(self, sock, key, loader):
		self.sock = sock
		self.key = key
		self.loader = loader
		self.killflag = threading.Event()
		self.sock.settimeout(2.0)
		threading.Thread.__init__(self)

	def please_exit(self):
		self.killflag.set()

	def read_expected(self, c, count):
		res = ''
		while len(res) != count:
			try:
				b = c.recv(count - len(res))
				if b:
					res += b
				else:
					break
			except:
				break
		
		return res

	def parse_flags(self, s):
		count = 0
		if s.find('s') >= 0:
			count += 1
			gtk.gdk.threads_enter()
			self.loader.setwindowvis(gtk.TRUE)
			gtk.gdk.threads_leave()
		elif s.find('h') >= 0:
			count += 1
			gtk.gdk.threads_enter()
			self.loader.setwindowvis(gtk.FALSE)
			gtk.gdk.threads_leave()
		if s.find('x') >= 0:
			count += 1
			gtk.gdk.threads_enter()
			self.loader.on_stop_all_transfers(None)
			gtk.gdk.threads_leave()
		if s.find('q') >= 0:
			count += 1
			gtk.gdk.threads_enter()
			self.loader.on_quit(None)
			gtk.gdk.threads_leave()
		return count
			
	def run(self):
		while 1:
			try:
				(c, a) = self.sock.accept()
			except:
				if self.killflag.isSet():
					break
				continue

			key = self.read_expected(c, 5)
			flags = self.read_expected(c, 10)
			count = self.parse_flags(flags)
			if count > 0:
				c.shutdown(socket.SHUT_RDWR)
				c.close()
				continue

			if cmp(key,self.key) != 0:
				print "Ineligible connection with key " + key
				c.shutdown(socket.SHUT_RDWR)
				c.close()
			else:
				f = c.recv(1024)
				file = ''
				while f:
					file += f
					try:
						f = c.recv(1024)
						if f is None:
							break
					except:
						break;

				c.shutdown(socket.SHUT_RDWR)
				c.close()

				self.handle_file(file)

		self.sock.shutdown(socket.SHUT_RDWR)
		self.sock.close()

	def handle_file(self, uri):
		if os.path.isfile(uri):
			gtk.gdk.threads_enter()
			self.loader.start_torrent(None, uri)
			gtk.gdk.threads_leave()
		else:
			gtk.gdk.threads_enter()
			self.loader.start_url(None, uri)
			gtk.gdk.threads_leave()
