//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: MeshWriter.hpp,v 1.4 2004/02/13 19:54:08 delpinux Exp $

#ifndef MESHWRITER_HPP
#define MESHWRITER_HPP

#include <ReferenceCounting.hpp>
#include <ostream>
#include <string>

/**
 * @file   MeshWriter.hpp
 * @author Stephane Del Pino
 * @date   Wed Dec 11 18:10:16 2002
 * 
 * @brief  Utility to write meshes
 * 
 * 
 */

class MeshWriter
{
private:
  std::ostream& __os;		/**< The output stream */

  ReferenceCounting<Mesh> __mesh; /**< The mesh to write */

  std::string __cr;		/**< The end of line caracter */

  /** 
   * Writes the mesh depending on its type.
   * 
   */
  void __proceed();

  /** 
   * Copy constructor is forbiden
   * 
   * @param m the initial MeshWriter
   */
  MeshWriter(const MeshWriter& m)
    : __os(m.__os),
      __mesh(m.__mesh),
      __cr(m.__cr)
  {
    ;
  }

  /** 
   * Saves mesh elements according to its type
   * 
   */
  template <typename MeshType>
  void __saveElements(const MeshType& m);

public:

  /** 
   * Constructor
   * 
   * @param os
   * @param mesh
   * @param cr
   */
  MeshWriter(std::ostream& os,
	     ReferenceCounting<Mesh> mesh,
	     std::string cr)
    : __os(os),
      __mesh(mesh),
      __cr(cr)
  {
    this->__proceed();
  }

  /** 
   * Destructor
   * 
   */
  ~MeshWriter()
  {
    ;
  }
};

#endif // MESHWRITER_HPP
