#include <Domain.hpp>

#include <Union.hpp>
#include <Intersection.hpp>
#include <Difference.hpp>
#include <Not.hpp>

void Domain::__buildReferenceAssociation(const Object& o)
{
  if (o.hasReference()) {
    const TinyVector<3, real_t>& ref = o.reference();
    if (__povToReference.find(ref) == __povToReference.end()) {
      const size_t n = __povToReference.size() + 1;
      __povToReference[ref] = n;
      ffout(2) << "\t\t" << ref << " -> " << n << '\n';
    }
  }

  const Shape& shape = (*o.shape());

  switch(shape.type()) {
  case Shape::union_: {
    const Union& U = static_cast<const Union&>(shape);

    for (Union::const_iterator i = U.begin();
	 i != U.end(); ++i) {
      __buildReferenceAssociation(*(*i));
    }
    break;
  }
  case Shape::difference: {
    const Difference& D = static_cast<const Difference&>(shape);

    for (Difference::const_iterator i = D.begin();
	 i != D.end(); ++i) {
      __buildReferenceAssociation(*(*i));
    }
    break;
  }
  case Shape::intersection: {
    const Intersection& I = static_cast<const Intersection&>(shape);

    for (Intersection::const_iterator i = I.begin();
	 i != I.end(); ++i) {
      __buildReferenceAssociation(*(*i));
    }
    break;
  }
  case Shape::not_: {
    const Object& notObject = *(static_cast<const Not&>(shape).object());
    __buildReferenceAssociation(notObject);
    break;
  }
  default: {
    ;
  }
  }
}
