//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDESystemExpression.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#ifndef _PDESYSTEM_EXPRESSION_HPP_
#define _PDESYSTEM_EXPRESSION_HPP_

#include <Expression.hpp>
#include <Variable.hpp>

#include <ProblemExpression.hpp>

#include <PDEProblemExpression.hpp>

/*!
  \class PDESystemExpression

  This class defines the base class of PDESystem expressions.

  \author Stephane Del Pino
 */
class PDESystem;
class PDESystemExpression
  : public ProblemExpression
{
private:
  ReferenceCounting<PDESystem> __pdeSystem;

  typedef std::list<ReferenceCounting<PDEProblemExpression> > SystemList;
  SystemList __system;

  std::ostream& put(std::ostream& os) const
  {
    for (SystemList::const_iterator i = __system.begin(); i!= __system.end();
	 ++i)
      os << (*(*i));
    return os;
  }

public:
  const size_t size() const
  {
    return __system.size();
  }

  ReferenceCounting<PDESystem> pdeSystem();

  void execute();

  void add(ReferenceCounting<PDEProblemExpression> p)
  {
    __system.push_back(p);
  }
    
  PDESystemExpression();

  PDESystemExpression(const PDESystemExpression& S);

  ~PDESystemExpression();
};

#endif // _PDESYSTEM_EXPRESSION_HPP_

