//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Scale.cpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#include <Scale.hpp>

#include <sstream>

//! Applies the scale to a vector \a v.
TinyVector<3>& Scale::operator()(TinyVector<3>& v) const
{
  v[0] *= __scale[0];
  v[1] *= __scale[1];
  v[2] *= __scale[2];
  return v;
}

//! Applies the inverse scale to a vector \a v.
TinyVector<3>& Scale::inverse(TinyVector<3>& v) const
{
  v[0] /= __scale[0];
  v[1] /= __scale[1];
  v[2] /= __scale[2];
  return v;
}

//! Prints scale informations to a std::string.
std::string Scale::povWrite() const
{
  std::stringstream povs;
  povs << "scale <"
       << __scale[0]
       << ", "
       << __scale[1]
       << ", "
       << __scale[2]
       << ">";
  povs << std::ends;
  return povs.str();
}


//! Default Constructor.
Scale::Scale()
{
  __type = scale;
  __scale = 0;
}

//! Constructs a Scale for a given set of scalings passed by \a v.
Scale::Scale(const TinyVector<3>& v)
{
  __type = scale;
  __scale = v;
}

//! Copy constructor.
Scale::Scale(const Scale& S)
{
  __type = scale;
  __scale = S.__scale;
}

