//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: KrylovSolver.hpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $


#ifndef _KRYLOVSOLVER_HPP_
#define _KRYLOVSOLVER_HPP_

/*!
  \class KrylovSolver
  This is used to drive the linear system resolution.

  \author Stphane Del Pino
 */

#include <KrylovSolverOptions.hpp>
#include <GetParameter.hpp>

#include <Structured3DMeshShape.hpp>

class BaseMatrix;
class BaseVector;

class DegreeOfFreedomSet;
class Problem;

class KrylovSolver
{
private:
  const BaseMatrix& __A;
  const BaseVector& __b;

  const DegreeOfFreedomSet& __degreeOfFreedomSet;

  KrylovSolverOptions::Type __type;

  KrylovSolverOptions::PreconditionerType __pType;

  ReferenceCounting<Structured3DMeshShape> __meshShape;

  GetParameter<KrylovSolverOptions> __options;

  template <int N>
  void run();
public:
  KrylovSolver(const BaseMatrix& A,
	       const BaseVector& b,
	       const DegreeOfFreedomSet& degreeOfFreedomSet,
	       ReferenceCounting<Structured3DMeshShape> meshShape = 0)
    : __A(A),
      __b(b),
      __degreeOfFreedomSet(degreeOfFreedomSet),
      __meshShape(meshShape)
  {
    __type = __options.value().type();
    __pType = __options.value().precond();
  }

  void solve(BaseVector& u, const Problem& problem);
};

#endif // _KRYLOVSOLVER_HPP_

