/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "outputtozero.h"

OutputToZero::OutputToZero(QObject *parent, const char *name)
 : CustomEffect(parent, name)
{
    bufferLength=0;
    input=0;
}


OutputToZero::~OutputToZero()
{
    zaparr(input);
}

void OutputToZero::process(long length){
    init(length);
}

void OutputToZero::init(long _bufferLength){
    if(!input || _bufferLength>bufferLength){
        bufferLength=_bufferLength;
        if (input) zaparr(input);
        input=new float[bufferLength];
    }
}

void OutputToZero::advancePosition(long length){
    init(length);
}

void OutputToZero::setPosition(long /*position*/){
    //no output
}




/*!
    \fn OutputToZero::getInput_P()
 */
float* OutputToZero::getInput_P()
{
    return input;
}

QString OutputToZero::getName(){
    return "OutputToZero";
}
