/**
 *  Copyright (C) 2002-2007  The FreeCol Team
 *
 *  This file is part of FreeCol.
 *
 *  FreeCol is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  FreeCol is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with FreeCol.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.freecol.common.model;

import java.util.Vector;

import junit.framework.TestCase;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.util.test.MockModelController;

public class GameTest extends TestCase {

	public void testGame() throws FreeColException {

		Game game = new Game(new MockModelController());
        
        game.setMap(new Map(game, Map.SMALL));

		game.addPlayer(new Player(game, "TestPlayer", false, Player.DUTCH));

		game.newTurn();

	}

	public void testAddPlayer() {
		Game game = new Game(new MockModelController());

		Vector<Player> players = new Vector<Player>();

		for (int i = Player.NUMBER_OF_NATIONS - 1; i >= 0; i--) {
			Player p = new Player(game, String.valueOf(i), false, !Player.isEuropeanNoREF(i), i);
			game.addPlayer(p);
			players.add(p);
		}

        assertEquals(Player.NUMBER_OF_NATIONS, game.getPlayers().size());
		assertEquals(players, game.getPlayers());
	}

}
