/*
Copyright (c) 2006-2008 Advanced Micro Devices, Inc. All Rights Reserved.
This software is subject to the Apache v2.0 License.
*/

#ifndef __FW_REF_XMMINTRIN_H__
#define __FW_REF_XMMINTRIN_H__

/* Dummy xmmintrin.h file */

#include "fw_ref_mmdefs.h"

static inline __m128
_mm_setzero_ps (void)
{
  FwInterrupt3();
  RZERO_m128;
}

static inline __m128
_mm_add_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_sub_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_mul_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_div_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_sqrt_ss (__m128 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_rcp_ss (__m128 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_rsqrt_ss (__m128 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_min_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_max_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_add_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_sub_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_mul_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_div_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_sqrt_ps (__m128 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_rcp_ps (__m128 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_rsqrt_ps (__m128 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_min_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_max_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_and_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_andnot_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_or_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_xor_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpeq_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmplt_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmple_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpgt_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpge_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpneq_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpnlt_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpnle_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpngt_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpnge_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpeq_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmplt_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmple_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpgt_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpge_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpneq_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpnlt_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpnle_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpngt_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cmpnge_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cvtsi32_ss (__m128 __A, int __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cvt_si2ss (__m128 __A, int __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cvtpi32_ps (__m128 __A, __m64 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cvt_pi2ps (__m128 __A, __m64 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_cvtpi16_ps (__m64 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_cvtpu16_ps (__m64 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_cvtpi8_ps (__m64 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_cvtpu8_ps(__m64 __A)
{
  FwInterrupt3();
  __A;
  RZERO_m128;
}

static inline __m128
_mm_cvtpi32x2_ps(__m64 __A, __m64 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_shuffle_ps(__m128 __A, __m128 __B, int __C)
{
  FwInterrupt3();
  __A, __B, __C;
  RZERO_m128;
}

static inline __m128
_mm_unpackhi_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_unpacklo_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_loadh_pi (__m128 __A, __m64 const *__P)
{
  FwInterrupt3();
  __A, __P;
  RZERO_m128;
}

static inline void
_mm_storeh_pi (__m64 *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline __m128
_mm_movehl_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_movelh_ps (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

static inline __m128
_mm_loadl_pi (__m128 __A, __m64 const *__P)
{
  FwInterrupt3();
  __A, __P;
  RZERO_m128;
}

static inline void
_mm_storel_pi (__m64 *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline int
_mm_movemask_ps (__m128 __A)
{
  FwInterrupt3();
  __A;
  return 0;
}

static inline __m128
_mm_set_ss (float __F)
{
  FwInterrupt3();
  __F;
  RZERO_m128;
}

static inline __m128
_mm_set1_ps (float __F)
{
  FwInterrupt3();
  __F;
  RZERO_m128;
}

static inline __m128
_mm_set_ps1 (float __F)
{
  FwInterrupt3();
  __F;
  RZERO_m128;
}

static inline __m128
_mm_load_ss (float const *__P)
{
  FwInterrupt3();
  __P;
  RZERO_m128;
}

static inline __m128
_mm_load1_ps (float const *__P)
{
  FwInterrupt3();
  __P;
  RZERO_m128;
}

static inline __m128
_mm_load_ps1 (float const *__P)
{
  FwInterrupt3();
  __P;
  RZERO_m128;
}

static inline __m128
_mm_load_ps (float const *__P)
{
  FwInterrupt3();
  __P;
  RZERO_m128;
}

static inline __m128
_mm_loadu_ps (float const *__P)
{
  FwInterrupt3();
  __P;
  RZERO_m128;
}

static inline __m128
_mm_loadr_ps (float const *__P)
{
  FwInterrupt3();
  __P;
  RZERO_m128;
}

static inline __m128
_mm_set_ps (const float __Z, const float __Y, const float __X, const float __W)
{
  FwInterrupt3();
  __Z, __Y, __X, __W;
  RZERO_m128;
}

static inline __m128
_mm_setr_ps (float __Z, float __Y, float __X, float __W)
{
  FwInterrupt3();
  __Z, __Y, __X, __W;
  RZERO_m128;
}

static inline void
_mm_store_ss (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline void
_mm_store_ps (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline void
_mm_storeu_ps (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline void
_mm_store1_ps (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline void
_mm_store_ps1 (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline void
_mm_storer_ps (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline __m128
_mm_move_ss (__m128 __A, __m128 __B)
{
  FwInterrupt3();
  __A, __B;
  RZERO_m128;
}

#define _mm_prefetch(P, I) 

static inline void
_mm_stream_pi (__m64 *__P, __m64 __A)
{
  FwInterrupt3();
  __P, __A;
}

static inline void
_mm_stream_ps (float *__P, __m128 __A)
{
  FwInterrupt3();
  __P, __A;
}

#if !defined (WIN64)

static inline void
_mm_sfence (void)
{
  FwInterrupt3();
}

#if !defined _MSC_VER >= 1500
    static inline void
    _mm_pause (void)
    {
      FwInterrupt3();
    }
#endif

#endif

#endif // __FW_REF_XMMINTRIN_H__

