/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.2 $
 *
 * $Log: list.h,v $
 * Revision 1.2  2003/06/19 17:12:02  tim
 * new memory management
 * removed the fragment list
 *
 * Revision 1.1  2003/03/20 20:28:17  tim
 * Initial revision
 *
 *
 *
 */
#ifndef _LIST_H
#define _LIST_H

#include <netinet/ether.h>

struct iif_node {
  unsigned short iif_id;
  struct ether_addr mac;
  struct iif_node *next;
} iif_node;

struct iif_node *lookup_iif_mac(struct iif_node *, struct ether_addr *);
struct iif_node *add_iif(struct iif_node *, int, char *);


#endif
