/*
 * Copyright (C) 2002  Bogdan Surdu (tim@rdsnet.ro)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Revision: 1.1 $
 *
 * $Log: fprobe.h,v $
 * Revision 1.1  2002/11/24 23:13:41  tim
 * Initial revision
 *
 *
 */

#ifndef _FPROBE_H
#define _FPROBE_H

#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <pthread.h>

#include "flow_storage.h"


#define	CAPTURE_LEN	64

#ifdef	MEM_STATS
#define	MALLOC(a,b)	my_malloc(a,b)
#define	FREE(a,b)	my_free(a,b)
#else
#define	MALLOC(a,b)	malloc(a)
#define	FREE(a,b)	free(a)
#endif

struct my_ip {
	u_int8_t	ip_vhl;	/* header length, version */
#define	IP_V(ip)	(((ip)->ip_vhl & 0xf0) >> 4
#define	IP_HL(ip)	((ip)->ip_vhl & 0x0f)
	u_int8_t	ip_tos;
	u_int16_t	ip_len;
	u_int16_t	ip_id;
	u_int16_t	ip_off;
	
	u_int8_t	ip_ttl;
	u_int8_t	ip_p;
	u_int16_t	ip_sum;
	u_int32_t	ip_src;
	u_int32_t	ip_dst;
};

#define	STACKSIZE	1024*64

unsigned long timestamp(struct timeval *);
char *copy_argv(register char **);


#endif
