/********************************************************************************
*                                                                               *
*                           S e t t i n g s   C l a s s                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************
* $Id: FXSettings.h,v 1.6 2001/07/17 07:24:56 jeroen Exp $                      *
********************************************************************************/
#ifndef FXSETTINGS_H
#define FXSETTINGS_H


/**
* FXSettings is a key-value database.  This is normally used as
* part of FXRegistry, but can also be used separately in application
* that need to maintain a key-value database of their own.
*/
class FXAPI FXSettings {
protected:
  FXSectionDict  sections;        // Dictionary of sections
  FXbool         modified;        // Settings changed
protected:
  FXbool parseValue(FXchar* value,const FXchar* buffer);
  FXbool unparseValue(FXchar* buffer,const FXchar* value);
private:
  FXSettings(const FXSettings&);
  FXSettings &operator=(const FXSettings&);
public:

  /// Construct settings database.
  FXSettings();

  /**
  * Parse a file containing a settings database.
  */
  FXbool parseFile(const FXString& filename,FXbool mark);
  
  /**
  * Unparse settings database into given file.
  */
  FXbool unparseFile(const FXString& filename);

  /// Read a string registry entry; if no value is found, the default value def is returned
  const FXchar *readStringEntry(const FXchar *section,const FXchar *key,const FXchar *def=NULL);

  /// Read a integer registry entry; if no value is found, the default value def is returned
  FXint readIntEntry(const FXchar *section,const FXchar *key,FXint def=0);

  /// Read a unsigned integer registry entry; if no value is found, the default value def is returned
  FXuint readUnsignedEntry(const FXchar *section,const FXchar *key,FXuint def=0);

  /// Read a double-precision floating point registry entry; if no value is found, the default value def is returned
  FXdouble readRealEntry(const FXchar *section,const FXchar *key,FXdouble def=0.0);

  /// Read a color value registry entry; if no value is found, the default value def is returned
  FXColor readColorEntry(const FXchar *section,const FXchar *key,FXColor def=0);

  /// Write a string registry entry
  FXbool writeStringEntry(const FXchar *section,const FXchar *key,const FXchar *val);

  /// Write a integer registry entry
  FXbool writeIntEntry(const FXchar *section,const FXchar *key,FXint val);

  /// Write a unsigned integer registry entry
  FXbool writeUnsignedEntry(const FXchar *section,const FXchar *key,FXuint val);

  /// Write a double-precision floating point registry entry
  FXbool writeRealEntry(const FXchar *section,const FXchar *key,FXdouble val);

  /// Write a color value entry
  FXbool writeColorEntry(const FXchar *section,const FXchar *key,FXColor val);

  /// Delete a registry entry
  FXbool deleteEntry(const FXchar *section,const FXchar *key);

  /// See if entry exists
  FXbool existingEntry(const FXchar *section,const FXchar *key);

  /// Delete section
  FXbool deleteSection(const FXchar *section);

  /// See if section exists
  FXbool existingSection(const FXchar *section);

  /// Clear all sections
  FXbool clear();

  /// Mark as changed
  void setModified(FXbool mdfy=TRUE){ modified=mdfy; }

  /// Is it modified
  FXbool isModified() const { return modified; }

  /// Return sections
  FXSectionDict& getSections(){ return sections; }
  };


#endif
