//
// ORB related utility functions that hide the differences in ORB
// functionality where possible.
//

#ifndef FN_UTILS
#define FN_UTILS

#include <iostream>
#include <string>

#include <Client.h>

//
// Write a string representation of an exception to a stream.
//
void
write_ex(std::ostream &os, const CORBA::Exception &ex);

//
// Write the contents of a wide string as integers to a stream.
//
void
write_wstring_data(std::ostream &os, const CORBA::WChar* ws);

//
// Determine if two wide strings are the same.
//
bool
wstring_compare(const CORBA::WChar* ws1, const CORBA::WChar* ws2);

//
// Get an object reference from a file
//
CORBA::Object_ptr
get_ior_from_file(CORBA::ORB_ptr orb, const std::string &file_name);

#endif // FN_UTILS
