#!/usr/bin/env python

import unittest
import datatransfer, datatransfer_skel

from orbrunner import ORBRunner

#
# The test case for "char" type transmission.
#
class CharTest(unittest.TestCase):

    def __init__(self, orb_runner):
        unittest.TestCase.__init__(self)
        self.orb_runner = orb_runner;

    #
    # Create the implementation of the "char" type test interface and
    # register it with the ORB.
    #
    def setUp(self):
        orb = self.orb_runner.getORB()
        stringified_ior = open('char.ref', 'r').read()
        self.obj = orb.string_to_object(stringified_ior)

    def tearDown(self):
        # Do nothing for the time being
        pass

    #
    # Perform the "char" type interface tests.
    #
    def runTest(self):
        char = 'f'

        self.assertEqual(self.obj.charIn(char), char)
        
        self.assertEqual(self.obj.charOut(char), char)

        char_in = 'n'
        (char_ret, char_out) = self.obj.charInOut(char, char_in)

        self.assertEqual(char_ret, char_in)
        self.assertEqual(char_out, char)

#
# Create a testsuite for testing "char" type transmission. This is
# meant to be used by other modules wanting to incorporate these
# tests.
#
def build_test_suite(orb_runner):
    char_test = CharTest(orb_runner)
    test_suite = unittest.TestSuite([char_test])
    return test_suite

#
# Run the tests with an ORB. This is meant to be used when this module
# is executed as a stand-alone program.
#
def run_tests():
    orb_runner = ORBRunner()

    test_suite = build_test_suite(orb_runner)

    test_runner = unittest.TextTestRunner()
    test_runner.run(test_suite)

#
# If this module was loaded as a program, then run the tests.
#
if __name__ == "__main__":
    run_tests()
