// splash.cxx -- draws the initial splash screen
//
// Written by Curtis Olson, started July 1998.  (With a little looking
// at Freidemann's panel code.) :-)
//
// Copyright (C) 1997  Michele F. America  - nomimarketing@mail.telepac.pt
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// $Id: splash.cxx,v 1.13 2001/05/15 20:30:40 curt Exp $


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef SG_MATH_EXCEPTION_CLASH
#  include <math.h>
#endif

#ifdef HAVE_WINDOWS_H          
#  include <windows.h>
#endif

#include <GL/glut.h>
#include <GL/gl.h>

#include <string.h>

#include <simgear/debug/logstream.hxx>
#include <simgear/math/sg_random.h>
#include <simgear/misc/sg_path.hxx>

#include <Objects/texload.h>

#include "globals.hxx"
#include "fg_props.hxx"
#include "splash.hxx"


static GLuint splash_texid;
static GLubyte *splash_texbuf;


// Initialize the splash screen
void fgSplashInit ( void ) {
    int width, height;

    SG_LOG( SG_GENERAL, SG_INFO, "Initializing splash screen" );
#ifdef GL_VERSION_1_1
    glGenTextures(1, &splash_texid);
    glBindTexture(GL_TEXTURE_2D, splash_texid);
#elif GL_EXT_texture_object
    glGenTexturesEXT(1, &splash_texid);
    glBindTextureEXT(GL_TEXTURE_2D, splash_texid);
#else
#  error port me
#endif

    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);   
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    // load in the texture data
    int num = (int)(sg_random() * 4.0 + 1.0);
    char num_str[256];
    sprintf(num_str, "%d", num);

    SGPath tpath( globals->get_fg_root() );
    tpath.append( "Textures/Splash" );
    tpath.concat( num_str );
    tpath.concat( ".rgb" );

    if ( (splash_texbuf = 
	  read_rgb_texture(tpath.c_str(), &width, &height)) == NULL )
    {
	// Try compressed
	SGPath fg_tpath = tpath;
	fg_tpath.concat( ".gz" );
	if ( (splash_texbuf = 
	      read_rgb_texture(fg_tpath.c_str(), &width, &height)) == NULL )
	{
	    SG_LOG( SG_GENERAL, SG_ALERT, 
		    "Error in loading splash screen texture " << tpath.str() );
	    exit(-1);
	} 
    } 

    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGB, width, height, 0, GL_RGB, 
		   GL_UNSIGNED_BYTE, (GLvoid *)(splash_texbuf) );
}


// Update the splash screen with progress specified from 0.0 to 1.0
void fgSplashUpdate ( double progress ) {
    int xmin, ymin, xmax, ymax;
    int xsize = 480;
    int ysize = 380;

    if ( !fgGetInt("/sim/startup/xsize")
	 || !fgGetInt("/sim/startup/ysize") ) {
	return;
    }

    xmin = (fgGetInt("/sim/startup/xsize") - xsize) / 2;
    xmax = xmin + xsize;

    ymin = (fgGetInt("/sim/startup/ysize") - ysize) / 2;
    ymax = ymin + ysize;

    // first clear the screen;
    glClearColor(0.0, 0.0, 0.0, 1.0);
    glClear( GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT );

    // now draw the logo
    glMatrixMode(GL_PROJECTION);
    glPushMatrix();
    glLoadIdentity();
    gluOrtho2D(0, fgGetInt("/sim/startup/xsize"),
	       0, fgGetInt("/sim/startup/ysize"));
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glLoadIdentity();

    glDisable(GL_DEPTH_TEST);
    glDisable(GL_LIGHTING);
    glEnable(GL_TEXTURE_2D);
#ifdef GL_VERSION_1_1
    glBindTexture(GL_TEXTURE_2D, splash_texid);
#elif GL_EXT_texture_object
    glBindTextureEXT(GL_TEXTURE_2D, splash_texid);
#else
#  error port me
#endif
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);

    glBegin(GL_POLYGON);
    glTexCoord2f(0.0, 0.0); glVertex2f(xmin, ymin);
    glTexCoord2f(1.0, 0.0); glVertex2f(xmax, ymin);
    glTexCoord2f(1.0, 1.0); glVertex2f(xmax, ymax);
    glTexCoord2f(0.0, 1.0); glVertex2f(xmin, ymax); 
    glEnd();

    glutSwapBuffers();

    glEnable(GL_DEPTH_TEST);
    glEnable(GL_LIGHTING);
    glDisable(GL_TEXTURE_2D);

    glMatrixMode(GL_PROJECTION);
    glPopMatrix();
    glMatrixMode(GL_MODELVIEW);
    glPopMatrix();
}


