/* File created from flex.skl via mkskel.sh */

#include "flexdef.h"

const char *skel[] = {
  "%# -*-C-*- vi: set ft=c:",
  "%# This file is processed in several stages.",
  "%# Here are the stages, as best as I can describe:",
  "%#",
  "%#   1. flex.skl is processed through GNU m4 during the",
  "%#      pre-compilation stage of flex. Only macros starting",
  "%#      with `m4_' are processed, and quoting is normal.",
  "%#",
  "%#   2. The preprocessed skeleton is translated verbatim into a",
  "%#      C array, saved as \"skel.c\" and compiled into the flex binary.",
  "%#",
  "%#   3. At runtime, the skeleton is generated and filtered (again)",
  "%#      through m4. Macros beginning with `m4_' will be processed.",
  "%#      The quoting is \"[[\" and \"]]\" so we don't interfere with",
  "%#      user code.",
  "%# ",
  "%# All generate macros for the m4 stage contain the text \"m4\" or \"M4\"",
  "%# in them. This is to distinguish them from CPP macros.",
  "%# The exception to this rule is YY_G, which is an m4 macro, ",
  "%# but it needs to be remain short because it is used everywhere.",
  "%#",
  "/* A lexical scanner generated by flex */",
  "",
  "%#  Macros for preproc stage.",
  "",
  "",
  "%# Macros for runtime processing stage.",
  "m4_changecom",
  "m4_changequote",
  "m4_changequote([[, ]])",
  "",
  "%# ",
  "%# Lines in this skeleton starting with a \"%\" character are \"control lines\"",
  "%# and affect the generation of the scanner. The possible control codes are",
  "%# listed and processed in misc.c.",
  "%#",
  "%#   %#  -  A comment. The current line is omitted from the generated scanner.",
  "%#   %if-c++-only  -  The following lines are printed for C++ scanners ONLY.",
  "%#   %if-c-only    -  The following lines are NOT printed for C++ scanners.",
  "%#   %if-c-or-c++  -  The following lines are printed in BOTH C and C++ scanners.",
  "%#   %if-reentrant     - Print for reentrant scanners.(push)",
  "%#   %if-not-reentrant - Print for non-reentrant scanners. (push)",
  "%#   %if-bison-bridge  - Print for bison-bridge. (push)",
  "%#   %if-not-bison-bridge  - Print for non-bison-bridge. (push)",
  "%#   %endif        - pop from the previous if code.",
  "%#   %%  -  A stop-point, where code is inserted by flex.",
  "%#          Each stop-point is numbered here and also in the code generator.",
  "%#          (See gen.c, etc. for details.)",
  "%#   %not-for-header  -  Begin code that should NOT appear in a \".h\" file.",
  "%#   %ok-for-header   -  %c and %e are used for building a header file.",
  "%#   %if-tables-serialization",
  "%#",
  "%#   All control-lines EXCEPT comment lines (\"%#\") will be inserted into",
  "%#   the generated scanner as a C-style comment. This is to aid those who",
  "%#   edit the skeleton.",
  "%#",
  "",
  "%not-for-header",
  "%if-c-only",
  "%if-not-reentrant",
  "m4_ifelse(M4_YY_PREFIX,yy,,",
  "#define yy_create_buffer M4_YY_PREFIX[[_create_buffer]]",
  "#define yy_delete_buffer M4_YY_PREFIX[[_delete_buffer]]",
  "#define yy_flex_debug M4_YY_PREFIX[[_flex_debug]]",
  "#define yy_init_buffer M4_YY_PREFIX[[_init_buffer]]",
  "#define yy_flush_buffer M4_YY_PREFIX[[_flush_buffer]]",
  "#define yy_load_buffer_state M4_YY_PREFIX[[_load_buffer_state]]",
  "#define yy_switch_to_buffer M4_YY_PREFIX[[_switch_to_buffer]]",
  "#define yyin M4_YY_PREFIX[[in]]",
  "#define yyleng M4_YY_PREFIX[[leng]]",
  "#define yylex M4_YY_PREFIX[[lex]]",
  "#define yylineno M4_YY_PREFIX[[lineno]]",
  "#define yyout M4_YY_PREFIX[[out]]",
  "#define yyrestart M4_YY_PREFIX[[restart]]",
  "#define yytext M4_YY_PREFIX[[text]]",
  "#define yywrap M4_YY_PREFIX[[wrap]]",
  "#define yyalloc M4_YY_PREFIX[[alloc]]",
  "#define yyrealloc M4_YY_PREFIX[[realloc]]",
  "#define yyfree M4_YY_PREFIX[[free]]",
  ")",
  "%endif",
  "%endif",
  "%ok-for-header",
  "",
  "#define FLEX_SCANNER",
  "#define YY_FLEX_MAJOR_VERSION 2",
  "#define YY_FLEX_MINOR_VERSION 6",
  "#define YY_FLEX_SUBMINOR_VERSION 1",
  "#if YY_FLEX_SUBMINOR_VERSION > 0",
  "#define FLEX_BETA",
  "#endif",
  "",
  "%# Some negated symbols",
  "m4_ifdef( [[M4_YY_IN_HEADER]], , [[m4_define([[M4_YY_NOT_IN_HEADER]], [[]])]])",
  "m4_ifdef( [[M4_YY_REENTRANT]], , [[m4_define([[M4_YY_NOT_REENTRANT]], [[]])]])",
  "",
  "%# This is the m4 way to say \"(stack_used || is_reentrant)",
  "m4_ifdef( [[M4_YY_STACK_USED]], [[m4_define([[M4_YY_HAS_START_STACK_VARS]])]])",
  "m4_ifdef( [[M4_YY_REENTRANT]],  [[m4_define([[M4_YY_HAS_START_STACK_VARS]])]])",
  "",
  "%# Prefixes.",
  "%# The complexity here is necessary so that m4 preserves",
  "%# the argument lists to each C function.",
  "",
  "",
  "m4_ifdef( [[M4_YY_PREFIX]],, [[m4_define([[M4_YY_PREFIX]], [[yy]])]])",
  "",
  "",
  "",
  "%if-c++-only",
  "    /* The c++ scanner is a mess. The FlexLexer.h header file relies on the",
  "     * following macro. This is required in order to pass the c++-multiple-scanners",
  "     * test in the regression suite. We get reports that it breaks inheritance.",
  "     * We will address this in a future release of flex, or omit the C++ scanner",
  "     * altogether.",
  "     */",
  "    #define yyFlexLexer M4_YY_PREFIX[[FlexLexer]]",
  "%endif",
  "",
  "%if-c-only",
  "    m4_define(yy[[_create_buffer]], [[M4_YY_PREFIX[[_create_buffer]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_delete_buffer]], [[M4_YY_PREFIX[[_delete_buffer]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_scan_buffer]], [[M4_YY_PREFIX[[_scan_buffer]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_scan_string]], [[M4_YY_PREFIX[[_scan_string]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_scan_bytes]], [[M4_YY_PREFIX[[_scan_bytes]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_init_buffer]], [[M4_YY_PREFIX[[_init_buffer]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_flush_buffer]], [[M4_YY_PREFIX[[_flush_buffer]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_load_buffer_state]], [[M4_YY_PREFIX[[_load_buffer_state]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_switch_to_buffer]], [[M4_YY_PREFIX[[_switch_to_buffer]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[push_buffer_state]], [[M4_YY_PREFIX[[push_buffer_state]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[pop_buffer_state]], [[M4_YY_PREFIX[[pop_buffer_state]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[ensure_buffer_stack]], [[M4_YY_PREFIX[[ensure_buffer_stack]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[lex]], [[M4_YY_PREFIX[[lex]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[restart]], [[M4_YY_PREFIX[[restart]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[lex_init]], [[M4_YY_PREFIX[[lex_init]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[lex_init_extra]], [[M4_YY_PREFIX[[lex_init_extra]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[lex_destroy]], [[M4_YY_PREFIX[[lex_destroy]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_debug]], [[M4_YY_PREFIX[[get_debug]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_debug]], [[M4_YY_PREFIX[[set_debug]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_extra]], [[M4_YY_PREFIX[[get_extra]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_extra]], [[M4_YY_PREFIX[[set_extra]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_in]], [[M4_YY_PREFIX[[get_in]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_in]], [[M4_YY_PREFIX[[set_in]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_out]], [[M4_YY_PREFIX[[get_out]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_out]], [[M4_YY_PREFIX[[set_out]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_leng]], [[M4_YY_PREFIX[[get_leng]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_text]], [[M4_YY_PREFIX[[get_text]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[get_lineno]], [[M4_YY_PREFIX[[get_lineno]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_lineno]], [[M4_YY_PREFIX[[set_lineno]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_ifdef( [[M4_YY_REENTRANT]],",
  "    [[",
  "        m4_define(yy[[get_column]], [[M4_YY_PREFIX[[get_column]]m4_ifelse($#,0,,[[($@)]])]])",
  "        m4_define(yy[[set_column]], [[M4_YY_PREFIX[[set_column]]m4_ifelse($#,0,,[[($@)]])]])",
  "    ]])",
  "    m4_define(yy[[wrap]], [[M4_YY_PREFIX[[wrap]]m4_ifelse($#,0,,[[($@)]])]])",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_BISON_LVAL]],",
  "[[",
  "    m4_define(yy[[get_lval]], [[M4_YY_PREFIX[[get_lval]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_lval]], [[M4_YY_PREFIX[[set_lval]]m4_ifelse($#,0,,[[($@)]])]])",
  "]])",
  "",
  "m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "[[",
  "    m4_define(yy[[get_lloc]], [[M4_YY_PREFIX[[get_lloc]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[set_lloc]], [[M4_YY_PREFIX[[set_lloc]]m4_ifelse($#,0,,[[($@)]])]])",
  "]])",
  "",
  "",
  "    m4_define(yy[[alloc]], [[M4_YY_PREFIX[[alloc]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[realloc]], [[M4_YY_PREFIX[[realloc]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[free]], [[M4_YY_PREFIX[[free]]m4_ifelse($#,0,,[[($@)]])]])",
  "",
  "%if-c-only",
  "m4_ifdef( [[M4_YY_NOT_REENTRANT]],",
  "[[",
  "    m4_define(yy[[text]], [[M4_YY_PREFIX[[text]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[leng]], [[M4_YY_PREFIX[[leng]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[in]], [[M4_YY_PREFIX[[in]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[out]], [[M4_YY_PREFIX[[out]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[_flex_debug]], [[M4_YY_PREFIX[[_flex_debug]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[lineno]], [[M4_YY_PREFIX[[lineno]]m4_ifelse($#,0,,[[($@)]])]])",
  "]])",
  "%endif",
  "",
  "",
  "m4_ifdef( [[M4_YY_TABLES_EXTERNAL]],",
  "[[",
  "    m4_define(yy[[tables_fload]], [[M4_YY_PREFIX[[tables_fload]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[tables_destroy]], [[M4_YY_PREFIX[[tables_destroy]]m4_ifelse($#,0,,[[($@)]])]])",
  "    m4_define(yy[[TABLES_NAME]], [[M4_YY_PREFIX[[TABLES_NAME]]m4_ifelse($#,0,,[[($@)]])]])",
  "]])",
  "",
  "/* First, we deal with  platform-specific or compiler-specific issues. */",
  "",
  "/* begin standard C headers. */",
  "%if-c-only",
  "#include <stdio.h>",
  "#include <string.h>",
  "#include <errno.h>",
  "#include <stdlib.h>",
  "%endif",
  "",
  "%if-tables-serialization",
  "#include <sys/types.h>",
  "#include <netinet/in.h>",
  "%endif",
  "/* end standard C headers. */",
  "",
  "%if-c-or-c++",
  "/* flex integer type definitions */",
  "",
  "#ifndef FLEXINT_H",
  "#define FLEXINT_H",
  "",
  "/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */",
  "",
  "#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L",
  "",
  "/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,",
  " * if you want the limit (max/min) macros for int types. ",
  " */",
  "#ifndef __STDC_LIMIT_MACROS",
  "#define __STDC_LIMIT_MACROS 1",
  "#endif",
  "",
  "#include <inttypes.h>",
  "typedef int8_t flex_int8_t;",
  "typedef uint8_t flex_uint8_t;",
  "typedef int16_t flex_int16_t;",
  "typedef uint16_t flex_uint16_t;",
  "typedef int32_t flex_int32_t;",
  "typedef uint32_t flex_uint32_t;",
  "#else",
  "typedef signed char flex_int8_t;",
  "typedef short int flex_int16_t;",
  "typedef int flex_int32_t;",
  "typedef unsigned char flex_uint8_t; ",
  "typedef unsigned short int flex_uint16_t;",
  "typedef unsigned int flex_uint32_t;",
  "",
  "/* Limits of integral types. */",
  "#ifndef INT8_MIN",
  "#define INT8_MIN               (-128)",
  "#endif",
  "#ifndef INT16_MIN",
  "#define INT16_MIN              (-32767-1)",
  "#endif",
  "#ifndef INT32_MIN",
  "#define INT32_MIN              (-2147483647-1)",
  "#endif",
  "#ifndef INT8_MAX",
  "#define INT8_MAX               (127)",
  "#endif",
  "#ifndef INT16_MAX",
  "#define INT16_MAX              (32767)",
  "#endif",
  "#ifndef INT32_MAX",
  "#define INT32_MAX              (2147483647)",
  "#endif",
  "#ifndef UINT8_MAX",
  "#define UINT8_MAX              (255U)",
  "#endif",
  "#ifndef UINT16_MAX",
  "#define UINT16_MAX             (65535U)",
  "#endif",
  "#ifndef UINT32_MAX",
  "#define UINT32_MAX             (4294967295U)",
  "#endif",
  "",
  "#endif /* ! C99 */",
  "",
  "#endif /* ! FLEXINT_H */",
  "",
  "%endif",
  "",
  "%if-c++-only",
  "/* begin standard C++ headers. */",
  "#include <iostream> ",
  "#include <errno.h>",
  "#include <cstdlib>",
  "#include <cstdio>",
  "#include <cstring>",
  "/* end standard C++ headers. */",
  "%endif",
  "",
  "/* TODO: this is always defined, so inline it */",
  "#define yyconst const",
  "",
  "#if defined(__GNUC__) && __GNUC__ >= 3",
  "#define yynoreturn __attribute__((__noreturn__))",
  "#else",
  "#define yynoreturn",
  "#endif",
  "",
  "%# For compilers that can not handle prototypes.",
  "%# e.g.,",
  "%# The function prototype",
  "%#    int foo(int x, char* y);",
  "%# ",
  "%# ...should be written as",
  "%#    int foo M4_YY_PARAMS(int x, char* y);",
  "%# ",
  "%# ...which could possibly generate",
  "%#    int foo ();",
  "%# ",
  "m4_ifdef( [[M4_YY_NO_ANSI_FUNC_PROTOS]],",
  "[[",
  "    m4_define( [[M4_YY_PARAMS]], [[()]])",
  "]],",
  "[[",
  "    m4_define( [[M4_YY_PARAMS]], [[($*)]])",
  "]])",
  "",
  "%not-for-header",
  "/* Returned upon end-of-file. */",
  "#define YY_NULL 0",
  "%ok-for-header",
  "",
  "%not-for-header",
  "/* Promotes a possibly negative, possibly signed char to an unsigned",
  " * integer for use as an array index.  If the signed char is negative,",
  " * we want to instead treat it as an 8-bit unsigned char, hence the",
  " * double cast.",
  " */",
  "#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)",
  "%ok-for-header",
  "",
  "",
  "",
  "%if-reentrant",
  "",
  "/* An opaque pointer. */",
  "#ifndef YY_TYPEDEF_YY_SCANNER_T",
  "#define YY_TYPEDEF_YY_SCANNER_T",
  "typedef void* yyscan_t;",
  "#endif",
  "",
  "%# Declare yyguts variable",
  "m4_define( [[M4_YY_DECL_GUTS_VAR]], [[struct yyguts_t * yyg = (struct yyguts_t*)yyscanner]])",
  "%# Perform a noop access on yyguts to prevent unused variable complains",
  "m4_define( [[M4_YY_NOOP_GUTS_VAR]], [[(void)yyg]])",
  "%# For use wherever a Global is accessed or assigned.",
  "m4_define( [[YY_G]], [[yyg->$1]])",
  "",
  "%# For use in function prototypes to append the additional argument.",
  "m4_define( [[M4_YY_PROTO_LAST_ARG]],  [[, yyscan_t yyscanner]])",
  "m4_define( [[M4_YY_PROTO_ONLY_ARG]],  [[yyscan_t yyscanner]])",
  "",
  "%# For use in function definitions to append the additional argument.",
  "m4_ifdef( [[M4_YY_NO_ANSI_FUNC_DEFS]],",
  "[[",
  "    m4_define( [[M4_YY_DEF_LAST_ARG]], [[, yyscanner]])",
  "    m4_define( [[M4_YY_DEF_ONLY_ARG]], [[yyscanner]])",
  "]],",
  "[[",
  "    m4_define( [[M4_YY_DEF_LAST_ARG]],  [[, yyscan_t yyscanner]])",
  "    m4_define( [[M4_YY_DEF_ONLY_ARG]],  [[yyscan_t yyscanner]])",
  "]])",
  "m4_define( [[M4_YY_DECL_LAST_ARG]],  [[yyscan_t yyscanner;]])",
  "",
  "%# For use in function calls to pass the additional argument.",
  "m4_define( [[M4_YY_CALL_LAST_ARG]], [[, yyscanner]])",
  "m4_define( [[M4_YY_CALL_ONLY_ARG]], [[yyscanner]])",
  "",
  "%# For use in function documentation to adjust for additional argument.",
  "m4_define( [[M4_YY_DOC_PARAM]], [[@param yyscanner The scanner object.]])",
  "",
  "/* For convenience, these vars (plus the bison vars far below)",
  "   are macros in the reentrant scanner. */",
  "#define yyin YY_G(yyin_r)",
  "#define yyout YY_G(yyout_r)",
  "#define yyextra YY_G(yyextra_r)",
  "#define yyleng YY_G(yyleng_r)",
  "#define yytext YY_G(yytext_r)",
  "#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)",
  "#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)",
  "#define yy_flex_debug YY_G(yy_flex_debug_r)",
  "",
  "m4_define( [[M4_YY_INCR_LINENO]],",
  "[[   ",
  "    do{ yylineno++;",
  "        yycolumn=0;",
  "    }while(0)",
  "]])",
  "",
  "%endif",
  "",
  "",
  "",
  "%if-not-reentrant",
  "",
  "m4_define( [[M4_YY_INCR_LINENO]],",
  "[[   ",
  "    yylineno++;",
  "]])",
  "",
  "%# Define these macros to be no-ops.",
  "m4_define( [[M4_YY_DECL_GUTS_VAR]], [[m4_dnl]])",
  "m4_define( [[M4_YY_NOOP_GUTS_VAR]], [[m4_dnl]])",
  "m4_define( [[YY_G]], [[($1)]])",
  "m4_define( [[M4_YY_PROTO_LAST_ARG]])",
  "m4_define( [[M4_YY_PROTO_ONLY_ARG]],  [[void]])",
  "m4_define( [[M4_YY_DEF_LAST_ARG]])",
  "",
  "m4_ifdef( [[M4_YY_NO_ANSI_FUNC_DEFS]],",
  "[[",
  "    m4_define( [[M4_YY_DEF_ONLY_ARG]])",
  "]],",
  "[[",
  "    m4_define( [[M4_YY_DEF_ONLY_ARG]],  [[void]])",
  "]])",
  "m4_define([[M4_YY_DECL_LAST_ARG]])",
  "m4_define([[M4_YY_CALL_LAST_ARG]])",
  "m4_define([[M4_YY_CALL_ONLY_ARG]])",
  "m4_define( [[M4_YY_DOC_PARAM]], [[]])",
  "",
  "%endif",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_ANSI_FUNC_DEFS]],",
  "[[",
  "%# For compilers that need traditional function definitions.",
  "%# e.g.,",
  "%# The function prototype taking 2 arguments",
  "%#    int foo (int x, char* y)",
  "%#",
  "%# ...should be written as",
  "%#    int foo YYFARGS2(int,x, char*,y)",
  "%#",
  "%# ...which could possibly generate",
  "%#    int foo (x,y,yyscanner)",
  "%#        int x;",
  "%#        char * y;",
  "%#        yyscan_t yyscanner;",
  "%#",
  "%# Generate traditional function defs",
  "    m4_define( [[YYFARGS0]], [[(M4_YY_DEF_ONLY_ARG) [[\\]]",
  "        M4_YY_DECL_LAST_ARG]])",
  "    m4_define( [[YYFARGS1]], [[($2 M4_YY_DEF_LAST_ARG) [[\\]]",
  "        $1 $2; [[\\]]",
  "        M4_YY_DECL_LAST_ARG]])",
  "    m4_define( [[YYFARGS2]], [[($2,$4 M4_YY_DEF_LAST_ARG) [[\\]]",
  "        $1 $2; [[\\]]",
  "        $3 $4; [[\\]]",
  "        M4_YY_DECL_LAST_ARG]])",
  "    m4_define( [[YYFARGS3]], [[($2,$4,$6 M4_YY_DEF_LAST_ARG) [[\\]]",
  "        $1 $2; [[\\]]",
  "        $3 $4; [[\\]]",
  "        $5 $6; [[\\]]",
  "        M4_YY_DECL_LAST_ARG]])",
  "]],",
  "[[",
  "%# Generate C99 function defs.",
  "    m4_define( [[YYFARGS0]], [[(M4_YY_DEF_ONLY_ARG)]])",
  "    m4_define( [[YYFARGS1]], [[($1 $2 M4_YY_DEF_LAST_ARG)]])",
  "    m4_define( [[YYFARGS2]], [[($1 $2, $3 $4 M4_YY_DEF_LAST_ARG)]])",
  "    m4_define( [[YYFARGS3]], [[($1 $2, $3 $4, $5 $6 M4_YY_DEF_LAST_ARG)]])",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Enter a start condition.  This macro really ought to take a parameter,",
  " * but we do it the disgusting crufty way forced on us by the ()-less",
  " * definition of BEGIN.",
  " */",
  "#define BEGIN YY_G(yy_start) = 1 + 2 *",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Translate the current start state into a value that can be later handed",
  " * to BEGIN to return to the state.  The YYSTATE alias is for lex",
  " * compatibility.",
  " */",
  "#define YY_START ((YY_G(yy_start) - 1) / 2)",
  "#define YYSTATE YY_START",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Action number for EOF rule of a given start state. */",
  "#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Special action meaning \"start processing a new file\". */",
  "#define YY_NEW_FILE yyrestart( yyin M4_YY_CALL_LAST_ARG )",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define YY_END_OF_BUFFER_CHAR 0",
  "]])",
  "",
  "/* Size of default input buffer. */",
  "#ifndef YY_BUF_SIZE",
  "#ifdef __ia64__",
  "/* On IA-64, the buffer size is 16k, not 8k.",
  " * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.",
  " * Ditto for the __ia64__ case accordingly.",
  " */",
  "#define YY_BUF_SIZE 32768",
  "#else",
  "#define YY_BUF_SIZE 16384",
  "#endif /* __ia64__ */",
  "#endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* The state buf must be large enough to hold one state per character in the main buffer.",
  " */",
  "#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))",
  "]])",
  "",
  "",
  "#ifndef YY_TYPEDEF_YY_BUFFER_STATE",
  "#define YY_TYPEDEF_YY_BUFFER_STATE",
  "typedef struct yy_buffer_state *YY_BUFFER_STATE;",
  "#endif",
  "",
  "#ifndef YY_TYPEDEF_YY_SIZE_T",
  "#define YY_TYPEDEF_YY_SIZE_T",
  "typedef size_t yy_size_t;",
  "#endif",
  "",
  "%if-not-reentrant",
  "extern int yyleng;",
  "%endif",
  "",
  "%if-c-only",
  "%if-not-reentrant",
  "extern FILE *yyin, *yyout;",
  "%endif",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define EOB_ACT_CONTINUE_SCAN 0",
  "#define EOB_ACT_END_OF_FILE 1",
  "#define EOB_ACT_LAST_MATCH 2",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "    m4_ifdef( [[M4_YY_USE_LINENO]],",
  "    [[",
  "    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires",
  "     *       access to the local variable yy_act. Since yyless() is a macro, it would break",
  "     *       existing scanners that call yyless() from OUTSIDE yylex. ",
  "     *       One obvious solution it to make yy_act a global. I tried that, and saw",
  "     *       a 5% performance hit in a non-yylineno scanner, because yy_act is",
  "     *       normally declared as a register variable-- so it is not worth it.",
  "     */",
  "    #define  YY_LESS_LINENO(n) \\",
  "            do { \\",
  "                int yyl;\\",
  "                for ( yyl = n; yyl < yyleng; ++yyl )\\",
  "                    if ( yytext[yyl] == '\\n' )\\",
  "                        --yylineno;\\",
  "            }while(0)",
  "    #define YY_LINENO_REWIND_TO(dst) \\",
  "            do {\\",
  "                const char *p;\\",
  "                for ( p = yy_cp-1; p >= (dst); --p)\\",
  "                    if ( *p == '\\n' )\\",
  "                        --yylineno;\\",
  "            }while(0)",
  "    ]],",
  "    [[",
  "    #define YY_LESS_LINENO(n)",
  "    #define YY_LINENO_REWIND_TO(ptr)",
  "    ]])",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Return all but the first \"n\" matched characters back to the input stream. */",
  "#define yyless(n) \\",
  "	do \\",
  "		{ \\",
  "		/* Undo effects of setting up yytext. */ \\",
  "        int yyless_macro_arg = (n); \\",
  "        YY_LESS_LINENO(yyless_macro_arg);\\",
  "		*yy_cp = YY_G(yy_hold_char); \\",
  "		YY_RESTORE_YY_MORE_OFFSET \\",
  "		YY_G(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \\",
  "		YY_DO_BEFORE_ACTION; /* set up yytext again */ \\",
  "		} \\",
  "	while ( 0 )",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define unput(c) yyunput( c, YY_G(yytext_ptr) M4_YY_CALL_LAST_ARG )",
  "]])",
  "",
  "#ifndef YY_STRUCT_YY_BUFFER_STATE",
  "#define YY_STRUCT_YY_BUFFER_STATE",
  "struct yy_buffer_state",
  "	{",
  "%if-c-only",
  "	FILE *yy_input_file;",
  "%endif",
  "",
  "%if-c++-only",
  "	std::streambuf* yy_input_file; ",
  "%endif",
  "",
  "",
  "	char *yy_ch_buf;		/* input buffer */",
  "	char *yy_buf_pos;		/* current position in input buffer */",
  "",
  "	/* Size of input buffer in bytes, not including room for EOB",
  "	 * characters.",
  "	 */",
  "	int yy_buf_size;",
  "",
  "	/* Number of characters read into yy_ch_buf, not including EOB",
  "	 * characters.",
  "	 */",
  "	int yy_n_chars;",
  "",
  "	/* Whether we \"own\" the buffer - i.e., we know we created it,",
  "	 * and can realloc() it to grow it, and should free() it to",
  "	 * delete it.",
  "	 */",
  "	int yy_is_our_buffer;",
  "",
  "	/* Whether this is an \"interactive\" input source; if so, and",
  "	 * if we're using stdio for input, then we want to use getc()",
  "	 * instead of fread(), to make sure we stop fetching input after",
  "	 * each newline.",
  "	 */",
  "	int yy_is_interactive;",
  "",
  "	/* Whether we're considered to be at the beginning of a line.",
  "	 * If so, '^' rules will be active on the next match, otherwise",
  "	 * not.",
  "	 */",
  "	int yy_at_bol;",
  "",
  "    int yy_bs_lineno; /**< The line count. */",
  "    int yy_bs_column; /**< The column count. */",
  "    ",
  "",
  "	/* Whether to try to fill the input buffer when we reach the",
  "	 * end of it.",
  "	 */",
  "	int yy_fill_buffer;",
  "",
  "	int yy_buffer_status;",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define YY_BUFFER_NEW 0",
  "#define YY_BUFFER_NORMAL 1",
  "	/* When an EOF's been seen but there's still some text to process",
  "	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we",
  "	 * shouldn't try reading from the input source any more.  We might",
  "	 * still have a bunch of tokens to match, though, because of",
  "	 * possible backing-up.",
  "	 *",
  "	 * When we actually see the EOF, we change the status to \"new\"",
  "	 * (via yyrestart()), so that the user can continue scanning by",
  "	 * just pointing yyin at a new input file.",
  "	 */",
  "#define YY_BUFFER_EOF_PENDING 2",
  "]])",
  "	};",
  "#endif /* !YY_STRUCT_YY_BUFFER_STATE */",
  "",
  "%if-c-only Standard (non-C++) definition",
  "%not-for-header",
  "%if-not-reentrant",
  "",
  "/* Stack of input buffers. */",
  "static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */",
  "static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */",
  "static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */",
  "%endif",
  "%ok-for-header",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* We provide macros for accessing buffer states in case in the",
  " * future we want to put the buffer states in a more general",
  " * \"scanner state\".",
  " *",
  " * Returns the top of the stack, or NULL.",
  " */",
  "#define YY_CURRENT_BUFFER ( YY_G(yy_buffer_stack) \\",
  "                          ? YY_G(yy_buffer_stack)[YY_G(yy_buffer_stack_top)] \\",
  "                          : NULL)",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Same as previous macro, but useful when we know that the buffer stack is not",
  " * NULL or when we need an lvalue. For internal use only.",
  " */",
  "#define YY_CURRENT_BUFFER_LVALUE YY_G(yy_buffer_stack)[YY_G(yy_buffer_stack_top)]",
  "]])",
  "",
  "%if-c-only Standard (non-C++) definition",
  "",
  "%if-not-reentrant",
  "%not-for-header",
  "/* yy_hold_char holds the character lost when yytext is formed. */",
  "static char yy_hold_char;",
  "static int yy_n_chars;		/* number of characters read into yy_ch_buf */",
  "int yyleng;",
  "",
  "/* Points to current character in buffer. */",
  "static char *yy_c_buf_p = NULL;",
  "static int yy_init = 0;		/* whether we need to initialize */",
  "static int yy_start = 0;	/* start state number */",
  "",
  "/* Flag which is used to allow yywrap()'s to do buffer switches",
  " * instead of setting up a fresh yyin.  A bit of a hack ...",
  " */",
  "static int yy_did_buffer_switch_on_eof;",
  "%ok-for-header",
  "%endif",
  "",
  "void yyrestart M4_YY_PARAMS( FILE *input_file M4_YY_PROTO_LAST_ARG );",
  "void yy_switch_to_buffer M4_YY_PARAMS( YY_BUFFER_STATE new_buffer M4_YY_PROTO_LAST_ARG );",
  "YY_BUFFER_STATE yy_create_buffer M4_YY_PARAMS( FILE *file, int size M4_YY_PROTO_LAST_ARG );",
  "void yy_delete_buffer M4_YY_PARAMS( YY_BUFFER_STATE b M4_YY_PROTO_LAST_ARG );",
  "void yy_flush_buffer M4_YY_PARAMS( YY_BUFFER_STATE b M4_YY_PROTO_LAST_ARG );",
  "void yypush_buffer_state M4_YY_PARAMS( YY_BUFFER_STATE new_buffer M4_YY_PROTO_LAST_ARG );",
  "void yypop_buffer_state M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "static void yyensure_buffer_stack M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "static void yy_load_buffer_state M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "static void yy_init_buffer M4_YY_PARAMS( YY_BUFFER_STATE b, FILE *file M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER M4_YY_CALL_LAST_ARG)",
  "]])",
  "",
  "YY_BUFFER_STATE yy_scan_buffer M4_YY_PARAMS( char *base, yy_size_t size M4_YY_PROTO_LAST_ARG );",
  "YY_BUFFER_STATE yy_scan_string M4_YY_PARAMS( yyconst char *yy_str M4_YY_PROTO_LAST_ARG );",
  "YY_BUFFER_STATE yy_scan_bytes M4_YY_PARAMS( yyconst char *bytes, int len M4_YY_PROTO_LAST_ARG );",
  "",
  "%endif",
  "",
  "void *yyalloc M4_YY_PARAMS( yy_size_t M4_YY_PROTO_LAST_ARG );",
  "void *yyrealloc M4_YY_PARAMS( void *, yy_size_t M4_YY_PROTO_LAST_ARG );",
  "void yyfree M4_YY_PARAMS( void * M4_YY_PROTO_LAST_ARG );",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define yy_new_buffer yy_create_buffer",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define yy_set_interactive(is_interactive) \\",
  "	{ \\",
  "	if ( ! YY_CURRENT_BUFFER ){ \\",
  "        yyensure_buffer_stack (M4_YY_CALL_ONLY_ARG); \\",
  "		YY_CURRENT_BUFFER_LVALUE =    \\",
  "            yy_create_buffer( yyin, YY_BUF_SIZE M4_YY_CALL_LAST_ARG); \\",
  "	} \\",
  "	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \\",
  "	}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define yy_set_bol(at_bol) \\",
  "	{ \\",
  "	if ( ! YY_CURRENT_BUFFER ){\\",
  "        yyensure_buffer_stack (M4_YY_CALL_ONLY_ARG); \\",
  "		YY_CURRENT_BUFFER_LVALUE =    \\",
  "            yy_create_buffer( yyin, YY_BUF_SIZE M4_YY_CALL_LAST_ARG); \\",
  "	} \\",
  "	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \\",
  "	}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)",
  "]])",
  "",
  "%% [1.0] yytext/yyin/yyout/yy_state_type/yylineno etc. def's & init go here",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "%% [1.5] DFA",
  "]])",
  "",
  "%if-c-only Standard (non-C++) definition",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "static yy_state_type yy_get_previous_state M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "static yy_state_type yy_try_NUL_trans M4_YY_PARAMS( yy_state_type current_state  M4_YY_PROTO_LAST_ARG);",
  "static int yy_get_next_buffer M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "static void yynoreturn yy_fatal_error M4_YY_PARAMS( yyconst char* msg M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Done after the current pattern has been matched and before the",
  " * corresponding action - sets up yytext.",
  " */",
  "#define YY_DO_BEFORE_ACTION \\",
  "	YY_G(yytext_ptr) = yy_bp; \\",
  "%% [2.0] code to fiddle yytext and yyleng for yymore() goes here \\",
  "	YY_G(yy_hold_char) = *yy_cp; \\",
  "	*yy_cp = '\\0'; \\",
  "%% [3.0] code to copy yytext_ptr to yytext[] goes here, if %array \\",
  "	YY_G(yy_c_buf_p) = yy_cp;",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "%% [4.0] data tables for the DFA and the user's section 1 definitions go here",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_IN_HEADER]], [[#ifdef YY_HEADER_EXPORT_START_CONDITIONS]])",
  "M4_YY_SC_DEFS",
  "m4_ifdef( [[M4_YY_IN_HEADER]], [[#endif]])",
  "",
  "m4_ifdef( [[M4_YY_NO_UNISTD_H]],,",
  "[[",
  "#ifndef YY_NO_UNISTD_H",
  "/* Special case for \"unistd.h\", since it is non-ANSI. We include it way",
  " * down here because we want the user's section 1 to have been scanned first.",
  " * The user has a chance to override it with an option.",
  " */",
  "%if-c-only",
  "#include <unistd.h>",
  "%endif",
  "%if-c++-only",
  "#include <unistd.h>",
  "%endif",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_EXTRA_TYPE_DEFS]],",
  "[[",
  "#define YY_EXTRA_TYPE M4_EXTRA_TYPE_DEFS",
  "]],",
  "[[",
  "#ifndef YY_EXTRA_TYPE",
  "#define YY_EXTRA_TYPE void *",
  "#endif",
  "]]",
  ")",
  "",
  "%if-c-only Reentrant structure and macros (non-C++).",
  "%if-reentrant",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Holds the entire state of the reentrant scanner. */",
  "struct yyguts_t",
  "    {",
  "",
  "    /* User-defined. Not touched by flex. */",
  "    YY_EXTRA_TYPE yyextra_r;",
  "",
  "    /* The rest are the same as the globals declared in the non-reentrant scanner. */",
  "    FILE *yyin_r, *yyout_r;",
  "    size_t yy_buffer_stack_top; /**< index of top of stack. */",
  "    size_t yy_buffer_stack_max; /**< capacity of stack. */",
  "    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */",
  "    char yy_hold_char;",
  "    int yy_n_chars;",
  "    int yyleng_r;",
  "    char *yy_c_buf_p;",
  "    int yy_init;",
  "    int yy_start;",
  "    int yy_did_buffer_switch_on_eof;",
  "    int yy_start_stack_ptr;",
  "    int yy_start_stack_depth;",
  "    int *yy_start_stack;",
  "    yy_state_type yy_last_accepting_state;",
  "    char* yy_last_accepting_cpos;",
  "",
  "    int yylineno_r;",
  "    int yy_flex_debug_r;",
  "",
  "m4_ifdef( [[M4_YY_USES_REJECT]],",
  "[[",
  "    yy_state_type *yy_state_buf;",
  "    yy_state_type *yy_state_ptr;",
  "    char *yy_full_match;",
  "    int yy_lp;",
  "",
  "    /* These are only needed for trailing context rules,",
  "     * but there's no conditional variable for that yet. */",
  "    int yy_looking_for_trail_begin;",
  "    int yy_full_lp;",
  "    int *yy_full_state;",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_TEXT_IS_ARRAY]],",
  "[[",
  "    char yytext_r[YYLMAX];",
  "    char *yytext_ptr;",
  "    int yy_more_offset;",
  "    int yy_prev_more_offset;",
  "]],",
  "[[",
  "    char *yytext_r;",
  "    int yy_more_flag;",
  "    int yy_more_len;",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_BISON_LVAL]],",
  "[[",
  "    YYSTYPE * yylval_r;",
  "]])",
  "",
  "m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "[[",
  "    YYLTYPE * yylloc_r;",
  "]])",
  "",
  "    }; /* end struct yyguts_t */",
  "]])",
  "",
  "",
  "%if-c-only",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "static int yy_init_globals M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "%endif",
  "",
  "%if-reentrant",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "    m4_ifdef( [[M4_YY_BISON_LVAL]],",
  "    [[",
  "    /* This must go here because YYSTYPE and YYLTYPE are included",
  "     * from bison output in section 1.*/",
  "    #    define yylval YY_G(yylval_r)",
  "    ]])",
  "",
  "    m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "    [[",
  "    #    define yylloc YY_G(yylloc_r)",
  "    ]])",
  "]])",
  "",
  "int yylex_init M4_YY_PARAMS(yyscan_t* scanner);",
  "",
  "int yylex_init_extra M4_YY_PARAMS( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);",
  "",
  "%endif",
  "",
  "%endif End reentrant structures and macros.",
  "",
  "/* Accessor methods to globals.",
  "   These are made visible to non-reentrant scanners for convenience. */",
  "",
  "m4_ifdef( [[M4_YY_NO_DESTROY]],,",
  "[[",
  "int yylex_destroy M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_DEBUG]],,",
  "[[",
  "int yyget_debug M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_DEBUG]],,",
  "[[",
  "void yyset_debug M4_YY_PARAMS( int debug_flag M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_EXTRA]],,",
  "[[",
  "YY_EXTRA_TYPE yyget_extra M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_EXTRA]],,",
  "[[",
  "void yyset_extra M4_YY_PARAMS( YY_EXTRA_TYPE user_defined M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_IN]],,",
  "[[",
  "FILE *yyget_in M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_IN]],,",
  "[[",
  "void yyset_in  M4_YY_PARAMS( FILE * _in_str M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_OUT]],,",
  "[[",
  "FILE *yyget_out M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_OUT]],,",
  "[[",
  "void yyset_out  M4_YY_PARAMS( FILE * _out_str M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_LENG]],,",
  "[[",
  "			int yyget_leng M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_TEXT]],,",
  "[[",
  "char *yyget_text M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_LINENO]],,",
  "[[",
  "int yyget_lineno M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_LINENO]],,",
  "[[",
  "void yyset_lineno M4_YY_PARAMS( int _line_number M4_YY_PROTO_LAST_ARG );",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_REENTRANT]],",
  "[[",
  "m4_ifdef( [[M4_YY_NO_GET_COLUMN]],,",
  "[[",
  "int yyget_column  M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_REENTRANT]],",
  "[[",
  "m4_ifdef( [[M4_YY_NO_SET_COLUMN]],,",
  "[[",
  "void yyset_column M4_YY_PARAMS( int _column_no M4_YY_PROTO_LAST_ARG );",
  "]])",
  "]])",
  "",
  "%if-bison-bridge",
  "m4_ifdef( [[M4_YY_NO_GET_LVAL]],,",
  "[[",
  "YYSTYPE * yyget_lval M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "]])",
  "",
  "void yyset_lval M4_YY_PARAMS( YYSTYPE * yylval_param M4_YY_PROTO_LAST_ARG );",
  "",
  "m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "[[",
  "    m4_ifdef( [[M4_YY_NO_GET_LLOC]],,",
  "    [[",
  "       YYLTYPE *yyget_lloc M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "    ]])",
  "",
  "    m4_ifdef( [[M4_YY_NO_SET_LLOC]],,",
  "    [[",
  "        void yyset_lloc M4_YY_PARAMS( YYLTYPE * yylloc_param M4_YY_PROTO_LAST_ARG );",
  "    ]])",
  "]])",
  "%endif",
  "",
  "/* Macros after this point can all be overridden by user definitions in",
  " * section 1.",
  " */",
  "",
  "#ifndef YY_SKIP_YYWRAP",
  "#ifdef __cplusplus",
  "extern \"C\" int yywrap M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "#else",
  "extern int yywrap M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "#endif",
  "#endif",
  "",
  "%not-for-header",
  "#ifndef YY_NO_UNPUT",
  "    m4_ifdef( [[M4_YY_NO_UNPUT]],,",
  "    [[",
  "    static void yyunput M4_YY_PARAMS( int c, char *buf_ptr  M4_YY_PROTO_LAST_ARG);",
  "    ]])",
  "#endif",
  "%ok-for-header",
  "%endif",
  "",
  "#ifndef yytext_ptr",
  "static void yy_flex_strncpy M4_YY_PARAMS( char *, yyconst char *, int M4_YY_PROTO_LAST_ARG);",
  "#endif",
  "",
  "#ifdef YY_NEED_STRLEN",
  "static int yy_flex_strlen M4_YY_PARAMS( yyconst char * M4_YY_PROTO_LAST_ARG);",
  "#endif",
  "",
  "#ifndef YY_NO_INPUT",
  "%if-c-only Standard (non-C++) definition",
  "%not-for-header",
  "#ifdef __cplusplus",
  "static int yyinput M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "#else",
  "static int input M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "#endif",
  "%ok-for-header",
  "%endif",
  "#endif",
  "",
  "",
  "%if-c-only",
  "%# TODO: This is messy.",
  "m4_ifdef( [[M4_YY_STACK_USED]],",
  "[[",
  "",
  "m4_ifdef( [[M4_YY_NOT_REENTRANT]],",
  "[[",
  "    m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "    [[",
  "        static int yy_start_stack_ptr = 0;",
  "        static int yy_start_stack_depth = 0;",
  "        static int *yy_start_stack = NULL;",
  "    ]])",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "    m4_ifdef( [[M4_YY_NO_PUSH_STATE]],,",
  "    [[",
  "    static void yy_push_state M4_YY_PARAMS( int _new_state M4_YY_PROTO_LAST_ARG);",
  "    ]])",
  "    m4_ifdef( [[M4_YY_NO_POP_STATE]],,",
  "    [[",
  "    static void yy_pop_state M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "    ]])",
  "    m4_ifdef( [[M4_YY_NO_TOP_STATE]],,",
  "    [[",
  "    static int yy_top_state M4_YY_PARAMS( M4_YY_PROTO_ONLY_ARG );",
  "    ]])",
  "]])",
  "",
  "]],",
  "[[",
  "m4_define( [[M4_YY_NO_PUSH_STATE]])",
  "m4_define( [[M4_YY_NO_POP_STATE]])",
  "m4_define( [[M4_YY_NO_TOP_STATE]])",
  "]])",
  "%endif",
  "",
  "/* Amount of stuff to slurp up with each read. */",
  "#ifndef YY_READ_BUF_SIZE",
  "#ifdef __ia64__",
  "/* On IA-64, the buffer size is 16k, not 8k */",
  "#define YY_READ_BUF_SIZE 16384",
  "#else",
  "#define YY_READ_BUF_SIZE 8192",
  "#endif /* __ia64__ */",
  "#endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Copy whatever the last rule matched to the standard output. */",
  "#ifndef ECHO",
  "%if-c-only Standard (non-C++) definition",
  "/* This used to be an fputs(), but since the string might contain NUL's,",
  " * we now use fwrite().",
  " */",
  "#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)",
  "%endif",
  "%if-c++-only C++ definition",
  "#define ECHO LexerOutput( yytext, yyleng )",
  "%endif",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Gets input and stuffs it into \"buf\".  number of characters read, or YY_NULL,",
  " * is returned in \"result\".",
  " */",
  "#ifndef YY_INPUT",
  "#define YY_INPUT(buf,result,max_size) \\",
  "%% [5.0] fread()/read() definition of YY_INPUT goes here unless we're doing C++ \\",
  "\\",
  "%if-c++-only C++ definition \\",
  "	if ( (int)(result = LexerInput( (char *) buf, max_size )) < 0 ) \\",
  "		YY_FATAL_ERROR( \"input in flex scanner failed\" );",
  "%endif",
  "",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* No semi-colon after return; correct usage is to write \"yyterminate();\" -",
  " * we don't want an extra ';' after the \"return\" because that will cause",
  " * some compilers to complain about unreachable statements.",
  " */",
  "#ifndef yyterminate",
  "#define yyterminate() return YY_NULL",
  "#endif",
  "]])",
  "",
  "/* Number of entries by which start-condition stack grows. */",
  "#ifndef YY_START_STACK_INCR",
  "#define YY_START_STACK_INCR 25",
  "#endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Report a fatal error. */",
  "#ifndef YY_FATAL_ERROR",
  "%if-c-only",
  "#define YY_FATAL_ERROR(msg) yy_fatal_error( msg M4_YY_CALL_LAST_ARG)",
  "%endif",
  "%if-c++-only",
  "#define YY_FATAL_ERROR(msg) LexerError( msg )",
  "%endif",
  "#endif",
  "]])",
  "",
  "%if-tables-serialization structures and prototypes",
  "#ifdef FLEX_SCANNER",
  "/*",
  "dnl  tables_shared.h - tables serialization header",
  "dnl",
  "dnl  Copyright (c) 1990 The Regents of the University of California.",
  "dnl  All rights reserved.",
  "dnl",
  "dnl  This code is derived from software contributed to Berkeley by",
  "dnl  Vern Paxson.",
  "dnl",
  "dnl  The United States Government has rights in this work pursuant",
  "dnl  to contract no. DE-AC03-76SF00098 between the United States",
  "dnl  Department of Energy and the University of California.",
  "dnl",
  "dnl  This file is part of flex.",
  "dnl",
  "dnl  Redistribution and use in source and binary forms, with or without",
  "dnl  modification, are permitted provided that the following conditions",
  "dnl  are met:",
  "dnl",
  "dnl  1. Redistributions of source code must retain the above copyright",
  "dnl     notice, this list of conditions and the following disclaimer.",
  "dnl  2. Redistributions in binary form must reproduce the above copyright",
  "dnl     notice, this list of conditions and the following disclaimer in the",
  "dnl     documentation and/or other materials provided with the distribution.",
  "dnl",
  "dnl  Neither the name of the University nor the names of its contributors",
  "dnl  may be used to endorse or promote products derived from this software",
  "dnl  without specific prior written permission.",
  "dnl",
  "dnl  THIS SOFTWARE IS PROVIDED `AS IS' AND WITHOUT ANY EXPRESS OR",
  "dnl  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED",
  "dnl  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR",
  "dnl  PURPOSE.",
  "",
  "dnl",
  "dnl  This file is meant to be included in both the skeleton and the actual",
  "dnl  flex code (hence the name \"_shared\").",
  "*/",
  "#ifndef yyskel_static",
  "#define yyskel_static static",
  "#endif",
  "#else",
  "#ifndef yyskel_static",
  "#define yyskel_static",
  "#endif",
  "#endif",
  "",
  "/* Structures and prototypes for serializing flex tables.  The",
  " * binary format is documented in the manual.",
  " *",
  " * Design considerations:",
  " *",
  " *  -  The format allows many tables per file.",
  " *  -  The tables can be streamed.",
  " *  -  All data is stored in network byte order.",
  " *  -  We do not hinder future unicode support.",
  " *  -  We can lookup tables by name.",
  " */",
  "",
  "/** Magic number for serialized format. */",
  "#ifndef YYTBL_MAGIC",
  "#define YYTBL_MAGIC 0xF13C57B1",
  "#endif",
  "",
  "/** Calculate (0-7) = number bytes needed to pad n to next 64-bit boundary. */",
  "#ifndef yypad64",
  "#define yypad64(n) ((8-((n)%8))%8)",
  "#endif",
  "",
  "",
  "#ifndef YYTABLES_TYPES",
  "#define YYTABLES_TYPES",
  "/** Possible values for td_id field. Each one corresponds to a",
  " *  scanner table of the same name.",
  " */",
  "enum yytbl_id {",
  "	YYTD_ID_ACCEPT = 0x01,		/**< 1-dim ints */",
  "	YYTD_ID_BASE = 0x02,		/**< 1-dim ints */",
  "	YYTD_ID_CHK = 0x03,		/**< 1-dim ints */",
  "	YYTD_ID_DEF = 0x04,		/**< 1-dim ints */",
  "	YYTD_ID_EC = 0x05,		/**< 1-dim ints */",
  "	YYTD_ID_META = 0x06,		/**< 1-dim ints */",
  "	YYTD_ID_NUL_TRANS = 0x07,	/**< 1-dim ints, maybe indices */",
  "	YYTD_ID_NXT = 0x08,		/**< may be 2 dimensional ints */",
  "	YYTD_ID_RULE_CAN_MATCH_EOL = 0x09, /**< 1-dim ints */",
  "	YYTD_ID_START_STATE_LIST = 0x0A,	/**< 1-dim indices into trans tbl  */",
  "	YYTD_ID_TRANSITION = 0x0B,	/**< structs */",
  "	YYTD_ID_ACCLIST = 0x0C		/**< 1-dim ints */",
  "};",
  "",
  "/** bit flags for t_flags field of struct yytbl_data */",
  "enum yytbl_flags {",
  "	/* These first three are mutually exclusive */",
  "	YYTD_DATA8 = 0x01,   /**< data is an array of type flex_int8_t */",
  "	YYTD_DATA16 = 0x02,  /**< data is an array of type flex_int16_t */",
  "	YYTD_DATA32 = 0x04,  /**< data is an array of type flex_int32_t */",
  "",
  "	/* These two are mutually exclusive. */",
  "	YYTD_PTRANS = 0x08,  /**< data is a list of indexes of entries",
  "                                 into the expanded yy_transition",
  "                                 array. See notes in manual. */",
  "	YYTD_STRUCT = 0x10  /**< data consists of yy_trans_info structs */",
  "};",
  "",
  "/* The serialized tables header. */",
  "struct yytbl_hdr {",
  "	flex_uint32_t th_magic;  /**< Must be 0xF13C57B1 (comes from \"Flex Table\") */",
  "	flex_uint32_t th_hsize;  /**< Size of this header in bytes. */",
  "	flex_uint32_t th_ssize;  /**< Size of this dataset, in bytes, including header. */",
  "	flex_uint16_t th_flags;  /**< Currently unused, must be 0 */",
  "	char   *th_version; /**< Flex version string. NUL terminated. */",
  "	char   *th_name;    /**< The name of this table set. NUL terminated. */",
  "};",
  "",
  "/** A single serialized table */",
  "struct yytbl_data {",
  "	flex_uint16_t td_id;      /**< enum yytbl_id table identifier */",
  "	flex_uint16_t td_flags;   /**< how to interpret this data */",
  "	flex_uint32_t td_hilen;   /**< num elements in highest dimension array */",
  "	flex_uint32_t td_lolen;   /**< num elements in lowest dimension array */",
  "	void   *td_data;     /**< table data */",
  "};",
  "#endif",
  "",
  "/** Extract corresponding data size_t from td_flags */",
  "#ifndef YYTDFLAGS2BYTES",
  "#define YYTDFLAGS2BYTES(td_flags)\\",
  "        (((td_flags) & YYTD_DATA8)\\",
  "            ? sizeof(flex_int8_t)\\",
  "            :(((td_flags) & YYTD_DATA16)\\",
  "                ? sizeof(flex_int16_t)\\",
  "                :sizeof(flex_int32_t)))",
  "#endif",
  "",
  "#ifdef FLEX_SCANNER",
  "%not-for-header",
  "#endif",
  "yyskel_static flex_int32_t yytbl_calc_total_len (const struct yytbl_data *tbl);",
  "#ifdef FLEX_SCANNER",
  "%ok-for-header",
  "#endif",
  "",
  "/* vim:set noexpandtab cindent tabstop=8 softtabstop=0 shiftwidth=8 textwidth=0: */",
  "",
  "",
  "/* Load the DFA tables from the given stream.  */",
  "int yytables_fload M4_YY_PARAMS(FILE * fp M4_YY_PROTO_LAST_ARG);",
  "",
  "/* Unload the tables from memory. */",
  "int yytables_destroy M4_YY_PARAMS(M4_YY_PROTO_ONLY_ARG);",
  "%not-for-header",
  "",
  "/** Describes a mapping from a serialized table id to its deserialized state in",
  " * this scanner.  This is the bridge between our \"generic\" deserialization code",
  " * and the specifics of this scanner. ",
  " */",
  "struct yytbl_dmap {",
  "	enum yytbl_id dm_id;/**< table identifier */",
  "	void  **dm_arr;		/**< address of pointer to store the deserialized table. */",
  "	size_t  dm_sz;		/**< local sizeof() each element in table. */",
  "};",
  "",
  "/** A {0,0,0}-terminated list of structs, forming the map */",
  "static struct yytbl_dmap yydmap[] =",
  "{",
  "%tables-yydmap generated elements",
  "    {0,0,0}",
  "};",
  "",
  "/** A tables-reader object to maintain some state in the read. */",
  "struct yytbl_reader {",
  "    FILE * fp; /**< input stream */",
  "    flex_uint32_t bread; /**< bytes read since beginning of current tableset */",
  "};",
  "",
  "%endif",
  "/* end tables serialization structures and prototypes */",
  "",
  "%ok-for-header",
  "",
  "/* Default declaration of generated scanner - a define so the user can",
  " * easily add parameters.",
  " */",
  "#ifndef YY_DECL",
  "#define YY_DECL_IS_OURS 1",
  "%if-c-only Standard (non-C++) definition",
  "",
  "",
  "m4_define( [[M4_YY_LEX_PROTO]], [[M4_YY_PARAMS(M4_YY_PROTO_ONLY_ARG)]])",
  "m4_define( [[M4_YY_LEX_DECLARATION]], [[YYFARGS0(void)]])",
  "",
  "m4_ifdef( [[M4_YY_BISON_LVAL]],",
  "[[",
  "    m4_dnl  The bison pure parser is used. Redefine yylex to",
  "    m4_dnl  accept the lval parameter.",
  "",
  "    m4_define( [[M4_YY_LEX_PROTO]], [[\\]]",
  "               [[M4_YY_PARAMS(YYSTYPE * yylval_param M4_YY_PROTO_LAST_ARG)]])",
  "    m4_define( [[M4_YY_LEX_DECLARATION]], [[\\]]",
  "               [[YYFARGS1(YYSTYPE *,yylval_param)]])",
  "]])",
  "",
  "m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "[[",
  "    m4_dnl  Locations are used. yylex should also accept the ylloc parameter.",
  "",
  "    m4_define( [[M4_YY_LEX_PROTO]], [[\\]]",
  "               [[M4_YY_PARAMS(YYSTYPE * yylval_param, YYLTYPE * yylloc_param M4_YY_PROTO_LAST_ARG)]])",
  "    m4_define( [[M4_YY_LEX_DECLARATION]], [[\\]]",
  "               [[YYFARGS2(YYSTYPE *,yylval_param, YYLTYPE *,yylloc_param)]])",
  "]])",
  "",
  "extern int yylex M4_YY_LEX_PROTO;",
  "",
  "#define YY_DECL int yylex M4_YY_LEX_DECLARATION",
  "%endif",
  "%if-c++-only C++ definition",
  "#define YY_DECL int yyFlexLexer::yylex()",
  "%endif",
  "#endif /* !YY_DECL */",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Code executed at the beginning of each rule, after yytext and yyleng",
  " * have been set up.",
  " */",
  "#ifndef YY_USER_ACTION",
  "#define YY_USER_ACTION",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* Code executed at the end of each rule. */",
  "#ifndef YY_BREAK",
  "#define YY_BREAK /*LINTED*/break;",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "%% [6.0] YY_RULE_SETUP definition goes here",
  "]])",
  "",
  "%not-for-header",
  "/** The main scanner function which does all the work.",
  " */",
  "YY_DECL",
  "{",
  "	yy_state_type yy_current_state;",
  "	char *yy_cp, *yy_bp;",
  "	int yy_act;",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "m4_ifdef( [[M4_YY_NOT_REENTRANT]],",
  "[[",
  "    m4_ifdef( [[M4_YY_BISON_LVAL]],",
  "    [[",
  "        YYSTYPE * yylval;",
  "    ]])",
  "    m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "    [[",
  "        YYLTYPE * yylloc;",
  "    ]])",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_BISON_LVAL]],",
  "[[",
  "    yylval = yylval_param;",
  "]])",
  "",
  "m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "[[",
  "    yylloc = yylloc_param;",
  "]])",
  "",
  "	if ( !YY_G(yy_init) )",
  "		{",
  "		YY_G(yy_init) = 1;",
  "",
  "#ifdef YY_USER_INIT",
  "		YY_USER_INIT;",
  "#endif",
  "",
  "m4_ifdef( [[M4_YY_USES_REJECT]],",
  "[[",
  "        /* Create the reject buffer large enough to save one state per allowed character. */",
  "        if ( ! YY_G(yy_state_buf) )",
  "            YY_G(yy_state_buf) = (yy_state_type *)yyalloc(YY_STATE_BUF_SIZE  M4_YY_CALL_LAST_ARG);",
  "            if ( ! YY_G(yy_state_buf) )",
  "                YY_FATAL_ERROR( \"out of dynamic memory in yylex()\" );",
  "]])",
  "",
  "		if ( ! YY_G(yy_start) )",
  "			YY_G(yy_start) = 1;	/* first start state */",
  "",
  "		if ( ! yyin )",
  "%if-c-only",
  "			yyin = stdin;",
  "%endif",
  "%if-c++-only",
  "			yyin.rdbuf(std::cin.rdbuf());",
  "%endif",
  "",
  "		if ( ! yyout )",
  "%if-c-only",
  "			yyout = stdout;",
  "%endif",
  "%if-c++-only",
  "			yyout.rdbuf(std::cout.rdbuf());",
  "%endif",
  "",
  "		if ( ! YY_CURRENT_BUFFER ) {",
  "			yyensure_buffer_stack (M4_YY_CALL_ONLY_ARG);",
  "			YY_CURRENT_BUFFER_LVALUE =",
  "				yy_create_buffer( yyin, YY_BUF_SIZE M4_YY_CALL_LAST_ARG);",
  "		}",
  "",
  "		yy_load_buffer_state( M4_YY_CALL_ONLY_ARG );",
  "		}",
  "",
  "	{",
  "%% [7.0] user's declarations go here",
  "",
  "	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */",
  "		{",
  "%% [8.0] yymore()-related code goes here",
  "		yy_cp = YY_G(yy_c_buf_p);",
  "",
  "		/* Support of yytext. */",
  "		*yy_cp = YY_G(yy_hold_char);",
  "",
  "		/* yy_bp points to the position in yy_ch_buf of the start of",
  "		 * the current run.",
  "		 */",
  "		yy_bp = yy_cp;",
  "",
  "%% [9.0] code to set up and find next match goes here",
  "",
  "yy_find_action:",
  "%% [10.0] code to find the action number goes here",
  "",
  "		YY_DO_BEFORE_ACTION;",
  "",
  "%% [11.0] code for yylineno update goes here",
  "",
  "do_action:	/* This label is used only to access EOF actions. */",
  "",
  "%% [12.0] debug code goes here",
  "",
  "		switch ( yy_act )",
  "	{ /* beginning of action switch */",
  "%% [13.0] actions go here",
  "",
  "	case YY_END_OF_BUFFER:",
  "		{",
  "		/* Amount of text matched not including the EOB char. */",
  "		int yy_amount_of_matched_text = (int) (yy_cp - YY_G(yytext_ptr)) - 1;",
  "",
  "		/* Undo the effects of YY_DO_BEFORE_ACTION. */",
  "		*yy_cp = YY_G(yy_hold_char);",
  "		YY_RESTORE_YY_MORE_OFFSET",
  "",
  "		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )",
  "			{",
  "			/* We're scanning a new file or input source.  It's",
  "			 * possible that this happened because the user",
  "			 * just pointed yyin at a new source and called",
  "			 * yylex().  If so, then we have to assure",
  "			 * consistency between YY_CURRENT_BUFFER and our",
  "			 * globals.  Here is the right place to do so, because",
  "			 * this is the first action (other than possibly a",
  "			 * back-up) that will match for the new input source.",
  "			 */",
  "			YY_G(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;",
  "%if-c-only",
  "			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;",
  "%endif",
  "%if-c++-only",
  "			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin.rdbuf();",
  "%endif",
  "			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;",
  "			}",
  "",
  "		/* Note that here we test for yy_c_buf_p \"<=\" to the position",
  "		 * of the first EOB in the buffer, since yy_c_buf_p will",
  "		 * already have been incremented past the NUL character",
  "		 * (since all states make transitions on EOB to the",
  "		 * end-of-buffer state).  Contrast this with the test",
  "		 * in input().",
  "		 */",
  "		if ( YY_G(yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[YY_G(yy_n_chars)] )",
  "			{ /* This was really a NUL. */",
  "			yy_state_type yy_next_state;",
  "",
  "			YY_G(yy_c_buf_p) = YY_G(yytext_ptr) + yy_amount_of_matched_text;",
  "",
  "			yy_current_state = yy_get_previous_state( M4_YY_CALL_ONLY_ARG );",
  "",
  "			/* Okay, we're now positioned to make the NUL",
  "			 * transition.  We couldn't have",
  "			 * yy_get_previous_state() go ahead and do it",
  "			 * for us because it doesn't know how to deal",
  "			 * with the possibility of jamming (and we don't",
  "			 * want to build jamming into it because then it",
  "			 * will run more slowly).",
  "			 */",
  "",
  "			yy_next_state = yy_try_NUL_trans( yy_current_state M4_YY_CALL_LAST_ARG);",
  "",
  "			yy_bp = YY_G(yytext_ptr) + YY_MORE_ADJ;",
  "",
  "			if ( yy_next_state )",
  "				{",
  "				/* Consume the NUL. */",
  "				yy_cp = ++YY_G(yy_c_buf_p);",
  "				yy_current_state = yy_next_state;",
  "				goto yy_match;",
  "				}",
  "",
  "			else",
  "				{",
  "%% [14.0] code to do back-up for compressed tables and set up yy_cp goes here",
  "				goto yy_find_action;",
  "				}",
  "			}",
  "",
  "		else switch ( yy_get_next_buffer( M4_YY_CALL_ONLY_ARG ) )",
  "			{",
  "			case EOB_ACT_END_OF_FILE:",
  "				{",
  "				YY_G(yy_did_buffer_switch_on_eof) = 0;",
  "",
  "				if ( yywrap( M4_YY_CALL_ONLY_ARG ) )",
  "					{",
  "					/* Note: because we've taken care in",
  "					 * yy_get_next_buffer() to have set up",
  "					 * yytext, we can now set up",
  "					 * yy_c_buf_p so that if some total",
  "					 * hoser (like flex itself) wants to",
  "					 * call the scanner after we return the",
  "					 * YY_NULL, it'll still work - another",
  "					 * YY_NULL will get returned.",
  "					 */",
  "					YY_G(yy_c_buf_p) = YY_G(yytext_ptr) + YY_MORE_ADJ;",
  "",
  "					yy_act = YY_STATE_EOF(YY_START);",
  "					goto do_action;",
  "					}",
  "",
  "				else",
  "					{",
  "					if ( ! YY_G(yy_did_buffer_switch_on_eof) )",
  "						YY_NEW_FILE;",
  "					}",
  "				break;",
  "				}",
  "",
  "			case EOB_ACT_CONTINUE_SCAN:",
  "				YY_G(yy_c_buf_p) =",
  "					YY_G(yytext_ptr) + yy_amount_of_matched_text;",
  "",
  "				yy_current_state = yy_get_previous_state( M4_YY_CALL_ONLY_ARG );",
  "",
  "				yy_cp = YY_G(yy_c_buf_p);",
  "				yy_bp = YY_G(yytext_ptr) + YY_MORE_ADJ;",
  "				goto yy_match;",
  "",
  "			case EOB_ACT_LAST_MATCH:",
  "				YY_G(yy_c_buf_p) =",
  "				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[YY_G(yy_n_chars)];",
  "",
  "				yy_current_state = yy_get_previous_state( M4_YY_CALL_ONLY_ARG );",
  "",
  "				yy_cp = YY_G(yy_c_buf_p);",
  "				yy_bp = YY_G(yytext_ptr) + YY_MORE_ADJ;",
  "				goto yy_find_action;",
  "			}",
  "		break;",
  "		}",
  "",
  "	default:",
  "		YY_FATAL_ERROR(",
  "			\"fatal flex scanner internal error--no action found\" );",
  "	} /* end of action switch */",
  "		} /* end of scanning one token */",
  "	} /* end of user's declarations */",
  "} /* end of yylex */",
  "%ok-for-header",
  "",
  "%if-c++-only",
  "%not-for-header",
  "/* The contents of this function are C++ specific, so the YY_G macro is not used.",
  " * This constructor simply maintains backward compatibility.",
  " * DEPRECATED",
  " */",
  "yyFlexLexer::yyFlexLexer( std::istream* arg_yyin, std::ostream* arg_yyout ):",
  "	yyin(arg_yyin ? arg_yyin->rdbuf() : std::cin.rdbuf()),",
  "	yyout(arg_yyout ? arg_yyout->rdbuf() : std::cout.rdbuf())",
  "{",
  "	ctor_common();",
  "}",
  "",
  "/* The contents of this function are C++ specific, so the YY_G macro is not used.",
  " */",
  "yyFlexLexer::yyFlexLexer( std::istream& arg_yyin, std::ostream& arg_yyout ):",
  "	yyin(arg_yyin.rdbuf()),",
  "	yyout(arg_yyout.rdbuf())",
  "{",
  "	ctor_common();",
  "}",
  "",
  "/* The contents of this function are C++ specific, so the YY_G macro is not used.",
  " */",
  "void yyFlexLexer::ctor_common()",
  "{",
  "	yy_c_buf_p = 0;",
  "	yy_init = 0;",
  "	yy_start = 0;",
  "	yy_flex_debug = 0;",
  "	yylineno = 1;	// this will only get updated if %option yylineno",
  "",
  "	yy_did_buffer_switch_on_eof = 0;",
  "",
  "	yy_looking_for_trail_begin = 0;",
  "	yy_more_flag = 0;",
  "	yy_more_len = 0;",
  "	yy_more_offset = yy_prev_more_offset = 0;",
  "",
  "	yy_start_stack_ptr = yy_start_stack_depth = 0;",
  "	yy_start_stack = NULL;",
  "",
  "	yy_buffer_stack = NULL;",
  "	yy_buffer_stack_top = 0;",
  "	yy_buffer_stack_max = 0;",
  "",
  "",
  "m4_ifdef( [[M4_YY_USES_REJECT]],",
  "[[",
  "	yy_state_buf = new yy_state_type[YY_STATE_BUF_SIZE];",
  "]],",
  "[[",
  "	yy_state_buf = 0;",
  "]])",
  "}",
  "",
  "/* The contents of this function are C++ specific, so the YY_G macro is not used.",
  " */",
  "yyFlexLexer::~yyFlexLexer()",
  "{",
  "	delete [] yy_state_buf;",
  "	yyfree( yy_start_stack M4_YY_CALL_LAST_ARG );",
  "	yy_delete_buffer( YY_CURRENT_BUFFER M4_YY_CALL_LAST_ARG);",
  "	yyfree( yy_buffer_stack M4_YY_CALL_LAST_ARG );",
  "}",
  "",
  "/* The contents of this function are C++ specific, so the YY_G macro is not used.",
  " */",
  "void yyFlexLexer::switch_streams( std::istream& new_in, std::ostream& new_out )",
  "{",
  "	// was if( new_in )",
  "	yy_delete_buffer( YY_CURRENT_BUFFER M4_YY_CALL_LAST_ARG);",
  "	yy_switch_to_buffer( yy_create_buffer( new_in, YY_BUF_SIZE  M4_YY_CALL_LAST_ARG) M4_YY_CALL_LAST_ARG);",
  "",
  "	// was if( new_out )",
  "	yyout.rdbuf(new_out.rdbuf());",
  "}",
  "",
  "/* The contents of this function are C++ specific, so the YY_G macro is not used.",
  " */",
  "void yyFlexLexer::switch_streams( std::istream* new_in, std::ostream* new_out )",
  "{",
  "	if( ! new_in ) {",
  "		new_in = &yyin;",
  "	}",
  "",
  "	if ( ! new_out ) {",
  "		new_out = &yyout;",
  "	}",
  "",
  "	switch_streams(*new_in, *new_out);",
  "}",
  "",
  "#ifdef YY_INTERACTIVE",
  "int yyFlexLexer::LexerInput( char* buf, int /* max_size */ )",
  "#else",
  "int yyFlexLexer::LexerInput( char* buf, int max_size )",
  "#endif",
  "{",
  "	if ( yyin.eof() || yyin.fail() )",
  "		return 0;",
  "",
  "#ifdef YY_INTERACTIVE",
  "	yyin.get( buf[0] );",
  "",
  "	if ( yyin.eof() )",
  "		return 0;",
  "",
  "	if ( yyin.bad() )",
  "		return -1;",
  "",
  "	return 1;",
  "",
  "#else",
  "	(void) yyin.read( buf, max_size );",
  "",
  "	if ( yyin.bad() )",
  "		return -1;",
  "	else",
  "		return yyin.gcount();",
  "#endif",
  "}",
  "",
  "void yyFlexLexer::LexerOutput( const char* buf, int size )",
  "{",
  "	(void) yyout.write( buf, size );",
  "}",
  "%ok-for-header",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/* yy_get_next_buffer - try to read in a new buffer",
  " *",
  " * Returns a code representing an action:",
  " *	EOB_ACT_LAST_MATCH -",
  " *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position",
  " *	EOB_ACT_END_OF_FILE - end of file",
  " */",
  "%if-c-only",
  "static int yy_get_next_buffer YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "int yyFlexLexer::yy_get_next_buffer()",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;",
  "	char *source = YY_G(yytext_ptr);",
  "	yy_size_t number_to_move, i;",
  "	int ret_val;",
  "",
  "	if ( YY_G(yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[YY_G(yy_n_chars) + 1] )",
  "		YY_FATAL_ERROR(",
  "		\"fatal flex scanner internal error--end of buffer missed\" );",
  "",
  "	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )",
  "		{ /* Don't try to fill the buffer, so this is an EOF. */",
  "		if ( YY_G(yy_c_buf_p) - YY_G(yytext_ptr) - YY_MORE_ADJ == 1 )",
  "			{",
  "			/* We matched a single character, the EOB, so",
  "			 * treat this as a final EOF.",
  "			 */",
  "			return EOB_ACT_END_OF_FILE;",
  "			}",
  "",
  "		else",
  "			{",
  "			/* We matched some text prior to the EOB, first",
  "			 * process it.",
  "			 */",
  "			return EOB_ACT_LAST_MATCH;",
  "			}",
  "		}",
  "",
  "	/* Try to read more data. */",
  "",
  "	/* First move last chars to start of buffer. */",
  "	number_to_move = (yy_size_t) (YY_G(yy_c_buf_p) - YY_G(yytext_ptr)) - 1;",
  "",
  "	for ( i = 0; i < number_to_move; ++i )",
  "		*(dest++) = *(source++);",
  "",
  "	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )",
  "		/* don't do the read, it's not guaranteed to return an EOF,",
  "		 * just force an EOF",
  "		 */",
  "		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = YY_G(yy_n_chars) = 0;",
  "",
  "	else",
  "		{",
  "			int num_to_read =",
  "			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;",
  "",
  "		while ( num_to_read <= 0 )",
  "			{ /* Not enough room in the buffer - grow it. */",
  "m4_ifdef( [[M4_YY_USES_REJECT]],",
  "[[",
  "			YY_FATAL_ERROR(",
  "\"input buffer overflow, can't enlarge buffer because scanner uses REJECT\" );",
  "]],",
  "[[",
  "			/* just a shorter name for the current buffer */",
  "			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;",
  "",
  "			int yy_c_buf_p_offset =",
  "				(int) (YY_G(yy_c_buf_p) - b->yy_ch_buf);",
  "",
  "			if ( b->yy_is_our_buffer )",
  "				{",
  "				int new_size = b->yy_buf_size * 2;",
  "",
  "				if ( new_size <= 0 )",
  "					b->yy_buf_size += b->yy_buf_size / 8;",
  "				else",
  "					b->yy_buf_size *= 2;",
  "",
  "				b->yy_ch_buf = (char *)",
  "					/* Include room in for 2 EOB chars. */",
  "					yyrealloc( (void *) b->yy_ch_buf,",
  "							 b->yy_buf_size + 2 M4_YY_CALL_LAST_ARG );",
  "				}",
  "			else",
  "				/* Can't grow it, we don't own it. */",
  "				b->yy_ch_buf = NULL;",
  "",
  "			if ( ! b->yy_ch_buf )",
  "				YY_FATAL_ERROR(",
  "				\"fatal error - scanner input buffer overflow\" );",
  "",
  "			YY_G(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];",
  "",
  "			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -",
  "						number_to_move - 1;",
  "]])",
  "			}",
  "",
  "		if ( num_to_read > YY_READ_BUF_SIZE )",
  "			num_to_read = YY_READ_BUF_SIZE;",
  "",
  "		/* Read in more data. */",
  "		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),",
  "			YY_G(yy_n_chars), num_to_read );",
  "",
  "		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = YY_G(yy_n_chars);",
  "		}",
  "",
  "	if ( YY_G(yy_n_chars) == 0 )",
  "		{",
  "		if ( number_to_move == YY_MORE_ADJ )",
  "			{",
  "			ret_val = EOB_ACT_END_OF_FILE;",
  "			yyrestart( yyin  M4_YY_CALL_LAST_ARG);",
  "			}",
  "",
  "		else",
  "			{",
  "			ret_val = EOB_ACT_LAST_MATCH;",
  "			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =",
  "				YY_BUFFER_EOF_PENDING;",
  "			}",
  "		}",
  "",
  "	else",
  "		ret_val = EOB_ACT_CONTINUE_SCAN;",
  "",
  "	if ((int) (YY_G(yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {",
  "		/* Extend the array by 50%, plus the number we really need. */",
  "		int new_size = YY_G(yy_n_chars) + number_to_move + (YY_G(yy_n_chars) >> 1);",
  "		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(",
  "			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, new_size M4_YY_CALL_LAST_ARG );",
  "		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )",
  "			YY_FATAL_ERROR( \"out of dynamic memory in yy_get_next_buffer()\" );",
  "	}",
  "",
  "	YY_G(yy_n_chars) += number_to_move;",
  "	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[YY_G(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;",
  "	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[YY_G(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;",
  "",
  "	YY_G(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];",
  "",
  "	return ret_val;",
  "}",
  "]])",
  "",
  "/* yy_get_previous_state - get the state just before the EOB char was reached */",
  "",
  "%if-c-only",
  "%not-for-header",
  "    static yy_state_type yy_get_previous_state YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "    yy_state_type yyFlexLexer::yy_get_previous_state()",
  "%endif",
  "{",
  "	yy_state_type yy_current_state;",
  "	char *yy_cp;",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "%% [15.0] code to get the start state into yy_current_state goes here",
  "",
  "	for ( yy_cp = YY_G(yytext_ptr) + YY_MORE_ADJ; yy_cp < YY_G(yy_c_buf_p); ++yy_cp )",
  "		{",
  "%% [16.0] code to find the next state goes here",
  "		}",
  "",
  "	return yy_current_state;",
  "}",
  "",
  "",
  "/* yy_try_NUL_trans - try to make a transition on the NUL character",
  " *",
  " * synopsis",
  " *	next_state = yy_try_NUL_trans( current_state );",
  " */",
  "%if-c-only",
  "    static yy_state_type yy_try_NUL_trans  YYFARGS1( yy_state_type, yy_current_state)",
  "%endif",
  "%if-c++-only",
  "    yy_state_type yyFlexLexer::yy_try_NUL_trans( yy_state_type yy_current_state )",
  "%endif",
  "{",
  "	int yy_is_jam;",
  "    M4_YY_DECL_GUTS_VAR(); /* This var may be unused depending upon options. */",
  "%% [17.0] code to find the next state, and perhaps do backing up, goes here",
  "",
  "	M4_YY_NOOP_GUTS_VAR();",
  "	return yy_is_jam ? 0 : yy_current_state;",
  "}",
  "",
  "",
  "#ifndef YY_NO_UNPUT",
  "%if-c-only",
  "m4_ifdef( [[M4_YY_NO_UNPUT]],,",
  "[[",
  "    static void yyunput YYFARGS2( int,c, char *,yy_bp)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yyunput( int c, char* yy_bp)",
  "%endif",
  "{",
  "	char *yy_cp;",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "    yy_cp = YY_G(yy_c_buf_p);",
  "",
  "	/* undo effects of setting up yytext */",
  "	*yy_cp = YY_G(yy_hold_char);",
  "",
  "	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )",
  "		{ /* need to shift things up to make room */",
  "		/* +2 for EOB chars. */",
  "		int number_to_move = YY_G(yy_n_chars) + 2;",
  "		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[",
  "					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];",
  "		char *source =",
  "				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];",
  "",
  "		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )",
  "			*--dest = *--source;",
  "",
  "		yy_cp += (int) (dest - source);",
  "		yy_bp += (int) (dest - source);",
  "		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =",
  "			YY_G(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;",
  "",
  "		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )",
  "			YY_FATAL_ERROR( \"flex scanner push-back overflow\" );",
  "		}",
  "",
  "	*--yy_cp = (char) c;",
  "",
  "%% [18.0] update yylineno here",
  "m4_ifdef( [[M4_YY_USE_LINENO]],",
  "[[",
  "    if ( c == '\\n' ){",
  "        --yylineno;",
  "    }",
  "]])",
  "",
  "	YY_G(yytext_ptr) = yy_bp;",
  "	YY_G(yy_hold_char) = *yy_cp;",
  "	YY_G(yy_c_buf_p) = yy_cp;",
  "}",
  "%if-c-only",
  "]])",
  "%endif",
  "#endif",
  "",
  "%if-c-only",
  "#ifndef YY_NO_INPUT",
  "#ifdef __cplusplus",
  "    static int yyinput YYFARGS0(void)",
  "#else",
  "    static int input  YYFARGS0(void)",
  "#endif",
  "",
  "%endif",
  "%if-c++-only",
  "    int yyFlexLexer::yyinput()",
  "%endif",
  "{",
  "	int c;",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "	*YY_G(yy_c_buf_p) = YY_G(yy_hold_char);",
  "",
  "	if ( *YY_G(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )",
  "		{",
  "		/* yy_c_buf_p now points to the character we want to return.",
  "		 * If this occurs *before* the EOB characters, then it's a",
  "		 * valid NUL; if not, then we've hit the end of the buffer.",
  "		 */",
  "		if ( YY_G(yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[YY_G(yy_n_chars)] )",
  "			/* This was really a NUL. */",
  "			*YY_G(yy_c_buf_p) = '\\0';",
  "",
  "		else",
  "			{ /* need more input */",
  "			int offset = YY_G(yy_c_buf_p) - YY_G(yytext_ptr);",
  "			++YY_G(yy_c_buf_p);",
  "",
  "			switch ( yy_get_next_buffer( M4_YY_CALL_ONLY_ARG ) )",
  "				{",
  "				case EOB_ACT_LAST_MATCH:",
  "					/* This happens because yy_g_n_b()",
  "					 * sees that we've accumulated a",
  "					 * token and flags that we need to",
  "					 * try matching the token before",
  "					 * proceeding.  But for input(),",
  "					 * there's no matching to consider.",
  "					 * So convert the EOB_ACT_LAST_MATCH",
  "					 * to EOB_ACT_END_OF_FILE.",
  "					 */",
  "",
  "					/* Reset buffer status. */",
  "					yyrestart( yyin M4_YY_CALL_LAST_ARG);",
  "",
  "					/*FALLTHROUGH*/",
  "",
  "				case EOB_ACT_END_OF_FILE:",
  "					{",
  "					if ( yywrap( M4_YY_CALL_ONLY_ARG ) )",
  "						return 0;",
  "",
  "					if ( ! YY_G(yy_did_buffer_switch_on_eof) )",
  "						YY_NEW_FILE;",
  "#ifdef __cplusplus",
  "					return yyinput(M4_YY_CALL_ONLY_ARG);",
  "#else",
  "					return input(M4_YY_CALL_ONLY_ARG);",
  "#endif",
  "					}",
  "",
  "				case EOB_ACT_CONTINUE_SCAN:",
  "					YY_G(yy_c_buf_p) = YY_G(yytext_ptr) + offset;",
  "					break;",
  "				}",
  "			}",
  "		}",
  "",
  "	c = *(unsigned char *) YY_G(yy_c_buf_p);	/* cast for 8-bit char's */",
  "	*YY_G(yy_c_buf_p) = '\\0';	/* preserve yytext */",
  "	YY_G(yy_hold_char) = *++YY_G(yy_c_buf_p);",
  "",
  "%% [19.0] update BOL and yylineno",
  "",
  "	return c;",
  "}",
  "%if-c-only",
  "#endif	/* ifndef YY_NO_INPUT */",
  "%endif",
  "",
  "/** Immediately switch to a different input stream.",
  " * @param input_file A readable stream.",
  " * M4_YY_DOC_PARAM",
  " * @note This function does not reset the start condition to @c INITIAL .",
  " */",
  "%if-c-only",
  "    void yyrestart  YYFARGS1( FILE *,input_file)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yyrestart( std::istream& input_file )",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "	if ( ! YY_CURRENT_BUFFER ){",
  "        yyensure_buffer_stack (M4_YY_CALL_ONLY_ARG);",
  "		YY_CURRENT_BUFFER_LVALUE =",
  "            yy_create_buffer( yyin, YY_BUF_SIZE M4_YY_CALL_LAST_ARG);",
  "	}",
  "",
  "	yy_init_buffer( YY_CURRENT_BUFFER, input_file M4_YY_CALL_LAST_ARG);",
  "	yy_load_buffer_state( M4_YY_CALL_ONLY_ARG );",
  "}",
  "",
  "%if-c++-only",
  "/** Delegate to the new version that takes an istream reference.",
  " * @param input_file A readable stream.",
  " * M4_YY_DOC_PARAM",
  " * @note This function does not reset the start condition to @c INITIAL .",
  " */",
  "void yyFlexLexer::yyrestart( std::istream* input_file )",
  "{",
  "	yyrestart( *input_file );",
  "}",
  "%endif",
  "",
  "/** Switch to a different input buffer.",
  " * @param new_buffer The new input buffer.",
  " * M4_YY_DOC_PARAM",
  " */",
  "%if-c-only",
  "    void yy_switch_to_buffer  YYFARGS1( YY_BUFFER_STATE ,new_buffer)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "	/* TODO. We should be able to replace this entire function body",
  "	 * with",
  "	 *		yypop_buffer_state();",
  "	 *		yypush_buffer_state(new_buffer);",
  "     */",
  "	yyensure_buffer_stack (M4_YY_CALL_ONLY_ARG);",
  "	if ( YY_CURRENT_BUFFER == new_buffer )",
  "		return;",
  "",
  "	if ( YY_CURRENT_BUFFER )",
  "		{",
  "		/* Flush out information for old buffer. */",
  "		*YY_G(yy_c_buf_p) = YY_G(yy_hold_char);",
  "		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = YY_G(yy_c_buf_p);",
  "		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = YY_G(yy_n_chars);",
  "		}",
  "",
  "	YY_CURRENT_BUFFER_LVALUE = new_buffer;",
  "	yy_load_buffer_state( M4_YY_CALL_ONLY_ARG );",
  "",
  "	/* We don't actually know whether we did this switch during",
  "	 * EOF (yywrap()) processing, but the only time this flag",
  "	 * is looked at is after yywrap() is called, so it's safe",
  "	 * to go ahead and always set it.",
  "	 */",
  "	YY_G(yy_did_buffer_switch_on_eof) = 1;",
  "}",
  "",
  "",
  "%if-c-only",
  "static void yy_load_buffer_state  YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_load_buffer_state()",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	YY_G(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;",
  "	YY_G(yytext_ptr) = YY_G(yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;",
  "%if-c-only",
  "	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;",
  "%endif",
  "%if-c++-only",
  "	yyin.rdbuf(YY_CURRENT_BUFFER_LVALUE->yy_input_file);",
  "%endif",
  "	YY_G(yy_hold_char) = *YY_G(yy_c_buf_p);",
  "}",
  "",
  "/** Allocate and initialize an input buffer state.",
  " * @param file A readable stream.",
  " * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.",
  " * M4_YY_DOC_PARAM",
  " * @return the allocated buffer state.",
  " */",
  "%if-c-only",
  "    YY_BUFFER_STATE yy_create_buffer  YYFARGS2( FILE *,file, int ,size)",
  "%endif",
  "%if-c++-only",
  "    YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream& file, int size )",
  "%endif",
  "{",
  "	YY_BUFFER_STATE b;",
  "    m4_dnl M4_YY_DECL_GUTS_VAR();",
  "",
  "	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) M4_YY_CALL_LAST_ARG );",
  "	if ( ! b )",
  "		YY_FATAL_ERROR( \"out of dynamic memory in yy_create_buffer()\" );",
  "",
  "	b->yy_buf_size = (yy_size_t)size;",
  "",
  "	/* yy_ch_buf has to be 2 characters longer than the size given because",
  "	 * we need to put in 2 end-of-buffer characters.",
  "	 */",
  "	b->yy_ch_buf = (char *) yyalloc( b->yy_buf_size + 2 M4_YY_CALL_LAST_ARG );",
  "	if ( ! b->yy_ch_buf )",
  "		YY_FATAL_ERROR( \"out of dynamic memory in yy_create_buffer()\" );",
  "",
  "	b->yy_is_our_buffer = 1;",
  "",
  "	yy_init_buffer( b, file M4_YY_CALL_LAST_ARG);",
  "",
  "	return b;",
  "}",
  "",
  "%if-c++-only",
  "/** Delegate creation of buffers to the new version that takes an istream reference.",
  " * @param file A readable stream.",
  " * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.",
  " * M4_YY_DOC_PARAM",
  " * @return the allocated buffer state.",
  " */",
  "	YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream* file, int size )",
  "{",
  "	return yy_create_buffer( *file, size );",
  "}",
  "%endif",
  "",
  "/** Destroy the buffer.",
  " * @param b a buffer created with yy_create_buffer()",
  " * M4_YY_DOC_PARAM",
  " */",
  "%if-c-only",
  "    void yy_delete_buffer YYFARGS1( YY_BUFFER_STATE ,b)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_delete_buffer( YY_BUFFER_STATE b )",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "	if ( ! b )",
  "		return;",
  "",
  "	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */",
  "		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;",
  "",
  "	if ( b->yy_is_our_buffer )",
  "		yyfree( (void *) b->yy_ch_buf M4_YY_CALL_LAST_ARG );",
  "",
  "	yyfree( (void *) b M4_YY_CALL_LAST_ARG );",
  "}",
  "",
  "",
  "/* Initializes or reinitializes a buffer.",
  " * This function is sometimes called more than once on the same buffer,",
  " * such as during a yyrestart() or at EOF.",
  " */",
  "%if-c-only",
  "    static void yy_init_buffer  YYFARGS2( YY_BUFFER_STATE ,b, FILE *,file)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_init_buffer( YY_BUFFER_STATE b, std::istream& file )",
  "%endif",
  "",
  "{",
  "	int oerrno = errno;",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "	yy_flush_buffer( b M4_YY_CALL_LAST_ARG);",
  "",
  "%if-c-only",
  "	b->yy_input_file = file;",
  "%endif",
  "%if-c++-only",
  "	b->yy_input_file = file.rdbuf();",
  "%endif",
  "	b->yy_fill_buffer = 1;",
  "",
  "    /* If b is the current buffer, then yy_init_buffer was _probably_",
  "     * called from yyrestart() or through yy_get_next_buffer.",
  "     * In that case, we don't want to reset the lineno or column.",
  "     */",
  "    if (b != YY_CURRENT_BUFFER){",
  "        b->yy_bs_lineno = 1;",
  "        b->yy_bs_column = 0;",
  "    }",
  "",
  "%if-c-only",
  "m4_ifdef( [[M4_YY_ALWAYS_INTERACTIVE]],",
  "[[",
  "	b->yy_is_interactive = 1;",
  "]],",
  "[[",
  "    m4_ifdef( [[M4_YY_NEVER_INTERACTIVE]],",
  "    [[",
  "        b->yy_is_interactive = 0;",
  "    ]],",
  "    [[",
  "        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;",
  "    ]])",
  "]])",
  "%endif",
  "%if-c++-only",
  "	b->yy_is_interactive = 0;",
  "%endif",
  "	errno = oerrno;",
  "}",
  "",
  "/** Discard all buffered characters. On the next scan, YY_INPUT will be called.",
  " * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.",
  " * M4_YY_DOC_PARAM",
  " */",
  "%if-c-only",
  "    void yy_flush_buffer YYFARGS1( YY_BUFFER_STATE ,b)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_flush_buffer( YY_BUFFER_STATE b )",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	if ( ! b )",
  "		return;",
  "",
  "	b->yy_n_chars = 0;",
  "",
  "	/* We always need two end-of-buffer characters.  The first causes",
  "	 * a transition to the end-of-buffer state.  The second causes",
  "	 * a jam in that state.",
  "	 */",
  "	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;",
  "	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;",
  "",
  "	b->yy_buf_pos = &b->yy_ch_buf[0];",
  "",
  "	b->yy_at_bol = 1;",
  "	b->yy_buffer_status = YY_BUFFER_NEW;",
  "",
  "	if ( b == YY_CURRENT_BUFFER )",
  "		yy_load_buffer_state( M4_YY_CALL_ONLY_ARG );",
  "}",
  "",
  "%if-c-or-c++",
  "/** Pushes the new state onto the stack. The new state becomes",
  " *  the current state. This function will allocate the stack",
  " *  if necessary.",
  " *  @param new_buffer The new state.",
  " *  M4_YY_DOC_PARAM",
  " */",
  "%if-c-only",
  "void yypush_buffer_state YYFARGS1(YY_BUFFER_STATE,new_buffer)",
  "%endif",
  "%if-c++-only",
  "void yyFlexLexer::yypush_buffer_state (YY_BUFFER_STATE new_buffer)",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	if (new_buffer == NULL)",
  "		return;",
  "",
  "	yyensure_buffer_stack(M4_YY_CALL_ONLY_ARG);",
  "",
  "	/* This block is copied from yy_switch_to_buffer. */",
  "	if ( YY_CURRENT_BUFFER )",
  "		{",
  "		/* Flush out information for old buffer. */",
  "		*YY_G(yy_c_buf_p) = YY_G(yy_hold_char);",
  "		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = YY_G(yy_c_buf_p);",
  "		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = YY_G(yy_n_chars);",
  "		}",
  "",
  "	/* Only push if top exists. Otherwise, replace top. */",
  "	if (YY_CURRENT_BUFFER)",
  "		YY_G(yy_buffer_stack_top)++;",
  "	YY_CURRENT_BUFFER_LVALUE = new_buffer;",
  "",
  "	/* copied from yy_switch_to_buffer. */",
  "	yy_load_buffer_state( M4_YY_CALL_ONLY_ARG );",
  "	YY_G(yy_did_buffer_switch_on_eof) = 1;",
  "}",
  "%endif",
  "",
  "",
  "%if-c-or-c++",
  "/** Removes and deletes the top of the stack, if present.",
  " *  The next element becomes the new top.",
  " *  M4_YY_DOC_PARAM",
  " */",
  "%if-c-only",
  "void yypop_buffer_state YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "void yyFlexLexer::yypop_buffer_state (void)",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	if (!YY_CURRENT_BUFFER)",
  "		return;",
  "",
  "	yy_delete_buffer(YY_CURRENT_BUFFER M4_YY_CALL_LAST_ARG);",
  "	YY_CURRENT_BUFFER_LVALUE = NULL;",
  "	if (YY_G(yy_buffer_stack_top) > 0)",
  "		--YY_G(yy_buffer_stack_top);",
  "",
  "	if (YY_CURRENT_BUFFER) {",
  "		yy_load_buffer_state( M4_YY_CALL_ONLY_ARG );",
  "		YY_G(yy_did_buffer_switch_on_eof) = 1;",
  "	}",
  "}",
  "%endif",
  "",
  "",
  "%if-c-or-c++",
  "/* Allocates the stack if it does not exist.",
  " *  Guarantees space for at least one push.",
  " */",
  "%if-c-only",
  "static void yyensure_buffer_stack YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "void yyFlexLexer::yyensure_buffer_stack(void)",
  "%endif",
  "{",
  "	int num_to_alloc;",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "	if (!YY_G(yy_buffer_stack)) {",
  "",
  "		/* First allocation is just for 2 elements, since we don't know if this",
  "		 * scanner will even need a stack. We use 2 instead of 1 to avoid an",
  "		 * immediate realloc on the next call.",
  "         */",
  "      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */",
  "		YY_G(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc",
  "								(num_to_alloc * sizeof(struct yy_buffer_state*)",
  "								M4_YY_CALL_LAST_ARG);",
  "		if ( ! YY_G(yy_buffer_stack) )",
  "			YY_FATAL_ERROR( \"out of dynamic memory in yyensure_buffer_stack()\" );",
  "								  ",
  "		",
  "		memset(YY_G(yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));",
  "				",
  "		YY_G(yy_buffer_stack_max) = num_to_alloc;",
  "		YY_G(yy_buffer_stack_top) = 0;",
  "		return;",
  "	}",
  "",
  "	if (YY_G(yy_buffer_stack_top) >= (YY_G(yy_buffer_stack_max)) - 1){",
  "",
  "		/* Increase the buffer to prepare for a possible push. */",
  "		yy_size_t grow_size = 8 /* arbitrary grow size */;",
  "",
  "		num_to_alloc = YY_G(yy_buffer_stack_max) + grow_size;",
  "		YY_G(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc",
  "								(YY_G(yy_buffer_stack),",
  "								num_to_alloc * sizeof(struct yy_buffer_state*)",
  "								M4_YY_CALL_LAST_ARG);",
  "		if ( ! YY_G(yy_buffer_stack) )",
  "			YY_FATAL_ERROR( \"out of dynamic memory in yyensure_buffer_stack()\" );",
  "",
  "		/* zero only the new slots.*/",
  "		memset(YY_G(yy_buffer_stack) + YY_G(yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));",
  "		YY_G(yy_buffer_stack_max) = num_to_alloc;",
  "	}",
  "}",
  "%endif",
  "",
  "",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_SCAN_BUFFER]],,",
  "[[",
  "%if-c-only",
  "/** Setup the input buffer state to scan directly from a user-specified character buffer.",
  " * @param base the character buffer",
  " * @param size the size in bytes of the character buffer",
  " * M4_YY_DOC_PARAM",
  " * @return the newly allocated buffer state object. ",
  " */",
  "YY_BUFFER_STATE yy_scan_buffer  YYFARGS2( char *,base, yy_size_t ,size)",
  "{",
  "	YY_BUFFER_STATE b;",
  "    m4_dnl M4_YY_DECL_GUTS_VAR();",
  "",
  "	if ( size < 2 ||",
  "	     base[size-2] != YY_END_OF_BUFFER_CHAR ||",
  "	     base[size-1] != YY_END_OF_BUFFER_CHAR )",
  "		/* They forgot to leave room for the EOB's. */",
  "		return NULL;",
  "",
  "	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) M4_YY_CALL_LAST_ARG );",
  "	if ( ! b )",
  "		YY_FATAL_ERROR( \"out of dynamic memory in yy_scan_buffer()\" );",
  "",
  "	b->yy_buf_size = size - 2;	/* \"- 2\" to take care of EOB's */",
  "	b->yy_buf_pos = b->yy_ch_buf = base;",
  "	b->yy_is_our_buffer = 0;",
  "	b->yy_input_file = NULL;",
  "	b->yy_n_chars = b->yy_buf_size;",
  "	b->yy_is_interactive = 0;",
  "	b->yy_at_bol = 1;",
  "	b->yy_fill_buffer = 0;",
  "	b->yy_buffer_status = YY_BUFFER_NEW;",
  "",
  "	yy_switch_to_buffer( b M4_YY_CALL_LAST_ARG );",
  "",
  "	return b;",
  "}",
  "%endif",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_SCAN_STRING]],,",
  "[[",
  "%if-c-only",
  "/** Setup the input buffer state to scan a string. The next call to yylex() will",
  " * scan from a @e copy of @a str.",
  " * @param yystr a NUL-terminated string to scan",
  " * M4_YY_DOC_PARAM",
  " * @return the newly allocated buffer state object.",
  " * @note If you want to scan bytes that may contain NUL values, then use",
  " *       yy_scan_bytes() instead.",
  " */",
  "YY_BUFFER_STATE yy_scan_string YYFARGS1( yyconst char *, yystr)",
  "{",
  "    m4_dnl M4_YY_DECL_GUTS_VAR();",
  "",
  "	return yy_scan_bytes( yystr, (int) strlen(yystr) M4_YY_CALL_LAST_ARG);",
  "}",
  "%endif",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_SCAN_BYTES]],,",
  "[[",
  "%if-c-only",
  "/** Setup the input buffer state to scan the given bytes. The next call to yylex() will",
  " * scan from a @e copy of @a bytes.",
  " * @param yybytes the byte buffer to scan",
  " * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.",
  " * M4_YY_DOC_PARAM",
  " * @return the newly allocated buffer state object.",
  " */",
  "YY_BUFFER_STATE yy_scan_bytes  YYFARGS2( yyconst char *,yybytes, int ,_yybytes_len)",
  "{",
  "	YY_BUFFER_STATE b;",
  "	char *buf;",
  "	yy_size_t n;",
  "	yy_size_t i;",
  "    m4_dnl M4_YY_DECL_GUTS_VAR();",
  "",
  "	/* Get memory for full buffer, including space for trailing EOB's. */",
  "	n = (yy_size_t) _yybytes_len + 2;",
  "	buf = (char *) yyalloc( n M4_YY_CALL_LAST_ARG );",
  "	if ( ! buf )",
  "		YY_FATAL_ERROR( \"out of dynamic memory in yy_scan_bytes()\" );",
  "",
  "	for ( i = 0; i < _yybytes_len; ++i )",
  "		buf[i] = yybytes[i];",
  "",
  "	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;",
  "",
  "	b = yy_scan_buffer( buf, n M4_YY_CALL_LAST_ARG);",
  "	if ( ! b )",
  "		YY_FATAL_ERROR( \"bad buffer in yy_scan_bytes()\" );",
  "",
  "	/* It's okay to grow etc. this buffer, and we should throw it",
  "	 * away when we're done.",
  "	 */",
  "	b->yy_is_our_buffer = 1;",
  "",
  "	return b;",
  "}",
  "%endif",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_PUSH_STATE]],,",
  "[[",
  "%if-c-only",
  "    static void yy_push_state YYFARGS1( int ,_new_state)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_push_state( int _new_state )",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	if ( YY_G(yy_start_stack_ptr) >= YY_G(yy_start_stack_depth) )",
  "		{",
  "		yy_size_t new_size;",
  "",
  "		YY_G(yy_start_stack_depth) += YY_START_STACK_INCR;",
  "		new_size = (yy_size_t) YY_G(yy_start_stack_depth) * sizeof( int );",
  "",
  "		if ( ! YY_G(yy_start_stack) )",
  "			YY_G(yy_start_stack) = (int *) yyalloc( new_size M4_YY_CALL_LAST_ARG );",
  "",
  "		else",
  "			YY_G(yy_start_stack) = (int *) yyrealloc(",
  "					(void *) YY_G(yy_start_stack), new_size M4_YY_CALL_LAST_ARG );",
  "",
  "		if ( ! YY_G(yy_start_stack) )",
  "			YY_FATAL_ERROR( \"out of memory expanding start-condition stack\" );",
  "		}",
  "",
  "	YY_G(yy_start_stack)[YY_G(yy_start_stack_ptr)++] = YY_START;",
  "",
  "	BEGIN(_new_state);",
  "}",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_POP_STATE]],,",
  "[[",
  "%if-c-only",
  "    static void yy_pop_state  YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "    void yyFlexLexer::yy_pop_state()",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	if ( --YY_G(yy_start_stack_ptr) < 0 )",
  "		YY_FATAL_ERROR( \"start-condition stack underflow\" );",
  "",
  "	BEGIN(YY_G(yy_start_stack)[YY_G(yy_start_stack_ptr)]);",
  "}",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_TOP_STATE]],,",
  "[[",
  "%if-c-only",
  "    static int yy_top_state  YYFARGS0(void)",
  "%endif",
  "%if-c++-only",
  "    int yyFlexLexer::yy_top_state()",
  "%endif",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	return YY_G(yy_start_stack)[YY_G(yy_start_stack_ptr) - 1];",
  "}",
  "]])",
  "",
  "#ifndef YY_EXIT_FAILURE",
  "#define YY_EXIT_FAILURE 2",
  "#endif",
  "",
  "%if-c-only",
  "static void yynoreturn yy_fatal_error YYFARGS1(yyconst char*, msg)",
  "{",
  "	M4_YY_DECL_GUTS_VAR();",
  "	M4_YY_NOOP_GUTS_VAR();",
  "	(void) fprintf( stderr, \"%s\\n\", msg );",
  "	exit( YY_EXIT_FAILURE );",
  "}",
  "%endif",
  "%if-c++-only",
  "void yyFlexLexer::LexerError( yyconst char* msg )",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "	std::cerr << msg << std::endl;",
  "	exit( YY_EXIT_FAILURE );",
  "}",
  "%endif",
  "",
  "/* Redefine yyless() so it works in section 3 code. */",
  "",
  "#undef yyless",
  "#define yyless(n) \\",
  "	do \\",
  "		{ \\",
  "		/* Undo effects of setting up yytext. */ \\",
  "        int yyless_macro_arg = (n); \\",
  "        YY_LESS_LINENO(yyless_macro_arg);\\",
  "		yytext[yyleng] = YY_G(yy_hold_char); \\",
  "		YY_G(yy_c_buf_p) = yytext + yyless_macro_arg; \\",
  "		YY_G(yy_hold_char) = *YY_G(yy_c_buf_p); \\",
  "		*YY_G(yy_c_buf_p) = '\\0'; \\",
  "		yyleng = yyless_macro_arg; \\",
  "		} \\",
  "	while ( 0 )",
  "",
  "",
  "",
  "/* Accessor  methods (get/set functions) to struct members. */",
  "",
  "%if-c-only",
  "%if-reentrant",
  "m4_ifdef( [[M4_YY_NO_GET_EXTRA]],,",
  "[[",
  "/** Get the user-defined data for this scanner.",
  " * M4_YY_DOC_PARAM",
  " */",
  "YY_EXTRA_TYPE yyget_extra  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yyextra;",
  "}",
  "]])",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_LINENO]],,",
  "[[",
  "/** Get the current line number.",
  " * M4_YY_DOC_PARAM",
  " */",
  "int yyget_lineno  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    ",
  "    m4_ifdef( [[M4_YY_REENTRANT]],",
  "    [[",
  "        if (! YY_CURRENT_BUFFER)",
  "            return 0;",
  "    ]])",
  "    return yylineno;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_REENTRANT]],",
  "[[",
  "m4_ifdef( [[M4_YY_NO_GET_COLUMN]],,",
  "[[",
  "/** Get the current column number.",
  " * M4_YY_DOC_PARAM",
  " */",
  "int yyget_column  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    ",
  "    m4_ifdef( [[M4_YY_REENTRANT]],",
  "    [[",
  "        if (! YY_CURRENT_BUFFER)",
  "            return 0;",
  "    ]])",
  "    return yycolumn;",
  "}",
  "]])",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_IN]],,",
  "[[",
  "/** Get the input stream.",
  " * M4_YY_DOC_PARAM",
  " */",
  "FILE *yyget_in  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yyin;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_OUT]],,",
  "[[",
  "/** Get the output stream.",
  " * M4_YY_DOC_PARAM",
  " */",
  "FILE *yyget_out  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yyout;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_LENG]],,",
  "[[",
  "/** Get the length of the current token.",
  " * M4_YY_DOC_PARAM",
  " */",
  "int yyget_leng  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yyleng;",
  "}",
  "]])",
  "",
  "/** Get the current token.",
  " * M4_YY_DOC_PARAM",
  " */",
  "m4_ifdef( [[M4_YY_NO_GET_TEXT]],,",
  "[[",
  "char *yyget_text  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yytext;",
  "}",
  "]])",
  "",
  "%if-reentrant",
  "m4_ifdef( [[M4_YY_NO_SET_EXTRA]],,",
  "[[",
  "/** Set the user-defined data. This data is never touched by the scanner.",
  " * @param user_defined The data to be associated with this scanner.",
  " * M4_YY_DOC_PARAM",
  " */",
  "void yyset_extra YYFARGS1( YY_EXTRA_TYPE ,user_defined)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    yyextra = user_defined ;",
  "}",
  "]])",
  "%endif",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_LINENO]],,",
  "[[",
  "/** Set the current line number.",
  " * @param _line_number line number",
  " * M4_YY_DOC_PARAM",
  " */",
  "void yyset_lineno YYFARGS1( int ,_line_number)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "    m4_ifdef( [[M4_YY_REENTRANT]],",
  "    [[",
  "        /* lineno is only valid if an input buffer exists. */",
  "        if (! YY_CURRENT_BUFFER )",
  "           YY_FATAL_ERROR( \"yyset_lineno called with no buffer\" );",
  "    ]])",
  "    yylineno = _line_number;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_REENTRANT]],",
  "[[",
  "m4_ifdef( [[M4_YY_NO_SET_COLUMN]],,",
  "[[",
  "/** Set the current column.",
  " * @param _column_no column number",
  " * M4_YY_DOC_PARAM",
  " */",
  "void yyset_column YYFARGS1( int , _column_no)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "    m4_ifdef( [[M4_YY_REENTRANT]],",
  "    [[",
  "        /* column is only valid if an input buffer exists. */",
  "        if (! YY_CURRENT_BUFFER )",
  "           YY_FATAL_ERROR( \"yyset_column called with no buffer\" );",
  "    ]])",
  "    yycolumn = _column_no;",
  "}",
  "]])",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_IN]],,",
  "[[",
  "/** Set the input stream. This does not discard the current",
  " * input buffer.",
  " * @param _in_str A readable stream.",
  " * M4_YY_DOC_PARAM",
  " * @see yy_switch_to_buffer",
  " */",
  "void yyset_in YYFARGS1( FILE * ,_in_str)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    yyin = _in_str ;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_OUT]],,",
  "[[",
  "void yyset_out YYFARGS1( FILE * ,_out_str)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    yyout = _out_str ;",
  "}",
  "]])",
  "",
  "",
  "m4_ifdef( [[M4_YY_NO_GET_DEBUG]],,",
  "[[",
  "int yyget_debug  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yy_flex_debug;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_DEBUG]],,",
  "[[",
  "void yyset_debug YYFARGS1( int ,_bdebug)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    yy_flex_debug = _bdebug ;",
  "}",
  "]])",
  "%endif",
  "",
  "%if-reentrant",
  "/* Accessor methods for yylval and yylloc */",
  "",
  "%if-bison-bridge",
  "m4_ifdef( [[M4_YY_NO_GET_LVAL]],,",
  "[[",
  "YYSTYPE * yyget_lval  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yylval;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_SET_LVAL]],,",
  "[[",
  "void yyset_lval YYFARGS1( YYSTYPE * ,yylval_param)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    yylval = yylval_param;",
  "}",
  "]])",
  "",
  "m4_ifdef( [[<M4_YY_BISON_LLOC>]],",
  "[[",
  "    m4_ifdef( [[M4_YY_NO_GET_LLOC]],,",
  "    [[",
  "YYLTYPE *yyget_lloc  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    return yylloc;",
  "}",
  "    ]])",
  "",
  "    m4_ifdef( [[M4_YY_NO_SET_LLOC]],,",
  "    [[",
  "void yyset_lloc YYFARGS1( YYLTYPE * ,yylloc_param)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    yylloc = yylloc_param;",
  "}",
  "    ]])",
  "]])",
  "",
  "%endif",
  "",
  "",
  "/* User-visible API */",
  "",
  "/* yylex_init is special because it creates the scanner itself, so it is",
  " * the ONLY reentrant function that doesn't take the scanner as the last argument.",
  " * That's why we explicitly handle the declaration, instead of using our macros.",
  " */",
  "m4_ifdef( [[M4_YY_NO_ANSI_FUNC_DEFS]],",
  "[[",
  "int yylex_init( ptr_yy_globals )",
  "    yyscan_t* ptr_yy_globals;",
  "]],",
  "[[",
  "int yylex_init(yyscan_t* ptr_yy_globals)",
  "]])",
  "{",
  "    if (ptr_yy_globals == NULL){",
  "        errno = EINVAL;",
  "        return 1;",
  "    }",
  "",
  "    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );",
  "",
  "    if (*ptr_yy_globals == NULL){",
  "        errno = ENOMEM;",
  "        return 1;",
  "    }",
  "",
  "    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */",
  "    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));",
  "",
  "    return yy_init_globals ( *ptr_yy_globals );",
  "}",
  "",
  "",
  "/* yylex_init_extra has the same functionality as yylex_init, but follows the",
  " * convention of taking the scanner as the last argument. Note however, that",
  " * this is a *pointer* to a scanner, as it will be allocated by this call (and",
  " * is the reason, too, why this function also must handle its own declaration).",
  " * The user defined value in the first argument will be available to yyalloc in",
  " * the yyextra field.",
  " */",
  "m4_ifdef( [[M4_YY_NO_ANSI_FUNC_DEFS]],",
  "[[",
  "int yylex_init_extra( yy_user_defined, ptr_yy_globals )",
  "    YY_EXTRA_TYPE yy_user_defined;",
  "    yyscan_t* ptr_yy_globals;",
  "]],",
  "[[",
  "int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )",
  "]])",
  "{",
  "    struct yyguts_t dummy_yyguts;",
  "",
  "    yyset_extra (yy_user_defined, &dummy_yyguts);",
  "",
  "    if (ptr_yy_globals == NULL){",
  "        errno = EINVAL;",
  "        return 1;",
  "    }",
  "	",
  "    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );",
  "	",
  "    if (*ptr_yy_globals == NULL){",
  "        errno = ENOMEM;",
  "        return 1;",
  "    }",
  "    ",
  "    /* By setting to 0xAA, we expose bugs in",
  "    yy_init_globals. Leave at 0x00 for releases. */",
  "    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));",
  "    ",
  "    yyset_extra (yy_user_defined, *ptr_yy_globals);",
  "    ",
  "    return yy_init_globals ( *ptr_yy_globals );",
  "}",
  "",
  "%endif if-c-only",
  "%# Actually, that ended an if-rentrant section",
  "",
  "%if-c-only",
  "static int yy_init_globals YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "    /* Initialization is the same as for the non-reentrant scanner.",
  "     * This function is called from yylex_destroy(), so don't allocate here.",
  "     */",
  "",
  "m4_ifdef( [[M4_YY_USE_LINENO]],",
  "[[",
  "    m4_ifdef( [[M4_YY_NOT_REENTRANT]],",
  "    [[",
  "    /* We do not touch yylineno unless the option is enabled. */",
  "    yylineno =  1;",
  "    ]])",
  "]])",
  "    YY_G(yy_buffer_stack) = NULL;",
  "    YY_G(yy_buffer_stack_top) = 0;",
  "    YY_G(yy_buffer_stack_max) = 0;",
  "    YY_G(yy_c_buf_p) = NULL;",
  "    YY_G(yy_init) = 0;",
  "    YY_G(yy_start) = 0;",
  "",
  "m4_ifdef( [[M4_YY_HAS_START_STACK_VARS]],",
  "[[",
  "    YY_G(yy_start_stack_ptr) = 0;",
  "    YY_G(yy_start_stack_depth) = 0;",
  "    YY_G(yy_start_stack) =  NULL;",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_USES_REJECT]],",
  "[[",
  "    YY_G(yy_state_buf) = 0;",
  "    YY_G(yy_state_ptr) = 0;",
  "    YY_G(yy_full_match) = 0;",
  "    YY_G(yy_lp) = 0;",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_TEXT_IS_ARRAY]],",
  "[[",
  "    YY_G(yytext_ptr) = 0;",
  "    YY_G(yy_more_offset) = 0;",
  "    YY_G(yy_prev_more_offset) = 0;",
  "]])",
  "",
  "/* Defined in main.c */",
  "#ifdef YY_STDINIT",
  "    yyin = stdin;",
  "    yyout = stdout;",
  "#else",
  "    yyin = NULL;",
  "    yyout = NULL;",
  "#endif",
  "",
  "    /* For future reference: Set errno on error, since we are called by",
  "     * yylex_init()",
  "     */",
  "    return 0;",
  "}",
  "%endif",
  "",
  "",
  "%if-c-only SNIP! this currently causes conflicts with the c++ scanner",
  "/* yylex_destroy is for both reentrant and non-reentrant scanners. */",
  "int yylex_destroy  YYFARGS0(void)",
  "{",
  "    M4_YY_DECL_GUTS_VAR();",
  "",
  "    /* Pop the buffer stack, destroying each element. */",
  "	while(YY_CURRENT_BUFFER){",
  "		yy_delete_buffer( YY_CURRENT_BUFFER M4_YY_CALL_LAST_ARG );",
  "		YY_CURRENT_BUFFER_LVALUE = NULL;",
  "		yypop_buffer_state(M4_YY_CALL_ONLY_ARG);",
  "	}",
  "",
  "	/* Destroy the stack itself. */",
  "	yyfree(YY_G(yy_buffer_stack) M4_YY_CALL_LAST_ARG);",
  "	YY_G(yy_buffer_stack) = NULL;",
  "",
  "m4_ifdef( [[M4_YY_HAS_START_STACK_VARS]],",
  "[[",
  "    /* Destroy the start condition stack. */",
  "        yyfree( YY_G(yy_start_stack) M4_YY_CALL_LAST_ARG );",
  "        YY_G(yy_start_stack) = NULL;",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_USES_REJECT]],",
  "[[",
  "    yyfree ( YY_G(yy_state_buf) M4_YY_CALL_LAST_ARG);",
  "    YY_G(yy_state_buf)  = NULL;",
  "]])",
  "",
  "    /* Reset the globals. This is important in a non-reentrant scanner so the next time",
  "     * yylex() is called, initialization will occur. */",
  "    yy_init_globals( M4_YY_CALL_ONLY_ARG);",
  "",
  "%if-reentrant",
  "    /* Destroy the main struct (reentrant only). */",
  "    yyfree ( yyscanner M4_YY_CALL_LAST_ARG );",
  "    yyscanner = NULL;",
  "%endif",
  "    return 0;",
  "}",
  "%endif",
  "",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "/*",
  " * Internal utility routines.",
  " */",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#ifndef yytext_ptr",
  "static void yy_flex_strncpy YYFARGS3( char*,s1, yyconst char *,s2, int,n)",
  "{",
  "	M4_YY_DECL_GUTS_VAR();",
  "	M4_YY_NOOP_GUTS_VAR();",
  "",
  "	int i;",
  "	for ( i = 0; i < n; ++i )",
  "		s1[i] = s2[i];",
  "}",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NOT_IN_HEADER]],",
  "[[",
  "#ifdef YY_NEED_STRLEN",
  "static int yy_flex_strlen YYFARGS1( yyconst char *,s)",
  "{",
  "	int n;",
  "	for ( n = 0; s[n]; ++n )",
  "		;",
  "",
  "	return n;",
  "}",
  "#endif",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_FLEX_ALLOC]],,",
  "[[",
  "void *yyalloc YYFARGS1( yy_size_t ,size)",
  "{",
  "	M4_YY_DECL_GUTS_VAR();",
  "	M4_YY_NOOP_GUTS_VAR();",
  "	return malloc(size);",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_FLEX_REALLOC]],,",
  "[[",
  "void *yyrealloc  YYFARGS2( void *,ptr, yy_size_t ,size)",
  "{",
  "	M4_YY_DECL_GUTS_VAR();",
  "	M4_YY_NOOP_GUTS_VAR();",
  "",
  "	/* The cast to (char *) in the following accommodates both",
  "	 * implementations that use char* generic pointers, and those",
  "	 * that use void* generic pointers.  It works with the latter",
  "	 * because both ANSI C and C++ allow castless assignment from",
  "	 * any pointer type to void*, and deal with argument conversions",
  "	 * as though doing an assignment.",
  "	 */",
  "	return realloc(ptr, size);",
  "}",
  "]])",
  "",
  "m4_ifdef( [[M4_YY_NO_FLEX_FREE]],,",
  "[[",
  "void yyfree YYFARGS1( void *,ptr)",
  "{",
  "	M4_YY_DECL_GUTS_VAR();",
  "	M4_YY_NOOP_GUTS_VAR();",
  "	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */",
  "}",
  "]])",
  "",
  "%if-tables-serialization definitions",
  "#ifdef FLEX_SCANNER",
  "/*",
  "dnl   tables_shared.c - tables serialization code",
  "dnl ",
  "dnl   Copyright (c) 1990 The Regents of the University of California.",
  "dnl   All rights reserved.",
  "dnl ",
  "dnl   This code is derived from software contributed to Berkeley by",
  "dnl   Vern Paxson.",
  "dnl ",
  "dnl   The United States Government has rights in this work pursuant",
  "dnl   to contract no. DE-AC03-76SF00098 between the United States",
  "dnl   Department of Energy and the University of California.",
  "dnl ",
  "dnl   This file is part of flex.",
  "dnl ",
  "dnl   Redistribution and use in source and binary forms, with or without",
  "dnl   modification, are permitted provided that the following conditions",
  "dnl   are met:",
  "dnl ",
  "dnl   1. Redistributions of source code must retain the above copyright",
  "dnl      notice, this list of conditions and the following disclaimer.",
  "dnl   2. Redistributions in binary form must reproduce the above copyright",
  "dnl      notice, this list of conditions and the following disclaimer in the",
  "dnl      documentation and/or other materials provided with the distribution.",
  "dnl ",
  "dnl   Neither the name of the University nor the names of its contributors",
  "dnl   may be used to endorse or promote products derived from this software",
  "dnl   without specific prior written permission.",
  "dnl ",
  "dnl   THIS SOFTWARE IS PROVIDED `AS IS' AND WITHOUT ANY EXPRESS OR",
  "dnl   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED",
  "dnl   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR",
  "dnl   PURPOSE.",
  "dnl ",
  "*/",
  "",
  "/* This file is meant to be included in both the skeleton and the actual",
  " * flex code (hence the name \"_shared\"). ",
  " */",
  "#ifndef yyskel_static",
  "#define yyskel_static static",
  "#endif",
  "#else",
  "#include \"flexdef.h\"",
  "#include \"tables.h\"",
  "#ifndef yyskel_static",
  "#define yyskel_static",
  "#endif",
  "#endif",
  "",
  "",
  "/** Get the number of integers in this table. This is NOT the",
  " *  same thing as the number of elements.",
  " *  @param tbl the table",
  " *  @return the number of integers in the table",
  " */",
  "yyskel_static flex_int32_t yytbl_calc_total_len (const struct yytbl_data *tbl)",
  "{",
  "	flex_int32_t n;",
  "",
  "	/* total number of ints */",
  "	n = tbl->td_lolen;",
  "	if (tbl->td_hilen > 0)",
  "		n *= tbl->td_hilen;",
  "",
  "	if (tbl->td_id == YYTD_ID_TRANSITION)",
  "		n *= 2;",
  "	return n;",
  "}",
  "",
  "",
  "static int yytbl_read8 (void *v, struct yytbl_reader * rd)",
  "{",
  "    errno = 0;",
  "    if (fread (v, sizeof (flex_uint8_t), 1, rd->fp) != 1){",
  "        errno = EIO;",
  "        return -1;",
  "    }",
  "    rd->bread += sizeof(flex_uint8_t);",
  "    return 0;",
  "}",
  "",
  "static int yytbl_read16 (void *v, struct yytbl_reader * rd)",
  "{",
  "    errno = 0;",
  "    if (fread (v, sizeof (flex_uint16_t), 1, rd->fp) != 1){",
  "        errno = EIO;",
  "        return -1;",
  "    }",
  "    *((flex_uint16_t *) v) = ntohs (*((flex_uint16_t *) v));",
  "    rd->bread += sizeof(flex_uint16_t);",
  "    return 0;",
  "}",
  "",
  "static int yytbl_read32 (void *v, struct yytbl_reader * rd)",
  "{",
  "    errno = 0;",
  "    if (fread (v, sizeof (flex_uint32_t), 1, rd->fp) != 1){",
  "        errno = EIO;",
  "        return -1;",
  "    }",
  "    *((flex_uint32_t *) v) = ntohl (*((flex_uint32_t *) v));",
  "    rd->bread += sizeof(flex_uint32_t);",
  "    return 0;",
  "}",
  "",
  "/** Read the header */",
  "static int yytbl_hdr_read YYFARGS2(struct yytbl_hdr *, th, struct yytbl_reader *, rd)",
  "{",
  "    size_t  bytes;",
  "    memset (th, 0, sizeof (struct yytbl_hdr));",
  "",
  "    if (yytbl_read32 (&(th->th_magic), rd) != 0)",
  "        return -1;",
  "",
  "    if (th->th_magic != YYTBL_MAGIC){",
  "        YY_FATAL_ERROR( \"bad magic number\" );   /* TODO: not fatal. */",
  "        return -1;",
  "    }",
  "",
  "    if (yytbl_read32 (&(th->th_hsize), rd) != 0",
  "        || yytbl_read32 (&(th->th_ssize), rd) != 0",
  "        || yytbl_read16 (&(th->th_flags), rd) != 0)",
  "        return -1;",
  "",
  "    /* Sanity check on header size. Greater than 1k suggests some funny business. */",
  "    if (th->th_hsize < 16 || th->th_hsize > 1024){",
  "        YY_FATAL_ERROR( \"insane header size detected\" );   /* TODO: not fatal. */",
  "        return -1;",
  "    }",
  "",
  "    /* Allocate enough space for the version and name fields */",
  "    bytes = th->th_hsize - 14;",
  "    th->th_version = (char *) yyalloc (bytes M4_YY_CALL_LAST_ARG);",
  "    if ( ! th->th_version )",
  "        YY_FATAL_ERROR( \"out of dynamic memory in yytbl_hdr_read()\" );",
  "",
  "    /* we read it all into th_version, and point th_name into that data */",
  "    if (fread (th->th_version, 1, bytes, rd->fp) != bytes){",
  "        errno = EIO;",
  "        yyfree(th->th_version M4_YY_CALL_LAST_ARG);",
  "        th->th_version = NULL;",
  "        return -1;",
  "    }",
  "    else",
  "        rd->bread += bytes;",
  "",
  "    th->th_name = th->th_version + strlen (th->th_version) + 1;",
  "    return 0;",
  "}",
  "",
  "/** lookup id in the dmap list.",
  " *  @param dmap pointer to first element in list",
  " *  @return NULL if not found.",
  " */",
  "static struct yytbl_dmap *yytbl_dmap_lookup YYFARGS2(struct yytbl_dmap *, dmap,",
  "                                                      int, id)",
  "{",
  "	M4_YY_DECL_GUTS_VAR();",
  "	M4_YY_NOOP_GUTS_VAR();",
  "",
  "    while (dmap->dm_id)",
  "        if ((int)(dmap->dm_id) == id)",
  "            return dmap;",
  "        else",
  "            dmap++;",
  "    return NULL;",
  "}",
  "",
  "/** Read a table while mapping its contents to the local array. ",
  " *  @param dmap used to performing mapping",
  " *  @return 0 on success",
  " */",
  "static int yytbl_data_load YYFARGS2(struct yytbl_dmap *, dmap, struct yytbl_reader*, rd)",
  "{",
  "    struct yytbl_data td;",
  "    struct yytbl_dmap *transdmap=0;",
  "    int     len, i, rv, inner_loop_count;",
  "    void   *p=0;",
  "",
  "    memset (&td, 0, sizeof (struct yytbl_data));",
  "",
  "    if (yytbl_read16 (&td.td_id, rd) != 0",
  "        || yytbl_read16 (&td.td_flags, rd) != 0",
  "        || yytbl_read32 (&td.td_hilen, rd) != 0",
  "        || yytbl_read32 (&td.td_lolen, rd) != 0)",
  "        return -1;",
  "",
  "    /* Lookup the map for the transition table so we have it in case we need it",
  "     * inside the loop below. This scanner might not even have a transition",
  "     * table, which is ok.",
  "     */",
  "    transdmap = yytbl_dmap_lookup (dmap, YYTD_ID_TRANSITION M4_YY_CALL_LAST_ARG);",
  "",
  "    if ((dmap = yytbl_dmap_lookup (dmap, td.td_id M4_YY_CALL_LAST_ARG)) == NULL){",
  "        YY_FATAL_ERROR( \"table id not found in map.\" );   /* TODO: not fatal. */",
  "        return -1;",
  "    }",
  "",
  "    /* Allocate space for table.",
  "     * The --full yy_transition table is a special case, since we",
  "     * need the dmap.dm_sz entry to tell us the sizeof the individual",
  "     * struct members.",
  "     */",
  "    {",
  "    size_t  bytes;",
  "",
  "    if ((td.td_flags & YYTD_STRUCT))",
  "        bytes = sizeof(struct yy_trans_info) * td.td_lolen * (td.td_hilen ? td.td_hilen : 1);",
  "    else",
  "        bytes = td.td_lolen * (td.td_hilen ? td.td_hilen : 1) * dmap->dm_sz;",
  "",
  "    if(M4_YY_TABLES_VERIFY)",
  "        /* We point to the array itself */",
  "        p = dmap->dm_arr; ",
  "    else",
  "        /* We point to the address of a pointer. */",
  "        *dmap->dm_arr = p = (void *) yyalloc (bytes M4_YY_CALL_LAST_ARG);",
  "        if ( ! p )",
  "            YY_FATAL_ERROR( \"out of dynamic memory in yytbl_data_load()\" );",
  "    }",
  "",
  "    /* If it's a struct, we read 2 integers to get one element */",
  "    if ((td.td_flags & YYTD_STRUCT) != 0)",
  "        inner_loop_count = 2;",
  "    else",
  "        inner_loop_count = 1;",
  "",
  "    /* read and map each element.",
  "     * This loop iterates once for each element of the td_data array.",
  "     * Notice that we increment 'i' in the inner loop.",
  "     */",
  "    len = yytbl_calc_total_len (&td);",
  "    for (i = 0; i < len; ){",
  "        int    j;",
  "",
  "",
  "        /* This loop really executes exactly 1 or 2 times.",
  "         * The second time is to handle the second member of the",
  "         * YYTD_STRUCT for the yy_transition array.",
  "         */",
  "        for (j = 0; j < inner_loop_count; j++, i++) {",
  "            flex_int32_t t32;",
  "",
  "            /* read into t32 no matter what the real size is. */",
  "            {",
  "            flex_int16_t t16;",
  "            flex_int8_t  t8;",
  "",
  "            switch (YYTDFLAGS2BYTES (td.td_flags)) {",
  "            case sizeof (flex_int32_t):",
  "                rv = yytbl_read32 (&t32, rd);",
  "                break;",
  "            case sizeof (flex_int16_t):",
  "                rv = yytbl_read16 (&t16, rd);",
  "                t32 = t16;",
  "                break;",
  "            case sizeof (flex_int8_t):",
  "                rv = yytbl_read8 (&t8, rd);",
  "                t32 = t8;",
  "                break;",
  "            default: ",
  "                YY_FATAL_ERROR( \"invalid td_flags\" );   /* TODO: not fatal. */",
  "                return -1;",
  "            }",
  "            }",
  "            if (rv != 0)",
  "                return -1;",
  "",
  "            /* copy into the deserialized array... */",
  "",
  "            if ((td.td_flags & YYTD_STRUCT)) {",
  "                /* t32 is the j'th member of a two-element struct. */",
  "                void   *v;",
  "",
  "                v = j == 0 ? &(((struct yy_trans_info *) p)->yy_verify)",
  "                    : &(((struct yy_trans_info *) p)->yy_nxt);",
  "",
  "                switch (dmap->dm_sz) {",
  "                case sizeof (flex_int32_t):",
  "                    if (M4_YY_TABLES_VERIFY){",
  "                        if( ((flex_int32_t *) v)[0] != (flex_int32_t) t32)",
  "                           YY_FATAL_ERROR( \"tables verification failed at YYTD_STRUCT flex_int32_t\" );",
  "                    }else",
  "                        ((flex_int32_t *) v)[0] = (flex_int32_t) t32;",
  "                    break;",
  "                case sizeof (flex_int16_t):",
  "                    if (M4_YY_TABLES_VERIFY ){",
  "                        if(((flex_int16_t *) v)[0] != (flex_int16_t) t32)",
  "                        YY_FATAL_ERROR( \"tables verification failed at YYTD_STRUCT flex_int16_t\" );",
  "                    }else",
  "                        ((flex_int16_t *) v)[0] = (flex_int16_t) t32;",
  "                    break;",
  "                case sizeof(flex_int8_t):",
  "                    if (M4_YY_TABLES_VERIFY ){",
  "                         if( ((flex_int8_t *) v)[0] != (flex_int8_t) t32)",
  "                        YY_FATAL_ERROR( \"tables verification failed at YYTD_STRUCT flex_int8_t\" );",
  "                    }else",
  "                        ((flex_int8_t *) v)[0] = (flex_int8_t) t32;",
  "                    break;",
  "                default:",
  "                    YY_FATAL_ERROR( \"invalid dmap->dm_sz for struct\" );   /* TODO: not fatal. */",
  "                    return -1;",
  "                }",
  "",
  "                /* if we're done with j, increment p */",
  "                if (j == 1)",
  "                    p = (struct yy_trans_info *) p + 1;",
  "            }",
  "            else if ((td.td_flags & YYTD_PTRANS)) {",
  "                /* t32 is an index into the transition array. */",
  "                struct yy_trans_info *v;",
  "",
  "",
  "                if (!transdmap){",
  "                    YY_FATAL_ERROR( \"transition table not found\" );   /* TODO: not fatal. */",
  "                    return -1;",
  "                }",
  "                ",
  "                if( M4_YY_TABLES_VERIFY)",
  "                    v = &(((struct yy_trans_info *) (transdmap->dm_arr))[t32]);",
  "                else",
  "                    v = &((*((struct yy_trans_info **) (transdmap->dm_arr)))[t32]);",
  "",
  "                if(M4_YY_TABLES_VERIFY ){",
  "                    if( ((struct yy_trans_info **) p)[0] != v)",
  "                        YY_FATAL_ERROR( \"tables verification failed at YYTD_PTRANS\" );",
  "                }else",
  "                    ((struct yy_trans_info **) p)[0] = v;",
  "                ",
  "                /* increment p */",
  "                p = (struct yy_trans_info **) p + 1;",
  "            }",
  "            else {",
  "                /* t32 is a plain int. copy data, then incrememnt p. */",
  "                switch (dmap->dm_sz) {",
  "                case sizeof (flex_int32_t):",
  "                    if(M4_YY_TABLES_VERIFY ){",
  "                        if( ((flex_int32_t *) p)[0] != (flex_int32_t) t32)",
  "                        YY_FATAL_ERROR( \"tables verification failed at flex_int32_t\" );",
  "                    }else",
  "                        ((flex_int32_t *) p)[0] = (flex_int32_t) t32;",
  "                    p = ((flex_int32_t *) p) + 1;",
  "                    break;",
  "                case sizeof (flex_int16_t):",
  "                    if(M4_YY_TABLES_VERIFY ){",
  "                        if( ((flex_int16_t *) p)[0] != (flex_int16_t) t32)",
  "                        YY_FATAL_ERROR( \"tables verification failed at flex_int16_t\" );",
  "                    }else",
  "                        ((flex_int16_t *) p)[0] = (flex_int16_t) t32;",
  "                    p = ((flex_int16_t *) p) + 1;",
  "                    break;",
  "                case sizeof (flex_int8_t):",
  "                    if(M4_YY_TABLES_VERIFY ){",
  "                        if( ((flex_int8_t *) p)[0] != (flex_int8_t) t32)",
  "                        YY_FATAL_ERROR( \"tables verification failed at flex_int8_t\" );",
  "                    }else",
  "                        ((flex_int8_t *) p)[0] = (flex_int8_t) t32;",
  "                    p = ((flex_int8_t *) p) + 1;",
  "                    break;",
  "                default:",
  "                    YY_FATAL_ERROR( \"invalid dmap->dm_sz for plain int\" );   /* TODO: not fatal. */",
  "                    return -1;",
  "                }",
  "            }",
  "        }",
  "",
  "    }",
  "",
  "    /* Now eat padding. */",
  "    {",
  "        int pad;",
  "        pad = yypad64(rd->bread);",
  "        while(--pad >= 0){",
  "            flex_int8_t t8;",
  "            if(yytbl_read8(&t8,rd) != 0)",
  "                return -1;",
  "        }",
  "    }",
  "",
  "    return 0;",
  "}",
  "",
  "%define-yytables   The name for this specific scanner's tables.",
  "",
  "/* Find the key and load the DFA tables from the given stream.  */",
  "static int yytbl_fload YYFARGS2(FILE *, fp, const char *, key)",
  "{",
  "    int rv=0;",
  "    struct yytbl_hdr th;",
  "    struct yytbl_reader rd;",
  "",
  "    rd.fp = fp;",
  "    th.th_version = NULL;",
  "",
  "    /* Keep trying until we find the right set of tables or end of file. */",
  "    while (!feof(rd.fp)) {",
  "        rd.bread = 0;",
  "        if (yytbl_hdr_read (&th, &rd M4_YY_CALL_LAST_ARG) != 0){",
  "            rv = -1;",
  "            goto return_rv;",
  "        }",
  "",
  "        /* A NULL key means choose the first set of tables. */",
  "        if (key == NULL)",
  "            break;",
  "",
  "        if (strcmp(th.th_name,key) != 0){",
  "            /* Skip ahead to next set */",
  "            fseek(rd.fp, th.th_ssize - th.th_hsize, SEEK_CUR);",
  "            yyfree(th.th_version M4_YY_CALL_LAST_ARG);",
  "            th.th_version = NULL;",
  "        }",
  "        else",
  "            break;",
  "    }",
  "",
  "    while (rd.bread < th.th_ssize){",
  "        /* Load the data tables */",
  "        if(yytbl_data_load (yydmap,&rd M4_YY_CALL_LAST_ARG) != 0){",
  "            rv = -1;",
  "            goto return_rv;",
  "        }",
  "    }",
  "",
  "return_rv:",
  "    if(th.th_version){",
  "        yyfree(th.th_version M4_YY_CALL_LAST_ARG);",
  "        th.th_version = NULL;",
  "    }",
  "",
  "    return rv;",
  "}",
  "",
  "/** Load the DFA tables for this scanner from the given stream.  */",
  "int yytables_fload YYFARGS1(FILE *, fp)",
  "{",
  "",
  "    if( yytbl_fload(fp, YYTABLES_NAME M4_YY_CALL_LAST_ARG) != 0)",
  "        return -1;",
  "    return 0;",
  "}",
  "",
  "/** Destroy the loaded tables, freeing memory, etc.. */",
  "int yytables_destroy YYFARGS0(void)",
  "{   ",
  "    struct yytbl_dmap *dmap=0;",
  "",
  "    if(!M4_YY_TABLES_VERIFY){",
  "        /* Walk the dmap, freeing the pointers */",
  "        for(dmap=yydmap; dmap->dm_id; dmap++) {",
  "            void * v;",
  "            v = dmap->dm_arr;",
  "            if(v && *(char**)v){",
  "                    yyfree(*(char**)v M4_YY_CALL_LAST_ARG);",
  "                    *(char**)v = NULL;",
  "            }",
  "        }",
  "    }",
  "",
  "    return 0;",
  "}",
  "",
  "/* end table serialization code definitions */",
  "%endif",
  "",
  "",
  "m4_ifdef([[M4_YY_MAIN]], [[",
  "int main M4_YY_PARAMS(void);",
  "",
  "int main ()",
  "{",
  "",
  "%if-reentrant",
  "    yyscan_t lexer;",
  "    yylex_init(&lexer);",
  "    yylex( lexer );",
  "    yylex_destroy( lexer);",
  "",
  "%endif",
  "%if-not-reentrant",
  "	yylex();",
  "%endif",
  "",
  "	return 0;",
  "}",
  "]])",
  "",
  "%ok-for-header",
  "m4_ifdef( [[M4_YY_IN_HEADER]],",
  "[[",
  "#undef YY_NEW_FILE",
  "#undef YY_FLUSH_BUFFER",
  "#undef yy_set_bol",
  "#undef yy_new_buffer",
  "#undef yy_set_interactive",
  "#undef YY_DO_BEFORE_ACTION",
  "",
  "#ifdef YY_DECL_IS_OURS",
  "#undef YY_DECL_IS_OURS",
  "#undef YY_DECL",
  "#endif",
  "]])",
  0
};
