const gDefaultColor = "#B6BDD2";
const gURLBar_value = "http://www.example.net/";
let gAnimation;

function initDialog()
{
	var flip = true;
	gAnimation = setInterval(function(aProgressBar) {
		if ((flip = !flip))
		{
			aProgressBar.value = 0;
			aProgressBar.value = 33;
		}
		else
		{
			aProgressBar.value = 90;
		}
	}, 2000, _("statusbar-icon"));
}

function uninitDialog()
{
	clearInterval(gAnimation);
}

function writeColor()
{
	let image = _("color-image").value.replace(/^\s+|\s+$/g, "");
	let color = _("color-plain").color;
	
	return (image || color != gDefaultColor) ? (image ? "url(" + image + ") " : "") + color : "";
}

function readColorPlain()
{
	document.getAnonymousElementByAttribute(_("statusbar-icon"), "class", "progress-bar").style.background = _("extensions.fission.color").value.replace(/^(url\(.+\)) #[0-9A-F]{6}$/, "$1 repeat-x left center transparent");
	
	return /(#[0-9A-F]{6})$/i.test(_("extensions.fission.color").value) ? RegExp.$1 : gDefaultColor;
}

function readColorImage()
{
	return /^url\((.+)\)/.test(_("extensions.fission.color").value) ? RegExp.$1 : "";
}

function readIconize()
{
	let iconize = _("extensions.fission.iconize").value;
	
	let urlbar = _("urlbar");
	urlbar.setAttribute("fission", iconize ? "icon" : "fusion");
	urlbar.flex = iconize ? 0 : 1000;
	urlbar.value = iconize ? "" : gURLBar_value;
	
	return iconize;
}

function onFindImage()
{
	const nsIFilePicker = Components.interfaces.nsIFilePicker;
	let filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	
	filePicker.init(window, null, nsIFilePicker.modeOpen);
	filePicker.appendFilters(nsIFilePicker.filterImages);
	
	try
	{
		let uri = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService).newURI(_("color-image").value, null, null);
		if (uri instanceof Components.interfaces.nsIFileURL && uri.file instanceof Components.interfaces.nsILocalFile)
		{
			filePicker.displayDirectory = uri.file.parent;
		}
	}
	catch (ex) { /* no valid (file) URI, so no default directory to set */ }
	
	if (filePicker.show() == nsIFilePicker.returnOK)
	{
		_("color-image").value = filePicker.fileURL.spec;
		_("FissionOptionsPane").userChangedValue(_("color-image"));
	}
}

function onResetColor()
{
	_("extensions.fission.color").value = "";
}

function _(aId)
{
	return document.getElementById(aId);
}
