/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.1
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.1 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.1 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <stdint.h>
#include <cstdlib>
#include <cmath>
#include "sdlscreen.h"
#include "vectorfield.h"
#include "ringbuffer.h"
#include "wavepainter.h"

using namespace std;

WavePainter::WavePainter(SdlScreen* s, VectorField* v, RingBuffer* r)
{
	__height = v->height();
	__width = v->width();
	__y0 = (s->height() - v->height()) / 2;
	__x0 = (s->width() - v->width()) / 2;
	__ringbuffer = r;
	__sdlscreen = s;
	__xCenter = __x0 + __width / 2;
	__yCenter = __y0 + __height / 2;
	__shape = 0;
	__shapes = 2;
	__color1 = rand() % 0xffffffff;
	__color2 = ~__color1;
	__alpha = 0;
	// style = 0;
}

WavePainter::~WavePainter()
{
}

void WavePainter::line(int x1, int y1, int x2, int y2, uint32_t color)
{
	int Dx = abs(x1 - x2);
	int Dy = abs(y1 - y2);
	int dx = 1;
	if(x2 < x1) dx = -1;
	int dy = 1;
	if(y2 < y1) dy = -1;
	uint32_t* pixels = (uint32_t*)__sdlscreen->pixels();
	int pitch = __sdlscreen->width();

	if((Dx == 0) && (Dy == 0)) return;
	
	if(Dx > Dy)
	{
		for(int x = x1; x * dx <= x2 * dx; x += dx)
		{
			int y = (int)((double)y1 + (double)Dy / (double)Dx * (double)dy * (double)abs(x - x1) + 0.5);
			/* color value 0xffffff00 inverts */
			if(color != 0xffffff00)	*(pixels + y * pitch + x) = color;
			else *(pixels + y * pitch + x) = ~*(pixels + y * pitch + x);
		}
	}
	else
	{
		for(int y = y1; y * dy <= y2 * dy; y += dy)
		{
			int x = (int)((double)x1 + (double)Dx / (double)Dy * (double)dx * (double)abs(y - y1) + 0.5);
			/* color value 0xffffff00 inverts */
			if(color != 0xffffff00)	*(pixels + y * pitch + x) = color;
			else *(pixels + y * pitch + x) = ~*(pixels + y * pitch + x);
		}
	}
}

void WavePainter::segment(double phi1, double phi2, double r1, double r2, uint32_t color)
{
	double x1 = __xCenter + r1 * sin(phi1);
	double x2 = __xCenter + r2 * sin(phi1);
	double x3 = __xCenter + r2 * sin(phi2);
	double x4 = __xCenter + r1 * sin(phi2);
	double y1 = __yCenter - r1 * cos(phi1);
	double y2 = __yCenter - r2 * cos(phi1);
	double y3 = __yCenter - r2 * cos(phi2);
	double y4 = __yCenter - r1 * cos(phi2);
	// switch(style)
	// {
		// case 0:
			line(x1, y1, x2, y2, color);
			line(x2, y2, x3, y3, color);
			line(x3, y3, x4, y4, color);
			line(x4, y4, x1, y1, color);
			// break;
		// case 1:
			// line(x1, y1, x3, y3, color);
			// line(x4, y4, x2, y2, color);
			// break;
		// default:
			// break;
	// }
	
}

void WavePainter::paint()
{
	int16_t* samples = (int16_t*)__ringbuffer->get();
	int l = __ringbuffer->size() / 4;
	int div = 196605 / __height;
	double Pi = acos(-1);
	static int count = 0;
	
	switch(__shape)
	{
		case 0:
			for(int i = 0; i < l - 1; i ++)
			{
				int x1 = __x0 + (__width * i) / l;
				int x2 = __x0 + (__width * (i + 1)) / l;
				int y1 = __yCenter - __height / 6 - *(samples + 2 * i) / div;
				int y2 = __yCenter - __height / 6 - *(samples + 2 * (i + 1)) / div;
				line(x1, y1, x2, y2, __color1);
				y1 = __yCenter + __height / 6 - *(samples + 1 + 2 * i) / div;
				y2 = __yCenter + __height / 6 - *(samples + 1 + 2 * (i + 1)) / div;
				line(x1, y1, x2, y2, __color2);
			}
			return;
		case 1:
			count ++;
			while(count >= 120) count -= 120;
			for(int i = 0; i < l - 1; i ++)
			{
				double phi1 = Pi * (0.25 + (double)i / (double)l) + Pi / 60 * count;
				double phi2 = phi1 + Pi / (double)l;
				double r1 = __height / 4 + *(samples + 2 * i) / div;
				double r2 = __height / 4 + *(samples + 2 * (i + 1)) / div;
				int x1 = iround(__xCenter + r1 * sin(phi1));
				int x2 = iround(__xCenter + r2 * sin(phi2));
				int y1 = iround(__yCenter + r1 * cos(phi1));
				int y2 = iround(__yCenter + r2 * cos(phi2));
				line(x1, y1, x2, y2, __color1);
				phi1 += Pi;
				phi2 += Pi;
				r1 = __height / 4 + *(samples + 1 + 2 * i) / div;
				r2 = __height / 4 + *(samples + 1 + 2 * (i + 1)) / div;
				x1 = iround(__xCenter + r1 * sin(phi1));
				x2 = iround(__xCenter + r2 * sin(phi2));
				y1 = iround(__yCenter + r1 * cos(phi1));
				y2 = iround(__yCenter + r2 * cos(phi2));
				line(x1, y1, x2, y2, __color2);
			}
			return;
	}
}

void WavePainter::changeShape()
{
	int n = rand() % __shapes;
	while(n == __shape) n = rand() % __shapes;
	__shape = n;
}

void WavePainter::changeColor()
{
	__color1 = rand() % 0xffffffff;
	__color2 = ~__color1;
}

int iround(double v)
{
	return (int)(v + 0.5);
}

void WavePainter::beat(double bpm)
{
	static double last = 0;
	if(bpm == 0)
	{
		__alpha = 0;
		return;
	}
//	if(abs( 1 - last / bpm) > 0.05)
//	{
//		if(style == 0) style = 1;
//		else style = 0;
//	}
	last = bpm;
	double Pi = acos(-1);
	double r2 = __height * 5 / 12;
	double r1 = __height * 21 / 48;
	double alpha0 = __alpha;
	double alpha1 = __alpha + Pi / bpm / 8;
	segment(alpha0, alpha1, r1, r2);
	segment(-alpha0, -alpha1, r1, r2);
	segment(alpha0 + Pi, alpha1 + Pi, r1, r2);
	segment(-alpha0 - Pi, -alpha1 - Pi, r1, r2);
	__alpha += Pi / bpm / 4;
}
