/****************************************************************
 *								*
 *	Copyright 2001 Sanchez Computer Associates, Inc.	*
 *								*
 *	This source code contains the intellectual property	*
 *	of its copyright holder(s), and is made available	*
 *	under a license.  If you do not know the terms of	*
 *	the license, please stop and do not read further.	*
 *								*
 ****************************************************************/

/* Object record types: */
#define	EOBJ$C_EMH		8
#define	EOBJ$C_EEOM		9
#define	EOBJ$C_EGSD		10
#define	EOBJ$C_ETIR		11
#define	EOBJ$C_EDBG		12
#define	EOBJ$C_ETBT		13
#define	EOBJ$C_MAXRECTYP	13

/* Byte offsets into object record and related constants: */
#define	EOBJ$K_SUBTYP		4
#define	EOBJ$C_SUBTYP		4
#define	EOBJ$C_MAXRECSIZ	8192
#define	EOBJ$C_STRLVL		2
#define	EOBJ$C_SYMSIZ		31
#define	EOBJ$C_STOREPLIM	-1
#define	EOBJ$C_PSCALILIM	16
#define	EOBJ$S_EOBJRECDEF	10
#define	EOBJ$W_RECTYP		0
#define	EOBJ$W_SIZE		2
#define	EOBJ$W_SUBTYP		4
#define	EOBJ$B_MHD_STRLV	6
#define	EOBJ$B_MHD_HOLD		7
#define	EOBJ$W_MHD_RECSZ	8
#define	EOBJ$T_MHD_NAME		10

/* Object header record (EOBJ$C_EMH) subtypes: */
#define	EMH$C_MHD		0
#define	EMH$C_LNM		1
#define	EMH$C_SRC		2
#define	EMH$C_TTL		3
#define	EMH$C_CPR		4
#define	EMH$C_MTC		5
#define	EMH$C_GTX		6
#define	EMH$C_MAXHDRTYP		6

/* Byte offsets of fields in object header record (EOBJ$C_EMH): */
#define	EMH$S_EMHDEF		52
#define	EMH$W_RECTYP		0
#define	EMH$W_SIZE		2
#define	EMH$W_HDRTYP		4
#define	EMH$B_STRLVL		6
#define	EMH$B_TEMP		7
#define	EMH$L_ARCH1		8
#define	EMH$L_ARCH2		12
#define	EMH$L_RECSIZ		16
#define	EMH$B_NAMLNG		20
#define	EMH$S_NAME		31
#define	EMH$T_NAME		21

#define	EEOM$C_SUCCESS		0
#define	EEOM$C_WARNING		1
#define	EEOM$C_ERROR		2
#define	EEOM$C_ABORT		3
#define	EEOM$K_EOMMIN		10
#define	EEOM$C_EOMMIN		10
#define	EEOM$K_EOMMX1		10
#define	EEOM$C_EOMMX1		10
#define	EEOM$M_WKTFR		0X1
#define	EEOM$K_EOMMAX		24
#define	EEOM$C_EOMMAX		24
#define	EEOM$S_EEOMDEF		24
#define	EEOM$W_RECTYP		0
#define	EEOM$W_SIZE		2
#define	EEOM$L_TOTAL_LPS	4
#define	EEOM$W_COMCOD		8
#define	EEOM$B_TFRFLG		10
#define	EEOM$V_WKTFR		0
#define	EEOM$B_TEMP		11
#define	EEOM$L_PSINDX		12
#define	EEOM$S_TFRADR		8
#define	EEOM$Q_TFRADR		16
#define	EEOM$L_TFRADR		16


#define	EGSD$K_ENTRIES		2
#define	EGSD$C_ENTRIES		2

#define	EGSD$C_PSC		0
#define	EGSD$C_SYM		1
#define	EGSD$C_IDC		2
#define	EGSD$C_ENV		3
#define	EGSD$C_LSY		4
#define	EGSD$C_SPSC		5
#define	EGSD$C_SYMV		6
#define	EGSD$C_SYMM		7
#define	EGSD$C_SYMG		8
#define	EGSD$C_MAXRECTYP	8

#define	EGSD$S_EGSDEF		12
#define	EGSD$W_RECTYP		0
#define	EGSD$W_RECSIZ		2
#define	EGSD$L_ALIGNLW		4
#define	EGSD$W_GSDTYP		8
#define	EGSD$W_GSDSIZ		10

#define	EGPS$M_PIC		0X1
#define	EGPS$M_LIB		0X2
#define	EGPS$M_OVR		0X4
#define	EGPS$M_REL		0X8
#define	EGPS$M_GBL		0X10
#define	EGPS$M_SHR		0X20
#define	EGPS$M_EXE		0X40
#define	EGPS$M_RD		0X80
#define	EGPS$M_WRT		0X100
#define	EGPS$M_VEC		0X200
#define	EGPS$M_NOMOD		0X400
#define	EGPS$M_COM		0X800
#define	EGPS$K_NAME		12
#define	EGPS$C_NAME		12
#define	EGPS$S_EGPSDEF		44
#define	EGPS$W_GSDTYP		0
#define	EGPS$T_START		0
#define	EGPS$W_SIZE		2
#define	EGPS$B_ALIGN		4
#define	EGPS$B_TEMP		5
#define	EGPS$W_FLAGS		6
#define	EGPS$V_PIC		0
#define	EGPS$V_LIB		1
#define	EGPS$V_OVR		2
#define	EGPS$V_REL		3
#define	EGPS$V_GBL		4
#define	EGPS$V_SHR		5
#define	EGPS$V_EXE		6
#define	EGPS$V_RD		7
#define	EGPS$V_WRT		8
#define	EGPS$V_VEC		9
#define	EGPS$V_NOMOD		10
#define	EGPS$V_COM		11
#define	EGPS$L_ALLOC		8
#define	EGPS$B_NAMLNG		12
#define	EGPS$S_NAME		31
#define	EGPS$T_NAME		13

#define	ESGPS$M_PIC		0X1
#define	ESGPS$M_LIB		0X2
#define	ESGPS$M_OVR		0X4
#define	ESGPS$M_REL		0X8
#define	ESGPS$M_GBL		0X10
#define	ESGPS$M_SHR		0X20
#define	ESGPS$M_EXE		0X40
#define	ESGPS$M_RD		0X80
#define	ESGPS$M_WRT		0X100
#define	ESGPS$M_VEC		0X200
#define	ESGPS$M_NOMOD		0X400
#define	ESGPS$M_COM		0X800
#define	ESGPS$K_NAME		25
#define	ESGPS$C_NAME		25
#define	ESGPS$S_ESGPSDEF	56
#define	ESGPS$W_GSDTYP		0
#define	ESGPS$T_START		0
#define	ESGPS$W_SIZE		2
#define	ESGPS$B_ALIGN		4
#define	ESGPS$B_TEMP		5
#define	ESGPS$W_FLAGS		6
#define	ESGPS$V_PIC		0
#define	ESGPS$V_LIB		1
#define	ESGPS$V_OVR		2
#define	ESGPS$V_REL		3
#define	ESGPS$V_GBL		4
#define	ESGPS$V_SHR		5
#define	ESGPS$V_EXE		6
#define	ESGPS$V_RD		7
#define	ESGPS$V_WRT		8
#define	ESGPS$V_VEC		9
#define	ESGPS$V_NOMOD		10
#define	ESGPS$V_COM		11
#define	ESGPS$L_ALLOC		8
#define	ESGPS$L_BASE		12
#define	ESGPS$S_VALUE		8
#define	ESGPS$Q_VALUE		16
#define	ESGPS$L_VALUE		16
#define	ESGPS$B_NAMLNG		24
#define	ESGPS$S_NAME		31
#define	ESGPS$T_NAME		25

#define	EGSY$M_WEAK		0X1
#define	EGSY$M_DEF		0X2
#define	EGSY$M_UNI		0X4
#define	EGSY$M_REL		0X8
#define	EGSY$M_COMM		0X10
#define	EGSY$M_VECEP		0X20
#define	EGSY$M_NORM		0X40
#define	EGSY$S_EGSYDEF		8
#define	EGSY$W_GSDTYP		0
#define	EGSY$T_START		0
#define	EGSY$W_SIZE		2
#define	EGSY$B_DATYP		4
#define	EGSY$B_TEMP		5
#define	EGSY$W_FLAGS		6
#define	EGSY$V_WEAK		0
#define	EGSY$V_DEF		1
#define	EGSY$V_UNI		2
#define	EGSY$V_REL		3
#define	EGSY$V_COMM		4
#define	EGSY$V_VECEP		5
#define	EGSY$V_NORM		6

#define	EGST$K_NAME		37
#define	EGST$C_NAME		37
#define	EGST$S_EGSTDEF		68
#define	EGST$W_GSDTYP		0
#define	EGST$T_START		0
#define	EGST$W_SIZE		2
#define	EGST$B_DATYP		4
#define	EGST$B_TEMP		5
#define	EGST$W_FLAGS		6
#define	EGST$S_VALUE		8
#define	EGST$Q_VALUE		8
#define	EGST$L_VALUE		8
#define	EGST$S_LP_1		8
#define	EGST$Q_LP_1		16
#define	EGST$L_LP_1		16
#define	EGST$S_LP_2		8
#define	EGST$Q_LP_2		24
#define	EGST$L_LP_2		24
#define	EGST$L_PSINDX		32
#define	EGST$B_NAMLNG		36
#define	EGST$S_NAME		31
#define	EGST$T_NAME		37

#define	ESDF$K_NAME		33
#define	ESDF$C_NAME		33
#define	ESDF$S_ESDFDEF		64
#define	ESDF$W_GSDTYP		0
#define	ESDF$T_START		0
#define	ESDF$W_SIZE		2
#define	ESDF$B_DATYP		4
#define	ESDF$B_TEMP		5
#define	ESDF$W_FLAGS		6
#define	ESDF$S_VALUE		8
#define	ESDF$Q_VALUE		8
#define	ESDF$L_VALUE		8
#define	ESDF$S_CODE_ADDRESS	8
#define	ESDF$Q_CODE_ADDRESS	16
#define	ESDF$L_CODE_ADDRESS	16
#define	ESDF$L_CA_PSINDX	24
#define	ESDF$L_PSINDX		28
#define	ESDF$B_NAMLNG		32
#define	ESDF$S_NAME		31
#define	ESDF$T_NAME		33

#define	ESDFV$K_NAME		25
#define	ESDFV$C_NAME		25
#define	ESDFV$S_ESDFVDEF	56
#define	ESDFV$W_GSDTYP		0
#define	ESDFV$T_START		0
#define	ESDFV$W_SIZE		2
#define	ESDFV$B_DATYP		4
#define	ESDFV$B_TEMP		5
#define	ESDFV$W_FLAGS		6
#define	ESDFV$S_VALUE		8
#define	ESDFV$Q_VALUE		8
#define	ESDFV$L_VALUE		8
#define	ESDFV$L_PSINDX		16
#define	ESDFV$L_VECTOR		20
#define	ESDFV$B_NAMLNG		24
#define	ESDFV$S_NAME		31
#define	ESDFV$T_NAME		25
#define	ESDFM$K_NAME		25
#define	ESDFM$C_NAME		25
#define	ESDFM$S_ESDFMDEF	56
#define	ESDFM$W_GSDTYP		0
#define	ESDFM$T_START		0
#define	ESDFM$W_SIZE		2
#define	ESDFM$B_DATYP		4
#define	ESDFM$B_TEMP		5
#define	ESDFM$W_FLAGS		6
#define	ESDFM$S_VALUE		8
#define	ESDFM$Q_VALUE		8
#define	ESDFM$L_VALUE		8
#define	ESDFM$L_PSINDX		16
#define	ESDFM$L_VERSION_MASK	20
#define	ESDFM$B_NAMLNG		24
#define	ESDFM$S_NAME		31
#define	ESDFM$T_NAME		25
#define	ESRF$K_NAME		9
#define	ESRF$C_NAME		9
#define	ESRF$S_ESRFDEF		40
#define	ESRF$W_GSDTYP		0
#define	ESRF$T_START		0
#define	ESRF$W_SIZE		2
#define	ESRF$B_DATYP		4
#define	ESRF$B_TEMP		5
#define	ESRF$W_FLAGS		6
#define	ESRF$B_NAMLNG		8
#define	ESRF$S_NAME		31
#define	ESRF$T_NAME		9
#define	EIDC$C_LEQ		0
#define	EIDC$C_EQUAL		1
#define	EIDC$S_EIDCDEF		7
#define	EIDC$W_GSDTYP		0
#define	EIDC$W_SIZE		2
#define	EIDC$B_NAMLNG		4
#define	EIDC$T_NAME		5
#define	EIDC$W_FLAGS		5
#define	EIDC$V_BINIDENT		0
#define	EIDC$S_IDMATCH		2
#define	EIDC$V_IDMATCH		1
#define	EIDC$S_ERRSEV		3
#define	EIDC$V_ERRSEV		3

#define	EENV$M_DEF		0X1
#define	EENV$M_NESTED		0X2
#define	EENV$S_EENVDEF		40
#define	EENV$W_GSDTYP		0
#define	EENV$W_SIZE		2
#define	EENV$W_FLAGS		4
#define	EENV$V_DEF		0
#define	EENV$V_NESTED		1
#define	EENV$W_ENVINDX		6
#define	EENV$B_NAMLNG		8
#define	EENV$S_NAME		31
#define	EENV$T_NAME		9

#define	ELSY$M_WEAK		0X1
#define	ELSY$M_DEF		0X2
#define	ELSY$M_UNI		0X4
#define	ELSY$M_REL		0X8
#define	ELSY$S_ELSYDEF		14
#define	ELSY$W_GSDTYP		0
#define	ELSY$T_START		0
#define	ELSY$W_SIZE		2
#define	ELSY$B_DATYP		4
#define	ELSY$B_TEMP1		5
#define	ELSY$W_FLAGS		6
#define	ELSY$V_WEAK		0
#define	ELSY$V_DEF		1
#define	ELSY$V_UNI		2
#define	ELSY$V_REL		3
#define	ELSY$L_PSINDX		8
#define	ELSY$W_ENVINDX		12

#define	ELSRF$K_NAME		17
#define	ELSRF$C_NAME		17
#define	ELSRF$S_ELSRFDEF	48
#define	ELSRF$W_GSDTYP		0
#define	ELSRF$T_START		0
#define	ELSRF$W_SIZE		2
#define	ELSRF$B_DATYP		4
#define	ELSRF$B_TEMP1		5
#define	ELSRF$W_FLAGS		6
#define	ELSRF$L_PSINDX		8
#define	ELSRF$W_ENVINDX		12
#define	ELSRF$W_TEMP2		14
#define	ELSRF$B_NAMLNG		16
#define	ELSRF$S_NAME		31
#define	ELSRF$T_NAME		17

#define	ELSDF$K_NAME		25
#define	ELSDF$C_NAME		25
#define	ELSDF$S_ELSDFDEF	56
#define	ELSDF$W_GSDTYP		0
#define	ELSDF$T_START		0
#define	ELSDF$W_SIZE		2
#define	ELSDF$B_DATYP		4
#define	ELSDF$B_TEMP1		5
#define	ELSDF$W_FLAGS		6
#define	ELSDF$S_VALUE		8
#define	ELSDF$Q_VALUE		8
#define	ELSDF$L_VALUE		8
#define	ELSDF$L_PSINDX		16
#define	ELSDF$W_ENVINDX		20
#define	ELSDF$W_TEMP2		22
#define	ELSDF$B_NAMLNG		24
#define	ELSDF$S_NAME		31
#define	ELSDF$T_NAME		25

/* ETIR command types: */
/* ETIR stack commands: */
#define	ETIR$C_MINSTACOD	0
#define	ETIR$C_STA_GBL		0
#define	ETIR$C_STA_LW		1
#define	ETIR$C_STA_QW		2
#define	ETIR$C_STA_PQ		3
#define	ETIR$C_STA_LI		4
#define	ETIR$C_STA_MOD		5
#define	ETIR$C_STA_CKARG	6
#define	ETIR$C_MAXSTACOD	6

#define	ETIR$C_MINSTOCOD	50
#define	ETIR$C_STO_B		50
#define	ETIR$C_STO_W		51
#define	ETIR$C_STO_LW		52
#define	ETIR$C_STO_QW		53
#define	ETIR$C_STO_IMMR		54
#define	ETIR$C_STO_GBL		55
#define	ETIR$C_STO_CA		56
#define	ETIR$C_STO_RB		57
#define	ETIR$C_STO_AB		58
#define	ETIR$C_STO_OFF		59
#define	ETIR$C_STO_IMM		61
#define	ETIR$C_STO_GBL_LW	62
#define	ETIR$C_STO_HINT_GBL	64
#define	ETIR$C_STO_HINT_PS	65
#define	ETIR$C_MAXSTOCOD	65

#define	ETIR$C_MINOPRCOD	100
#define	ETIR$C_OPR_NOP		100
#define	ETIR$C_OPR_ADD		101
#define	ETIR$C_OPR_SUB		102
#define	ETIR$C_OPR_MUL		103
#define	ETIR$C_OPR_DIV		104
#define	ETIR$C_OPR_AND		105
#define	ETIR$C_OPR_IOR		106
#define	ETIR$C_OPR_EOR		107
#define	ETIR$C_OPR_NEG		108
#define	ETIR$C_OPR_COM		109
#define	ETIR$C_OPR_INSV		110
#define	ETIR$C_OPR_ASH		111
#define	ETIR$C_OPR_USH		112
#define	ETIR$C_OPR_ROT		113
#define	ETIR$C_OPR_SEL		114
#define	ETIR$C_OPR_REDEF	115
#define	ETIR$C_OPR_DFLIT	116
#define	ETIR$C_MAXOPRCOD	116

#define	ETIR$C_MINCTLCOD	150
#define	ETIR$C_CTL_SETRB	150
#define	ETIR$C_CTL_AUGRB	151
#define	ETIR$C_CTL_DFLOC	152
#define	ETIR$C_CTL_STLOC	153
#define	ETIR$C_CTL_STKDL	154
#define	ETIR$C_MAXCTLCOD	154

#define	ETIR$C_MINSTCCOD	200
#define	ETIR$C_STC_LP		200
#define	ETIR$C_STC_LP_PSB	201
#define	ETIR$C_STC_GBL		202
#define	ETIR$C_STC_GCA		203
#define	ETIR$C_STC_PS		204
#define	ETIR$C_STC_NOP_GBL	205
#define	ETIR$C_STC_NOP_PS	206
#define	ETIR$C_STC_BSR_GBL	207
#define	ETIR$C_STC_BSR_PS	208
#define	ETIR$C_STC_LDA_GBL	209
#define	ETIR$C_STC_LDA_PS	210
#define	ETIR$C_STC_BOH_GBL	211
#define	ETIR$C_STC_BOH_PS	212
#define	ETIR$C_STC_NBH_GBL	213
#define	ETIR$C_STC_NBH_PS	214
#define	ETIR$C_MAXSTCCOD	214

#define	ETIR$S_ETIRDEF		4
#define	ETIR$W_RECTYP		0
#define	ETIR$W_SIZE		2
