#ifndef _CDLGUSPACERULES_HH
#define _CDLGUSPACERULES_HH

#include <glibmm/refptr.h>
#include <glibmm/ustring.h>
#include <config.h>
#include "fireflierIO.h"
#include "dispatcher.h"
#include "CSync.h"

#ifdef WITHGCONF
#include "CGConf.h"
#endif


using Glib::ustring;


class CDlgUSpaceRules: public Gtk::Window, public CSync
{
private:
	class CUSpaceRulesColumnRecord: public Gtk::TreeModel::ColumnRecord
	{
	public:
		Gtk::TreeModelColumn <ustring> m_colUSpaceRule;
		
		CUSpaceRulesColumnRecord()
		{
			add(m_colUSpaceRule);
		}
	};
	
	static const CUSpaceRulesColumnRecord m_colRecord;
	Glib::RefPtr <Gtk::ListStore> m_pListUSpaceRules;
	Glib::RefPtr <Gtk::TreeSelection> m_pListSel;
	Dispatcher1 <int> m_signalAuthentication;
	Dispatcher2 <CffIO::pCffIOError, bool> m_signalNetworkThreadError;
	Dispatcher2 <const char*, int> m_signalUSpaceRulesAvail;

#ifdef WITHGCONF
	CGConfUI m_gconfUI;
#endif

protected:
	Gtk::Button m_butDel;
	Gtk::TreeView m_tvUSpaceRules;


public:
	CDlgUSpaceRules();
	virtual ~CDlgUSpaceRules();
	

protected:
#ifdef WITHGCONF
	void on_value_changed(const ustring& strKey, const Gnome::Conf::Value& value);
	void on_butCancel_clicked();
	bool on_delete(GdkEventAny*);
	void save_pos_and_size();
#endif
	void initGUI();
	void on_butDel_clicked();
	void on_selection_changed();
	void on_USpaceRules_avail(const char* szMsg, int nLen);
	static void deleteRule(const Gtk::TreePath& path, int* nCount);
	// callback for Gtk::TreeSelection::selected_foreach
	// callback just to find out whether any node is selected
	static void isAnySelected(const Gtk::TreePath& path, bool* bWasHere);

	// callbacks for the network thread
	void on_Authentication(int nAuthenticated);
	void on_networkthread_error(CffIO::pCffIOError pErr, bool bDisconnected);
};

#endif
