# XSLT FilterProxy Module

# Copyright (C) 2002 Mario Lang <mlang@delysid.org>
# See the file COPYING for redistribution and modification terms.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package FilterProxy::XSLT;


use strict;
no strict 'subs';
use vars qw($VERSION $CONFIG);  # The $CONFIG variable MUST be exported.

use XML::LibXSLT;
use XML::LibXML;

push @FilterProxy::MODULES,"XSLT";
$VERSION = 0.01;
$CONFIG = {};
$CONFIG->{order} = 6;
$CONFIG->{mime_types} = ["text/html", "text/xml"];

*logger = \&FilterProxy::logger;# Tells perl to use FilterProxy's logger function
                                # instead of looking for 
                                # FilterProxy::Skeleton::logger (this is because
                                # I'm lazy and don't want to type 
                                # FilterProxy::logger every time)
                                # Using this function will cause data to go to 
                                # FilterProxy's log file.

my($htmldebugmsg)="";

sub log_xslt_to_html {
  $htmldebugmsg = $htmldebugmsg . shift;
}
sub log_xslt_to_log {
  logger(DEBUG, shift);
}

sub filter {                    # The main filtering routine.  Does the dirty work.
  my($req,$res,$siteconfig,$order) = @_;
  my($stylesheet)=${$siteconfig}[0]{stylesheet};
  my($site)=${$siteconfig}[0];
  if(defined $res && !defined($site->{ignore})) {
    my(%paramhash);
    foreach (@{$site->{'params'}}) {
      my($key,$value)=$_=~/([^=]+)=(.*?)$/;
      $paramhash{$key}=$value;
    }
    my $parser = XML::LibXML->new();
    my $xslt = XML::LibXSLT->new();
#    $xslt->debug_callback(\&log_xslt_to_html);
    my $sheetfile = $FilterProxy::HOME . "/xsl/" . $stylesheet;
    if (!-r $sheetfile) {
      ${$res->content_ref} = 
	"<h1><center>FilterProxy::XSLT: Stylesheet not found</center></h1>"
	  . ${$res->content_ref};
      return;
    }
    my $source = $parser->parse_html_string(${$res->content_ref});
    my $style_doc = $parser->parse_file($sheetfile);
    my $style = $xslt->parse_stylesheet($style_doc);
    my $result = $style->transform($source, %paramhash);
    ${$res->content_ref}=$style->output_string($result);
    if ($htmldebugmsg ne "") {
      ${$res->content_ref}=${$res->content_ref}.
	"<!-- XSLT debug messages\n".$htmldebugmsg."-->";
    }
  }
  logger(DEBUG, "FilterProxy::XSLT::filter finished.");
  return;
}

sub Config {
  my($req, $cgi, $siteconfig) = @_;
  my($message) = "";

  if($cgi->param()) {
    my($name) = $cgi->param('name');
    my($value) = ((defined $cgi->param('value'))?$cgi->param('value'):"") ;

    if ($cgi->param('stylesheet')) {
      $siteconfig->{'stylesheet'} = $cgi->param('stylesheet');
      if ($siteconfig->{ignore} ne $cgi->param("ignore")) {
        $siteconfig->{'ignore'} = $cgi->param('ignore');
      } else {
        $siteconfig->{'params'} = [];
#      $siteconfig->{'filters'} = [];
      }
    } elsif (defined $cgi->param('delete') || defined $cgi->param('delete.x')) {
      my(@newparams) = ();
      foreach my $param (@{$siteconfig->{params}}) {
	unless($param =~ /^$name=/) { push(@newparams, $param); }
      }
      delete $siteconfig->{params};
      $siteconfig->{params} = \@newparams;
      $message = "Parameter $name succussfully deleted.\n";
    } elsif(defined $cgi->param('change') || defined $cgi->param('change.x')) {
      my(@newparams) = ();
      foreach my $param (@{$siteconfig->{params}}) {
	unless($param =~ /^$name=/) { push(@newparams, $param); }
      }
      push @newparams, $cgi->param('name') . "=" . $value;
      delete $siteconfig->{params};
      $siteconfig->{params} = \@newparams;
      $message = "Parameter $name succussfully changed.\n";
    } elsif(defined $cgi->param('add') || defined $cgi->param('add.x')) {
      push @{$siteconfig->{params}}, $name . "=" . $value;
      $message = "Parameter $name succussfully added.\n";
    }
  }


  return $message;        # a HTML-formatted message that will be 
                          # available to your .html file as $ENV{MESSAGE}
}

# Local Variables:
# mode: cperl
# End:
