/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  File-Roller
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef MENU_H
#define MENU_H


#include <config.h>

#include "dlg-add.h"
#include "dlg-delete.h"
#include "dlg-extract.h"
#include "dlg-open-with.h"
#include "dlg-preferences.h"
#include "dlg-prop.h"
#include "menu-callbacks.h"


/* Definition of the File menu */

enum {
	FILE_MENU_NEW_ARCHIVE = 0,
	FILE_MENU_OPEN_ARCHIVE,
	FILE_MENU_CLOSE_ARCHIVE,
	FILE_MENU_SEP3,
	FILE_MENU_ARCHIVE_PROP,
	FILE_MENU_SEP4,
	FILE_MENU_MOVE_ARCHIVE,
	FILE_MENU_COPY_ARCHIVE,
	FILE_MENU_RANAME_ARCHIVE,
	FILE_MENU_DELETE_ARCHIVE,
	FILE_MENU_SEP1,
	FILE_MENU_EXIT,
	FILE_MENU_LENGTH
};

GnomeUIInfo file_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("New _Archive"), N_("Create a new archive"), 
	  new_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  'n', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Open Archive..."), N_("Open an existing archive"), 
	  open_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  'o', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Close Archive"), N_("Close current archive"), 
	  close_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM,
	  N_("Archive _Properties..."), N_("Show archive properties"),
	  dlg_prop, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Move Archive"), " ", 
	  move_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Copy Arc_hive"), " ", 
	  copy_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Rename Archive"), " ", 
	  rename_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Archive"), " ", 
	  delete_archive_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("E_xit"), N_("Exit"), 
	  quit_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 
	  'q', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};

enum {
	ACTIONS_MENU_ADD = 0,
	ACTIONS_MENU_DELETE,
	ACTIONS_MENU_EXTRACT,
	ACTIONS_MENU_SEP1,
	ACTIONS_MENU_OPEN,
	ACTIONS_MENU_VIEW,
	ACTIONS_MENU_SEP2,
	ACTIONS_MENU_STOP,
	ACTIONS_MENU_SEP3,
	ACTIONS_MENU_SELECT_ALL,
	ACTIONS_MENU_LENGTH
};

GnomeUIInfo actions_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("Add _files..."), N_("Add files to the archive"), 
	  add_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete files..."), N_("Delete files from the archive"), 
	  dlg_delete, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Extract to..."), N_("Extract files from the archive"), 
	  dlg_extract, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Open files with..."), N_("Open selected files with an application"), 
	  open_with_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_View file"), N_("View file with internal viewer"), 
	  view_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Stop operation"), N_("Stop current operation"), 
	  stop_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
	  GDK_Escape, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("Select _All"), N_("Select all files"), 
	  select_all_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'a', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo sort_by_radio_list[] = {
        { GNOME_APP_UI_ITEM, 
          N_("by _Name"), N_("Sort file list by name"), 
          sort_list_by_name, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },

        { GNOME_APP_UI_ITEM, 
          N_("by _Type"), N_("Sort file list by type"), 
	  sort_list_by_type, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
        
        { GNOME_APP_UI_ITEM, 
          N_("by _Size"), N_("Sort file list by file size"), 
	  sort_list_by_size, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
        
        { GNOME_APP_UI_ITEM, 
          N_("by _Time"), N_("Sort file list by modification time"), 
	  sort_list_by_time, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },

        { GNOME_APP_UI_ITEM, 
          N_("by _Path"), N_("Sort file list by path"), 
	  sort_list_by_path, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },

        GNOMEUIINFO_END
};


GnomeUIInfo sort_menu[] = {
        GNOMEUIINFO_RADIOLIST (sort_by_radio_list),

        GNOMEUIINFO_SEPARATOR,

        { GNOME_APP_UI_TOGGLEITEM, 
          N_("_Reversed Order"), N_("Reverse the list order"), 
	  sort_list_reversed, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
        
        GNOMEUIINFO_END
};


enum {
	VIEW_LIST_VIEW_ALL = 0,
	VIEW_LIST_AS_DIR
};


GnomeUIInfo view_list[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("View all _files"), " ", 
	  set_list_mode_flat_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("View as a _directory"), " ", 
	  set_list_mode_as_dir_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo options_menu[] = {
	GNOMEUIINFO_RADIOLIST (view_list),

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_SUBTREE (N_("S_ort File List"), sort_menu),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Preferences..."), " ", 
	  dlg_preferences, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF, 
	  'p', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};


/* Definition of the Windows menu */

GnomeUIInfo windows_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("New _Window"), N_("Open a new window"), 
	  new_window_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'w', GDK_SHIFT_MASK | GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Clo_se Window"), N_("Close this window"), 
	  close_window_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'w', GDK_CONTROL_MASK, NULL },
	
	GNOMEUIINFO_END
};


/* Definition of the Help menu */

GnomeUIInfo help_menu[] = {
/*	GNOMEUIINFO_HELP("file-roller"),    FIXME

	GNOMEUIINFO_SEPARATOR,
*/
	{ GNOME_APP_UI_ITEM, 
	  N_("_About..."), N_("Information about the program"), 
	  about_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 
	  0, 0, NULL },
	
	GNOMEUIINFO_END
};


/* Definition of the main menu */

GnomeUIInfo main_menu[] = {
	GNOMEUIINFO_MENU_FILE_TREE (file_menu),
	GNOMEUIINFO_SUBTREE (N_("_Actions"), actions_menu),
	GNOMEUIINFO_SUBTREE (N_("_Options"), options_menu),
	GNOMEUIINFO_SUBTREE (N_("_Windows"), windows_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};



/* popup menus. */

GnomeUIInfo file_popup_menu_data[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("Add _files..."), N_("Add files to the archive"), 
	  add_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete files..."), N_("Delete files from the archive"), 
	  dlg_delete, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Extract to..."), N_("Extract files from the archive"), 
	  dlg_extract, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Open files with..."), " ", 
	  open_with_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXEC,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_View file"), N_("View file with internal viewer"), 
	  view_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("Select All"), " ", 
	  select_all_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_END
};


#endif /* MENU_H */
