/* stk_handle_notify.c  */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_handle_notify.c,v $
 * Revision 1.2  2000/12/06 20:56:05  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.5  2000/03/08 00:45:25  moz
 * Compile fixes.
 *
 * Revision 1.4  1999/07/04 19:20:46  moz
 * Fix for naughty wm's that don't report x,y properly.
 *
 * Revision 1.3  1999/06/30 13:11:33  moz
 * Update tooltip when we update an icon.
 *
 * Revision 1.2  1999/05/19 17:07:33  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:06:33  moz
 * Initial revision
 *
 */    

#include "include/stk_internal.h"
#include "include/stk_extern.h" 
#include "include/stk.h"

/* handle resizing of windows  */  
void 
stk_handle_configure_notify(Window eventwin, int x, int y, int w, int h)
{
	List entry;
	List temp; 

	entry = where_in_list(stk_window_list, (ulong)eventwin);

	switch (entry->type)
		{
		case MENU_BAR_TYPE:
			MENUBAR(entry)->window->x = x;
			MENUBAR(entry)->window->y = y;
			MENUBAR(entry)->window->w = w;
			MENUBAR(entry)->window->h = h;
				 
			break;

		case TOOL_WINDOW_TYPE:
		 	temp = where_in_list(stk_window_list, (ulong) bar_window_id);

			XMoveResizeWindow(stk_display, MENUBAR(temp)->window->win, MENUBAR(temp)->window->x,
					MENUBAR(temp)->window->y, 
					(uint)w, 
					MENUBAR(temp)->window->h);
			
			temp = where_in_list(stk_window_list, (ulong) tool_window_id);

			/* if not resized, we can trust the returned x and y (!)  */  
			if (TOOLWINDOW(temp)->w == (uint)w && TOOLWINDOW(temp)->h == (uint)h) 
				{ 
				TOOLWINDOW(temp)->x = x;
				TOOLWINDOW(temp)->y = y;
				}; 
			TOOLWINDOW(temp)->w = w;
			TOOLWINDOW(temp)->h = h;

			/* aargh, we need to resize all the icons in the icon panel */
			
			stk_resize_icon_panel((uint)w);
			
			break;
			 
		case DIALOG_TYPE:
			if (((uint)w)!=DIALOG(entry)->window.w || ((uint)h)!=DIALOG(entry)->window.h)
    			stk_resize_dialog(DIALOG(entry),x,y,w,h);   
			else
				{
				DIALOG(entry)->window.x = x;
				DIALOG(entry)->window.y = y;
				};
			break; 
		};
}

/* highlight objects when entering the window  */  
void 
stk_handle_enter_notify(Window win)
{
	List entry;
	stkInternalIcon *ic; 
	Boolean need_redraw = FALSE; 

	entry = where_in_list(stk_window_list,(ulong)win);

	switch (entry->type)
		{
		case MENU_ICON_TYPE: 
		case ICON_TYPE:
			ic = (stkInternalIcon *)entry->data;

			if (!ic->selected)
				{
				ic->selected = TRUE;
				need_redraw=TRUE;
				};
			
			if (!ic->pressed && entry->type==MENU_ICON_TYPE)
				{
				ic->pressed = TRUE;
				need_redraw = TRUE;
				};

			if (need_redraw)
				stk_redraw_icon(ic);
			break;
		};

}

/* unhighlight the objects when leaving window  */ 
void 
stk_handle_leave_notify(Window win)
{
	List entry;
	stkInternalMenuBar *bar; 
	stkInternalMenuBarElement *elp; 
	stkInternalIcon *ic; 
	List elements; 
	Boolean need_redraw = FALSE; 

	entry = where_in_list(stk_window_list,(ulong)win);

	switch (entry->type)
		{
		case MENU_BAR_TYPE:
			
			if (!mousebutton_pressed[0]) 
				{ 
				elements = ((stkInternalMenuBar *) entry->data)->elements;
				bar = (stkInternalMenuBar *)entry->data; 

				if (bar->current_menu_el != NULL)
					{
					bar->current_menu_el = NULL;
					};

				do
					{
					elp = (stkInternalMenuBarElement *)elements->data;

					if (elp->selected == TRUE)
						{
						stk_redraw_menu_bar();
						elp->selected = FALSE;
						need_redraw = TRUE; 
						}; 

					elements=elements->next;
					} while (elements != NULL);  
				};

			if (need_redraw)
				stk_redraw_menu_bar();
			break;

		case MENU_ICON_TYPE: 
		case ICON_TYPE:
			ic = (stkInternalIcon *)entry->data;

			if (ic->selected)
				{
				ic->selected = FALSE;
				need_redraw=TRUE;
				};
			
			if (ic->pressed && entry->type==MENU_ICON_TYPE)
				{
				ic->pressed = FALSE;
				need_redraw = TRUE;
				};

			if (need_redraw)
				{ 
				stk_tooltip(ic->window.win,TRUE);
				stk_redraw_icon(ic);
				}; 
			break;
		};

}
