/* Figurine initialisation */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: init.c,v $
 * Revision 1.4  2001/01/31 15:38:06  movement
 * pre11 - fix netscape, add metapost support, credit foggy
 *
 * Revision 1.4  2001/01/29 20:57:28  moz
 * Make netscape work again, metapost support.
 *
 * Revision 1.3  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:02  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.28  2000/03/06 02:28:22  moz
 * Compile fixes.
 *
 * Revision 1.27  2000/03/05 21:50:58  moz
 * Complain about broken -screenppi or -undolevels.
 *
 * Revision 1.26  2000/02/29 20:17:42  moz
 * Merged opts.c
 *
 * Revision 1.25  2000/02/27 21:28:07  moz
 * Removed unused variables.
 *
 * Revision 1.24  2000/01/26 18:13:31  moz
 * Add undolevels==0.
 * free_list fixes.
 *
 * Revision 1.23  2000/01/25 01:35:49  moz
 * Removed border setting.
 *
 * Revision 1.22  2000/01/21 11:49:55  moz
 * Tidied code.
 * Removed desertgc, blackgc and maingc.
 *
 * Revision 1.21  2000/01/21 11:22:17  moz
 * Protect strncpy()s.
 * last_mouse_movement isn't used.
 *
 * Revision 1.20  1999/11/15 02:09:13  moz
 * Name change.
 *
 * Revision 1.19  1999/08/10 23:55:12  moz
 * Set save_under for the floating icon menu.
 *
 * Revision 1.18  1999/07/27 01:47:33  moz
 * Remove pointless bgcolor parsing.
 *
 * Revision 1.17  1999/07/04 15:03:06  moz
 * Compile if no HAVE_GETHOSTNAME.
 *
 * Revision 1.16  1999/06/16 00:56:24  moz
 * Only complain once about unallocatable standard colours.
 *
 * Revision 1.15  1999/05/22 23:39:00  moz
 *  Pedantic ANSI.
 *
 * Revision 1.14  1999/05/22 02:54:52  moz
 * Parse -nocompoundoutlines and -guidelines.
 *
 * Revision 1.13  1999/05/19 17:09:03  moz
 * 1.0 Checkin.
 *
 * Revision 1.12  1999/05/05 12:28:57  moz
 * Print dialog.
 *
 * Revision 1.11  1999/05/04 15:49:33  moz
 * open_display_and_parse_database() merged in.
 *
 * Revision 1.10  1999/05/03 06:21:41  moz
 * Changes to dialogs.
 *
 * Revision 1.9  1999/05/03 06:00:04  moz
 * Correct default buttons for dialogs.
 *
 * Revision 1.8  1999/05/01 16:25:05  moz
 * Change of xpm.h location method.
 *
 * Revision 1.7  1999/04/27 21:14:21  moz
 * Parse -notooltips and set menu label correctly.
 *
 * Revision 1.6  1999/04/27 06:45:46  moz
 * Pass TRUE to signify cmdline to load
 *
 * Revision 1.5  1999/04/23 20:20:42  moz
 * UI fix - cosmetic.
 *
 * Revision 1.4  1999/04/23 01:05:41  moz
 * Initialise fig files only choice.
 *
 * Revision 1.3  1999/04/22 21:39:01  moz
 * X11/xpm.h -> xpm.h
 *
 * Revision 1.2  1999/04/04 01:48:27  moz
 * Export dialog.
 *
 * Revision 1.1  1999/03/30 00:05:12  moz
 * Initial revision
 *
 */    

#include <stdio.h>
#include <string.h> 
#include <unistd.h> 
#include <stdlib.h> 

#ifndef __DATE__
#define __DATE__ "unknown"
#endif
#ifndef __TIME__
#define __TIME__ ""
#endif

#ifdef HAVE_X11_XPM_H
#  include <X11/xpm.h>
#else
#  ifdef HAVE_XPM_H
#    include <xpm.h>
#  else
#    include "xpm.h"
#  endif
#endif    
#include "include/figurine.h"
#include "include/extern.h" 
#include "include/stk.h" 
#include "pixmaps/nofill.xpm"
/* xbm's for fillstyle */ 
#include "pixmaps/fillstyles.h" 
	

static Colormap colourmap;
static Visual *visual; 

/* stores files specified on the command line  */  
List files_to_load=NULL;

/* get_colour */
/* usage: get_colour(int *colour, BLACK|WHITE, char *resource_string, char *resource_class_string)
	the second argument determines the preferred backup pixel colour
	*/
void 
get_colour(ulong *return_colour, int want_white, char *res_string, char *res_class_string, char *color_name)
{
	char string[20];
	static Boolean complained=FALSE; 
	XColor colour;
	XrmValue value;
	char *str_type_return[20];
	 
	if (XParseColor(display, colourmap, color_name, &colour)==0)
		(want_white) ? (*return_colour = WhitePixel(display,screen)) 
						 : (*return_colour = BlackPixel(display,screen));
	else
		{
		if (XAllocColor(display, colourmap, &colour)==0)
			{
			(want_white) ? (*return_colour = WhitePixel(display,screen)) 
							 : (*return_colour = BlackPixel(display,screen));
			if (!complained)
				{ 
				fprintf(stderr, "figurine: couldn't allocate all colours.\n");
				complained=TRUE;
				};
			}
		else
			*return_colour = colour.pixel;
		};
	 
	if (streq("",res_string))
		return;

	if (XrmGetResource(XresourceDatabase, res_string, res_class_string,
		 str_type_return, &value)==True)
		{
		strncpy(string, value.addr, (uint) min(100,value.size));
		
		if (XParseColor(display, colourmap, string, &colour)==0)
			fprintf(stderr, "figurine: specified colour %s invalid.\n", string);
		else
			{
			if ((visual->class == StaticGray) || (visual->class == GrayScale))
				(want_white) ? (*return_colour = WhitePixel(display,screen)) 
					     : (*return_colour = BlackPixel(display,screen));
			else
				{
				if (XAllocColor(display, colourmap, &colour)==0)
					{
					if (!complained)
						{ 
						fprintf(stderr, "figurine: couldn't allocate all colours.\n");
						complained=TRUE;
						};
					}
				else
					*return_colour = colour.pixel;
				};
			};
		}

}

void 
figurine_init(int argc, char *argv[])
{
	XTextProperty windowName, iconName; 
	XSetWindowAttributes xswa; 
	XpmAttributes xpm_attr; 
	XpmColorSymbol xpm_col; 
	XGCValues gcvalues; 
	Pixmap dummy; 
	List l; 
	char *window_name = "Figurine"; 
	ulong topleftcolor;
	ulong backgroundcolor;
	ulong bottomrightcolor;   
	ulong handlecolor; 
	ulong tooltipcolor; 
	XrmValue value;
	char *str_type_return[20];
	char *fonts[] ={"8x13",
			"fixed", 
			"-adobe-new century schoolbook-medium-r-normal-*-*-120-*-*-p-*-iso8859-1", 
			"-adobe-times-medium-r-normal-*-*-120-*-*-p-*-iso8859-1", 
			"-adobe-utopia-regular-r-normal-*-*-120-*-*-p-*-iso8859-1",
			"-b&h-lucida-medium-r-normal-*-*-120-*-*-p-*-iso8859-1", 
			"-adobe-helvetica-medium-r-normal-*-*-*-*-*-p-*-iso8859-1", 
			"-adobe-helvetica-medium-r-normal-*-*-120-*-*-p-*-iso8859-1", 
			};
			/* favourite font goes rightmost in list */
			 
	int fontcount = (int)(sizeof(fonts)/sizeof(char *)); 
	char string[100];
	long geometry_flags;
	int i = 0; 
	uint gcm= GCForeground | GCBackground; 

	/* var init  */  

	last_mouse_x = 0;
	last_mouse_y = 0;
	 
	/* allocate our colours for STK */

	get_colour(&topleftcolor, WHITE, "figurine.tlcolor", "Figurine.Tlcolor", "grey90");
	get_colour(&backgroundcolor, WHITE, "figurine.background", "Figurine.Background", "grey"); 
	get_colour(&bottomrightcolor, BLACK, "figurine.brcolor", "Figurine.Brcolor", "grey30");
	get_colour(&handlecolor, BLACK, "figurine.handlecolor", "Figurine.Handlecolor", "red"); 
	get_colour(&tooltipcolor, WHITE, "figurine.tooltipcolor", "Figurine.Tooltipcolor", "yellow");
	
	/* standard Xfig colours  */

	/* i==7 means White, so set WHITE. BLACK for all others  */  
	for (i=0;i<numcols;i++)
		get_colour(&cols[i].colour,(i==7),"","",cols[i].name);
	
	for (i=0;i<fillnumcols;i++)
		fillcols[i].colour = cols[i].colour;

	/* set up some utility GCs  */

	gcvalues.line_style = LineOnOffDash;
	gcvalues.foreground = BlackPixel(display,screen);
	dashgc = XCreateGC(display,RootWindow(display,screen), GCForeground | GCLineStyle, &gcvalues); 
	 
	gcvalues.foreground = BlackPixel(display,screen);
	gcvalues.background = backgroundcolor;
	rulergc = XCreateGC(display,RootWindow(display,screen),  gcm, &gcvalues);

	gcvalues.foreground = BlackPixel(display,screen);
	gcvalues.background = BlackPixel(display,screen);
	fillgc = XCreateGC(display,RootWindow(display,screen),  gcm, &gcvalues);
	XSetFillStyle(display,fillgc,FillOpaqueStippled);  
	 
	gcvalues.foreground = cols[28].colour;
	gcvalues.background = backgroundcolor;
	ugc = XCreateGC(display,RootWindow(display,screen),  gcm, &gcvalues);
	XSetLineAttributes(display,ugc,0,LineSolid, CapRound, JoinRound);
	  
	gcvalues.foreground = backgroundcolor;
	gcvalues.background = backgroundcolor;
	backgc = XCreateGC(display,RootWindow(display,screen),  gcm, &gcvalues);
	
	gcvalues.foreground = WhitePixel(display,screen);
	gcvalues.background = WhitePixel(display,screen);
	whitegc = XCreateGC(display,RootWindow(display,screen),  gcm, &gcvalues);
	
	gcvalues.foreground = BlackPixel(display,screen) ^ WhitePixel(display,screen); 
	gcvalues.background = WhitePixel(display,screen);
	gcvalues.function = GXxor; 
	blackxorgc = XCreateGC(display,RootWindow(display,screen), gcm | GCFunction, &gcvalues);
	
	gcvalues.foreground = handlecolor;
	gcvalues.background = WhitePixel(display,screen);
	handlegc = XCreateGC(display,RootWindow(display,screen), gcm, &gcvalues); 
	
	/* perform our fonts stuff */ 
	 
	if (XrmGetResource(XresourceDatabase, "figurine.font", "Figurine.Font",
		 str_type_return, &value)==True)
		{
		strncpy(string, value.addr, (uint) min(100,value.size));

		if ((font=XLoadQueryFont(display,string))==NULL)
			{ 
			fprintf(stderr, "figurine: could not load font %s.\n", string);
			/* load a font in preference order */

			while (((font=XLoadQueryFont(display,fonts[fontcount-1]))==NULL) && fontcount>0)
				fontcount--; 
			
			if (fontcount==0) /* wow, can't load a font  */ 
				{
				fprintf(stderr, "figurine: can't load any fonts !\n");
				close_down();
				};
			};
		}
	else
		{
		/* load a font in preference order */

		while (((font=XLoadQueryFont(display,fonts[fontcount-1]))==NULL) && fontcount>0)
			fontcount--; 
			
		if (fontcount==0) /* wow, can't load a font  */ 
			{
			fprintf(stderr, "figurine: can't load any fonts !\n");
			close_down();
		 	};

		};
		
	/* if screenppi specified on cmdline, take it, otherwise
		attempt to get a reasonable value from the X server */ 
	if (XrmGetResource(XresourceDatabase, "figurine.screenppi", "Figurine.Screenppi",
		 str_type_return, &value)==True)
	 	{
		strncpy(string, value.addr, (uint) min(100,value.size));
		if (!sscanf(string,"%lf",&screen_ppi)) 
			figurine_usage(argv);
		 
		screen_ppi = max(40.0,screen_ppi);
		}
	else
		screen_ppi = ((double)DisplayWidth(display,screen))/((double)DisplayWidthMM(display,screen))*25.4;
		 
	/* undo levels defaults to 10 but can be changed on cmdline  */ 
	if (XrmGetResource(XresourceDatabase, "figurine.undolevels", "Figurine.Undolevels",
		 str_type_return, &value)==True)
	 	{
		strncpy(string, value.addr, (uint) min(100,value.size));
		if (!sscanf(string,"%d",&undolevels))
			figurine_usage(argv);

		/* 0 means no undo at all */  
		undolevels = max(0,undolevels); 
		};
		 
	/* turn off tooltips if asked  */ 
	if (XrmGetResource(XresourceDatabase, "figurine.notooltips", "Figurine.Notooltips",
		 str_type_return, &value)==True)
		tooltips = FALSE;
	else
		tooltips = TRUE;

	/* show compound outlines */  
	if (XrmGetResource(XresourceDatabase, "figurine.compoundoutlines", "Figurine.Compoundoutlines",
		 str_type_return, &value)==True)
		compound_outlines = TRUE;
	
	/* show highlights */
	if (XrmGetResource(XresourceDatabase, "figurine.nohighlightobjects", "Figurine.Nohighlightobjects",
		str_type_return, &value)==True)
		highlight_objects = FALSE;

	/* guidelines */ 
	if (XrmGetResource(XresourceDatabase, "figurine.guidelines", "Figurine.Guidelines",
		 str_type_return, &value)==True)
		guide_lines = TRUE;
	
	/* determine requested ruler font  */  
	if (XrmGetResource(XresourceDatabase, "figurine.rulerfont", "Figurine.Rulerfont",
		 str_type_return, &value)==True)
		{
		strncpy(string, value.addr, (uint) min(100,value.size));

		if ((rulerfont=XLoadQueryFont(display,string))==NULL)
			{ 
			fprintf(stderr, "figurine: could not load font %s.\n", string);

			rulerfont=XLoadQueryFont(display,"6x10");
			
			if (rulerfont==NULL) /* wow, can't load a ruler font  */ 
				{
				fprintf(stderr, "figurine: can't load ruler font !\n");
				close_down();
				};
			};
		}
	else
		{
		rulerfont=XLoadQueryFont(display,"6x10");
			
		if (rulerfont==NULL) /* wow, can't load a ruler font  */ 
			{
			fprintf(stderr, "figurine: can't load ruler font !\n");
			close_down();
			};

		};
		 
	/* fillstyles bitmap creation */ 
	
	for (i=0; i < NUM_SHADES; i++)
		{ 
		fills[i] = XCreatePixmapFromBitmapData(display,RootWindow(display,screen),
				(char *)shade_images[i], 32, 32, 
				BlackPixel(display,screen),
				WhitePixel(display,screen),
				(uint)DefaultDepth(display,screen));

		bfills[i] = XCreateBitmapFromData(display,RootWindow(display,screen), (char *)shade_images[i],32,32);
		};
	for ( ; i < (NUM_SHADES + NUM_PATTERNS); i++)
		{ 
		fills[i] = XCreatePixmapFromBitmapData(display,RootWindow(display,screen),
				(char *)pattern_images[i-NUM_SHADES].data,
				(uint)pattern_images[i-NUM_SHADES].width,
				(uint)pattern_images[i-NUM_SHADES].height,
				BlackPixel(display,screen),
				WhitePixel(display,screen),
				(uint)DefaultDepth(display,screen));
		bfills[i] = XCreateBitmapFromData(display,RootWindow(display,screen), 
				pattern_images[i-NUM_SHADES].data,
				(uint)pattern_images[i-NUM_SHADES].width, 
				(uint)pattern_images[i-NUM_SHADES].height);
		};
						
	fillstyleicons = (stkIcon *)malloc(sizeof(stkIcon)*(NUM_SHADES+NUM_PATTERNS+2));
	if (fillstyleicons==NULL)
		close_down();
 
 	free_list(fillstyleicons);

	/* fill out STK structure for icons  */   
	for (i=0; i < (NUM_SHADES + NUM_PATTERNS); i++)
		{ 
		fillstyleicons[i].xpm_data = NULL;
		fillstyleicons[i].pixmap = fills[i]; 
		fillstyleicons[i].tag = STARTOFFILLSTYLES+i;
		fillstyleicons[i].x = 0;
		fillstyleicons[i].y = 0;
		fillstyleicons[i].w = 20;
		fillstyleicons[i].h = 20;
		fillstyleicons[i].pressable = TRUE;
		fillstyleicons[i].binary = FALSE;
		fillstyleicons[i].tooltip = filltags[i];
		}; 
	
	/* create no fill pixmap  */  
	xpm_col.name = NULL;
	xpm_col.value = "none";
	xpm_col.pixel = backgroundcolor;
	xpm_attr.valuemask = XpmColorSymbols;
	xpm_attr.numsymbols = 1;
	xpm_attr.colorsymbols = &xpm_col;   
	XpmCreatePixmapFromData(display, RootWindow(display,screen), nofill_xpm, &nofill, &dummy, &xpm_attr);
	fillstyleicons[i].xpm_data = NULL;
	fillstyleicons[i].pixmap = nofill;
	fillstyleicons[i].tag = STARTOFFILLSTYLES+i;
	fillstyleicons[i].x = 0;
	fillstyleicons[i].y = 0;
	fillstyleicons[i].w = 20;
	fillstyleicons[i].h = 20;
	fillstyleicons[i].pressable = TRUE;
	fillstyleicons[i].binary = FALSE;
	fillstyleicons[i].tooltip = "No fill";
	fillstyle_icon.pixmap = nofill;

	/* set up and create tool window */

	toolWindow.x = 0;
	toolWindow.y = 0;
	toolWindow.w = 96; 
	toolWindow.h = 128;

	toolWindow.size_hints = XAllocSizeHints();
	toolWindow.class_hints = XAllocClassHint();
	toolWindow.wm_hints = XAllocWMHints();

	if (!toolWindow.size_hints || !toolWindow.class_hints || !toolWindow.wm_hints)
		exit(1);
		
	if (!XStringListToTextProperty(&window_name, 1, &windowName))
		exit(1);

	if (!XStringListToTextProperty(&window_name, 1, &iconName))
		exit(1);

	toolWindow.size_hints->flags = PPosition | PSize | PMinSize;
	toolWindow.size_hints->min_width = 96;
	toolWindow.size_hints->min_height = 128;
	toolWindow.wm_hints->initial_state = NormalState;
	toolWindow.wm_hints->input = True;
	toolWindow.wm_hints->flags = StateHint | InputHint;
	toolWindow.class_hints->res_name = "figurine";
	toolWindow.class_hints->res_class = "Figurine";
	toolWindow.win = XCreateSimpleWindow(display, RootWindow(display,screen),
						toolWindow.x,toolWindow.y,toolWindow.w,toolWindow.h,
						0, BlackPixel(display,screen), backgroundcolor);
	XSetWMProperties(display, toolWindow.win, &windowName, &iconName,
						argv, argc, toolWindow.size_hints, toolWindow.wm_hints,
						toolWindow.class_hints);
		 
	/* participate in WM protocols  */ 
	winproto = XInternAtom(display, "WM_PROTOCOLS", False); 
	windelete = XInternAtom(display, "WM_DELETE_WINDOW", False);  
	XSetWMProtocols(display,toolWindow.win, &windelete,2); 
	/* what events we take */  
	XSelectInput(display, toolWindow.win, KeyPressMask | ButtonPressMask 
					 | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask
					 | PointerMotionMask | ButtonMotionMask
					 | StructureNotifyMask
					 | ExposureMask | StructureNotifyMask | FocusChangeMask);

	/*  if the user has specified geometry, set it and resize window */  
	if (XrmGetResource(XresourceDatabase, "figurine.geometry", "Figurine.Geometry",
		 str_type_return, &value)==True)
		{
		strncpy(string, value.addr, (uint) min(100,value.size));
		geometry_flags = XParseGeometry(string, &toolWindow.x, &toolWindow.y, 
					  &toolWindow.w, &toolWindow.h);
		
		if ((XValue & geometry_flags) && (XNegative & geometry_flags))
			toolWindow.x = DisplayWidth(display,screen) + toolWindow.x - toolWindow.w;

		if ((YValue & geometry_flags) && (YNegative & geometry_flags))
			toolWindow.y = DisplayHeight(display,screen) + toolWindow.y - toolWindow.h;

		/* we insist on the minimum size */

		toolWindow.w = max(toolWindow.w,96);
		toolWindow.h = max(toolWindow.h,128);
		 
		XMoveResizeWindow(display, toolWindow.win, toolWindow.x, toolWindow.y, toolWindow.w, toolWindow.h); 
		}; 
	
	/* initialise the toolkit and create the menu bar */
	stk_init(&toolWindow, font, topleftcolor, backgroundcolor, bottomrightcolor, tooltipcolor, display);
	
	/* returns -1 if init failed or height of menu bar in pixels otherwise  */
	/* we want our icons directly below menu bar, so ...  */ 
	if ((icon_panel.y = stk_create_menu_bar(toolWindow, &main_menu))==(uint)FAIL)
		close_down();

	toolWindow.h = max(toolWindow.h,128+icon_panel.y);
	toolWindow.size_hints->min_height = 128 + icon_panel.y;

	XSetWMNormalHints(display,toolWindow.win,toolWindow.size_hints);

	icon_panel.x = 0; /* relative to toolWindow  */

	icon_panel.icons = icons;
	icon_panel.iconnum = icon_number;
	
	/* resize the icons to fit the window  */  
	for (i=0; i<icon_number; i++)
		icons[i].w = toolWindow.w / 3;
		 
	/* all the icon panel work is done by calling this function  */
	/* this will setup the icons and claim subwindows on the window passed to it */ 
	if ((stk_create_icon_panel(toolWindow, &icon_panel))==FAIL)
		close_down();

	/* set up our icon menus  */  
	icon_float.icons = floaticons; 
	icon_float.iconnum = floaticon_number;
	
	if ((float_menu=stk_create_icon_menu(&icon_float,3))==(Window)FAIL)
		close_down();

	/* set SaveUnder for floating icon menu  */  
	xswa.save_under = True;
	XChangeWindowAttributes(display,float_menu,CWSaveUnder,&xswa);
	 
	linestyle_float.icons = linestyleicons;
	linestyle_float.iconnum = linestyleicon_number;

	if ((linestyle_menu=stk_create_icon_menu(&linestyle_float,2))==(Window)FAIL)
		close_down();

	stk_select_icon(SOLIDICON, linestyle_menu);

	justification_float.icons = justificationicons;
	justification_float.iconnum = justificationicon_number;

	if ((justification_menu=stk_create_icon_menu(&justification_float,1))==(Window)FAIL)
		close_down();
		 
	endstyle_float.icons = endstyleicons;
	endstyle_float.iconnum = endstyleicon_number;

	if ((endstyle_menu=stk_create_icon_menu(&endstyle_float,1))==(Window)FAIL)
		close_down();

	joinstyle_float.icons = joinstyleicons;
	joinstyle_float.iconnum = joinstyleicon_number;

	if ((joinstyle_menu=stk_create_icon_menu(&joinstyle_float,1))==(Window)FAIL)
		close_down();
		 
	setarcellipse_float.icons = setarcellipseicons;
	setarcellipse_float.iconnum = setarcellipseicon_number;

	if ((setarcellipse_menu=stk_create_icon_menu(&setarcellipse_float,1))==(Window)FAIL)
		close_down();
		 
	fillstyle_float.icons = fillstyleicons;
	fillstyle_float.iconnum = fillstyleicon_number+1;

	if ((fillstyle_menu=stk_create_icon_menu(&fillstyle_float,4))==(Window)FAIL)
		close_down();
	
	stk_select_icon(STARTOFFILLSTYLES, fillstyle_menu);
	 
	if ((colour_menu=stk_create_colour_icon_menu(cols, numcols, 4))==(Window)FAIL)
		close_down();

	if ((fillcolour_menu=stk_create_colour_icon_menu(fillcols, fillnumcols, 4))==(Window)FAIL)
		close_down();

	/* select the pointer icon */

	stk_select_icon(POINTERICON,toolWindow.win);
	stk_select_icon(POINTERICON,float_menu); 
	
	/* set up initial state  */

	state.current_icon = POINTERICON;
	state.current_icon_window_open = FALSE;
	state.busy_drawing = FALSE; 
	state.editing_object = FALSE;
	state.editing_point = FALSE; 
	state.editing_text = FALSE; 
	state.compound_selected = FALSE; 
	state.tied_corner = NOTSCALING; 
	state.drawing_released = FALSE; 
	state.control_down = FALSE; 
	state.shift_down = FALSE; 
	state.show_fig_files_only = TRUE; 
	state.last_press = 0;
	state.last_release = 0;
	state.views = NULL;

	/* create our menus now  */
	 
	if (stk_create_menu("File", &file_menu, &toolWindow, 0, icon_panel.y-2)==(Window)FAIL
		|| (hpw=stk_create_menu("Help", &options_menu, &toolWindow, 0, icon_panel.y-2))==(Window)FAIL )
		close_down();
	
	if (tooltips)
		stk_change_menu_label(hpw, "Show tooltips", "Hide tooltips");
	else 
		stk_tooltips(FALSE);
		 

	if ((vmw=stk_create_menu(NULL, &view_menu, NULL, 0, 0))==(uint)FAIL)
		close_down();

	if ((emw=stk_create_menu(NULL, &edit_menu, NULL, 0, 0))==(uint)FAIL)
		close_down();

	stk_disable_menu_label(emw,2);

	toolWindow.h = 128 + icon_panel.y;
	XResizeWindow(display,toolWindow.win, toolWindow.w, toolWindow.h);
	
	/* create all our needed dialogs  */ 
	/* laborious but simple  */  
	file_dialog = stk_create_dialog(400,300);
	stk_add_dialog_title(file_dialog,"Load FIG file"); 
	lfile_text = stk_add_text_slider(file_dialog, "Directories", 10, LEFT, J_FILE_SLIDERS);
 	rfile_text = stk_add_text_slider(file_dialog, "Files", 10, RIGHT, J_FILE_SLIDERS); 
	file_figfiles = stk_add_choice(file_dialog, "Show FIG files only", RIGHT, 0);    
 	file_entry = stk_add_text_entry(file_dialog, "Selection :", "", RIGHT, 0);  
	file_ok = stk_add_button(file_dialog, "OK", LEFT, J_FILE_BUTTONS,TRUE,2); 
	file_cancel = stk_add_button(file_dialog, "Cancel", RIGHT, J_FILE_BUTTONS, FALSE,2); 

	savefile_dialog = stk_create_dialog(400,300); 
	stk_add_dialog_title(savefile_dialog,"Save FIG file"); 
	savelfile_text = stk_add_text_slider(savefile_dialog, "Directories", 10, LEFT, J_FILE_SLIDERS);
 	saverfile_text = stk_add_text_slider(savefile_dialog, "Files", 10, RIGHT, J_FILE_SLIDERS); 
	savefile_figfiles = stk_add_choice(savefile_dialog, "Show FIG files only", RIGHT, 0);    
 	savefile_entry = stk_add_text_entry(savefile_dialog, "Selection :", "", RIGHT, 0);  
	savefile_ok = stk_add_button(savefile_dialog, "OK", LEFT, J_FILE_BUTTONS,TRUE,2); 
	savefile_cancel = stk_add_button(savefile_dialog, "Cancel", RIGHT, J_FILE_BUTTONS, FALSE,2); 

	insertfile_dialog = stk_create_dialog(400,300); 
	stk_add_dialog_title(insertfile_dialog,"Insert FIG file"); 
	insertlfile_text = stk_add_text_slider(insertfile_dialog, "Directories", 10, LEFT, J_FILE_SLIDERS);
 	insertrfile_text = stk_add_text_slider(insertfile_dialog, "Files", 10, RIGHT, J_FILE_SLIDERS); 
	insertfile_figfiles = stk_add_choice(insertfile_dialog, "Show FIG files only", RIGHT, 0);    
 	insertfile_entry = stk_add_text_entry(insertfile_dialog, "Selection :", "", RIGHT, 0);  
	insertfile_ok = stk_add_button(insertfile_dialog, "OK", LEFT, J_FILE_BUTTONS,TRUE,2); 
	insertfile_cancel = stk_add_button(insertfile_dialog, "Cancel", RIGHT, J_FILE_BUTTONS, FALSE,2); 

	exportfile_dialog = stk_create_dialog(400,400);
	stk_add_dialog_title(exportfile_dialog,"Export FIG file");
	exportlfile_text = stk_add_text_slider(exportfile_dialog, "Directories", 10, LEFT, J_FILE_SLIDERS);
 	exportrfile_text = stk_add_text_slider(exportfile_dialog, "Files", 10, RIGHT, J_FILE_SLIDERS); 
	exportformat_text = stk_add_text_slider(exportfile_dialog, "Format", 6, RIGHT, 0);
	/* FIXME: metapost support */ 
	stk_add_textlist_member(exportformat_text, ".box: LaTeX box (figure boundary)");
	stk_add_textlist_member(exportformat_text, ".eepic: LaTeX picture with eepic macros");
	stk_add_textlist_member(exportformat_text, ".eepicemu: LaTeX picture with eepicemu macros");
	stk_add_textlist_member(exportformat_text, ".epic: LaTeX picture with epic macros");
	stk_add_textlist_member(exportformat_text, ".eps: Encapsulated PostScript");
	stk_add_textlist_member(exportformat_text, ".gif: GIF");
	stk_add_textlist_member(exportformat_text, ".hgl: IBM-GL / HP-GL");
	stk_add_textlist_member(exportformat_text, ".jpg: JPEG");
	stk_add_textlist_member(exportformat_text, ".latex: LaTeX picture");
	stk_add_textlist_member(exportformat_text, ".mf: MetaFont");
	stk_add_textlist_member(exportformat_text, ".mp: MetaPost (if supported)");
	stk_add_textlist_member(exportformat_text, ".mmp: Multi MetaPost (if supported)");
	stk_add_textlist_member(exportformat_text, ".pcx: Microsoft PCX format");
	stk_add_textlist_member(exportformat_text, ".pic: PIC");
	stk_add_textlist_member(exportformat_text, ".pictex: PiCTeX macros");
	stk_add_textlist_member(exportformat_text, ".png: Portable Network Graphics (PNG)");
	stk_add_textlist_member(exportformat_text, ".ppm: Portable Pixmap (ppm)");
	stk_add_textlist_member(exportformat_text, ".ps: PostScript");
	stk_add_textlist_member(exportformat_text, ".pstex: PS/LaTeX split files");
	stk_add_textlist_member(exportformat_text, ".sld: AutoCad slide");
	stk_add_textlist_member(exportformat_text, ".textyl: Textyl \\special commands");
	stk_add_textlist_member(exportformat_text, ".tif: TIFF");
	stk_add_textlist_member(exportformat_text, ".tpic: TPIC");
	stk_add_textlist_member(exportformat_text, ".xbm: X11 bitmap (xbm)");
	stk_add_textlist_member(exportformat_text, ".xpm: X11 Pixmap (xpm3)");
 	exportfile_entry = stk_add_text_entry(exportfile_dialog, "Selection :", "", RIGHT, 0);  
	exportfile_ok = stk_add_button(exportfile_dialog, "OK", LEFT, J_FILE_BUTTONS,TRUE,2); 
	exportfile_cancel = stk_add_button(exportfile_dialog, "Cancel", RIGHT, J_FILE_BUTTONS, FALSE,2); 

	printfile_dialog = stk_create_dialog(300,300);
	stk_add_dialog_title(printfile_dialog,"Print file");
	printfile_choice = stk_add_radio_choice(printfile_dialog,"Figure Justification :", "Centred", "Flush Left", NULL, NULL, RIGHT, 0);
	printfile_entry = stk_add_text_entry(printfile_dialog, "Print command :", "lpr ", RIGHT, 0);
	printfile_print = stk_add_button(printfile_dialog, "Print", LEFT, J_VIEW_BUTTONS, FALSE, 2); 
	printfile_cancel = stk_add_button(printfile_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, TRUE, 2); 
	strcpy(state.print,"lpr "); 
	 
	view_dialog = stk_create_dialog(300,300);
	stk_add_dialog_title(view_dialog,"View settings");
 	view_gridx_entry = stk_add_text_entry(view_dialog, "x Grid Size (inches) :", "", LEFT, J_GRID);  
 	view_gridy_entry = stk_add_text_entry(view_dialog, "y Grid Size (inches) :", "", RIGHT, J_GRID);  
	view_units = stk_add_radio_choice(view_dialog,"Document units :", "Centimetres", "Inches", NULL, NULL, RIGHT, 0);
	view_guides = stk_add_choice(view_dialog, "Show guidelines", RIGHT, 0);
	view_highlight = stk_add_choice(view_dialog, "Highlight objects", RIGHT, 0); 
	view_compounds = stk_add_choice(view_dialog, "Show compound outlines", RIGHT, 0);
 	view_ok = stk_add_button(view_dialog, "OK", LEFT, J_VIEW_BUTTONS, TRUE,3);  
 	view_apply = stk_add_button(view_dialog, "Apply", LEFT, J_VIEW_BUTTONS, FALSE,3);  
 	view_cancel = stk_add_button(view_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, FALSE,3);  
	 
	lw_dialog = stk_create_dialog(200,100);
	stk_add_dialog_title(lw_dialog,"Set line width");
	lw_entry = stk_add_text_entry(lw_dialog, "Width (1/80 inch) :", "", RIGHT, 0);
	lw_ok = stk_add_button(lw_dialog, "OK", LEFT, J_VIEW_BUTTONS, TRUE,3);
	lw_apply = stk_add_button(lw_dialog, "Apply", LEFT, J_VIEW_BUTTONS, FALSE,3);
	lw_cancel = stk_add_button(lw_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, FALSE,3);
	 
	roundbox_dialog = stk_create_dialog(200,100);
	stk_add_dialog_title(roundbox_dialog,"Set rounded box");
	roundbox_choice = stk_add_choice(roundbox_dialog, "Rounded corners", RIGHT, 0);
	roundbox_entry = stk_add_text_entry(roundbox_dialog, "Radius (1/80 inch) :", "", RIGHT, 0);
	roundbox_ok = stk_add_button(roundbox_dialog, "OK", LEFT, J_VIEW_BUTTONS, TRUE,3);
	roundbox_apply = stk_add_button(roundbox_dialog, "Apply", LEFT, J_VIEW_BUTTONS, FALSE,3);
	roundbox_cancel = stk_add_button(roundbox_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, FALSE,3);
	 
	polygon_dialog = stk_create_dialog(200,100);
	stk_add_dialog_title(polygon_dialog, "Polygon settings");
	polygon_choice = stk_add_choice(polygon_dialog, "Regular", RIGHT, 0);
	polygon_entry = stk_add_text_entry(polygon_dialog, "Sides :", "", RIGHT, 0);
	polygon_ok = stk_add_button(polygon_dialog, "OK", LEFT, J_VIEW_BUTTONS, TRUE,3);
	polygon_apply = stk_add_button(polygon_dialog, "Apply", LEFT, J_VIEW_BUTTONS, FALSE,3);
	polygon_cancel = stk_add_button(polygon_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, FALSE,3);

	spline_dialog = stk_create_dialog(200,100);
	stk_add_dialog_title(spline_dialog, "Spline settings");
	spline_choice = stk_add_choice(spline_dialog, "Closed spline (filled)", RIGHT, 0);
	spline_slider = stk_add_slider(spline_dialog, "Default shape factor", "Interpolated", "Approximated", 0, RIGHT, 0);
	spline_entry = stk_add_text_entry(spline_dialog, "Value :", "", RIGHT, 0); 
	spline_ok = stk_add_button(spline_dialog, "OK", LEFT, J_VIEW_BUTTONS, TRUE,3);
	spline_apply = stk_add_button(spline_dialog, "Apply", LEFT, J_VIEW_BUTTONS, FALSE,3);
	spline_cancel = stk_add_button(spline_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, FALSE,3);

	arrow_dialog = stk_create_dialog(400, 300);
	stk_add_dialog_title(arrow_dialog,"Set line arrows");
	larrow_choice = stk_add_choice(arrow_dialog, "Start arrow", RIGHT, 0);
	larrow_fillchoice = stk_add_choice(arrow_dialog, "Filled", RIGHT, 0); 
	larrow_type = stk_add_radio_choice(arrow_dialog,"Style :", "Stick", "Flat", "Indented", "Pointed", RIGHT, 0);
	larrow_width = stk_add_text_entry(arrow_dialog, "Width :", "", RIGHT, 0);
	larrow_height = stk_add_text_entry(arrow_dialog, "Height :", "", RIGHT, 0);
	larrow_thickness = stk_add_text_entry(arrow_dialog, "Thickness :", "", RIGHT, 0);
	rarrow_choice = stk_add_choice(arrow_dialog, "End arrow", RIGHT, 0);
	rarrow_fillchoice = stk_add_choice(arrow_dialog, "Filled", RIGHT, 0);
	rarrow_type = stk_add_radio_choice(arrow_dialog,"Style :", "Stick", "Flat", "Indented", "Pointed", RIGHT, 0);
	rarrow_width = stk_add_text_entry(arrow_dialog, "Width :", "", RIGHT, 0);
	rarrow_height = stk_add_text_entry(arrow_dialog, "Height :", "", RIGHT, 0);
	rarrow_thickness = stk_add_text_entry(arrow_dialog, "Thickness :", "", RIGHT, 0);
	arrow_ok = stk_add_button(arrow_dialog, "OK", LEFT, J_VIEW_BUTTONS, TRUE,3);
	arrow_apply = stk_add_button(arrow_dialog, "Apply", LEFT, J_VIEW_BUTTONS, FALSE,3);
	arrow_cancel = stk_add_button(arrow_dialog, "Cancel", RIGHT, J_VIEW_BUTTONS, FALSE,3);
	 
	font_dialog = stk_create_dialog(400, 350);
	stk_add_dialog_title(font_dialog, "Set font");
	font_typeface_text = stk_add_text_slider(font_dialog, "Typeface", 20, LEFT, J_FILE_SLIDERS);
	font_size_text = stk_add_text_slider(font_dialog, "Size", 20, RIGHT, J_FILE_SLIDERS);
	font_entry = stk_add_text_entry(font_dialog,  "Size :", "", RIGHT, 0);
	font_close = stk_add_button(font_dialog, "Close", RIGHT, 0, TRUE,1);

	for (i=0; i<numfontnames; i++)
		stk_add_textlist_member(font_typeface_text, fontnames[i][1]);
		 
	stk_add_textlist_member(font_size_text, "7");
	stk_add_textlist_member(font_size_text, "8");
	stk_add_textlist_member(font_size_text, "9");
	stk_add_textlist_member(font_size_text, "10");
	stk_add_textlist_member(font_size_text, "11");
	stk_add_textlist_member(font_size_text, "12");
	stk_add_textlist_member(font_size_text, "13");
	stk_add_textlist_member(font_size_text, "14");
	stk_add_textlist_member(font_size_text, "16");
	stk_add_textlist_member(font_size_text, "18");
	stk_add_textlist_member(font_size_text, "20");
	stk_add_textlist_member(font_size_text, "24");
	stk_add_textlist_member(font_size_text, "30");
	stk_add_textlist_member(font_size_text, "36");
	stk_add_textlist_member(font_size_text, "40");
	stk_add_textlist_member(font_size_text, "45");
	stk_add_textlist_member(font_size_text, "50");
	stk_add_textlist_member(font_size_text, "55");
	stk_add_textlist_member(font_size_text, "60");
	stk_add_textlist_member(font_size_text, "65");
	stk_add_textlist_member(font_size_text, "70");
	stk_add_textlist_member(font_size_text, "75");
	stk_add_textlist_member(font_size_text, "80");
	stk_add_textlist_member(font_size_text, "85");
	 
	getcwd(state.cwd, sizeof(state.cwd));
	strcat(state.cwd,"/"); 
	 
	afonts = NULL; /* no loaded fonts for drawing yet */ 
	XMapWindow(display,toolWindow.win); 
	

	/* load files specified on command line  */ 
	 
	l = files_to_load;

	while (l!=NULL)
		{
		load(((char *)l->data),TRUE);
 		free (l->data);
		l = l->next;
		};
	
	delete_list(files_to_load);
}
	
/* extract options from cmdline  */  
void 
open_display_and_parse_database(void)
{
	XrmValue xValue;
	char hostname[FIGURINE_HOSTNAME_MAX] = "\0";
	char home_dir[FIGURINE_PATH_MAX] = "\0";
	char displayName[256];
	XrmDatabase XenvironmentDatabase, XserverDatabase, XapplicationDatabase;
	char defaults_filename[FIGURINE_PATH_MAX];
	char *temppointer; 
	char class_name[] = "Figurine";
	char *str_type_return[20];
	
	displayName[0] = '\0';
	
	/* first we need to get the display to reach the other databases  */ 
	
	if (XrmGetResource(XcommandLineDatabase, "figurine.display", "Figurine.Display", str_type_return, &xValue)==True)
		strncpy(displayName, xValue.addr, (uint) min(256,xValue.size));

	/* try and open our display */
	
	if (!(display = XOpenDisplay(displayName)))
		{
		fprintf(stderr, "figurine: Can't open display %s\n", XDisplayName(displayName));
		exit(1);
		};
	
	screen = DefaultScreen(display);
	visual = DefaultVisual(display,screen); 
	colourmap = DefaultColormap(display,screen); 
	
	/* get home dir as we need it now */

	home_directory(home_dir);

	/* parse databases  */  
	
	strcpy(defaults_filename, "/usr/lib/X11/app-defaults/");
	strcat(defaults_filename, class_name);

	XapplicationDatabase = XrmGetFileDatabase(defaults_filename);
	
	/* app-defaults */ 
	XrmMergeDatabases(XapplicationDatabase,&XresourceDatabase);

	if (XResourceManagerString(display) != NULL)
		{
		XserverDatabase = XrmGetStringDatabase(XResourceManagerString(display));
		}
	else
		{
		strcpy(defaults_filename,home_dir);
		strcat(defaults_filename,"/.Xdefaults");

		XserverDatabase = XrmGetFileDatabase(defaults_filename);
		};
	
	/* server/user settings over app-defaults  */ 
	XrmMergeDatabases(XserverDatabase, &XresourceDatabase);

	/* deal with environment-specific settings now  */  
	if ((temppointer=getenv("XENVIRONMENT"))==NULL)
		{
		strncpy(defaults_filename, home_dir, FIGURINE_PATH_MAX);
		strcat(defaults_filename, "/.Xdefaults-");
#ifdef HAVE_GETHOSTNAME
		gethostname(hostname, FIGURINE_HOSTNAME_MAX); 
#else
		strcpy(hostname,"localhost");
#endif
		strcat(defaults_filename, hostname);
		}
	else
		strncpy(defaults_filename, temppointer, FIGURINE_PATH_MAX);
	
	XenvironmentDatabase = XrmGetFileDatabase(defaults_filename);

	/* environment/user over server/user settings */ 
	XrmMergeDatabases(XenvironmentDatabase, &XresourceDatabase);

	/* command line finally over everything else */
	XrmMergeDatabases(XcommandLineDatabase, &XresourceDatabase);
}
 

void 
figurine_usage(char *argv[])
{
 	int i; 
	 
 	fprintf(stderr, "Usage: %s ", argv[0]);
	 
	for (i=0; i < XcommandLineTableEntries; i++)
		{
		fprintf(stderr, "[%s", XcommandLineTable[i].option);
		if (XcommandLineTable[i].argKind == XrmoptionSepArg)
			{
			if (XcommandLineTable[i].option[1] == '-')
				fprintf(stderr, " <%s>] ",&XcommandLineTable[i].option[2]);
			else
				fprintf(stderr, " <%s>] ",&XcommandLineTable[i].option[1]);
			}
		else
			fprintf(stderr, "] ");
		}; 
		 
	fprintf(stderr, "[<filenames>]\n");
	
	exit(1); 
}  
 
  
void 
get_opts(int argc, char *argv[])
{
	char *str_type_return[20];
	XrmValue versionValue; 
	int arg_count = argc; 
	char program_name[] = "figurine"; 

	XrmInitialize(); 


	/* Parse all the commands defined in xvars.c  */  

 	XrmParseCommand(&XcommandLineDatabase, XcommandLineTable, XcommandLineTableEntries,
 	                program_name, &arg_count, argv);
	
	/* if they just want the version, it's time to leave */
	
	if (XrmGetResource(XcommandLineDatabase, "figurine.askversion", "Figurine.Askversion", str_type_return, &versionValue)==True)
		{
		printf("Figurine %s, compiled on " __DATE__ ", " __TIME__ " \n", VERSION);
		printf("Figurine is released under the GNU General Public License,\n"
			"either Version 2, or (at your option) any later version.\n"); 
		exit(0);
		}

	/* complain about usage and quit if anything left */
	
	if (arg_count>1) /* we still have program name in argv[0]  */ 
		{
		char *a;

		arg_count--; 
		while (arg_count)
			{
			if (*argv[arg_count]=='-')
				{
				/* wrong argument */ 
				figurine_usage(argv);
				}
			else
				{
				a = (char *)malloc(strlen(argv[arg_count])+1);		
				strcpy(a,argv[arg_count]); 
				files_to_load = add_to_list(files_to_load,0,0,(void *)a);
				};
			arg_count--;
			};
		}

} 
