#ifndef _FIGURINE_FIGURINE_H
#define _FIGURINE_FIGURINE_H

/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: figurine.h,v $
 * Revision 1.4  2000/12/17 00:57:44  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.3  2000/12/08 22:33:38  moz
 * Clean up possibly unsafe tmp file handling.
 *
 * Revision 1.2  2000/12/06 20:56:08  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:32  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:32  moz
 * CVS Import
 *
 * Revision 1.46  2000/03/11 19:11:52  moz
 * recalc_text_box() changed.
 *
 * Revision 1.45  2000/03/11 18:18:17  moz
 * calc_text_outer_box() -> calc_text_outer_box_adjust().
 *
 * Revision 1.44  2000/03/09 01:06:11  moz
 * Compile fixes.
 *
 * Revision 1.43  2000/03/06 02:08:59  moz
 * is_in_bbox prototype changed.
 *
 * Revision 1.42  2000/02/27 15:23:09  moz
 * fillstyle_out,fillcolour_out take Object *.
 *
 * Revision 1.41  2000/02/18 21:19:23  moz
 * Compile fixes.
 *
 * Revision 1.40  2000/02/17 22:25:28  moz
 * Compiler fixes.
 * Added clear_redo_stack() and kill_undo().
 *
 * Revision 1.39  2000/02/15 01:49:19  moz
 * switch_icons() takes View *.
 *
 * Revision 1.38  2000/01/30 17:24:18  moz
 * Removed unused View members.
 *
 * Revision 1.37  2000/01/26 18:26:01  moz
 * Change prototypes for FIG_DEBUG_LIST_ALLOC.
 *
 * Revision 1.36  2000/01/25 01:38:06  moz
 * Border not kept.
 *
 * Revision 1.35  2000/01/21 11:21:31  moz
 * Use memwatch.
 *
 * Revision 1.34  1999/11/16 01:50:37  moz
 * clip_line must take signed longs.
 *
 * Revision 1.33  1999/11/15 23:04:35  moz
 * Prototype fixes.
 *
 * Revision 1.32  1999/11/15 02:13:06  moz
 * Use enums.
 * Rounded trig prototypes.
 *
 * Revision 1.31  1999/08/17 00:38:35  moz
 * Proto fix.
 *
 * Revision 1.30  1999/08/09 00:17:30  moz
 * New prototypes for handle_icon.c
 *
 * Revision 1.29  1999/08/08 20:54:23  moz
 * Clean up structs.
 *
 * Revision 1.28  1999/07/29 20:56:37  moz
 * draw_text() now takes rx,ry scaling factors.
 *
 * Revision 1.27  1999/07/03 21:36:09  moz
 * zoom_in() zoom_out() prototypes take Boolean.
 *
 * Revision 1.26  1999/06/17 19:11:04  moz
 * PDerry defined.
 * Prototypes for persistent attachment functions.
 *
 * Revision 1.25  1999/05/23 20:11:34  moz
 * Fixed broken prototype fix.
 *
 * Revision 1.24  1999/05/23 00:28:17  moz
 * Pedantic changes.
 *
 * Revision 1.23  1999/05/22 23:39:59  moz
 *  Pedantic ANSI.
 *
 * Revision 1.22  1999/05/22 15:09:04  moz
 * new_doc() takes argument now.
 *
 * Revision 1.21  1999/05/19 17:11:10  moz
 * 1.0 Checkin.
 *
 * Revision 1.20  1999/05/05 12:29:44  moz
 * export_name() changed.
 *
 * Revision 1.19  1999/05/04 20:10:24  moz
 * insert_after(), insert_before() prototypes.
 *
 * Revision 1.18  1999/05/03 06:22:03  moz
 * fill_in_file now takes .fig file filter option.
 *
 * Revision 1.17  1999/05/02 22:49:35  moz
 * Removed unused split_compound().
 *
 * Revision 1.16  1999/04/29 22:57:46  moz
 * New function prototypes for redo.
 *
 * Revision 1.15  1999/04/28 16:36:11  moz
 * Use TextLine->w in recalc_text_box.
 *
 * Revision 1.14  1999/04/27 16:58:50  moz
 * Flip object prototypes.
 *
 * Revision 1.13  1999/04/27 07:41:10  moz
 * notify_compound_undo prototype.
 *
 * Revision 1.12  1999/04/27 06:46:24  moz
 * Allow cmdline new files.
 *
 * Revision 1.11  1999/04/27 04:25:07  moz
 * draw_view change.
 *
 * Revision 1.10  1999/04/27 04:12:58  moz
 * Added missing prototypes.
 *
 * Revision 1.9  1999/04/26 20:00:36  moz
 * New prototype for move_object added.
 *
 * Revision 1.8  1999/04/25 00:22:09  moz
 * draw_text takes angle now.
 *
 * Revision 1.7  1999/04/24 22:24:52  moz
 * Change of gc_colour and gc_fillcolour prototypes.
 * New UColour structure for user-defined colours.
 *
 * Revision 1.6  1999/04/23 01:06:39  moz
 * Store state of show_fig_files_only.
 *
 * Revision 1.5  1999/04/23 00:40:51  moz
 * Change redraw method of whole window.
 *
 * Revision 1.4  1999/04/22 22:18:11  moz
 * Changes in prototypes.
 *
 * Revision 1.3  1999/04/22 21:39:25  moz
 * New function for scaling compounds.
 *
 * Revision 1.2  1999/04/12 19:06:00  moz
 * New functions for export facility.
 *
 * Revision 1.1  1999/03/30 00:10:20  moz
 * Initial revision
 *
 */

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h> 
#include <limits.h>
#include <unistd.h> 
#include <sys/param.h>
#include <stdio.h>
#include <stdlib.h> 
#include <X11/cursorfont.h> 
#include <string.h> 
/* For maintainer */  
#ifdef MEMWATCH
#include "memwatch.h"
#endif 

#include "define.h"

/* typedefs used in STK & Figurine  */

typedef struct _ListEl
   {
   unsigned long id;
   unsigned long type;
   void *data;
   struct _ListEl *next;
   struct _ListEl *prev;
   } ListEl;

typedef ListEl *List; 

enum _Boolean { FALSE, TRUE };

typedef enum _Boolean Boolean;

typedef struct _Papersize
   {
   char name[20];
	char fname[20]; 
   double w;
   double h;
   } Papersize;  

/* contains info about an X window  */  
typedef struct _WindowStruct
	{
	Window win;
	Window parent; 
	int cursor_num; 
	int x,y;
	uint w,h;
	XSizeHints *size_hints;
	XClassHint *class_hints;
	XWMHints *wm_hints;
	Boolean grabbed; 
	GC gc;
	} WindowStruct;       
													  
/* normal colour  */ 
typedef struct _VColour 
	{
	char label[20]; 
	unsigned long colour;
	char name[10];
	int tag; 
	} VColour;

/* user defined colour  */  
typedef struct _UColour
	{
	long tag; 
	unsigned long colour;
	char name[10];
	} UColour;

/* button event created by mouse_motion.c or mouse_button.c  */  
typedef struct _BEvent
	{
	int type; /* one of BUTTON_CLICKED, BUTTON_HELD, BUTTON_RELEASED */
	int x,y;
	unsigned int state; 
	int button; /* Button1, Button2, Button3  */
	} BEvent;

/* normal polyline point  */  
typedef struct _VPoint
	{
	long x;
	long y;
	Boolean derried;
	} VPoint;

/* line - used for clip_line()  */  
typedef struct _VLine
	{
	long x1;
	long y1;
	long x2;
	long y2;
	} VLine;

/* used as bboxes  */  
typedef struct _VRegion
	{
	long x1;
	long y1;
	long x2;
	long y2;
	} VRegion;

/* font description  */  
typedef struct _VFont
	{
	XFontStruct *x;
	int num; /* index into fontnames array  */  
	int size; /* note this is actual zoomed size. e.g. 120 point could be representing 12 point at 100% zoom */ 
	} VFont;

/* section of text. less than 20 chars, all same font  */  
typedef struct _TextSection
	{
	Boolean isReturn;
	int num; /* index used to get relevant VFont */  
	int size; 
	char text[20]; 
	long x;
	long y;
	long w;
	long h;
	} TextSection;

/* line of text sections  */  
typedef struct _TextLine
	{
	long y;
	long w; 
	long h;
	int just; /* LEFT, CENTRE, RIGHT  */  
	List sections; 
	} TextLine; 

/* for _Text  */  
struct _Object;
 
/* text object is a list of lines  */  
typedef struct _Text
	{
	List lines;
	Boolean node;
	double angle; 
	VRegion bbox; /* bbox of actual text == ob->bbox for normal text */  
	struct _Object *ellipse; /* Object * to ellipse for node */ 
	} Text;
 
/* polyline object  */  
typedef struct _Polyline
	{
	List points;
	char *pic; /* pic line for import/export */  
	} Polyline;
	
/* roundbox object  */ 
typedef struct _RoundBox
	{
	int radius; /* units of 1/80th inch  */ 
	/* co-ords are specified by bbox  */ 
	} RoundBox;

/* ellipse object  */  
typedef struct _Ellipse
	{
	VPoint centre;
	long xradius;
	long yradius;
	} Ellipse;

/* Control point for spline  */  
typedef struct _SPoint
	{
	long x;
	long y;
	Boolean derried; 
	double s; /* -1 <= s <= 1 */ 
	} SPoint;

/* spline object  */  
typedef struct _Spline
	{
	List points; /* control points + shape factors */  
	List cache; /* points array for drawing  */ 
	Boolean closed; 
	} Spline;

/* arcellipse object  */  
typedef struct _ArcEllipse
	{
	VPoint centre;
	long xradius;
	long yradius;
	double start; /* angles, +-clockwise from E   */ 
	double end;
	Boolean open; 
	} ArcEllipse;

/* compound object  */  
typedef struct _Compound
	{
	List obs;
	} Compound;

/* arrow definition  */  
typedef struct _Arrow
	{
	ArrowStyle type; /* ARROWSTICK, ARROWFLAT, ARROWINDENTED, ARROWPOINTED */ 
	int filled;
	long lw; /* in 1/80th inch  */ 
	long w; /* in 1/80th inch  */ 
	long h; /* in 1/80th inch  */ 
	} Arrow;
	
/* all objects are of this type  */ 
typedef struct _Object
	{

	ObjectType type; /* POLYLINE, ARC, etc.  */ 
	unsigned long ticket; /* unique id */ 
	unsigned long depth; /* depth of object  */  
	ColourType colour; /* color - STARTOFCOLOURS upwards */
	FillColourType fillcolour; /* color of fill STARTOFFILLCOLOURS upwards */  

	LineStyle ls; /* see include/defines.h for line styles  */
	int lw; /* line width, 1/80s inch  */ 
	int fs; /* see pixmaps/fillstyle.h  */  
	int es; /* end style */
	int js; /* join style */
	long dash; /* (Pixel) size of dash  */ 
	long gap; /* (Pixel) size of gap  */ 
	
	Arrow *farrow; /* forward arrow description  */ 
	Arrow *barrow; /* backward arrow description  */ 
	
	VRegion bbox; /* bounding box of object  */ 

	List derries; /* linked objects  */  
	union 
		{
		Text       text;
		Polyline      polyline;
		RoundBox      roundbox; 
		/* rectangle and generalised case regular polygon 
			represented by polyline object */  
		/* whether to even check for fill is testing for POLYGON  */ 
		Spline        spline; 
		Ellipse       ellipse;
		ArcEllipse    arcellipse; 
		Compound compound; 
		} ob;  

	} Object;

/* leaf in object tree  */  
/* branches have ob==NULL  */  
/* real leaves have left==NULL,right==NULL */  
/* up is used in still_same_object()  */  
typedef struct _Node
	{
	struct _Node *left;
	Object *ob;
	VRegion bbox; 
	struct _Node *right;
	struct _Node *up; 
	} Node;

typedef Node *Tree;
 
/* main structure for a document  */  
typedef struct _Document
	{
	Tree o; /* our tree of objects */
	List lo; /* list of objects  */  
	List cols; /* user-defined colours for document */  
	double ppi; /* always 1200  */ 
	unsigned long ob_depth; /* latest ob_depth  */  
	double width_in_inches;
	double height_in_inches;
	List views; /* view list for document  */ 
	char canvas_name[40]; 
	Boolean landscape;
	Boolean centred; /* if ==0, flush left  */ 
	Boolean in_mm;
	double magnify; /* for export/print  */ 
	Boolean mpage; /* multipage  */ 
	int transcolour; /* transparent GIF colour index  */ 
	char pathname[FIGURINE_PATH_MAX]; 
	char filename[FIGURINE_PATH_MAX]; 
	Window check_dial; /* unpleasant hack ... */  
	Window check_save; 
	Window check_close;
	Window check_cancel;
	} Document;

/* each view has this structure  */  
typedef struct _View
	{
	WindowStruct window;
	
	Document *doc; /* parent document  */ 
	WindowStruct *ruler_x_window;
	WindowStruct *ruler_y_window;
	WindowStruct *draw_window;
	WindowStruct *view_icon_window; 
	
	Boolean guide_lines; /* guide lines on ?  */ 
	Boolean guide_lines_displayed; 
	Boolean in_mm; /* mm or inches  */ 
	Boolean show_compounds; /* dashgc round compound bbox  */  
	Boolean highlight_objects; 
	
	Node *highlighted_object; 
	Node *selected_object; /* which object is selected  */ 
	Node *edited_object; /* i.e. point editing of object  */  
	int guide_x; /* position of guidelines  */ 
	int guide_y;
	unsigned long colour; /* colour to be used */  
	unsigned long fillcolour; /* fill colour to be used */  
	 
	Object *text_object; /* current text object  */ 
	Boolean showgrid;  /* whether grid is shown  */ 
	Boolean gridon; /* whether grid has an effect  */ 
	long grid_x; /* grid size  */ 
	long grid_y;
	int sides; /* no of sides of regular polygon  */  
	double side_angle; /* pre-computed when sides changed  */  
	Boolean regular; /* regular polygon ?  */  

	char wname[850]; /* window name  */ 
	double x_inches_offset; /* offset of rulers  */ 
	double y_inches_offset;
	double zoom_factor; /* current zoom value  */ 
	int zoom_level; /* current zoom position  */ 
	int linestyle; /* current object parameters  */ 
	int linewidth; 
	int endstyle;
	int joinstyle;
	Boolean fillon; 
	int fillstyle; 
	Boolean roundbox;
	int roundsize;
	int fontnum; 
	int fontsize; /* nominal e.g. 12pt when screen font is 120pt  */  
	int justification; 
	Boolean closed; /* for spline  */ 
	double current_sfactor; /* for splines  */  
	Boolean openarc; /* for arcellipses  */  
	Boolean farrow_on;
	Boolean barrow_on;
	Arrow farrow; 
	Arrow barrow;
	 
	} View;
	 
/* stores useful state  */ 
typedef struct _State
	{
	IconType current_icon; /* current tool icon  */ 
	Boolean current_icon_window_open;
	Boolean busy_drawing; 
	Boolean editing_object; 
	Boolean editing_point; 
	Boolean editing_text; 
	Boolean compound_selected; 
	Boolean drawing_released; 
	Boolean rubberon; 
	Boolean control_down; /* keys down  */ 
	Boolean shift_down; 
	Boolean show_fig_files_only; /* in file dialogs  */ 
	ScalingCorner tied_corner; /* for scaling  */ 
	Time last_press;
	Time last_release;
	char cwd[FIGURINE_PATH_MAX]; /* working dir  */ 
	char print[200]; /* print command  */  
	View *menu_view; /* current view with an icon menu open  */ 
	List views; /* all open views  */  
	} State;
	 
typedef struct _Undo
	{
	UndoType type;
	Object *ob; /* usually duplicated object  */ 
	Object *real_ob; /* usually a pointer to the object in the tree  */ 
	Document *doc; /* relevant document  */ 
	} Undo;

/* indicating an object is attached to this one  */  
typedef struct _Derry
	{
	unsigned long ticket; /* ob_ticket of attached object  */ 
	VPoint *point; /* and the point itself  */ 
	} Derry;

/* persistent derry structure used in load.c  */  

typedef struct _PDerry
	{
	Object *ob; /* this is the target */ 
	char tag[40]; /* this is the picked out tag == old pointer  */ 
	long x,y; 
	} PDerry; 
 
/* function prototypes  */
#ifdef PROTOTYPES 
void get_opts(int, char **);
void figurine_usage(char *argv[]); 
void get_colour(ulong *return_colour, int want_white, char *res_string, char *res_class_string, char *color_name);
void open_display_and_parse_database(void); 
void home_directory(char *); 
void close_display(void); 
void event_loop(void); 
void figurine_init(int, char **); 
void close_down(void); 
int max_int(int, int); 
List create_list(ulong, ulong, void *);
List add_to_list0(List list, ulong id, ulong type, void *data); 
List add_to_list_neq0(List list, ulong id, ulong type, void *data); 
void delete_list(List);
List insert_after(List list, ListEl *pos, ulong id, ulong type, void *data, ListEl **le);
List insert_before(List list, ListEl *pos, ulong id, ulong type, void *data, ListEl **le);
List delete_from_list(List, ulong);
List delete_from_list_v(List, void *);
Boolean is_in_list(List, ulong);
Boolean is_in_list_v(List, void *); 
Boolean is_in_box(int, int, int, int, int, int); 
Boolean is_in_bbox(int, int, int, int, int, int);
Boolean is_in_object(long, long, Object *);
Boolean is_in_object_p(View *, long, long, Object *);
void force_in_box(int *, int *, int, int, int, int); 
void force_in_box_l(long *, long *, long, long, long, long); 
void normalise_rectangle(long *, long *, long *, long *); 
void normalise_frectangle(double *, double *, double *, double *); 
Boolean is_contained(int, int, int, int, int, int, int, int); 
Boolean is_contained_v(VRegion, VRegion); 
Boolean intersects(int, int, int, int, int, int, int, int); 
Boolean intersects_v(VRegion, VRegion);
List intersecting_objects(Tree, VRegion, List); 
List where_in_list(List, ulong); 
Document *new_doc(Boolean); 
Window new_view0(Document *); 
void new_view(Document *); 
Boolean close_view(View *);
void really_close_view(View *); 
Boolean close_doc(Document *,View *);
Boolean really_close_doc(Document *); 
void draw_ruler_x(WindowStruct *, double, double);
void draw_ruler_x_mm(WindowStruct *, double, double);
void draw_ruler_y(WindowStruct *, double, double);
void draw_ruler_y_mm(WindowStruct *, double, double);
void toggle_guidelines(View *);
void toggle_rubber_line(WindowStruct *, int, int, int, int); 
Boolean create_window(WindowStruct *, Window, List *, int, void *); 
void send_redraw(WindowStruct *, int, int, int, int); 
void send_redraw_v(View *,VRegion); 
void send_redraw_object(View *, Object *); 
void send_configure(WindowStruct *, int, int, int, int); 
void set_window_name(WindowStruct *,char *); 
void set_clip(GC, int, int, int, int);
void set_clip_v(GC, View *, VRegion); 
void handle_button_press(XEvent *); 
void handle_button_release(XEvent *); 
void handle_motion(XEvent *); 
void handle_keypress(XKeyPressedEvent *); 
void zoom_in(View *,Boolean);
void zoom_out(View *,Boolean);
void polyline_button(BEvent *, View *);
void polyline_point_button(BEvent *, View *);
void polyline_point_motion(View *, long, long);
void ellipse_button(BEvent *, View *); 
void polygon_button(BEvent *, View *); 
void rectangle_button(BEvent *, View *); 
void edit_button(BEvent *, View *);
void edit_motion(View *, long, long);
void text_button(BEvent *, View *);
void text_key(View *, XKeyPressedEvent *);
void toggle(View *, int, int); 
void toggle_polyline(View *, int, int);
void toggle_ellipse(View *, int, int); 
void toggle_polygon(View *, int, int); 
void toggle_rectangle(View *, int, int); 
void toggle_object_outline(View *);
void toggle_point_polyline(View *, long, long); 
int nudge_ruler_x(WindowStruct *, View *, int);
int nudge_ruler_y(WindowStruct *, View *, int);
void recalc_polyline_bbox(Object *,Boolean); 
List polygon_into_points(View *view, List points); 
VRegion merge_boxes(VRegion, VRegion); 
Tree add_object(Tree, List *, Object *);       
Tree add_object0(Tree, Object *);       
Tree delete_object(Tree, Object *); 
Node *get_object_node(Tree, Object *); 
void tree_walk(Tree t); 
Tree change_bbox(Tree,Object *); 
void resize_bbox(Tree,Object *); 
Node *object_at_point(View *, Tree,long,long); 
List object_at_point0(List match, View *v, Tree t, long x, long y); 
Node *object_at_point_p(View *, Tree,long,long); 
void draw_tree(Tree t, View *); 
void draw_view(View *view, long,long,long,long);
void draw_section(View *, int, int, int, int); 
void draw_section_v(View *, VRegion); 
void draw_section0(View *, VRegion *, int, int, int, int); 
void draw_object(Object *,View *, GC, long, long, double, double, double,long, long, long, long); 
void draw_polyline(Object *,View *, GC, long, long, double, double, double); 
void draw_ellipse(Object *,View *, GC, long, long, double, double); 
void draw_roundbox(Object *,View *, GC, long, long, double, double);
void draw_spline(Object *, View *, GC, long, long, double, double, double);
void draw_text(Object *, View *, GC, long, long, double, double, double); 
void draw_grid(View *,long, long, long, long); 
void constrain_line(long, long, long *, long *); 
void constrain_ellipse(long *, long *);
void constrain_resize(double *,double *);
void constrain_rectangle(long, long, long *, long *); 
VLine *clip_line(long, long, long, long, VLine *, Boolean *, int);
signed long line_x_at_y(long, long, long, long, long);
signed long line_y_at_x(long, long, long, long, long);
long snap(long, long); 
void draw_bbox_handles(View *); 
void draw_handle(View *, long x, long y); 
Boolean still_same_object(Node *,long,long);
Boolean still_same_object_p(View *, Node *, long, long);
void gc_line(GC, Object *); 
void gc_fill(GC, Object *); 
void gc_colour(View *, GC, Object *); 
void gc_fillcolour(View *, GC, Object *); 
void gc_lw(View *, GC, Object *); 
void gc_lw_v(View *, GC, int); 
void gc_end(GC, Object *);
void gc_join(GC, Object *);
Boolean edit_on_handle(View *, Object *, long, long); 
Boolean edit_on_rotate_handle(View *, Object *, long, long); 
void apply_scale_to_object(View *, Object *, double, double, Boolean); 
void apply_rotate_to_object(View *, Object *, double); 
void corner_magic(Object *, long *, long *, double, double); 
void deselect_everything(void); 
ListEl *polyline_nearest_point(List, long, long,double *); 
List alloc_points(int); 
void fill_in_file(Window,Window,Boolean);
Boolean is_directory(char *); 
void strip_end_dir(char *); 
double f_blend(double, double); 
double g_blend(double, double); 
double h_blend(double, double); 
void compute_negative_s1(double, double, double *, double *); 
void compute_negative_s2(double, double, double *, double *); 
void compute_positive_s2(int, double, double, double *, double *); 
void compute_positive_s1(int, double, double, double *, double *); 
List compute_spline_segment(List,Boolean);
List spline_compute(List,double,int,SPoint *,SPoint *,SPoint *,SPoint *,double, double);
void spline_button(BEvent *, View *);
void toggle_spline_line(View *, int, int);
void spline_point_button(BEvent *, View *);
void spline_point_motion(View *, long, long);
void toggle_point_spline(View *, long, long);
long size_of_spline(List, View *);     
Boolean point_in_ellipse(long, long, long, long, long, long);
int ellipse_box(long, long, long, long, long, long, long, long);
Boolean new_object(View *, long, long); 
VFont *get_font(int, int);
void unselect_text(View *); 
void unselect_compound(View *); 
void unselect_arc(View *); 
void recalc_text_box(View *, Object *,Boolean,Boolean); 
void recalc_text_boxes(View *);
void calc_text_outer_box_adjust(Object *,long,long); 
void set_window_cursor(Window,int); 
void arcellipse_button(BEvent *, View *); 
void draw_arcellipse(Object *ob, View *view, GC gc, long x,long y, double rx, double ry);
void toggle_arcellipse(View *view, int x, int y); 
Tree trash_object(Tree t, List *lo, Object *ob);
Object *create_compound(View *view);
void add_to_compound(View *view, Object *ob); 
void compound_button(BEvent *bev, View *view);
void draw_compound(Object *ob, View *view, GC gc, long x, long y, double rx, double ry, long, long, long, long);
void compound_move(View *,Object *,long, long, long, long); 
void apply_scale_to_compound(View *view, Object *ob, double x, double y, long, long); 
void break_compound(View *view, Object *ob);
void commit_ellipse(View *, long, long); 
void commit_arc(View *view, long x, long y);
void commit_arcellipse(View *view, long x);
void commit_polygon(View *, long, long); 
void commit_rectangle(View *, long, long); 
void switch_icons(View *);
void kill_object(Object *);
Object *duplicate_object(Object *);
void cut_object(View *,Object *);
void copy_object(Object *);
void paste_object(View *,long,long);
void move_object(View *,Object *,long, long); 
void free_list(void *); 
void handle_dialog(XEvent report, ulong); 
void change_function(XEvent report);
void icon_chosen(XEvent report);
void fake_icon_chosen(IconType icon, Window parent);
void dialog_text_val(Window te, long val);
void icon_swap_pixmap(View *v, Window parent, int a, int b);
void set_text_just(View *); 
void place_cursor(View *view, int x, int y);
void new_text(BEvent *bev, View *view);
void insert_char(char *str, char c, int pos);
TextSection *new_section(View *view);
void add_char(View *,char *);
Boolean is_fluff(char *);
char *get_whole_line(void);
void parse_papersize(void);
Boolean string_eq(char *);
int stringcomp(char **a, char **b);
void skip_to_space(void);
double get_double(void);
int get_int(void);
int get_arc_open(void);
int get_line_style(void);
int get_fcolour(void);
int get_fill_fcolour(void);
int get_fill_colour(void);
ulong get_depth(void);
int get_fillstyle(Object *);
int get_capstyle(void);
int get_joinstyle(void); 
Arrow *parse_arrow(void);
void parse_colour_object(void);
void parse_vcomment(Object *); 
Object *parse_arc_ellipse(void);
Object *parse_compound(View *);
Object *parse_ellipse(void);
Object *parse_polyline(void);
VPoint *parse_point(Object *); 
SPoint *parse_spoint(Object *); 
Object *parse_spline(void);
Object *parse_text(View *);
void load(char *,Boolean cmdline);
void draw_arrow(View *view, GC gc, Arrow *arrow, int sx, int sy, int ex, int ey);     
Arrow *make_arrow(Arrow arrow);
void bent_midpoint(long,long,long,long,double, short *, short *); 
void set_arrow_radio(uint type, Window win);
void arc_button(BEvent *bev, View *view);
void toggle_arc(View *view, int x, int y);
Boolean arc_key(View *view, XKeyPressedEvent *report); 
void register_undo(int type, Object *ob, Document *doc);
List push_undo(List, Undo *);
Undo *pop_undo(List *);
void do_undo(void); 
void kill_undo(Undo *, int); 
void replace_undo_refs(Object *old,Object *new);
Object *undo_duplicate_object(Object *);
void clear_redo_stack(void); 
void nullify_sel_object(Document *doc);
void do_redo(void); 
void insert_file(Document *, char *,Boolean ,Boolean );
Boolean get_nearest_point(View *view, Tree t, long cx, long cy, long *x,long *y,Object **); 
List intersecting_objects_point(Tree t, long cx, long cy, List l);
void save(Document *d);
void save_name(Document *d, char *file); 
void derry_out(Object *ob);
void derry_check(Object *ob);
void linestyle_out(int ls);
void colour_out(int col);
void fillcolour_out(Object *ob);
void depth_out(ulong depth); 
void fillstyle_out(Object *ob); 
void joinstyle_out(int js); 
void capstyle_out(int es); 
void arrow_out(Arrow *arrow); 
void polyline_out(Object *ob);
void spline_out(Object *ob);
void polygon_out(Object *ob);
void roundbox_out(Object *ob);
void ellipse_out(Object *ob);
void arcellipse_out(Object *ob);
void text_out(Object *ob);
void compound_out(Object *ob);
void font_out(int num);
void add_derry(Object *,Object *,VPoint *); 
Object *get_object_by_ticket(Tree t, ulong ticket); 
void derry_move(View *, Object *, long, long); 
void remove_derry(View *v,Object *ob, VPoint *p);  
void delete_cache_list(List l); 
void store_redraw_object(Object *ob);
void send_stored_redraw_object(View *v, Object *ob);
void polyline_export(Object *); 
void spline_export(Object *); 
void polygon_export(Object *); 
void roundbox_export(Object *); 
void ellipse_export(Object *); 
void arcellipse_export(Object *); 
void text_export(Object *); 
void compound_export(Object *); 
char *export_name(Document *, char *, ExportType);
void start_help(void); 
void add_export_extension(int);
char *strip_dirname(char *); 
void redraw_view_window(View *view);
double sinround(double angle);
double cosround(double angle);
double flip_angle_y(double angle); 
double flip_angle_x(double angle); 
void flip_object_x(View *view, Object *ob);
void flip_object_x0(View *view, Object *ob,Boolean);
void flip_object_y(View *view, Object *ob);
void flip_object_y0(View *view, Object *ob,Boolean);
#endif

#endif
