#ifndef _FIGURINE_DEFINE_H
#define _FIGURINE_DEFINE_H

/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: define.h,v $
 * Revision 1.4  2001/01/31 15:38:06  movement
 * pre11 - fix netscape, add metapost support, credit foggy
 *
 * Revision 1.4  2001/01/29 20:57:31  moz
 * Make netscape work again, metapost support.
 *
 * Revision 1.3  2000/12/17 00:57:44  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:08  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:32  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:32  moz
 * CVS Import
 *
 * Revision 1.32  2000/03/09 01:06:03  moz
 * Compile fixes.
 *
 * Revision 1.31  2000/03/06 02:21:06  moz
 * is_in_bbox() all signed.
 *
 * Revision 1.30  2000/02/18 21:19:15  moz
 * Compile fix.
 *
 * Revision 1.29  2000/02/18 04:08:02  moz
 * Compile fixes.
 *
 * Revision 1.28  2000/02/17 22:25:18  moz
 * Compiler fixes.
 *
 * Revision 1.27  2000/01/29 21:27:07  moz
 * Fixed comment.
 *
 * Revision 1.26  2000/01/29 20:59:33  moz
 * Reduce maxpoints.
 *
 * Revision 1.25  2000/01/28 17:36:59  moz
 * "###FIGURINE" is 11 characters long !
 *
 * Revision 1.24  2000/01/26 18:25:17  moz
 * Add FIG_DEBUG_LIST_ALLOC.
 *
 * Revision 1.23  1999/11/29 20:35:06  moz
 * BBSIZE() renamed to avoid IRIX param.h namespace clash.
 *
 * Revision 1.22  1999/11/15 02:12:16  moz
 * Use enums where possible.
 * Name change.
 *
 * Revision 1.21  1999/08/17 00:38:10  moz
 * Sign P_IN_DOC.
 *
 * Revision 1.20  1999/08/09 00:17:02  moz
 * New selob() macros added.
 * IS_TEXT_FUNC() added.
 * NVIW() added.
 *
 * Revision 1.19  1999/06/30 17:42:50  moz
 * Change of view icon size.
 * Define caddr_t and S_IFDIR if not present (unlikely).
 *
 * Revision 1.18  1999/06/17 19:09:45  moz
 * PDERRY(), numstreq(), and is_vcomment() added.
 *
 * Revision 1.17  1999/06/16 00:57:52  moz
 * More fluid ROTATE_PIXEL_SIZE.
 *
 * Revision 1.16  1999/05/31 23:05:53  moz
 * SHAPE_ATTACH_THRESHOLD added.
 *
 * Revision 1.15  1999/05/22 23:39:47  moz
 *  Pedantic ANSI.
 *
 * Revision 1.14  1999/05/19 17:11:43  moz
 * 1.0 Checkin.
 *
 * Revision 1.13  1999/05/02 22:49:27  moz
 * UNDO_UNCOMPOUND added.
 *
 * Revision 1.12  1999/04/29 22:57:27  moz
 * VIEW_REDO added.
 *
 * Revision 1.11  1999/04/29 00:26:26  moz
 * Removed nodebox icon.
 *
 * Revision 1.10  1999/04/27 21:15:20  moz
 * HELP_TOOLTIPS added.
 *
 * Revision 1.9  1999/04/27 16:58:42  moz
 * FLIP_X and FLIP_Y defined.
 *
 * Revision 1.8  1999/04/27 07:40:59  moz
 * Defined UNDO_IGNOREME
 *
 * Revision 1.7  1999/04/26 20:00:22  moz
 * min3,max3 convenience macros.
 *
 * Revision 1.6  1999/04/25 00:21:56  moz
 * Added ROTATE_PIXEL_SIZE
 *
 * Revision 1.5  1999/04/24 22:24:34  moz
 * Removed macro cruft.
 * Added UCOLOUR deref macro.
 *
 * Revision 1.4  1999/04/23 00:40:32  moz
 * Start to move out old macros from code.
 *
 * Revision 1.3  1999/04/22 22:18:00  moz
 * Define ulong.
 * UNDO_COMPOUND added.
 *
 * Revision 1.2  1999/04/04 01:50:23  moz
 * Defines for exporting.
 *
 * Revision 1.1  1999/03/30 00:09:58  moz
 * Initial revision
 *
 */

#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h> 
#include <limits.h>
#include <sys/param.h>
#include <stdio.h>
#include <X11/cursorfont.h> 

/* define ulong and uint */
#undef ulong
#define ulong unsigned long
#undef uint
#define uint unsigned int
 
#ifndef caddr_t
#define caddr_t char *
#endif

#ifndef __LINE__
#define __LINE__ 0
#endif

#ifndef S_IFDIR
#define S_IFDIR 0040000
#endif 

#define FAIL -1
/* used in icon_chosen()  */  
#define MATCHED -1 

#define LETTER_INCH_WIDTH  8.5
#define LETTER_INCH_HEIGHT 11

/* proves quite useful  */  
#undef PI 
#define PI   3.14159265358979323846   
 
#ifndef BLACK
#	define BLACK 0
#endif

#ifndef WHITE
#	define WHITE 1
#endif

/* used by ellipse_box  */  
#define NO_INTERSECT 0 
#define CONTAINS 1
#define CONTAINED 2
 
/* button stuff  */
#define BUTTON_HELD 1
#define BUTTON_CLICKED 2
#define BUTTON_RELEASED 3

/* these are defined for the ruler movement functions  */  
#define LEFT -1 
#define CENTRE 0 
#define RIGHT 1
#define UP -1
#define DOWN 1
 
/* line styles  */
typedef enum { SOLID, DASHED, DOTTED, DASH_DOTTED, DASH_DOUBLE_DOTTED, DASH_TRIPLE_DOTTED } LineStyle;

/* arrow styles  */  
typedef enum { ARROWSTICK, ARROWFLAT, ARROWINDENTED, ARROWPOINTED } ArrowStyle;
 
/* undo types  */   
typedef enum { UNDO_VOID, UNDO_OB_PROP, UNDO_CUT, UNDO_PASTE, UNDO_COMPOUND, UNDO_UNCOMPOUND } UndoType;
 
/* for scaling, which corner stays tied  */  
typedef enum { NOTSCALING, TOPLEFT, TOPRIGHT, BOTTOMLEFT, BOTTOMRIGHT } ScalingCorner;

/* object types  */
typedef enum { POLYLINE=1, ELLIPSE, TEXT, RECTANGLE, POLYGON, 
               SPLINE, ROUNDBOX, ARCELLIPSE, COMPOUND, NODE, ARC } ObjectType;

/* export file types  */  
/* these are *dependent* on ordering of textlist creation in init.c  */  
typedef enum {  EXPORT_LATEX_BOX, EXPORT_EEPIC, EXPORT_EEPICEMU, EXPORT_EPIC,
		EXPORT_EPS, EXPORT_GIF, EXPORT_IBMGL, EXPORT_JPEG, EXPORT_LATEX_PICTURE, 
		EXPORT_METAFONT, EXPORT_METAPOST, EXPORT_MULTIMETAPOST, EXPORT_PCX, EXPORT_PIC, EXPORT_PICTEX, EXPORT_PNG,
		EXPORT_PPM, EXPORT_PS, EXPORT_PSLATEX, EXPORT_AUTOCAD, EXPORT_TEXTYL, 
		EXPORT_TIFF, EXPORT_TPIC, EXPORT_XBM, EXPORT_XPM } ExportType;

/* defines used for STK communication  */ 
typedef enum { RECTANGLEICON=1, ELLIPSEICON, POLYGONICON, SPLINEICON, NODEICON, POLYLINEICON, 
               TEXTICON, POINTERICON, EYEICON, GRIDICON, LINESTYLEICON, SOLIDICON, DASHEDICON, 
               DOTTEDICON, DASHDOTTEDICON, DASHDOUBLEDOTTEDICON, DASHTRIPLEDOTTEDICON, 
               FILLSTYLEICON, COLOURICON, FILLCOLOURICON, ARCELLIPSEICON, COMPOUNDICON, ARCICON, 
               BOXELLIPSEICON, SHOWGRIDICON, ZOOMINICON, ZOOMOUTICON, ARROWICON, SETPOLYGONICON, 
               ENDSTYLEICON, JOINSTYLEICON, FONTICON, LINEWIDTHICON, SETSPLINEICON, ROUNDBOXICON, 
               JUSTIFICATIONICON, ROUNDENDICON, FLATENDICON, PROJECTINGENDICON, ROUNDJOINICON, 
               SHARPJOINICON, BEVELJOINICON, SETARCELLIPSEICON, CLOSEDARCELLIPSEICON, 
               OPENARCELLIPSEICON, LEFTJUSTICON, CENTREJUSTICON, RIGHTJUSTICON } IconType;

/* leave 200-300 for fill styles */
#define NONE -1 
#define STARTOFFILLSTYLES 200
#define FILLSTYLENONE 243 

/* leave 300-400 for colours  */  
#define STARTOFCOLOURS 300
typedef enum { CBLACK=300, CBLUE, CGREEN, CCYAN, CRED, CMAGENTA, CYELLOW, CWHITE, CBLUE4, CBLUE3, CBLUE2, 
               CLIGHTBLUE, CGREEN4, CGREEN3, CGREEN2, CCYAN4, CCYAN3, CCYAN2, CRED4, CRED3, CRED2, CMAGENTA4, 
               CMAGENTA3, CMAGENTA2, CBROWN4, CBROWN3, CBROWN2, CPINK4, CPINK3, CPINK2, CPINK, CGOLD } ColourType;

/* leave 400-500 for fillcolours  */  
#define STARTOFFILLCOLOURS 400
typedef enum { FILLCBLACK=400, FILLCBLUE, FILLCGREEN, FILLCCYAN, FILLCRED, FILLCMAGENTA, 
               FILLCYELLOW, FILLCWHITE, FILLCBLUE4, FILLCBLUE3, FILLCBLUE2, FILLCLIGHTBLUE, FILLCGREEN4, FILLCGREEN3, 
               FILLCGREEN2, FILLCCYAN4, FILLCCYAN3, FILLCCYAN2, FILLCRED4, FILLCRED3, FILLCRED2, FILLCMAGENTA4, 
               FILLCMAGENTA3, FILLCMAGENTA2, FILLCBROWN4, FILLCBROWN3, FILLCBROWN2, FILLCPINK4, FILLCPINK3, 
               FILLCPINK2, FILLCPINK, FILLCGOLD } FillColourType;

#define FILE_NEW 100
#define FILE_OPEN 101
#define VIEW_UNDO 102 
#define FILE_INSERT 103 
#define FILE_QUIT 110
#define HELP_CONTENTS 111 
#define FILE_SAVE 122
#define FILE_SAVE_AS 123
#define FILE_CLOSE 124
#define FILE_EXPORT 125
#define NEW_VIEW 126
#define VIEW_SETTINGS 127
#define FILE_PRINT 128 
#define EDIT_CUT 129
#define EDIT_COPY 130
#define EDIT_PASTE 131
#define EDIT_DELETE 132
#define EDIT_RAISE 133
#define EDIT_LOWER 134
#define FLIP_X 135
#define FLIP_Y 136
#define HELP_TOOLTIPS 137
#define VIEW_REDO 138 

/* justification values  */  
#define J_FILE_SLIDERS 3
#define J_FILE_BUTTONS 4 
#define J_GRID 5 
#define J_VIEW_BUTTONS 6 
#define J_UNITS 7 
#define J_ARROW1 8
#define J_ARROW2 9
#define J_ARROW3 10

/* constrictions  */  

#ifdef PATH_MAX
#	define FIGURINE_PATH_MAX PATH_MAX
#else
#	define FIGURINE_PATH_MAX 1024
#endif

#ifdef MAXHOSTNAMELEN
#	define FIGURINE_HOSTNAME_MAX MAXHOSTNAMELEN
#else
#	define FIGURINE_HOSTNAME_MAX 1024
#endif

#define POINTS_IN_INCH 72.27
/* this affects the ability to render filled splines */
/* this is a reasonable value, if you have problems with */ 
/* filling the filled spline : */  
/* a) wonder what you're doing with such a complex spline */  
/* b) increase this number and recompile */  
#define MAXPOINTS 5000
#define MIN_ZOOM 0.2
#define MAX_ZOOM 20.0
#define USER_ZOOM -1 
#define ZOOM_MULT 1.1 
#define RULER_PIXEL_SIZE 20
#define HANDLE_PIXEL_SIZE 8 
/* defines the distance needed to move the mouse for rotation 
   smaller amounts rotate more sharply, but less smoothly */  
#define ROTATE_PIXEL_SIZE 200 
/* difference at which an angle should mean rectilinear rotation */  
#define ROTATE_RECTI_THRESHOLD .02 
#define VIEW_ICON_SIZE 25
#define VIEW_ICON_WIDTH 25 
#define GUIDE_LINE_GAP 30 
#define NUM_FILLSTYLES 43
#define RELEASE_DEFAULTS_LATENCY 300 /* in ms, the time before a held mouse button defaults to drawing starting */  
#define MOVE_BOUNDARY 20 /* pixel border when drawing to scroll document  */ 
#define MIN_GRID_PIXEL_SEPARATION 10 /* greek out the grid when grid_x or grid_y is very small on screen  */ 
#define POINTER_JUMP_SIZE 20 /* max number of pixels the pointer can jump when editing points  */  
#define SELECT_PIXEL_LOOSENESS 3 /* pixels around object that select it (for 1-pixel wide lines)  */  
#define SHAPE_ATTACH_THRESHOLD 0.1 /* shape factors below this are considered to be co-incident with point */  

/* window types  */ 
#define MAIN_VIEW_WIN 1
#define RULER_X_WIN 2
#define RULER_Y_WIN 3
#define DRAW_WIN 4 
#define VIEW_ICON_WIN 5

/* MACROS  */

/* these are used for values stored in list,
	casting the ->data to the correct type */  
#define DOC(a) ((Document *)((a)->data)) 
#define WS(a) ((WindowStruct *)((a)->data))
#define VIEW(a) ((View *)((a)->data)) 
#define OB(a) ((Object *)(a)->data) 
#define POINT(a) ((VPoint *)(a)->data) 
#define SPOINT(a) ((SPoint *)(a)->data) 
#define FONT(a) ((VFont *)(a)->data) 
#define TEXTSEC(a) ((TextSection *)(a)->data) 
#define TEXTLINE(a) ((TextLine *)(a)->data) 
#define DERRY(a) ((Derry *)(a)->data) 
#define PDERRY(a) ((PDerry *)(a)->data)
#define UCOLOUR(a) ((UColour *)(a)->data)
#define UNDO(a) ((Undo *)(a)->data) 
 
/* obvious utility macros  */  
#define max(a,b) (((a)>(b)) ? (a) : (b))   
#define min(a,b) (((a)<(b)) ? (a) : (b))   
#define min3(a,b,c) min((a),min((b),(c)))
#define max3(a,b,c) max((a),max((b),(c)))
#define abs(a)  ((a)<0 ? -(a) : (a)) 
#define sqr(a)  ((a)*(a)) 
#define streq(a,b) (!strcmp((a),(b))) 
#define numstreq(a,b,c) (!strncmp((a),(b),(c))) 
#define between(t,a,b) ((t)>(a) && (t)<(b)) 
#define is_vcomment(a) (numstreq((a),"###FIGURINE",11))
#define selobtype(v,t) ((v)->selected_object!=NULL && (v)->selected_object->ob->type==(t))
#define isselob(v) ((v)->selected_object!=NULL)
#define selob(v) ((v)->selected_object->ob) 
#define NVIW(v) ((v) ? (v->view_icon_window->win) : (Window)-1) 
	 
 
#define R(a,b) ((long)(((double)(a))*(b)))
 
/* gnarly scaling stuff with view  */
/* usage FUNC(double value, View *view) or similar */
#define ZPO(a,v) (int)(((double)((a)*10))*(v)->zoom_factor) /* zoomed screen point size from nominal */  
#define P2I(a,v) ((double)(a))/(screen_ppi*(v)->zoom_factor)  /* pixels to inches at current zoom  */ 
#define I2P(a,v) ((long)((a)*screen_ppi*(v)->zoom_factor)) /* inches to pixels at current zoom  */ 
#define I2D(a,v) ((long)((a)*(v)->doc->ppi)) /* inches to document pixels */  
#define D2I(a,v) (((double)(a)/(v)->doc->ppi)) /* doc pixels to inches  */  
#define M2I(a)   ((a)/25.4) /* mm to inches conversion  */  
#define I2M(a)   ((a)*25.4) /* inches to mm conversion  */  
#define D2P(a,v) ((long)((((a))*(screen_ppi*(v)->zoom_factor))/(v)->doc->ppi))
#define P2D(a,v) ((long)(((a)*(v)->doc->ppi)/(screen_ppi*(v)->zoom_factor)))

/* pixels to document, with offset  */  
#define XP2D(a,v) ((long)((((a)*(v)->doc->ppi)/((v)->zoom_factor*screen_ppi))) + I2D((v)->x_inches_offset,v)+1)
#define YP2D(a,v) ((long)((((a)*(v)->doc->ppi)/((v)->zoom_factor*screen_ppi))) + I2D((v)->y_inches_offset,v)+1)

/* pixels to document, snapped to grid  */  
#define GXP2D(a,v) snap((v)->grid_x,((long)((((a)*(v)->doc->ppi)/((v)->zoom_factor*screen_ppi))) + I2D((v)->x_inches_offset,v)+1))
#define GYP2D(a,v) snap((v)->grid_y,((long)((((a)*(v)->doc->ppi)/((v)->zoom_factor*screen_ppi))) + I2D((v)->y_inches_offset,v)+1))

#define XD2P(a,v) ((long)((((a)-I2D((v)->x_inches_offset,v))*(screen_ppi*(v)->zoom_factor))/(v)->doc->ppi))
#define YD2P(a,v) ((long)((((a)-I2D((v)->y_inches_offset,v))*(screen_ppi*(v)->zoom_factor))/(v)->doc->ppi))

/* useful measure of bbox size  */  
#define FIG_BBSIZE(b) ((ulong)(((b).x2-(b).x1)*((b).y2-(b).y1)))

/* pixel bounds of doc  */  
#define DOCPBOUNDS(v) XD2P(0,(v)), YD2P(0,(v)), XD2P(0,(v))+XD2P(I2D((v)->doc->width_in_inches,(v)),(v)), XD2P(0,(v))+YD2P(I2D((v)->doc->height_in_inches,(v)),(v)) 
/* document bounds of doc  */  
#define DOCDBOUNDS(v) 0, 0, I2D((v)->doc->width_in_inches,(v)), I2D((v)->doc->height_in_inches,(v)) 
 
/* is a pixel in the document window ?  */  
#define P_IN_DOC(x,y,v)  is_in_bbox(((int)x),((int)y), 0, 0, (int)(v)->draw_window->w, (int)(v)->draw_window->h)

#define INCHES_TO_PIXELS(a) ((int)((a)*screen_ppi)) 
#define MM_TO_INCHES(a) ((a)/25.4)
#define INCHES_TO_MM(a) ((a)*25.4)

#define REDRAW_ALL_WINDOW(a) (send_redraw((a),0,0,(int)(a)->w,(int)(a)->h))
#define SET_CLIP_WINDOW(g,l) (set_clip((g),0,0, (int)((l)->w), (int)((l)->h)))
   
/* is a text cursor wanted ?  */ 

#define IS_TEXT_FUNC(a) ((a)==NODEICON || (a)==TEXTICON) 
 
/* provides pixel co-ords for edges of doc  */  
/* returns 4 ,-separated values x1,y1,x2,y2  */ 

#define DOC_PIXEL_BOUNDS(l) 		DOC_PIXEL_BOUNDS_V(VIEW(l))

#define DOC_PIXEL_BOUNDS_V(v) 	I2P(0-v->x_inches_offset,(v)), \
											I2P(0-v->y_inches_offset,(v)), \
									 		I2P(v->doc->width_in_inches-v->x_inches_offset,(v)), \
									 		I2P(v->doc->height_in_inches-v->y_inches_offset,(v)) 
											 
/* test for inside document borders  */ 
/* use DRAW_WIN relative pixels co-ords  */ 
#define IS_IN_DOC(x,y,l) is_in_bbox((x),(y),DOC_PIXEL_BOUNDS((l)))
 
/* constrain between two points  */  
/* minval is lowest, maxval is highest */  
#define MINMAX(val,minval,maxval) min(max((val),(minval)),(maxval))

/* debuggin output */  

#ifndef FIG_DEBUG_LIST_ALLOC 
#define add_to_list(a,b,c,d) add_to_list0((a),(b),(c),(d))
#define add_to_list_neq(a,b,c,d) add_to_list_neq0((a),(b),(c),(d))
#else
#define add_to_list(a,b,c,d) add_to_list0((a),(b),(c),(d)); \
   fprintf(stderr, "figurine: add_to_list called from " __FILE__ " line %d\n", __LINE__)
#define add_to_list_neq(a,b,c,d) add_to_list_neq0((a),(b),(c),(d)); \
   fprintf(stderr, "figurine: add_to_list_neq called from " __FILE__ " line %d\n", __LINE__)
#endif

#define E(a) fprintf(stderr,(a))
#define v_error(d) fprintf(stderr,"figurine: BUG at "__FILE__ " line %d: %d\n", __LINE__, (d))
 
#endif
