<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).
*/

static $supporteddbs = array (
    'dbase' => 'dBASE',
    'fbsql' => 'FrontBase',
    'ibase' => 'Interbase',
    'ifx'   => 'Informix',
    'msql'  => 'MiniSQL',
    'mssql' => 'Microsoft SQL Server',
    'mysql' => 'mySQL',
    'oci8'  => 'Oracle 7/8/8i',
    'odbc'  => 'ODBC',
    'pgsql' => 'PostgreSQL',
    'sybase'=> 'Sybase'
);

function checklanguage( $l )
{
    if( preg_match( '/[a-z]{2,5}/i', $l ) && is_readable( "lang/$l.php" ) )
	return $l;
    else
	return '';
}

session_start();
$HTTP_SESSION_VARS['lang'] = null;

# read configuration file
$mypath = pathinfo( $HTTP_SERVER_VARS['SCRIPT_FILENAME'] );
$cfgfile = $mypath['dirname'] . '/fibusql.conf';
if( is_readable( $cfgfile ) ) {
    $cfg = parse_ini_file( $cfgfile, TRUE );

    # interface section 
    $HTTP_SESSION_VARS['lang'] = checklanguage( $cfg['interface']['language'] );
    if( $cfg['interface']['decimalsep'] == '.' || $cfg['interface']['decimalsep'] == ',' )
	$HTTP_SESSION_VARS['decimalsep'] = $cfg['interface']['decimalsep'];
    if( $cfg['interface']['thousandsep'] == '.' || $cfg['interface']['thousandsep'] == ',' || 
	$cfg['interface']['thousandsep'] == "'" )
	$HTTP_SESSION_VARS['thousandsep'] = $cfg['interface']['thousandsep'];

    # login section; use only if complete
    if( $cfg['login']['dbtype'] && $cfg['login']['dbname'] &&
	$cfg['login']['user'] && $cfg['login']['host'] &&
	( $cfg['login']['password'] || !$cfg['login']['usepwd'] ) ) {
	$pwd = $cfg['login']['usepwd'] ? ':' . rawurlencode( $cfg['login']['password'] ) : '';
	$HTTP_SESSION_VARS['dbspec'] = $cfg['login']['dbtype'] .'://' . $cfg['login']['user'] .
	      $pwd . '@'.$cfg['login']['host'].'/'.$cfg['login']['dbname'];

	# directly go to start page, no login form necessary
	header( 'Location: about.php' );
	exit;
    }
} 

 # Formular based login
if( $HTTP_GET_VARS['host'] && $HTTP_GET_VARS['dbname'] &&
    $HTTP_GET_VARS['type'] && $HTTP_GET_VARS['user'] &&
    !$HTTP_GET_VARS['setonly'] ) {
    if( $HTTP_GET_VARS['password'] ) 
	$pwd = ':' . rawurlencode( $HTTP_GET_VARS['password'] );
    else
	$pwd = '';

    $HTTP_SESSION_VARS['dbspec'] = 
	( $HTTP_GET_VARS['type'] . '://' .  $HTTP_GET_VARS['user'] . $pwd
	. '@' . $HTTP_GET_VARS['host'] . '/' .  $HTTP_GET_VARS['dbname'] );

    $HTTP_SESSION_VARS['lang'] = checklanguage( $HTTP_GET_VARS['lang'] );

    if( $HTTP_GET_VARS['decimalsep'] == '.' || $HTTP_GET_VARS['decimalsep'] == ',' )
	$HTTP_SESSION_VARS['decimalsep'] = $HTTP_GET_VARS['decimalsep'];

    if( $HTTP_GET_VARS['thousandsep'] == 'apos' )
	$HTTP_SESSION_VARS['thousandsep'] = "'";
    else if( $HTTP_GET_VARS['thousandsep'] == '.' || $HTTP_GET_VARS['thousandsep'] == ',' )
	$HTTP_SESSION_VARS['thousandsep'] = $HTTP_GET_VARS['thousandsep'];

    header( 'Location: about.php' );
    exit;
}

include_once 'langinc.inc';
include get_lang_inc( '-login' );
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">

<html>
<head>
   <title>FibuSQL</title>
   <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
   <meta name="author" content="Martin Pitt (piware@piware.de)" />
   <link rel="stylesheet" href="fibu.css" />
</head>

<body>

<h2><?php echo $LANG_logintitle ?></h2>

<form action="<?php echo $HTTP_SERVER_VARS['PHP_SELF'] ?>" method="get">
<table>

<tr><th><?php echo $LANG_host ?>:</th><td>
<?php if( $HTTP_GET_VARS['host'] ) { ?>
  <input type="hidden" name="host" value="<?php echo $HTTP_GET_VARS['host'] ?>" />
  <span class="fixed"><?php echo $HTTP_GET_VARS['host'] ?></span>
<?php } else { ?>
  <input type="text" size="30" name="host" />
<?php } ?> </td></tr>

<tr><th><?php echo $LANG_dbname ?>:</th><td>
<?php if( $HTTP_GET_VARS['dbname'] ) { ?>
  <input type="hidden" name="dbname" value="<?php echo $HTTP_GET_VARS['dbname'] ?>" />
  <span class="fixed"><?php echo $HTTP_GET_VARS['dbname'] ?></span>
<?php } else { ?>
  <input type="text" size="30" name="dbname" />
<?php } ?> </td></tr>

<tr><th><?php echo $LANG_dbtype ?>:</th><td>
<?php if( array_key_exists( $HTTP_GET_VARS['type'], $supporteddbs ) ) { ?>
  <input type="hidden" name="type" value="<?php echo $HTTP_GET_VARS['type'] ?>" />
  <span class="fixed"><?php echo $HTTP_GET_VARS['type'] ?></span>
<?php 
    } else {
	echo "<select name=\"type\">\n";
	foreach( $supporteddbs as $k => $v ) {
	    echo "<option value=\"$k\"";
	    if( $HTTP_GET_VARS['type'] == $k) echo ' selected="selected"';
	    echo ">$v</option>\n";
	}
	echo "</select>\n";
    }
?>
</td></tr>  

<tr><th><?php echo $LANG_user ?>:</th><td>
<?php if( $HTTP_GET_VARS['user'] ) { ?>
  <input type="hidden" name="user" value="<?php echo $HTTP_GET_VARS['user'] ?>" />
  <span class="fixed"><?php echo $HTTP_GET_VARS['user'] ?></span>
<?php } else { ?>
  <input type="text" size="30" name="user" />
<?php } ?> </td></tr>

<tr><th><?php echo $LANG_passwd ?>:</th><td>
<?php if( $HTTP_GET_VARS['password'] ) { ?>
  <input type="hidden" name="password" value="<?php echo $HTTP_GET_VARS['password'] ?>" />
  <?php echo $LANG_pwdset ?>
<?php } else { ?>
  <input type="password" size="30" name="password" />
<?php } ?>
</td></tr>

<tr><td>&nbsp;</td></tr>

<tr><th><?php echo $LANG_language ?>:</th><td>
  <select name="lang">
    <option value="0" 
	<?php if( !$HTTP_GET_VARS['lang'] ) echo 'selected="selected"'; ?>
	><?php echo $LANG_langbrowser ?></option>
    <option value="de" 
	<?php if( $HTTP_GET_VARS['lang'] == 'de') echo 'selected="selected"'; ?>
	>Deutsch</option>
    <option value="en" 
	<?php if( $HTTP_GET_VARS['lang'] == 'en') echo 'selected="selected"'; ?>
	>English</option>
  </select>
</td></tr>  

<tr><th><?php echo $LANG_decimalpoint ?>:</th><td>
  <input type="radio" name="decimalsep" value="," 
  <?php if( $HTTP_GET_VARS['decimalsep'] == ',' ) echo 'checked="checked"' ?> />1,23
  <input type="radio" name="decimalsep" value="." 
  <?php if( $HTTP_GET_VARS['decimalsep'] == '.' ) echo 'checked="checked"' ?> />1.23
</td></tr>  

<tr><th><?php echo $LANG_thousandsep ?>:</th><td>
  <input type="radio" name="thousandsep" value="apos" 
  <?php if( $HTTP_GET_VARS['thousandsep'] == "apos" ) echo 'checked="checked"' ?> />1'000
  <input type="radio" name="thousandsep" value="." 
  <?php if( $HTTP_GET_VARS['thousandsep'] == '.' ) echo 'checked="checked"' ?> />1.000
  <input type="radio" name="thousandsep" value="," 
  <?php if( $HTTP_GET_VARS['thousandsep'] == ',' ) echo 'checked="checked"' ?> />1,000
  <input type="radio" name="thousandsep" value="no" 
  <?php if( $HTTP_GET_VARS['thousandsep'] == 'no' ) echo 'checked="checked"' ?> />1000
</td></tr>  

<tr><td>&nbsp;</td></tr>

<tr><td><input type="submit" name="login" value=" <?php echo $LANG_login ?> " /></td>
<td>(<?php echo $LANG_proceedtostart ?>)</td></tr>

<tr><td><input type="submit" name="setonly" value="<?php echo $LANG_takeover ?>"/></td>
    <td>(<?php echo $LANG_takeovernote ?>)</td></tr>

</table>
</form>

<p><?php echo $LANG_docrefer ?></p>

</body>
</html>
