<?php
/*
    FibuSQL 0.4.1  -  (c) 2003 Martin Pitt <martin@piware.de>

    This software is protected by the GNU General Public License (see
    file COPYING).

    Backend module:
    for every past due date, insert appropriate transaction and update due date
    HTML output must already be possible, so insert after pagehead-html!
*/

include_once 'invalbal.inc';

do {
    $res = $db->query( 'select * from repeated where nextdue <= CURRENT_TIMESTAMP' );
    if( DB::isError( $res ) ) break;

    $changed = 0;
    while( $row = $res->fetchRow() ) {
	$changed = 1;
	
	# insert appropriate transaction into journal
	$newid = $db->getOne( 'select max(id) from journal' ) + 1;
	check_res( $newid, $LANG_err_maxidj );
	if( !$row[4] )
	    $row[4] = 'null';
	$r = $db->query( "insert into journal values( $newid, $row[1], $row[2], $row[3], $row[4], '$row[5]', '$row[6]' )" );
	check_res( $r, $LANG_err_insertj );
	invalidate_balance( $row[1] );
	invalidate_balance( $row[2] );

	$nextDue = $db->getRow( 'select extract(YEAR from nextDue), extract(MONTH from nextDue), 
	    extract(DAY from nextDue), extract(HOUR from nextDue),
	    extract(MINUTE from nextDue) from repeated where id='.$row[0] );
	check_res( $nextDue, $LANG_err_extracttime );

	# update due date
	if( $row[7] ) {  # daily
	    $d = sprintf( '%04d-%02d-%02d', $nextDue[0], $nextDue[1], $nextDue[2] );
	    $t = sprintf( '%02d:%02d', $nextDue[3], $nextDue[4] );
	    $newdate = strftime( '%Y-%m-%d', strtotime( $d ) + $row[7] * 86400) .' '.$t;
	}
	else { # monthly
	    $nextDue[1] += $row[8]; # add months
	    while( $nextDue[1] > 12 ) { # months modulo 12
		++$nextDue[0];
		$nextDue[1] -= 12;
	    }

	    $newdate = sprintf( '%04d-%02d-%02d %02d:%02d', $nextDue[0], $nextDue[1], 
		$nextDue[2], $nextDue[3], $nextDue[4] );
	}

	check_res( $db->query( "update repeated set nextdue = '$newdate' where id=$row[0]" ),
		    $LANG_err_updaterep );
    }
} while( $changed );

?>
