"""Here are defined all global constants."""


from os.path import expanduser, join, pardir


# FGo! related constants.
NAME = 'FGo! 1.5.2'
USER_AGENT = 'FGo!/1.5.2 (+http://sites.google.com/site/erobosprojects/flightgear/add-ons/fgo)'
COPYRIGHT = "Copyright 2009-2014 by\nRobert 'erobo' Leda  <erobo@wp.pl>"
LICENSE = \
"""This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.
"""
HOME_DIR = expanduser('~')  # User's home directory.
USER_DATA_DIR = join(HOME_DIR, '.fgo')  # Default directory for user data files.
APT = join(USER_DATA_DIR, 'apt')  # Path to airport data file.
INSTALLED_APT = join(USER_DATA_DIR, 'apt_installed')  # Path to locally installed airport list.
CONFIG = join(USER_DATA_DIR, 'config')  # Path to config file.
APT_TIMESTAMP = join(USER_DATA_DIR, 'timestamp')  # Path to apt.dat.gz timestamp file.
DATA_DIR = join(pardir, 'data')
DEFAULT_CONFIG_DIR = join(DATA_DIR, 'config')  # Path to default config directory.
PRESETS = join(DEFAULT_CONFIG_DIR, 'presets')  # Path to config file with predefined settings.
HELP_DIR = join(DATA_DIR, 'help')  # Path to help directory.
LOCALE_DIR = join(DATA_DIR, 'locale')  # Name of directory where localization files are stored.
MESSAGES = 'messages'  # Name of localization file.
NO_PIL_PIC = join(DATA_DIR, 'pics', 'thumbnail.ppm')  # Path to substitutionary thumbnail.
NO_THUMBNAIL_PIC = join(DATA_DIR, 'pics', 'thumbnail.jpg')  # Path to substitutionary thumbnail.
CUT_LINE = ' INTERNAL OPTIONS ABOVE. EDIT CAREFULLY! '.center(80, 'x')
DEFAULT_AIRCRAFT = 'c172p'
DEFAULT_AIRPORT = 'KSFO'
DEFAULT_PORT = '5501'  # Default port for TerraSync.
TOOLTIP_DELAY = 600  # Tooltip delay in milliseconds.
# Custom colors.
CARRIER_COL = '#98afd9'  # Color to highlight background for carrier name in the main window.
COMMENT_COL = '#0014a7'  # Color to highlight comments in text window.
GRAYED_OUT_COL = '#b2b2b2'  # Color to apply to rwy button when inactive.
MESSAGE_BG_COL = '#fffeb2'  # Background color for various messages.
TEXT_BG_COL = '#ffffff'  # Background color for various text windows.

# FG related constants.
AI_DIR = 'AI'  # FG_DATA/AI directory name.
DEFAULT_AIRCRAFT_DIR = 'Aircraft'  # FG_DATA/Aircraft directory name.
DEFAULT_AIRPORTS_DIR = 'Airports'  # FG_DATA(or FG_SCENERY)/Airports directory name.
APT_DAT = join('Airports', 'apt.dat.gz')  # FG_DATA/Airports/apt.dat.gz file path.
METAR_DAT = join('Airports', 'metar.dat.gz')  # FG_DATA/Airports/apt.dat.gz file path.
