/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:43:28 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_twiddle_c -simd -compact -variables 4 -n 15 -name t1fv_15 -include t1f.h */

/*
 * This function contains 92 FP additions, 53 FP multiplications,
 * (or, 78 additions, 39 multiplications, 14 fused multiply/add),
 * 52 stack variables, and 30 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twiddle_c.ml,v 1.7 2003/04/16 19:51:27 athena Exp $
 */

#include "t1f.h"

static const R *t1fv_15(R *ri, R *ii, const R *W, stride ios, int m, int dist)
{
     DVK(KP216506350, +0.216506350946109661690930792688234045867850657);
     DVK(KP484122918, +0.484122918275927110647408174972799951354115213);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DVK(KP509036960, +0.509036960455127183450980863393907648510733164);
     DVK(KP823639103, +0.823639103546331925877420039278190003029660514);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     R *x;
     x = ri;
     BEGIN_SIMD();
     for (i = m; i > 0; i = i - VL, x = x + (VL * dist), W = W + (TWVL * 28)) {
	  V T1e, T7, TP, T12, T15, Tf, Tn, To, T1b, T1c, T1f, TQ, TR, TS, Tw;
	  V TE, TF, TT, TU, TV;
	  {
	       V T1, T5, T3, T4, T2, T6;
	       T1 = LD(&(x[0]), dist, &(x[0]));
	       T4 = LD(&(x[WS(ios, 10)]), dist, &(x[0]));
	       T5 = BYTWJ(&(W[TWVL * 18]), T4);
	       T2 = LD(&(x[WS(ios, 5)]), dist, &(x[WS(ios, 1)]));
	       T3 = BYTWJ(&(W[TWVL * 8]), T2);
	       T1e = VSUB(T5, T3);
	       T6 = VADD(T3, T5);
	       T7 = VADD(T1, T6);
	       TP = VFNMS(LDK(KP500000000), T6, T1);
	  }
	  {
	       V T9, Tq, Ty, Th, Te, T13, Tv, T10, TD, T11, Tm, T14;
	       {
		    V T8, Tp, Tx, Tg;
		    T8 = LD(&(x[WS(ios, 3)]), dist, &(x[WS(ios, 1)]));
		    T9 = BYTWJ(&(W[TWVL * 4]), T8);
		    Tp = LD(&(x[WS(ios, 6)]), dist, &(x[0]));
		    Tq = BYTWJ(&(W[TWVL * 10]), Tp);
		    Tx = LD(&(x[WS(ios, 9)]), dist, &(x[WS(ios, 1)]));
		    Ty = BYTWJ(&(W[TWVL * 16]), Tx);
		    Tg = LD(&(x[WS(ios, 12)]), dist, &(x[0]));
		    Th = BYTWJ(&(W[TWVL * 22]), Tg);
	       }
	       {
		    V Tb, Td, Ta, Tc;
		    Ta = LD(&(x[WS(ios, 8)]), dist, &(x[0]));
		    Tb = BYTWJ(&(W[TWVL * 14]), Ta);
		    Tc = LD(&(x[WS(ios, 13)]), dist, &(x[WS(ios, 1)]));
		    Td = BYTWJ(&(W[TWVL * 24]), Tc);
		    Te = VADD(Tb, Td);
		    T13 = VSUB(Td, Tb);
	       }
	       {
		    V Ts, Tu, Tr, Tt;
		    Tr = LD(&(x[WS(ios, 11)]), dist, &(x[WS(ios, 1)]));
		    Ts = BYTWJ(&(W[TWVL * 20]), Tr);
		    Tt = LD(&(x[WS(ios, 1)]), dist, &(x[WS(ios, 1)]));
		    Tu = BYTWJ(&(W[0]), Tt);
		    Tv = VADD(Ts, Tu);
		    T10 = VSUB(Tu, Ts);
	       }
	       {
		    V TA, TC, Tz, TB;
		    Tz = LD(&(x[WS(ios, 14)]), dist, &(x[0]));
		    TA = BYTWJ(&(W[TWVL * 26]), Tz);
		    TB = LD(&(x[WS(ios, 4)]), dist, &(x[0]));
		    TC = BYTWJ(&(W[TWVL * 6]), TB);
		    TD = VADD(TA, TC);
		    T11 = VSUB(TC, TA);
	       }
	       {
		    V Tj, Tl, Ti, Tk;
		    Ti = LD(&(x[WS(ios, 2)]), dist, &(x[0]));
		    Tj = BYTWJ(&(W[TWVL * 2]), Ti);
		    Tk = LD(&(x[WS(ios, 7)]), dist, &(x[WS(ios, 1)]));
		    Tl = BYTWJ(&(W[TWVL * 12]), Tk);
		    Tm = VADD(Tj, Tl);
		    T14 = VSUB(Tl, Tj);
	       }
	       T12 = VSUB(T10, T11);
	       T15 = VSUB(T13, T14);
	       Tf = VADD(T9, Te);
	       Tn = VADD(Th, Tm);
	       To = VADD(Tf, Tn);
	       T1b = VADD(T13, T14);
	       T1c = VADD(T10, T11);
	       T1f = VADD(T1b, T1c);
	       TQ = VFNMS(LDK(KP500000000), Te, T9);
	       TR = VFNMS(LDK(KP500000000), Tm, Th);
	       TS = VADD(TQ, TR);
	       Tw = VADD(Tq, Tv);
	       TE = VADD(Ty, TD);
	       TF = VADD(Tw, TE);
	       TT = VFNMS(LDK(KP500000000), Tv, Tq);
	       TU = VFNMS(LDK(KP500000000), TD, Ty);
	       TV = VADD(TT, TU);
	  }
	  {
	       V TI, TG, TH, TM, TO, TK, TL, TN, TJ;
	       TI = VMUL(LDK(KP559016994), VSUB(To, TF));
	       TG = VADD(To, TF);
	       TH = VFNMS(LDK(KP250000000), TG, T7);
	       TK = VSUB(Tw, TE);
	       TL = VSUB(Tf, Tn);
	       TM = VBYI(VFNMS(LDK(KP587785252), TL, VMUL(LDK(KP951056516), TK)));
	       TO = VBYI(VFMA(LDK(KP951056516), TL, VMUL(LDK(KP587785252), TK)));
	       ST(&(x[0]), VADD(T7, TG), dist, &(x[0]));
	       TN = VADD(TI, TH);
	       ST(&(x[WS(ios, 6)]), VSUB(TN, TO), dist, &(x[0]));
	       ST(&(x[WS(ios, 9)]), VADD(TO, TN), dist, &(x[WS(ios, 1)]));
	       TJ = VSUB(TH, TI);
	       ST(&(x[WS(ios, 3)]), VSUB(TJ, TM), dist, &(x[WS(ios, 1)]));
	       ST(&(x[WS(ios, 12)]), VADD(TM, TJ), dist, &(x[0]));
	  }
	  {
	       V T16, T1m, T1u, T1h, T1o, T1a, T1p, TZ, T1t, T1l, T1d, T1g;
	       T16 = VFNMS(LDK(KP509036960), T15, VMUL(LDK(KP823639103), T12));
	       T1m = VFMA(LDK(KP823639103), T15, VMUL(LDK(KP509036960), T12));
	       T1u = VBYI(VMUL(LDK(KP866025403), VADD(T1e, T1f)));
	       T1d = VMUL(LDK(KP484122918), VSUB(T1b, T1c));
	       T1g = VFNMS(LDK(KP216506350), T1f, VMUL(LDK(KP866025403), T1e));
	       T1h = VSUB(T1d, T1g);
	       T1o = VADD(T1d, T1g);
	       {
		    V T18, T19, TY, TW, TX;
		    T18 = VSUB(TT, TU);
		    T19 = VSUB(TQ, TR);
		    T1a = VFNMS(LDK(KP587785252), T19, VMUL(LDK(KP951056516), T18));
		    T1p = VFMA(LDK(KP951056516), T19, VMUL(LDK(KP587785252), T18));
		    TY = VMUL(LDK(KP559016994), VSUB(TS, TV));
		    TW = VADD(TS, TV);
		    TX = VFNMS(LDK(KP250000000), TW, TP);
		    TZ = VSUB(TX, TY);
		    T1t = VADD(TP, TW);
		    T1l = VADD(TY, TX);
	       }
	       {
		    V T17, T1i, T1r, T1s;
		    ST(&(x[WS(ios, 5)]), VSUB(T1t, T1u), dist, &(x[WS(ios, 1)]));
		    ST(&(x[WS(ios, 10)]), VADD(T1t, T1u), dist, &(x[0]));
		    T17 = VSUB(TZ, T16);
		    T1i = VBYI(VSUB(T1a, T1h));
		    ST(&(x[WS(ios, 8)]), VSUB(T17, T1i), dist, &(x[0]));
		    ST(&(x[WS(ios, 7)]), VADD(T17, T1i), dist, &(x[WS(ios, 1)]));
		    T1r = VSUB(T1l, T1m);
		    T1s = VBYI(VADD(T1p, T1o));
		    ST(&(x[WS(ios, 11)]), VSUB(T1r, T1s), dist, &(x[WS(ios, 1)]));
		    ST(&(x[WS(ios, 4)]), VADD(T1r, T1s), dist, &(x[0]));
		    {
			 V T1n, T1q, T1j, T1k;
			 T1n = VADD(T1l, T1m);
			 T1q = VBYI(VSUB(T1o, T1p));
			 ST(&(x[WS(ios, 14)]), VSUB(T1n, T1q), dist, &(x[0]));
			 ST(&(x[WS(ios, 1)]), VADD(T1n, T1q), dist, &(x[WS(ios, 1)]));
			 T1j = VADD(TZ, T16);
			 T1k = VBYI(VADD(T1a, T1h));
			 ST(&(x[WS(ios, 13)]), VSUB(T1j, T1k), dist, &(x[WS(ios, 1)]));
			 ST(&(x[WS(ios, 2)]), VADD(T1j, T1k), dist, &(x[0]));
		    }
	       }
	  }
     }
     END_SIMD();
     return W;
}

static const tw_instr twinstr[] = {
     VTW(1),
     VTW(2),
     VTW(3),
     VTW(4),
     VTW(5),
     VTW(6),
     VTW(7),
     VTW(8),
     VTW(9),
     VTW(10),
     VTW(11),
     VTW(12),
     VTW(13),
     VTW(14),
     {TW_NEXT, VL, 0}
};

static const ct_desc desc = { 15, "t1fv_15", twinstr, {78, 39, 14, 0}, &GENUS, 0, 0, 0 };

void X(codelet_t1fv_15) (planner *p) {
     X(kdft_dit_register) (p, t1fv_15, &desc);
}
