/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.IOException;
import visad.FunctionType;
import visad.MathType;
import visad.ScalarType;
import visad.SetType;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryFunctionType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryQuantity;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryScalarType;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryTextType;
import visad.data.visad.object.BinaryTupleType;

public class BinaryMathType
implements BinaryObject {
    public static final MathType read(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int objLen = file.readInt();
        int index = file.readInt();
        byte mathType = file.readByte();
        switch (mathType) {
            case 1: {
                return BinaryFunctionType.read(reader, index);
            }
            case 7: {
                return BinaryQuantity.read(reader, index);
            }
            case 3: {
                return BinaryRealTupleType.read(reader, index);
            }
            case 2: {
                return BinaryRealType.read(reader, index);
            }
            case 4: {
                return BinarySetType.read(reader, index);
            }
            case 5: {
                return BinaryTextType.read(reader, index);
            }
            case 6: {
                return BinaryTupleType.read(reader, index, objLen - 5);
            }
        }
        throw new VisADException("Unknown Math type " + mathType);
    }

    public static final MathType[] readList(BinaryReader reader, int dim) throws IOException, VisADException {
        if (dim < 1) {
            throw new IOException("Corrupted file (bad MathType list length)");
        }
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        MathType[] list = new MathType[dim];
        for (int i = 0; i < dim; ++i) {
            int typeIndex = file.readInt();
            list[i] = (MathType)cache.get(typeIndex);
        }
        return list;
    }

    public static final int write(BinaryWriter writer, MathType mt, Object token) throws IOException {
        int index;
        if (mt instanceof FunctionType) {
            index = BinaryFunctionType.write(writer, (FunctionType)mt, token);
        } else if (mt instanceof ScalarType) {
            index = BinaryScalarType.write(writer, (ScalarType)mt, token);
        } else if (mt instanceof SetType) {
            index = BinarySetType.write(writer, (SetType)mt, null, token);
        } else if (mt instanceof TupleType) {
            index = BinaryTupleType.write(writer, (TupleType)mt, token);
        } else {
            BinaryObjectCache cache = writer.getTypeCache();
            index = cache.getIndex(mt);
            if (index < 0) {
                index = cache.add(mt);
                if (index < 0) {
                    throw new IOException("Couldn't cache MathType " + mt);
                }
                BinarySerializedObject.write(writer, (byte)6, mt, token);
            }
        }
        return index;
    }
}

