/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DataTools {
    public static final int UNIX = 0;
    public static final int COBOL = 1;
    public static final long UNIX_EPOCH = 0L;
    public static final long COBOL_EPOCH = 11644444800000L;
    private static ThreadLocal eightBytes = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[8];
        }
    };

    private DataTools() {
    }

    public static byte readSignedByte(DataInput in) throws IOException {
        byte[] b = (byte[])eightBytes.get();
        in.readFully(b, 0, 1);
        return b[0];
    }

    public static short readUnsignedByte(DataInput in) throws IOException {
        short q = DataTools.readSignedByte(in);
        if (q < 0) {
            q = (short)(q + 256);
        }
        return q;
    }

    public static short read2SignedBytes(DataInput in, boolean little) throws IOException {
        byte[] b = (byte[])eightBytes.get();
        in.readFully(b, 0, 2);
        return DataTools.bytesToShort(b, little);
    }

    public static int read2UnsignedBytes(DataInput in, boolean little) throws IOException {
        int q = DataTools.read2SignedBytes(in, little);
        if (q < 0) {
            q += 65536;
        }
        return q;
    }

    public static int read4SignedBytes(DataInput in, boolean little) throws IOException {
        byte[] b = (byte[])eightBytes.get();
        in.readFully(b, 0, 4);
        return DataTools.bytesToInt(b, little);
    }

    public static long read4UnsignedBytes(DataInput in, boolean little) throws IOException {
        long q = DataTools.read4SignedBytes(in, little);
        if (q < 0L) {
            q += 0x100000000L;
        }
        return q;
    }

    public static long read8SignedBytes(DataInput in, boolean little) throws IOException {
        byte[] b = (byte[])eightBytes.get();
        in.readFully(b, 0, 8);
        return DataTools.bytesToLong(b, little);
    }

    public static float readFloat(DataInput in, boolean little) throws IOException {
        return Float.intBitsToFloat(DataTools.read4SignedBytes(in, little));
    }

    public static double readDouble(DataInput in, boolean little) throws IOException {
        return Double.longBitsToDouble(DataTools.read8SignedBytes(in, little));
    }

    public static void writeString(DataOutput out, String s) throws IOException {
        byte[] b = s.getBytes("UTF-8");
        out.write(b);
    }

    public static void writeInt(DataOutput out, int v, boolean little) throws IOException {
        if (little) {
            out.write(v & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 24 & 0xFF);
        } else {
            out.write(v >>> 24 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v & 0xFF);
        }
    }

    public static void writeShort(DataOutput out, int v, boolean little) throws IOException {
        if (little) {
            out.write(v & 0xFF);
            out.write(v >>> 8 & 0xFF);
        } else {
            out.write(v >>> 8 & 0xFF);
            out.write(v & 0xFF);
        }
    }

    public static short bytesToShort(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        short total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total = (short)(total | (bytes[ndx] < 0 ? 256 + bytes[ndx] : bytes[ndx]) << (little ? i : len - i - 1) * 8);
            ++i;
            ++ndx;
        }
        return total;
    }

    public static short bytesToShort(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToShort(bytes, off, 2, little);
    }

    public static short bytesToShort(byte[] bytes, boolean little) {
        return DataTools.bytesToShort(bytes, 0, 2, little);
    }

    public static short bytesToShort(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        short total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total = (short)(total | bytes[ndx] << (little ? i : len - i - 1) * 8);
            ++i;
            ++ndx;
        }
        return total;
    }

    public static short bytesToShort(short[] bytes, int off, boolean little) {
        return DataTools.bytesToShort(bytes, off, 2, little);
    }

    public static short bytesToShort(short[] bytes, boolean little) {
        return DataTools.bytesToShort(bytes, 0, 2, little);
    }

    public static int bytesToInt(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        int total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (bytes[ndx] < 0 ? 256 + bytes[ndx] : bytes[ndx]) << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static int bytesToInt(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToInt(bytes, off, 4, little);
    }

    public static int bytesToInt(byte[] bytes, boolean little) {
        return DataTools.bytesToInt(bytes, 0, 4, little);
    }

    public static int bytesToInt(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        int total = 0;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= bytes[ndx] << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static int bytesToInt(short[] bytes, int off, boolean little) {
        return DataTools.bytesToInt(bytes, off, 4, little);
    }

    public static int bytesToInt(short[] bytes, boolean little) {
        return DataTools.bytesToInt(bytes, 0, 4, little);
    }

    public static long bytesToLong(byte[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        long total = 0L;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (bytes[ndx] < 0 ? 256L + (long)bytes[ndx] : (long)bytes[ndx]) << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static long bytesToLong(byte[] bytes, int off, boolean little) {
        return DataTools.bytesToLong(bytes, off, 8, little);
    }

    public static long bytesToLong(byte[] bytes, boolean little) {
        return DataTools.bytesToLong(bytes, 0, 8, little);
    }

    public static long bytesToLong(short[] bytes, int off, int len, boolean little) {
        if (bytes.length - off < len) {
            len = bytes.length - off;
        }
        long total = 0L;
        int i = 0;
        int ndx = off;
        while (i < len) {
            total |= (long)bytes[ndx] << (little ? i : len - i - 1) * 8;
            ++i;
            ++ndx;
        }
        return total;
    }

    public static long bytesToLong(short[] bytes, int off, boolean little) {
        return DataTools.bytesToLong(bytes, off, 8, little);
    }

    public static long bytesToLong(short[] bytes, boolean little) {
        return DataTools.bytesToLong(bytes, 0, 8, little);
    }

    public static Object makeDataArray(byte[] b, int bpp, boolean fp, boolean little) {
        if (bpp == 1) {
            return b;
        }
        if (bpp == 2) {
            short[] s = new short[b.length / 2];
            for (int i = 0; i < s.length; ++i) {
                s[i] = DataTools.bytesToShort(b, i * 2, 2, little);
            }
            return s;
        }
        if (bpp == 4 && fp) {
            float[] f = new float[b.length / 4];
            for (int i = 0; i < f.length; ++i) {
                f[i] = Float.intBitsToFloat(DataTools.bytesToInt(b, i * 4, 4, little));
            }
            return f;
        }
        if (bpp == 4) {
            int[] i = new int[b.length / 4];
            for (int j = 0; j < i.length; ++j) {
                i[j] = DataTools.bytesToInt(b, j * 4, 4, little);
            }
            return i;
        }
        if (bpp == 8 && fp) {
            double[] d = new double[b.length / 8];
            for (int i = 0; i < d.length; ++i) {
                d[i] = Double.longBitsToDouble(DataTools.bytesToLong(b, i * 8, 8, little));
            }
            return d;
        }
        if (bpp == 8) {
            long[] l = new long[b.length / 8];
            for (int i = 0; i < l.length; ++i) {
                l[i] = DataTools.bytesToLong(b, i * 8, 8, little);
            }
            return l;
        }
        return null;
    }

    public static short swap(short x) {
        return (short)(x << 8 | x >> 8 & 0xFF);
    }

    public static char swap(char x) {
        return (char)(x << 8 | x >> 8 & 0xFF);
    }

    public static int swap(int x) {
        return DataTools.swap((short)x) << 16 | DataTools.swap((short)(x >> 16)) & 0xFFFF;
    }

    public static long swap(long x) {
        return (long)DataTools.swap((int)x) << 32 | (long)DataTools.swap((int)(x >> 32)) & 0xFFFFFFFFL;
    }

    public static String stripString(String toStrip) {
        char[] toRtn = new char[toStrip.length()];
        int counter = 0;
        for (int i = 0; i < toRtn.length; ++i) {
            if (toStrip.charAt(i) == '\u0000') continue;
            toRtn[counter] = toStrip.charAt(i);
            ++counter;
        }
        toStrip = new String(toRtn);
        toStrip = toStrip.trim();
        return toStrip;
    }

    public static boolean samePrefix(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        int n1 = s1.indexOf(".");
        int n2 = s2.indexOf(".");
        if (n1 == -1 || n2 == -1) {
            return false;
        }
        int slash1 = s1.lastIndexOf(File.pathSeparator);
        int slash2 = s2.lastIndexOf(File.pathSeparator);
        String sub1 = s1.substring(slash1 == -1 ? 0 : slash1 + 1, n1);
        String sub2 = s2.substring(slash2 == -1 ? 0 : slash2 + 1, n2);
        return sub1.equals(sub2) || sub1.startsWith(sub2) || sub2.startsWith(sub1);
    }

    public static float[] normalizeFloats(float[] data) {
        int i;
        float[] rtn = new float[data.length];
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (i = 0; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        for (i = 0; i < rtn.length; ++i) {
            rtn[i] = (data[i] - min) / (max - min);
        }
        return rtn;
    }

    public static String convertDate(long stamp, int format) {
        long ms = stamp;
        switch (format) {
            case 1: {
                ms -= 11644444800000L;
            }
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuffer sb = new StringBuffer();
        Date d = new Date(ms);
        fmt.format(d, sb, new FieldPosition(0));
        return sb.toString();
    }
}

