/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.rmi.RemoteException;
import visad.CellImpl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReferenceImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public class DualRes {
    public static boolean DEBUG = true;
    protected DataReferenceImpl hi_ref;
    protected DataReferenceImpl lo_ref;
    private CellImpl cell;
    private double scale = 0.5;

    public static FieldImpl rescale(FieldImpl field, double scale) throws VisADException, RemoteException {
        Set set = field.getDomainSet();
        if (!(set instanceof LinearSet)) {
            return null;
        }
        LinearSet lset = (LinearSet)((Object)set);
        int dim = set.getDimension();
        int[] lengths = new int[dim];
        for (int i = 0; i < dim; ++i) {
            Linear1DSet lin1set = lset.getLinear1DComponent(i);
            lengths[i] = (int)((double)lin1set.getLength() * scale);
            if (lengths[i] >= 1) continue;
            lengths[i] = 1;
        }
        return DualRes.rescale(field, lengths);
    }

    public static FieldImpl rescale(FieldImpl field, int[] lengths) throws VisADException, RemoteException {
        Set set = field.getDomainSet();
        if (!(set instanceof LinearSet)) {
            return null;
        }
        LinearSet lset = (LinearSet)((Object)set);
        int dim = set.getDimension();
        if (lengths.length != dim) {
            throw new VisADException("bad lengths dimension");
        }
        Linear1DSet[] lin_sets = new Linear1DSet[dim];
        for (int i = 0; i < dim; ++i) {
            Linear1DSet lin1set = lset.getLinear1DComponent(i);
            MathType type = lin1set.getType();
            double first = lin1set.getFirst();
            double last = lin1set.getLast();
            CoordinateSystem coord_sys = lin1set.getCoordinateSystem();
            Unit[] units = lin1set.getSetUnits();
            lin_sets[i] = new Linear1DSet(type, first, last, lengths[i], coord_sys, units, null);
        }
        MathType type = set.getType();
        CoordinateSystem coord_sys = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        GriddedSet nset = dim == 1 ? lin_sets[0] : (dim == 2 ? new Linear2DSet(type, lin_sets, coord_sys, units, null) : (dim == 3 ? new Linear3DSet(type, lin_sets, coord_sys, units, null) : new LinearNDSet(type, lin_sets, coord_sys, units, null)));
        return (FieldImpl)field.resample(nset, 101, 202);
    }

    public DualRes(DataReferenceImpl ref) throws VisADException, RemoteException {
        this.hi_ref = ref;
        this.lo_ref = new DataReferenceImpl("DualRes_ref");
        this.cell = new CellImpl(){

            public void doAction() {
                block9: {
                    try {
                        FieldImpl downfield;
                        Data data = DualRes.this.hi_ref.getData();
                        if (data == null || !(data instanceof FieldImpl)) {
                            return;
                        }
                        FieldImpl field = (FieldImpl)data;
                        FunctionType ftype = (FunctionType)data.getType();
                        RealTupleType domain = ftype.getDomain();
                        MathType range = ftype.getRange();
                        if (domain.getDimension() == 1 && range instanceof FunctionType) {
                            downfield = new FieldImpl(ftype, field.getDomainSet());
                            int len = field.getLength();
                            for (int i = 0; i < len; ++i) {
                                Data sample = field.getSample(i);
                                if (!(sample instanceof FieldImpl)) {
                                    return;
                                }
                                downfield.setSample(i, (Data)DualRes.rescale((FieldImpl)sample, DualRes.this.scale));
                            }
                        } else {
                            downfield = DualRes.rescale(field, DualRes.this.scale);
                        }
                        DualRes.this.lo_ref.setData(downfield);
                    }
                    catch (VisADException exc) {
                        if (DEBUG) {
                            exc.printStackTrace();
                        }
                    }
                    catch (RemoteException exc) {
                        if (!DEBUG) break block9;
                        exc.printStackTrace();
                    }
                }
            }
        };
        this.cell.addReference(this.hi_ref);
    }

    public void setResolutionScale(double scale) throws VisADException {
        if (!(scale > 1.0)) {
            throw new VisADException("DualRes: scale factor must be greater than 1");
        }
        this.scale = 1.0 / scale;
    }

    public double getResolutionScale() {
        return 1.0 / this.scale;
    }

    public DataReferenceImpl getHighResReference() {
        return this.hi_ref;
    }

    public DataReferenceImpl getLowResReference() {
        return this.lo_ref;
    }
}

