/*
  fblogo.h
  Generate linux_logo.h header file for use with the framebuffer boot logo
  Written by Daniel Vedy <daniel@kongsberg.online.no> 1999
  Adapted by Gordon Fraser <gordon@freakzone.net> 2001/2002
  Released under the GPL
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <string.h>
#include <unistd.h>

#include "png.h"
#include "low_color.h"

#define VERSION       "0.3"
#define LINUX_24      0 
#define LINUX_22      1
#define PNG_SIG_BYTES 8


#define ERR_NOPNG     1
#define ERR_PNGPTR    2
#define ERR_PNGINFO   3
#define ERR_COLNUM    4

void usage(void);
int read_image(FILE*);
int write_header(FILE*, char);


png_uint_32 width, height;

int num_palette;
png_colorp palette;
png_bytep image_data;

char verbose;
