--
-- Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity frdm_kl02z is
	port(
		gnd : inout std_logic;
		vdd : inout std_logic;

		j7_1 : inout std_logic;
		j7_2 : inout std_logic;
		j7_3 : inout std_logic;
		j7_4 : inout std_logic;
		j7_5 : inout std_logic;
		j7_6 : inout std_logic;
		j7_7 : inout std_logic;
		j7_8 : inout std_logic;
		j7_9 : inout std_logic;
		j7_10 : inout std_logic;

		j8_1 : inout std_logic;
		j8_2 : inout std_logic;
		j8_3 : inout std_logic;
		j8_4 : inout std_logic;
		j8_5 : inout std_logic;
		j8_6 : inout std_logic;
		j8_7 : inout std_logic;
		j8_8 : inout std_logic;

		j9_1 : inout std_logic;
		j9_2 : inout std_logic;
		j9_3 : inout std_logic;
		j9_4 : inout std_logic;
		j9_5 : inout std_logic;
		j9_6 : inout std_logic;
		j9_7 : inout std_logic;
		j9_8 : inout std_logic;

		j10_1 : inout std_logic;
		j10_2 : inout std_logic;
		j10_3 : inout std_logic;
		j10_4 : inout std_logic;
		j10_5 : inout std_logic;
		j10_6 : inout std_logic;

		led : out opt_rgb
	);
end frdm_kl02z;

architecture structural of frdm_kl02z is
begin
	board : mb_frdm_kl02z
		port map(
			gnd => gnd,
			vdd => vdd,

			j7_1 => j7_1,
			j7_2 => j7_2,
			j7_3 => j7_3,
			j7_4 => j7_4,
			j7_5 => j7_5,
			j7_6 => j7_6,
			j7_7 => j7_7,
			j7_8 => j7_8,
			j7_9 => j7_9,
			j7_10 => j7_10,

			j8_1 => j8_1,
			j8_2 => j8_2,
			j8_3 => j8_3,
			j8_4 => j8_4,
			j8_5 => j8_5,
			j8_6 => j8_6,
			j8_7 => j8_7,
			j8_8 => j8_8,

			j9_1 => j9_1,
			j9_2 => j9_2,
			j9_3 => j9_3,
			j9_4 => j9_4,
			j9_5 => j9_5,
			j9_6 => j9_6,
			j9_7 => j9_7,
			j9_8 => j9_8,

			j10_1 => j10_1,
			j10_2 => j10_2,
			j10_3 => j10_3,
			j10_4 => j10_4,
			j10_5 => j10_5,
			j10_6 => j10_6,

			led => led
		);
end structural;
