/*
 * Copyright (C) 2007-2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ALIGN_H_INCLUDED
#define __ALIGN_H_INCLUDED

extern uint8_t
CHIP_(inb)(struct cpssp *cpssp, paddr_t port);
extern uint16_t
CHIP_(inw)(struct cpssp *cpssp, paddr_t port);
#if 80386 <= CONFIG_CPU
extern uint32_t
CHIP_(inl)(struct cpssp *cpssp, paddr_t port);
#endif /* 80386 <= CONFIG_CPU */

extern void
CHIP_(outb)(struct cpssp *cpssp, uint8_t value, paddr_t port);
extern void
CHIP_(outw)(struct cpssp *cpssp, uint16_t value, paddr_t port);
#if 80386 <= CONFIG_CPU
extern void
CHIP_(outl)(struct cpssp *cpssp, uint32_t value, paddr_t port);
#endif /* 80386 <= CONFIG_CPU */

/*
 * Functions
 */
#define ACCESS_TYPE 3
#define MEMSUFFIX _code

#define DATA_SIZE 1
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_align_template.h"

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
#define DATA_SIZE 8
#include "arch_gen_cpu_x86_align_template.h"
#endif /* CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT */

#undef ACCESS_TYPE
#undef MEMSUFFIX

#define ldul_user ldl_user
#define ldul_kernel ldl_kernel

#define ACCESS_TYPE 0
#define MEMSUFFIX _kernel
#define DATA_SIZE 1
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 8
#include "arch_gen_cpu_x86_align_template.h"
#undef ACCESS_TYPE
#undef MEMSUFFIX

#define ACCESS_TYPE 1
#define MEMSUFFIX _user
#define DATA_SIZE 1
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 8
#include "arch_gen_cpu_x86_align_template.h"
#undef ACCESS_TYPE
#undef MEMSUFFIX

/* these access are slower, they must be as rare as possible */
#define ACCESS_TYPE 2
#define MEMSUFFIX _data
#define DATA_SIZE 1
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 2
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 4
#include "arch_gen_cpu_x86_align_template.h"

#define DATA_SIZE 8
#include "arch_gen_cpu_x86_align_template.h"
#undef ACCESS_TYPE
#undef MEMSUFFIX

#define ldub(cpssp, p) ldub_data(cpssp, p)
#define ldsb(cpssp, p) ldsb_data(cpssp, p)
#define lduw(cpssp, p) lduw_data(cpssp, p)
#define ldsw(cpssp, p) ldsw_data(cpssp, p)
#define ldl(cpssp, p) ldl_data(cpssp, p)
#define ldq(cpssp, p) ldq_data(cpssp, p)

#define stb(cpssp, p, v) stb_data(cpssp, p, v)
#define stw(cpssp, p, v) stw_data(cpssp, p, v)
#define stl(cpssp, p, v) stl_data(cpssp, p, v)
#define stq(cpssp, p, v) stq_data(cpssp, p, v)

static inline double ldfq(struct cpssp *cpssp, vaddr_t ptr)
{
	union {
		double d;
		uint64_t i;
	} u;
	u.i = ldq(cpssp, ptr);
	return u.d;
}

static inline void stfq(struct cpssp *cpssp, vaddr_t ptr, double v)
{
	union {
		double d;
		uint64_t i;
	} u;
	u.d = v;
	stq(cpssp, ptr, u.i);
}

static inline float ldfl(struct cpssp *cpssp, vaddr_t ptr)
{
	union {
		float f;
		uint32_t i;
	} u;
	u.i = ldl(cpssp, ptr);
	return u.f;
}

static inline void stfl(struct cpssp *cpssp, vaddr_t ptr, float v)
{
	union {
		float f;
		uint32_t i;
	} u;
	u.f = v;
	stl(cpssp, ptr, u.i);
}

#endif /* __ALIGN_H_INCLUDED */
