/*
 * $Id: sig_video.c,v 1.16 2009-05-21 16:38:09 vrsieh Exp $
 *
 * Video signal (only the video component of the VGA cable).
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"

#include "sig_video.h"

void
sig_video_vert_retrace(struct sig_video *b, void *s)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->vert_retrace;
		if (func) {
			func(b->member[nr].s);
		}
	}
}

void
sig_video_hor_retrace(struct sig_video *b, void *s)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->hor_retrace;
		if (func) {
			func(b->member[nr].s);
		}
	}
}

void
sig_video_out(
	struct sig_video *b,
	void *s,
	uint8_t red,
	uint8_t green,
	uint8_t blue
)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *, uint8_t, uint8_t, uint8_t);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->out;
		if (func) {
			func(b->member[nr].s, red, green, blue);
		}
	}
}

void
sig_video_no_sync(struct sig_video *b, void *s)
{
	unsigned int nr;

	for (nr = 0; nr < b->member_count; nr++) {
		void (*func)(void *);

		if (b->member[nr].s == s) {
			continue;
		}
		func = b->member[nr].f->no_sync;
		if (func) {
			func(b->member[nr].s);
		}
	}
}

void
sig_video_connect(
	struct sig_video *b,
	void *s,
	const struct sig_video_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_VIDEO);
	assert(b->member_count < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->member_count].s = s;
	b->member[b->member_count].f = f;
	b->member_count++;
}

static void
sig_video_s0_out(
	void *_f,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_out(f->s1, f, r, g, b);
}

static void
sig_video_s0_no_sync(void *_f)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_no_sync(f->s1, f);
}

static void
sig_video_s0_vert_retrace(void *_f)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_vert_retrace(f->s1, f);
}

static void
sig_video_s0_hor_retrace(void *_f)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_hor_retrace(f->s1, f);
}

static void
sig_video_s1_out(
	void *_f,
	uint8_t r,
	uint8_t g,
	uint8_t b
)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_out(f->s0, f, r, g, b);
}

static void
sig_video_s1_no_sync(void *_f)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_no_sync(f->s0, f);
}

static void
sig_video_s1_vert_retrace(void *_f)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_vert_retrace(f->s0, f);
}

static void
sig_video_s1_hor_retrace(void *_f)
{
	struct sig_video_merge *f = (struct sig_video_merge *) _f;

	sig_video_hor_retrace(f->s0, f);
}

struct sig_video_merge *
sig_video_merge(struct sig_video *s0, struct sig_video *s1)
{
	static const struct sig_video_funcs s0_funcs = {
		.out = sig_video_s0_out,
		.hor_retrace = sig_video_s0_hor_retrace,
		.vert_retrace = sig_video_s0_vert_retrace,
		.no_sync = sig_video_s0_no_sync,
	};
	static const struct sig_video_funcs s1_funcs = {
		.out = sig_video_s1_out,
		.hor_retrace = sig_video_s1_hor_retrace,
		.vert_retrace = sig_video_s1_vert_retrace,
		.no_sync = sig_video_s1_no_sync,
	};
	struct sig_video_merge *m;

	m = malloc(sizeof(*m));
	assert(m);

	m->s0 = s0;
	sig_video_connect(s0, m, &s0_funcs);
	m->s1 = s1;
	sig_video_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_video_split(struct sig_video_merge *m)
{
	fixme();
}

struct sig_video *
sig_video_create(const char *name)
{
	struct sig_video *b;

	b = malloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_VIDEO;
	b->member_count = 0;

	return b;
}

void
sig_video_destroy(struct sig_video *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_VIDEO);

	free(sig);
}
