/*
 * $Id: sig_cardbus.h,v 1.23 2009-05-21 16:38:06 vrsieh Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_CARDBUS_H_INCLUDED
#define __SIG_CARDBUS_H_INCLUDED

#include "sig_boolean.h"
#include "sig_boolean_or.h"
#include "sig_pci_bus.h"

struct sig_cardbus {
	struct sig_boolean *conn;
	struct sig_boolean *p5V;
	struct sig_boolean *n_reset;
	struct sig_pci_bus_main *bus;
	struct sig_boolean_or *irq;
};

extern struct sig_cardbus *
sig_cardbus_create(const char *name);
extern void
sig_cardbus_destroy(struct sig_cardbus *c);

#endif /* __SIG_CARDBUS_H_INCLUDED */
