/*
 * $Id: arch_scsi_gen_cdrom.c,v 1.286 2009-11-24 14:22:19 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {
	/*
	 * Config
	 */
	unsigned int id;

	/*
	 * Process
	 */
	struct process process;

	/*
	 * Signals
	 */
	unsigned int state_atn;

	/*
	 * State
	 */
	/* Media Description */
	unsigned int media_locked;

	/* Controller */
	unsigned int inserted;
	unsigned int locked;

	struct toc_entry {
		uint8_t type;
		uint8_t track;
		uint8_t pmin100;
		uint8_t pmin;
		uint8_t psec;
		uint8_t pframe;
	} PMA[1000], TOC[1000];
	unsigned int nPMAs;
	unsigned int nTOCs;
	int incomplete_session;
	int32_t last_written_lba;
	int is_writing;

	unsigned int unit_attention;
	unsigned char changed;
	unsigned char sense_key; /* sense: needed for request_sense */
	unsigned char asc;       /* asc:   needed for request_sense */
	unsigned char ascq;      /* ascq:  needed for request_sense */

	/* Write Mode Page */
	unsigned int write_parameter_bufe;
	unsigned int write_parameter_ls_v;
	unsigned int write_parameter_test_write;
	enum {
		WRITE_TYPE_PACKET = 0,
		WRITE_TYPE_TAO = 1,
		WRITE_TYPE_SAO = 2,
		WRITE_TYPE_RAW = 3,
	} write_parameter_write_type;
	unsigned int write_parameter_multi_session;
	unsigned int write_parameter_fp;
	unsigned int write_parameter_copy;
	unsigned int write_parameter_track_mode;
	enum {
		DATA_BLOCK_TYPE_MODE1 = 8,
		DATA_BLOCK_TYPE_MODE2_XA_FORM1 = 10,
		DATA_BLOCK_TYPE_MODE2_XA = 13,
	} write_parameter_data_block_type;
	unsigned int write_parameter_link_size;
	unsigned int write_parameter_host_application_code;
	unsigned int write_parameter_session_format;
	uint32_t write_parameter_packet_size;
	uint16_t write_parameter_audio_pause_length;
	uint8_t write_parameter_media_catalog_number[16];
	uint8_t write_parameter_i18n_standard_recording_code[16];
	uint8_t write_parameter_sub_header_byte[4];

	/* New state */
	unsigned int selected;
	unsigned int lun;

	uint8_t buf[0x10000];
	unsigned int count;
	unsigned int head;
	unsigned int tail;

	uint8_t msg_buf[2 + 256];
	uint8_t cmd_buf[12];
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

#if CD_WRITER_DAO_SUPPORT
static void
NAME_(dump)(const char *title, uint8_t *buf, unsigned int buflen)
{
	unsigned int x;

	fprintf(stderr, "%s:\n", title);
	for (x = 0; x < buflen; x++) {
		fprintf(stderr, " %02x", buf[x]);
		if (x % 16 == 15) {
			fprintf(stderr, "\n");
		}
	}
	if (x % 16 != 0) {
		fprintf(stderr, "\n");
	}
}
#endif

static void
NAME_(media_lock)(struct cpssp *cpssp)
{
	cpssp->NAME.media_locked = 1;
}

static void
NAME_(media_unlock)(struct cpssp *cpssp)
{
	cpssp->NAME.media_locked = 0;
}

static int
NAME_(media_atip)(struct cpssp *cpssp, struct cd_atip *atip)
{
	return sig_magneto_optical_atip(cpssp->port_media, cpssp, atip);
}

static int
NAME_(media_read)(
	struct cpssp *cpssp,
	int32_t sector,
	uint8_t *data,
	uint8_t *psub,
	uint8_t *qsub
)
{
	return sig_magneto_optical_read(cpssp->port_media, cpssp,
			sector, data, psub, qsub);
}

#if CD_WRITER_SUPPORT
static int
NAME_(media_write)(
	struct cpssp *cpssp,
	int32_t sector,
	const uint8_t *data,
	const uint8_t *psub,
	const uint8_t *qsub
)
{
	return sig_magneto_optical_write(cpssp->port_media, cpssp,
			sector, data, psub, qsub);
}
#endif

static uint8_t
NAME_(bcd_to_bin)(uint8_t bcd)
{
	uint8_t high;
	uint8_t low;

	high = (bcd >> 4) & 0xf;
	low = (bcd >> 0) & 0xf;

	if (high <= 9
	 && low <= 9) {
		return high * 10 + low;
	} else {
		return bcd;
	}
}

#if CD_WRITER_SUPPORT
static uint8_t
NAME_(bin_to_bcd)(uint8_t bin)
{
	uint8_t high;
	uint8_t low;

	high = bin / 10;
	low = bin % 10;

	if (high <= 9
	 && low <= 9) {
		return (high << 4) | (low << 0);
	} else {
		return bin;
	}
}
#endif

static int32_t
NAME_(msf_to_lin)(uint8_t msf[3])
{
	/* msf[0] = min; msf[1] = sec; msf[2] = frame */
	if (msf[0] < 90) {
		return (msf[0] * 60 + msf[1]) * 75 + msf[2];
	} else {
		return (msf[0] * 60 + msf[1]) * 75 + msf[2] - 450000;
	}
}

static int32_t
NAME_(msf100_to_lin)(uint8_t msf[4])
{
	/* msf[0] = min100; msf[1] = min; msf[2] = sec; msf[3] = frame */
	return ((msf[0] * 100 + msf[1]) * 60 + msf[2]) * 75 + msf[3];
}

#if CD_WRITER_SUPPORT /* only used in writer */
static void
NAME_(msf_to_lba)(uint8_t msf[3], int32_t *lbap)
{
	*lbap = NAME_(msf_to_lin)(msf) - 150;
}
#endif

static void
NAME_(msf100_to_lba)(uint8_t msf[4], int32_t *lbap)
{
	*lbap = NAME_(msf100_to_lin)(msf) - 150;
}

#if CD_WRITER_SUPPORT /* only used in writer */
static void
NAME_(lin_to_msf)(int32_t lin, uint8_t *msf)
{
	/* msf[0] = min; msf[1] = sec; msf[2] = frame */

	if (lin < 0) {
		lin += 100*60*75;
	}

	assert(0 <= lin);
	assert(lin < 100*60*75);

	msf[0] = lin / (60 * 75);
	msf[1] = (lin - (msf[0] * 60 * 75)) / 75;
	msf[2] = (lin - (msf[0] * 60 * 75) - msf[1] * 75);
}

static void
NAME_(lin_to_msf100)(int32_t lin, uint8_t *msf100)
{
	/* msf[0] = min100; msf[1] = min; msf[2] = sec; msf[3] = frame */

	NAME_(lin_to_msf)(lin, msf100 + 1); /* FIXME */
}
#endif /* CD_WRITER_SUPPORT */

static void
NAME_(check_condition)(
	struct cpssp *s,
	unsigned char sense_key,
	unsigned char asc,
	unsigned char ascq
)
{
	s->NAME.sense_key = sense_key;
	s->NAME.asc = asc;
	s->NAME.ascq = ascq;
}

/*
 * SCSI-3
 *
 * MMC-2: page 289 ff
 *
 * Please keep sorted by numbers!
 */
/* Recovered Errors */

/* Not Ready Errors */
static void
NAME_(medium_not_present)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, NOT_READY, 0x3a, 0x00);
}

/* Medium Errors */
static void
NAME_(unrecovered_read_error)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, MEDIUM_ERROR, 0x11, 0x00);
}

/* Illegal Request Errors */
static void
NAME_(invalid_command_operation_code)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, ILLEGAL_REQUEST, 0x20, 0x00);
}

static void
NAME_(logical_block_address_out_of_range)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, ILLEGAL_REQUEST, 0x21, 0x00);
}

static void
NAME_(invalid_field_in_cdb)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, ILLEGAL_REQUEST, 0x24, 0x00);
}

static void
NAME_(invalid_field_in_parameter_list)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, ILLEGAL_REQUEST, 0x26, 0x00);
}

static void
NAME_(command_sequence_error)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, ILLEGAL_REQUEST, 0x2c, 0x00);
}

/* Unit Attention Codes */
static void
NAME_(medium_changed)(struct cpssp *cpssp)
{
	NAME_(check_condition)(cpssp, UNIT_ATTENTION, 0x28, 0x00);
}

static void
NAME_(_recv)(struct cpssp *cpssp, unsigned int count)
{
	cpssp->NAME.count = count;
	cpssp->NAME.head = 0;
	cpssp->NAME.tail = 0;

	NAME_(want_recv)(cpssp, count);

	while (cpssp->NAME.head < cpssp->NAME.count) {
		sched_sleep();
	}
}

static void
NAME_(_send)(struct cpssp *cpssp, unsigned int count)
{
	cpssp->NAME.count = count;
	cpssp->NAME.head = count;
	cpssp->NAME.tail = 0;

	NAME_(want_send)(cpssp, count);

	while (cpssp->NAME.tail < cpssp->NAME.count) {
		sched_sleep();
	}
}

/*
 * SCSI-3
 *
 * SPC: page 72
 * SPC-2: page 206
 *
 * 0xa0, mandatory
 */
static void
NAME_(report_luns)(struct cpssp *s)
{
	uint8_t select_report;
	uint32_t allocation_length;
	unsigned int offset;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0xa0);
	/* s->NAME.cmd_buf[1]: Reserved */
	select_report = s->NAME.cmd_buf[2];
	/* s->NAME.cmd_buf[3]: Reserved */
	/* s->NAME.cmd_buf[4]: Reserved */
	/* s->NAME.cmd_buf[5]: Reserved */
	allocation_length = (s->NAME.cmd_buf[6] << 24)
			| (s->NAME.cmd_buf[7] << 16)
			| (s->NAME.cmd_buf[8] << 8)
			| (s->NAME.cmd_buf[9] << 0);
	/* s->NAME.cmd_buf[10]: Reserved */
	/* s->NAME.cmd_buf[11]: Control */

	if (allocation_length < 16) {
illegal_request:;
		/* INVALID FIELD IN CDB */
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

	offset = 0;

	switch (select_report) {
	case 0x00:
	case 0x01:
	case 0x02:
		s->NAME.buf[offset++] = (8 >> 24) & 0xff; /* One 8-byte entry */
		s->NAME.buf[offset++] = (8 >> 16) & 0xff;
		s->NAME.buf[offset++] = (8 >>  8) & 0xff;
		s->NAME.buf[offset++] = (8 >>  0) & 0xff;

		s->NAME.buf[offset++] = 0; /* Reserved */
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;

		s->NAME.buf[offset++] = 0; /* LUN 0 */
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		s->NAME.buf[offset++] = 0;
		break;
	default:
		goto illegal_request;
	}

	if (offset < allocation_length) {
		allocation_length = offset;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

/*
 * SCSI-3 SBC 41
 *
 * 0x28, mandatory
 */
static void
NAME_(read_10)(struct cpssp *s)
{
	uint32_t sector;
	uint16_t count;
	int32_t start_lba;
	int32_t lba;
	int32_t end_lba;
	unsigned int track_index;
	unsigned int i;

	/*
	 * Get parameter.
	 */
	assert(s->NAME.cmd_buf[0] == 0x28);
	/* dpo fua and reladr are reserved in atapi */
	/* (s->NAME.cmd_buf[1] >> 5) & 7: Reserved */
	/* dpo = (s->NAME.cmd_buf[1] >> 4) & 1 */
	/* fua = (s->NAME.cmd_buf[1] >> 3) & 1 */
	/* (s->NAME.cmd_buf[1] >> 1) & 3: Reserved */
	/* reladr = (s->NAME.cmd_buf[1] >> 0) & 1 */
	sector = (s->NAME.cmd_buf[2] << 24)
		| (s->NAME.cmd_buf[3] << 16)
		| (s->NAME.cmd_buf[4] <<  8)
		| (s->NAME.cmd_buf[5] <<  0);
	/* s->NAME.cmd_buf[6]: Reserved */
	count = (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control */

	if (s->NAME.inserted == 0) {
		NAME_(medium_not_present)(s);
		return;
	}

	start_lba = 0;
	end_lba = 0;
	for (i = 0; i < s->NAME.nTOCs; i++) {
		if (s->NAME.TOC[i].track == 0xa2) {
			NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
					&end_lba);
		}
	}
	for (i = 0; i < s->NAME.nTOCs; i++) {
		if (s->NAME.TOC[i].track == 0xa2) {
			NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
					&lba);
			if (sector <= lba
			 && lba < end_lba) {
				end_lba = lba;
			}
		} else if (1 <= s->NAME.TOC[i].track
			&& s->NAME.TOC[i].track <= 99) {
			NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
					&lba);
			if (lba <= sector
			 && start_lba < lba) {
				track_index = i;
				start_lba = lba;
			}
			if (sector < lba
			 && lba < end_lba) {
				end_lba = lba;
			}
		}
	}
	if (end_lba < sector + count) {
		NAME_(logical_block_address_out_of_range)(s);
		return;
	}

	NAME_(phase_data_in)(s);
	while (count) {
		uint8_t data[2352];
		uint8_t psub[10];
		uint8_t qsub[10];

		if (NAME_(media_read)(s, sector + 150, data, psub, qsub) < 0) {
			/* Read error. */
			NAME_(unrecovered_read_error)(s);
			return;
		}
		memcpy(s->NAME.buf, data, 2048); /* FIXME */
		NAME_(_send)(s, 2048);
		sector++;
		count--;
	}
}

/* Adapted from QEMU */
static void
padstr8(unsigned char *buf, int buf_size, const char *src)
{
	int i;

	for (i = 0; i < buf_size; i++) {
		if (*src) {
			buf[i] = *src++;

		} else {
			buf[i] = ' ';
		}
	}
}

/*
 * SCSI-3 SPC, 34
 *
 * 0x12, mandatory
 */
static void
NAME_(inquiry)(struct cpssp *s)
{
	uint8_t reserved0;
	uint8_t cmddt;
	uint8_t evpd;
	uint8_t lun;
	uint8_t page_or_operation_code;
	uint8_t reserved1;
	uint16_t allocation_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x12);
	reserved0 = (s->NAME.cmd_buf[1] >> 2) & 0x03;
	lun = (s->NAME.cmd_buf[1] >> 5);
	cmddt = (s->NAME.cmd_buf[1] >> 1) & 1;
	evpd = (s->NAME.cmd_buf[1] >> 0) & 1;
	page_or_operation_code = s->NAME.cmd_buf[2];
	reserved1 = s->NAME.cmd_buf[3];
	allocation_length = s->NAME.cmd_buf[4];
	/* control = s->NAME.cmd_buf[5]; not used */

	/* Check reserved/unsupported fields. */
	if (reserved0 != 0
	 || cmddt != 0
	 || evpd != 0
	 || page_or_operation_code != 0
	 || reserved1 != 0) {
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

	if (allocation_length == 0) {
		/* Only transfer header. */
		allocation_length = 5;
	}
	if (96 < allocation_length) {
		allocation_length = 96;
	}

	if (lun == 0
	 && s->NAME.lun == 0) {
		s->NAME.buf[0] = (0 << 5)    /* Peripheral qualifier */
			| (5 << 0);     /* CDROM */
		s->NAME.buf[1] = (1 << 7)    /* Removable medium */
			| (0 << 0);     /* Reserved */
		s->NAME.buf[2] = (0 << 6)    /* ISO/IEC version */
			| (0 << 3)      /* ECMA version */
			| (3 << 0);     /* ANSI version (compliant to SCSI-3) */
		s->NAME.buf[3] = (0 << 7)    /* No async event reporting */
			| (0 << 6)      /* No terminate task function */
			| (0 << 5)      /* No normal ACA support */
			| (0 << 4)      /* Reserved */
			| (2 << 0);     /* Response data format compliant to SCSI-3 */
		s->NAME.buf[4] = 95 - 4;/* Additional transfer length */
		s->NAME.buf[5] = 0;	/* Reserved */
		s->NAME.buf[6] = (0 << 7)    /* Reserved */
			| (0 << 6)      /* EncServ */
			| (0 << 5)      /* VS */
			| (0 << 4)      /* MultiP */
			| (0 << 3)      /* MChngr */
			| (0 << 2)      /* ACKREQQ */
			| (0 << 1)      /* Addr32 */
			| (0 << 0);     /* Addr16 */
		s->NAME.buf[7] = (0 << 7)    /* RelAdr */
			| (0 << 6)      /* WBus32 */
			| (0 << 5)      /* WBus16 */
			| (0 << 4)      /* Sync */
			| (0 << 3)      /* Linked */
			| (0 << 2)      /* TranDis */
			| (0 << 1)      /* CmdQue */
			| (0 << 0);     /* VS */
		padstr8(&s->NAME.buf[8], 8, "FAUM"); /* Vendor identification */
#if CD_WRITER_SUPPORT && CD_WRITER_RW_SUPPORT
		padstr8(&s->NAME.buf[16], 16, "CD/DVD-RW"); /*Product identification*/
#elif CD_WRITER_SUPPORT
		padstr8(&s->NAME.buf[16], 16, "CD/DVD-R"); /*Product identification*/
#else
		padstr8(&s->NAME.buf[16], 16, "CD/DVD-ROM"); /*Product identification*/
#endif
		padstr8(&s->NAME.buf[32], 4, "1.0"); /* Product revision level */
		memset(&s->NAME.buf[36], 0, 56 - 36); /* Vendor-specific */
		memset(&s->NAME.buf[56], 0, 96 - 56); /* Reserved */
	} else {
		s->NAME.buf[0] = 0x7f; /* No device on this lun. */
		memset(&s->NAME.buf[1], 0, 36 - 1); /* not needed */
		memset(&s->NAME.buf[36], 0, 56 - 36); /* Vendor-specific */
		memset(&s->NAME.buf[56], 0, 96 - 56); /* Reserved */
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

/*
 * Write Parameters
 *
 * SCSI-3
 * MMC: page 89
 * MMC-2: page 111
 */
static void
NAME_(modepage_write_parameters_set)(struct cpssp *cpssp, uint8_t *p)
{
	/* p[0]: PS, Reserved, Page Code */
	/* p[1]: Page Length */
	cpssp->NAME.write_parameter_bufe = (p[2] >> 6) & 0x1;
	cpssp->NAME.write_parameter_ls_v = (p[2] >> 5) & 0x1;
	cpssp->NAME.write_parameter_test_write = (p[2] >> 4) & 0x1;
	cpssp->NAME.write_parameter_write_type = (p[2] >> 0) & 0xf;
	cpssp->NAME.write_parameter_multi_session = (p[3] >> 6) & 0x3;
	cpssp->NAME.write_parameter_fp = (p[3] >> 5) & 0x1;
	cpssp->NAME.write_parameter_copy = (p[3] >> 4) & 0x1;
	cpssp->NAME.write_parameter_track_mode = (p[3] >> 0) & 0xf;
	cpssp->NAME.write_parameter_data_block_type = (p[4] >> 0) & 0xf;
	cpssp->NAME.write_parameter_link_size = p[5];
	/* p[6]: Reserved */
	cpssp->NAME.write_parameter_host_application_code = (p[7] >> 0) & 0x3f;
	cpssp->NAME.write_parameter_session_format = p[8];
	/* p[9]: Reserved */
	cpssp->NAME.write_parameter_packet_size = (p[10] << 24)
			| (p[11] << 16)
			| (p[12] <<  8)
			| (p[13] <<  0);
	cpssp->NAME.write_parameter_audio_pause_length = (p[14] << 8)
			| (p[15] <<  0);
	memcpy(cpssp->NAME.write_parameter_media_catalog_number,
			&p[16], sizeof(cpssp->NAME.write_parameter_media_catalog_number));
	memcpy(cpssp->NAME.write_parameter_i18n_standard_recording_code,
			&p[16], sizeof(cpssp->NAME.write_parameter_i18n_standard_recording_code));
	cpssp->NAME.write_parameter_sub_header_byte[0] = p[48];
	cpssp->NAME.write_parameter_sub_header_byte[1] = p[49];
	cpssp->NAME.write_parameter_sub_header_byte[2] = p[50];
	cpssp->NAME.write_parameter_sub_header_byte[3] = p[51];

#if 0
	fprintf(stderr, "bufe = %d\n",
			cpssp->NAME.write_parameter_bufe);
	fprintf(stderr, "ls_v = %d\n",
			cpssp->NAME.write_parameter_ls_v);
	fprintf(stderr, "test_write = %d\n",
			cpssp->NAME.write_parameter_test_write);
	fprintf(stderr, "write_type = %d\n",
			cpssp->NAME.write_parameter_write_type);
	fprintf(stderr, "multi_session = %d\n",
			cpssp->NAME.write_parameter_multi_session);
	fprintf(stderr, "copy = %d\n",
			cpssp->NAME.write_parameter_copy);
	fprintf(stderr, "track_mode = %d\n",
			cpssp->NAME.write_parameter_track_mode);
	fprintf(stderr, "data_block_type = %d\n",
			cpssp->NAME.write_parameter_data_block_type);
	fprintf(stderr, "link_size = %d\n",
			cpssp->NAME.write_parameter_link_size);
	fprintf(stderr, "host_application_code = %d\n",
			cpssp->NAME.write_parameter_host_application_code);
	fprintf(stderr, "packet_size = %d\n",
			cpssp->NAME.write_parameter_packet_size);
	fprintf(stderr, "audio_pause_length = %d\n",
			cpssp->NAME.write_parameter_audio_pause_length);
	fprintf(stderr, "sub_header_byte[0..3] = 0x%02x, 0x%02x, 0x%02x, 0x%02x\n",
			cpssp->NAME.write_parameter_sub_header_byte[0],
			cpssp->NAME.write_parameter_sub_header_byte[1],
			cpssp->NAME.write_parameter_sub_header_byte[2],
			cpssp->NAME.write_parameter_sub_header_byte[3]);
#endif
}

static void
NAME_(modepage_write_parameters_get)(struct cpssp *cpssp, uint8_t *p, int pc)
{
	/* 0: Current, 1: Changeable, 2: Default */
	switch (pc) {
	case 0:
	case 2:
		p[0] = (0 << 7) /* PS */
			| (0 << 6) /* Reserved */
			| (0x05 << 0); /* Page Code */
		p[1] = 0x34 - 2; /* Page Length */
		break;
	case 1:
		p[0] = 0x00;
		p[1] = 0x00;
		break;
	}
	switch (pc) {
	case 0:
		p[2] = (cpssp->NAME.write_parameter_bufe << 6)
			| (cpssp->NAME.write_parameter_ls_v << 5)
			| (cpssp->NAME.write_parameter_test_write << 4)
			| (cpssp->NAME.write_parameter_write_type << 0);
		break;
	case 1: p[2] = 0x7f; break;
	case 2: p[2] = (0 << 5) | (0 << 4) | (0x01 << 0); break;
	}
	switch (pc) {
	case 0: p[3] = (cpssp->NAME.write_parameter_multi_session << 6)
		| (cpssp->NAME.write_parameter_fp << 5)
		| (cpssp->NAME.write_parameter_copy << 4)
		| (cpssp->NAME.write_parameter_track_mode << 0);
		break;
	case 1: p[3] = 0x0f; break;
	case 2: p[3] = (0 << 6) | (0 << 5) | (0 << 4) | (0x5 << 0); break;
	}
	switch (pc) {
	case 0: p[4] = (0 << 4)
		| (cpssp->NAME.write_parameter_data_block_type << 0);
		break;
	case 1: p[4] = 0x0f; break;
	case 2: p[4] = (0 << 4) | (0x8 << 0); break;
	}
	switch (pc) {
	case 0: p[5] = cpssp->NAME.write_parameter_link_size; break;
	case 1: p[5] = 0xff; break;
	case 2: p[5] = 0x00; break;
	}
	switch (pc) {
	case 0: p[6] = 0x00; break;
	case 1: p[6] = 0x00; break;
	case 2: p[6] = 0x00; break;
	}
	switch (pc) {
	case 0: p[7] = (0 << 6)
		| (cpssp->NAME.write_parameter_host_application_code << 0);
		break;
	case 1: p[7] = 0x3f; break;
	case 2: p[7] = (0 << 6) | (0x00 << 0); break;
	}
	switch (pc) {
	case 0: p[8] = cpssp->NAME.write_parameter_session_format; break;
	case 1: p[8] = 0xff; break;
	case 2: p[8] = 0x00; break;
	}
	switch (pc) {
	case 0: p[9] = 0x00; break;
	case 1: p[9] = 0x00; break;
	case 2: p[9] = 0x00; break;
	}
	switch (pc) {
	case 0: p[10] = (cpssp->NAME.write_parameter_packet_size >> 24) & 0xff;
		p[11] = (cpssp->NAME.write_parameter_packet_size >> 16) & 0xff;
		p[12] = (cpssp->NAME.write_parameter_packet_size >>  8) & 0xff;
		p[13] = (cpssp->NAME.write_parameter_packet_size >>  0) & 0xff;
		break;
	case 1: p[10] = 0xff;
		p[11] = 0xff;
		p[12] = 0xff;
		p[13] = 0xff;
		break;
	case 2: p[10] = 0x00;
		p[11] = 0x00;
		p[12] = 0x00;
		p[13] = 0x00;
		break;
	}
	switch (pc) {
	case 0: p[14] = (cpssp->NAME.write_parameter_audio_pause_length >> 8) & 0xff;
		p[15] = (cpssp->NAME.write_parameter_audio_pause_length >> 0) & 0xff;
		break;
	case 1: p[14] = 0xff;
		p[15] = 0xff;
		break;
	case 2: p[14] = (150 >> 8) & 0xff;
		p[15] = (150 >> 0) & 0xff;
		break;
	}
	switch (pc) {
	case 0: memcpy(&p[16], cpssp->NAME.write_parameter_media_catalog_number,
			sizeof(cpssp->NAME.write_parameter_media_catalog_number));
		break;
	case 1: memset(&p[16], 0xff, sizeof(cpssp->NAME.write_parameter_media_catalog_number));
		break;
	case 2: memset(&p[16], 0x00, sizeof(cpssp->NAME.write_parameter_media_catalog_number));
		break;
	}
	switch (pc) {
	case 0: memcpy(&p[32], cpssp->NAME.write_parameter_i18n_standard_recording_code,
			sizeof(cpssp->NAME.write_parameter_i18n_standard_recording_code));
		break;
	case 1: memset(&p[32], 0xff, sizeof(cpssp->NAME.write_parameter_i18n_standard_recording_code));
		break;
	case 2: memset(&p[32], 0x00, sizeof(cpssp->NAME.write_parameter_i18n_standard_recording_code));
		break;
	}
	switch (pc) {
	case 0: p[48] = cpssp->NAME.write_parameter_sub_header_byte[0];
		p[49] = cpssp->NAME.write_parameter_sub_header_byte[1];
		p[50] = cpssp->NAME.write_parameter_sub_header_byte[2];
		p[51] = cpssp->NAME.write_parameter_sub_header_byte[3];
		break;
	case 1: p[48] = 0xff;
		p[49] = 0xff;
		p[50] = 0xff;
		p[51] = 0xff;
		break;
	case 2: p[48] = 0x00;
		p[49] = 0x00;
		p[50] = 0x00;
		p[51] = 0x00;
		break;
	}
}

static void
NAME_(mode_select_gen)(
	struct cpssp *s,
	int cmd_len,
	uint16_t parameter_list_length
)
{
	unsigned char *pointer;
	int block_descriptor_length;

	pointer = s->NAME.buf;

	if (cmd_len == 10) {
		/* skip 8 bytes header */
		pointer += 8;
		parameter_list_length -= 8;

		/* After 8 bytes header there may be block descriptors */
		block_descriptor_length = (s->NAME.buf[6] << 8) | s->NAME.buf[7];
	} else {
		/* skip 4 bytes header */
		pointer += 4;
		parameter_list_length -= 4;

		/* After 4 bytes header there may be block descriptors */
		block_descriptor_length = s->NAME.buf[3];
	}

	while (0 < block_descriptor_length) {
		/* 8 bytes block descriptors */
		pointer += 8;
		parameter_list_length -= 8;
		block_descriptor_length -= 8;
		/* Do nothing here because block descriptors must not be supported:
		 * MMC-5 P.648 A.3 */
	}

	/* finally process mode pages */
	/* FIXME there is no verification whether the parameters are valid */
	while (0 < parameter_list_length) {
		switch (pointer[0] & 0x3f) {
		case 0x05:
			/* Write Parameters */
			NAME_(modepage_write_parameters_set)(s, pointer);
			break;

		case 0x0e:
			/*
			 * CD Audio Control Parameters
			 *
			 * SCSI-3
			 * MMC: page 75
			 * MMC-2: page ?
			 */
			/* FIXME: do we have to set something here? */
			break;

		case 0x2a:
			/*
			 * MM Capabilities and Mechanical Status Page (ro)
			 *
			 * SCSI-3
			 * MMC: page ?
			 * MMC-2: page ?
			 */
			break;

		default:
			/* Invalid Field in Parameter List */
			NAME_(invalid_field_in_parameter_list)(s);
			return;
		}

		/*
		 * Decrease parameter list length and increase pointer
		 * (do not forget the 2 bytes header not included in
		 * pointer[1]).
		 */
		parameter_list_length -= pointer[1] + 2;
		pointer += pointer[1] + 2;
	}
}

/*
 * SCSI-3
 *
 * SPC: page 45
 *
 * 0x15, mandatory
 */
static void
NAME_(mode_select_6)(struct cpssp *s)
{
	int pf;
	int sp;
	uint16_t parameter_list_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x15);
	/* (s->NAME.cmd_buf[1] >> 5) & 0x7: Reserved */
	pf = (s->NAME.cmd_buf[1] >> 4) & 1;
	/* (s->NAME.cmd_buf[1] >> 1) & 0x7: Reserved */
	sp = (s->NAME.cmd_buf[1] >> 0) & 1;
	/* s->NAME.cmd_buf[2]: Reserved */
	/* s->NAME.cmd_buf[3]: Reserved */
	parameter_list_length = s->NAME.cmd_buf[4];
	/* s->NAME.cmd_buf[5]: Control */

	if (sp == 1) {
		/* We don't support saved pages. */
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

	NAME_(phase_data_out)(s);
	NAME_(_recv)(s, parameter_list_length);

	if (pf == 1) {
		/* According to Standard */
		NAME_(mode_select_gen)(s, 6, parameter_list_length);

	} else {
		/* Vendor Specific */
		fprintf(stderr, "%s: WARNING: %s (Ignored).\n", progname,
				"Got vendor specific mode_select_6");
	}
}

/*
 * SCSI-3
 *
 * SPC: page 47
 *
 * 0x55, mandatory
 */
static void
NAME_(mode_select_10)(struct cpssp *s)
{
	int pf;
	int sp;
	uint16_t parameter_list_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x55);
	/* (s->NAME.cmd_buf[1] >> 5) & 0x7: Reserved */
	pf = (s->NAME.cmd_buf[1] >> 4) & 1;
	/* (s->NAME.cmd_buf[1] >> 1) & 0x7: Reserved */
	sp = (s->NAME.cmd_buf[1] >> 0) & 1;
	/* s->NAME.cmd_buf[2]: Reserved */
	/* s->NAME.cmd_buf[3]: Reserved */
	parameter_list_length = (s->NAME.cmd_buf[7] << 8)
		| s->NAME.cmd_buf[8];
	/* s->NAME.cmd_buf[9]: Control */

	if (sp == 1) {
		/* We don't support saved pages. */
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

	NAME_(phase_data_out)(s);
	NAME_(_recv)(s, parameter_list_length);

	if (pf == 1) {
		/* According to Standard */
		NAME_(mode_select_gen)(s, 10, parameter_list_length);
	} else {
		/* Vendor Specific */
		fprintf(stderr, "%s: WARNING: %s (Ignored).\n", progname,
				"Got vendor specific mode_select_10");
	}
}

static void
NAME_(mode_sense_gen)(
	struct cpssp *s,
	int cmd_len,
	int dbd,
	int pc,
	unsigned int page_code,
	uint16_t allocation_length
)
{
	unsigned int offset;
	unsigned int handled = 0;
	int i; /* just for counting */

	/*
	 * Fill header.
	 */
	offset = 0;

	/* Mode data length */
	/* Will be filled later. */
	if (cmd_len == 6) {
		offset += 1;
	} else {
		offset += 2;
	}

	/* Medium Type */
	/* SCSI-3 MMC 73 */
	s->NAME.buf[offset++] = 0x01; /* CD-ROM, data only, 120mm (obsolete?) */

	/* Device specific parameter */
	/* SCSI-3 MMC 73 */
	s->NAME.buf[offset++] = 0x00;

	if (cmd_len == 10) {
		/* Reserved */
		s->NAME.buf[offset++] = 0x00;
		s->NAME.buf[offset++] = 0x00;
	}

	/* Block Descriptor Lenght */
	if (cmd_len == 6) {
		s->NAME.buf[offset++] = 0x00;
	} else {
		s->NAME.buf[offset++] = 0x00;
		s->NAME.buf[offset++] = 0x00;
	}

	assert((cmd_len ==  6 && offset == 4)
	    || (cmd_len == 10 && offset == 8));

	/*
	 * Fill block descriptor table.
	 */
	/* Nothing to do... No table... */

	/*
	 * Fill mode pages.
	 */
	if (page_code == 0x01
	 || page_code == 0x3f) {
		/* SCSI-3 MMC 78 */
		/* PS, Reserved, Page Code */
		s->NAME.buf[offset++] = (0 << 7) | (0 << 6) | (0x01 << 0);
		/* Parameter Length */
		s->NAME.buf[offset++] = 6;
		handled = 1; /* no need to generate check condition if handled */
		switch (pc) {
		case 0: /* Read Current */
		case 2: /* Default Values */
			/* Error Recovery Parameter */
			s->NAME.buf[offset++] = 0x00;
			/* Read Retry Count */
			s->NAME.buf[offset++] = 3;
			/* Reserved */
			s->NAME.buf[offset++] = 0;
			s->NAME.buf[offset++] = 0;
			s->NAME.buf[offset++] = 0;
			s->NAME.buf[offset++] = 0;
			break;
		case 1:
			/* Read Changeable */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;
		case 3: /* Saved values */
		default:
			/* Saved pages not supported. */
			NAME_(invalid_field_in_cdb)(s);
		}
	}
	if (page_code == 0x05
	 || page_code == 0x3f) {
		/* SCSI-3 MMC 89 - Write Parameters */
		/* size = 0x32 + 2 */
		handled = 1; /* no need to generate check condition if handled */
		NAME_(modepage_write_parameters_get)(s, &s->NAME.buf[offset], pc);
		offset += 0x34;
	}
	if (page_code == 0x0d
	 || page_code == 0x3f) {
		/* SCSI-3 MMC 77 */
		/* PS, Reserved, Page Code */
		s->NAME.buf[offset++] = (0 << 7) | (0 << 6) | (0x0d << 0);
		/* Parameter Lenght */
		s->NAME.buf[offset++] = 6;
		handled = 1; /* no need to generate check condition if handled */
		switch (pc) {
		case 0: /* Read Current */
		case 2: /* Default Values */
			/* Reserved */
			s->NAME.buf[offset++] = 0x00;
			/* Reserved, Inactivity Timer Multiplier */
			s->NAME.buf[offset++] = (0 << 4) | (0x1 << 0);
			/* Number Of MSF - S Units Per MSF - M Unit */
			s->NAME.buf[offset++] = 60 / 256;
			s->NAME.buf[offset++] = 60 % 256;
			/* Number Of MSF - F Units Per MSF - S Unit */
			s->NAME.buf[offset++] = 75 / 256;
			s->NAME.buf[offset++] = 75 % 256;
			break;
		case 1: /* Read Changeable */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;
		default:
			/* Saved pages not supported. */
			NAME_(invalid_field_in_cdb)(s);
		}
	}
	if (page_code == 0x0e
	 || page_code == 0x3f) {
		/* SCSI-3 MMC 75 */
		/* PS, Reserved, Page Code */
		s->NAME.buf[offset++] = (0 << 7) | (0 << 6) | (0x0e << 0);
		/* Parameter Lenght */
		s->NAME.buf[offset++] = 0x0e;
		handled = 1; /* no need to generate check condition if handled */
		switch (pc) {
		case 0: /* Read Current */
		case 2: /* Default Values */
			/* Reserved, IMMED, SOTC, Reserved */
			s->NAME.buf[offset++] = (0 << 3) | (1 << 2) | (0 << 1) | (0 << 0);
			/* Reserved */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			/* Obsolete */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			/* Reserved, Output Port 0 Channel Selection */
			s->NAME.buf[offset++] = (0 << 5) | (1 << 0);
			/* Output Port 0 Volume */
			s->NAME.buf[offset++] = 0xff;
			/* Reserved, Output Port 1 Channel Selection */
			s->NAME.buf[offset++] = (0 << 5) | (2 << 0);
			/* Output Port 1 Volume */
			s->NAME.buf[offset++] = 0xff;
			/* Reserved, Output Port 2 Channel Selection */
			s->NAME.buf[offset++] = (0 << 5) | (0 << 0);
			/* Output Port 2 Volume */
			s->NAME.buf[offset++] = 0x00;
			/* Reserved, Output Port 3 Channel Selection */
			s->NAME.buf[offset++] = (0 << 5) | (0 << 0);
			/* Output Port 3 Volume */
			s->NAME.buf[offset++] = 0x00;
			break;
		case 1: /* Read Changeable */
			for (i=0; i < 14; i++) {
				s->NAME.buf[offset++] = 0x00;
			}
			break;
		default:
			/* Saved pages not supported. */
			NAME_(invalid_field_in_cdb)(s);
		}
	}
	if (page_code == 0x2a
	 || page_code == 0x3f) {
		/* CD capabilities and mechanical status page */
		/* SCSI-3 MMC pp. 79-82 */
		handled = 1; /* no need to generate check condition if handled */

		/* byte 0 */
		s->NAME.buf[offset++] =      (0 << 7) /* PS not supported */
					|    (0 << 6) /* reserved */
					| (0x2a << 0) /* Page Code */
					;
		/* byte 1 */
		s->NAME.buf[offset++] = 0x14; /* page length */

		switch (pc) {
		case 0: /* Read Current */
		case 2: /* Default Values */
			/* byte 2 */
			s->NAME.buf[offset++] =   (0 << 3) /* reserved */
						| (0 << 2) /* Method 2 */
						| (1 << 1) /* read CD-RW */
						| (1 << 0) /* read CD-R */
						;
			/* byte 3 */
			s->NAME.buf[offset++] =   (0 << 3)  /* reserved */
#if CD_WRITER_SUPPORT
			/* test write is mandatory here, otherwise windows will
			 * not recognize the cd-media */
						| (1 << 2) /* Test Write */
						| (1 << 1) /* write CD-RW */
						| (1 << 0) /* write CD-R */
#else
						| (0 << 2) /* Test Write */
						| (0 << 1) /* write CD-RW */
						| (0 << 0) /* write CD-R */
#endif
						;
			/* byte 4 */
			s->NAME.buf[offset++] =   (0 << 7) /* reserved */
						| (1 << 6) /* Multi Session */
						| (0 << 5) /* Mode 2 Form 2 */
						| (0 << 4) /* Mode 2 Form 1 */
						| (0 << 3) /* Digital Port 2 */
						| (0 << 2) /* Digital Port 1 */
#if CD_AUDIO_SUPPORT
						| (1 << 1) /* Composite */
						| (1 << 0) /* Audio Play */
#else
						| (0 << 1) /* Composite */
						| (0 << 0) /* Audio Play */
#endif
						;
			/* byte 5 */
			s->NAME.buf[offset++] =   (0 << 7)  /* Read Bar Code */
						| (1 << 6)  /* UPC */
#if CD_AUDIO_SUPPORT 
						| (1 << 5) /* ISRC */
						| (1 << 4) /* C2 Pointers */
						| (1 << 3) /* R-W De-interleaved & corr. */
						| (1 << 2) /* R-W Supported */
						| (1 << 1) /* CD-DA Stream Accurate */
						| (1 << 0) /* CD-DA Commands Supported */
#else
						| (0 << 5) /* ISRC */
						| (0 << 4) /* C2 Pointers */
						| (0 << 3) /* R-W De-interleaved & corr. */
						| (0 << 2) /* R-W Supported */
						| (0 << 1) /* CD-DA Stream Accurate */
						| (0 << 0) /* CD-DA Commands Supported */
#endif
						;
			/* byte 6 */
			s->NAME.buf[offset++] =   (1 << 5) /* Loading Mechanism: tray */
						| (0 << 4) /* reserved */
						| (1 << 3) /* Eject (via START STOP) */
						| (0 << 2) /* Prevent Jumper */
						| (s->NAME.locked << 1) /* Lock State */
						| (1 << 0) /* Lock possible */
						;
			/* byte 7 */
			s->NAME.buf[offset++] =   (0 << 4) /* reserved */
						| (0 << 3) /* S/W Slot Selection */
						| (0 << 2) /* Changer Supports Disc Present */
#if CD_AUDIO_SUPPORT
						| (1 << 1) /* Separate Channel Mute */
						| (1 << 0) /* Separate volume levels */
#else
						| (0 << 1) /* Separate Channel Mute */
						| (0 << 0) /* Separate volume levels */
#endif
						;
			/* byte 8/9 */
			s->NAME.buf[offset++] = 0x05; /* max read speed */
			s->NAME.buf[offset++] = 0x83;

			/* byte 10/11 */
			s->NAME.buf[offset++] = 0x01; /* # of volume levels */
			s->NAME.buf[offset++] = 0x00;

			/* byte 12/13 */
			s->NAME.buf[offset++] = 0x00; /* buffer size */
			s->NAME.buf[offset++] = 0x00;

			/* byte 14/15 */
			s->NAME.buf[offset++] = 0x05; /* current read speed */
			s->NAME.buf[offset++] = 0x83;

			/* byte 16 */
			s->NAME.buf[offset++] = 0x00; /* reserved */

			/* byte 17 */
			s->NAME.buf[offset++] = 0x00; /* digital out control */
#if CD_WRITER_SUPPORT
			/* byte 18/19 */
			s->NAME.buf[offset++] = 0x05; /* max write speed */
			s->NAME.buf[offset++] = 0x83;

			/* byte 20/21 */
			s->NAME.buf[offset++] = 0x05; /* curr write speed */
			s->NAME.buf[offset++] = 0x83;
#else
			/* byte 18/19 */
			s->NAME.buf[offset++] = 0x00; /* max write speed */
			s->NAME.buf[offset++] = 0x00;

			/* byte 20/21 */
			s->NAME.buf[offset++] = 0x00; /* curr write speed */
			s->NAME.buf[offset++] = 0x00;
#endif
			break;
		case 1: /* Read Changeable */
			for (i = 0; i < 38; i++) {
				s->NAME.buf[offset++] = 0x00;
			}
			break;
		default:
			/* Saved pages not supported. */
			NAME_(invalid_field_in_cdb)(s);
			return;
		}
	}
	if (! handled) {
		/* if it was no implemented mode page */
		NAME_(invalid_field_in_cdb)(s);
		return;
	}
	/* Patch data length */
	if (cmd_len == 10) {
		s->NAME.buf[0] = (offset - 2) / 256;
		s->NAME.buf[1] = (offset - 2) % 256;
	} else {
		s->NAME.buf[0] = offset - 2;
	}

	if (offset < allocation_length) {
		allocation_length = offset;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

/*
 * SCSI-3 SPC 47
 *
 * 0x1a, mandatory
 */
static void
NAME_(mode_sense_6)(struct cpssp *s)
{
	int dbd;
	int pc;
	unsigned int page_code;
	uint8_t allocation_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x1a);
	/* (s->NAME.cmd_buf[1] >> 4) & 0xf: Reserved */
	dbd = (s->NAME.cmd_buf[1] >> 3) & 0x1;
	/* (s->NAME.cmd_buf[1] >> 0) & 0x7: Reserved */
	pc = (s->NAME.cmd_buf[2] >> 6) & 0x3;
	page_code = (s->NAME.cmd_buf[2] >> 0) & 0x3f;
	/* s->NAME.cmd_buf[3]: Reserved */
	allocation_length = s->NAME.cmd_buf[4];
	/* s->NAME.cmd_buf[5]: Control */

	if (pc == 3) {
		/* Saved pages not supported. */
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

	NAME_(mode_sense_gen)(s, 6, dbd, pc, page_code, allocation_length);
}

/*
 * SCSI-3 SPC 50
 *
 * 0x5a, mandatory
 */
static void
NAME_(mode_sense_10)(struct cpssp *s)
{
	int dbd;
	int pc;
	unsigned int page_code;
	uint16_t allocation_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x5a);
	/* (s->NAME.cmd_buf[1] >> 4) & 0xf: Reserved */
	dbd = (s->NAME.cmd_buf[1] >> 3) & 0x1;
	/* (s->NAME.cmd_buf[1] >> 0) & 0x7: Reserved */
	pc = (s->NAME.cmd_buf[2] >> 6) & 0x3;
	page_code = (s->NAME.cmd_buf[2] >> 0) & 0x3f;
	/* s->NAME.cmd_buf[3]: Reserved */
	/* s->NAME.cmd_buf[4]: Reserved */
	/* s->NAME.cmd_buf[5]: Reserved */
	/* s->NAME.cmd_buf[6]: Reserved */
	allocation_length = (s->NAME.cmd_buf[7] << 8) | (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control */

	if (pc == 3) {
		/* Saved pages not supported. */
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

	NAME_(mode_sense_gen)(s, 10, dbd, pc, page_code, allocation_length);
}

/*
 * SCSI-3 SPC ???
 *
 * 0x1e, mandatory
 */
static void
NAME_(prevent_allow_medium_removal)(struct cpssp *s)
{
	s->NAME.locked = s->NAME.cmd_buf[4] & 0x01;

	if (s->NAME.locked) {
		NAME_(media_lock)(s);
	} else {
		NAME_(media_unlock)(s);
	}
}

/*
 * SCSI-3 SPC ???
 *
 * 0x57, mandatory
 */
static void
NAME_(release_10)(struct cpssp *s)
{
	fixme();
}

/*
 * ATAPI working draft Rev 2.5 Page 171
 *
 * 0x03, mandatory
 */
static void
NAME_(request_sense)(struct cpssp *s)
{
	struct request_sense *sns = (struct request_sense *) s->NAME.buf;
	unsigned int length = s->NAME.cmd_buf[4]; /* Allocation Length */

	memset(sns, 0, length);

	sns->valid = 1;
	sns->error_code = 0x70;
	sns->sense_key = s->NAME.sense_key;
	sns->add_sense_len = 11;
	sns->asc = s->NAME.asc;
	sns->ascq = s->NAME.ascq;

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, length);
}

/*
 * SCSI-3 SPC ???
 *
 * 0x56, mandatory
 */
static void
NAME_(reserve_10)(struct cpssp *s)
{
	fixme();
}

/*
 * SCSI-3 SPC ???
 *
 * 0x0b, mandatory
 */
static void
NAME_(seek_6)(struct cpssp *s)
{
	fixme();
}

/*
 * SCSI-3 SBC P.51
 *
 * 0x2b, mandatory
 */
static void
NAME_(seek_10)(struct cpssp *s)
{
	/* Nothing to do... */
}

/*
 * SCSI-3 SPC ???
 *
 * 0x1d, mandatory
 */
static void
NAME_(send_diagnostic)(struct cpssp *s)
{
	fixme();
}

/*
 * SCSI-3
 *
 * SBC: page 53
 * SBC-3: page 72
 *
 * 0x1b, mandatory
 */
static void
NAME_(start_stop_unit)(struct cpssp *s)
{
	unsigned int immed;
	unsigned int power_conditions;
	unsigned int loej;
	unsigned int start;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x1b);
	immed = (s->NAME.cmd_buf[1] >> 0) & 1;
	/* s->NAME.cmd_buf[2]: Reserved */
	/* s->NAME.cmd_buf[3]: Reserved */
	power_conditions = (s->NAME.cmd_buf[4] >> 4) & 0xf;
	loej = (s->NAME.cmd_buf[4] >> 1) & 1;
	start = (s->NAME.cmd_buf[4] >> 0) & 1;
	/* s->NAME.cmd_buf[5]: Control */

	if (start) {
		if (loej) {
			/* Load Disc */
			/* FIXME */
		}
		/* Start the disc and read the TOC. */
		/* FIXME */

	} else {
		/* Stop the disc. */
		/* FIXME */
		s->NAME.locked = 0;
		if (loej) {
			/* Eject Disc */
			/* FIXME */
		}
	}
}

/*
 * SCSI-3 SPC 95
 */
static void
NAME_(test_unit_ready)(struct cpssp *s) /* 0x00, mandatory */
{
	if (s->NAME.inserted == 0) {
		/* Removed Media */
		NAME_(medium_not_present)(s);
		return;
	}
}

/*
 * SCSI-3
 * MMC: page 27
 * MMC-2: page 141 (Features: page 60)
 *
 * 0x46, mandatory
 */
static void
NAME_(get_configuration)(struct cpssp *s) /* 0x46 */
{
	unsigned int rt;
	uint16_t starting_feature_number;
	uint16_t allocation_length;
	unsigned int offset;
	enum {
		NONE,
		CD_RO,
		CD_WO,
		CD_RW,
	} medium;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x46);
	rt = s->NAME.cmd_buf[1] & 0x03;
	starting_feature_number = (s->NAME.cmd_buf[2] << 8)
		| s->NAME.cmd_buf[3];
	/* s->NAME.cmd_buf[4]: Reserved */
	/* s->NAME.cmd_buf[5]: Reserved */
	/* s->NAME.cmd_buf[6]: Reserved */
	allocation_length = (s->NAME.cmd_buf[7] << 8)
		| s->NAME.cmd_buf[8];
	/* s->NAME.cmd_buf[9]: Control */

	memset(s->NAME.buf, 0, allocation_length);

	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[1] later. */
	offset++;
	/* Patch s->NAME.buf[2] later. */
	offset++;
	/* Patch s->NAME.buf[3] later. */
	offset++;
	s->NAME.buf[offset++] = 0x00; /* Reserved */
	s->NAME.buf[offset++] = 0x00; /* Reserved */

	/* Currently we only have CD_RW media -- FIXME */
	if (! s->NAME.inserted) {
		s->NAME.buf[offset++] = 0x00;
		s->NAME.buf[offset++] = 0x00;
		medium = NONE;

	} else if (0) { /* FIXME */
		s->NAME.buf[offset++] = 0x00;
		s->NAME.buf[offset++] = 0x08;
		medium = CD_RO;

	} else if (0) { /* FIXME */
		s->NAME.buf[offset++] = 0x00;
		s->NAME.buf[offset++] = 0x09;
		medium = CD_WO;

	} else if (1) { /* FIXME */
		s->NAME.buf[offset++] = 0x00;
		s->NAME.buf[offset++] = 0x0A;
		medium = CD_RW;
	}
	assert(offset == 8);

	for (;;) {
		switch (starting_feature_number) {
		case 0x0000:
			/*
			 * Feature 0x0000: Profile list
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 2 * 4; /* Additional Length */

			s->NAME.buf[offset++] = 0x0A; // cd-rw
			s->NAME.buf[offset++] = (medium == CD_RW) ? 1 : 0;
			s->NAME.buf[offset++] = 0x09; // cd-r write once
			s->NAME.buf[offset++] = (medium == CD_WO) ? 1 : 0;
			s->NAME.buf[offset++] = 0x08; // cd-r read only
			s->NAME.buf[offset++] = (medium == CD_RO) ? 1 : 0;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x0001:
			/*
			 * Feature 0x0001: Core
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x01;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 0x04; /* Additional Length */

			s->NAME.buf[offset++] = 0x01; /* SCSI */
							/* ATAPI: 2 -- FIXME */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x0002:
			/*
			 * Feature 0x0002: Morphing
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x02;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 0x04; /* Additional Length */

			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x0003:
			/*
			 * Feature 0x0003: Removable Medium
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x03;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 0x04; /* Additional Length */

			s->NAME.buf[offset++] = (0x1 << 5) /* Tray type loading */
					| (1 << 3) /* Eject supported */
					| (1 << 0); /* Locking supported */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x0010:
			/*
			 * Feature 0x0010: Random Readable
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x10;
			if (! s->NAME.inserted
			 || s->NAME.nTOCs == 0) {
			 	/* No Media or media empty. */
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x08; /* Additional Length */

			s->NAME.buf[offset++] = (2048 >> 24) & 0xff;
			s->NAME.buf[offset++] = (2048 >> 16) & 0xff;
			s->NAME.buf[offset++] = (2048 >>  8) & 0xff;
			s->NAME.buf[offset++] = (2048 >>  0) & 0xff;
			s->NAME.buf[offset++] = (0x10 >> 8) & 0xff; /* Correct? -- FIXME */
			s->NAME.buf[offset++] = (0x10 >> 0) & 0xff;
			s->NAME.buf[offset++] = 0x01; /* Error Recovery Page Present */
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x001d:
			/*
			 * Feature 0x001d: Multi-Read
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x1d;
			s->NAME.buf[offset++] = 0x00; /* Correct? -- FIXME */
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x001e:
			/*
			 * Feature 0x001e: CD Read
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x1e;
			if (! s->NAME.inserted
			 || s->NAME.nTOCs == 0) {
			 	/* No Media or media empty. */
				s->NAME.buf[offset++] = (1 << 2) /* Version */
						| (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (1 << 2) /* Version */
						| (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x04; /* Additional Length */

			s->NAME.buf[offset++] = (0 << 1) /* C2 Flag */
					| (0 << 0); /* CD-Text */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x001f:
			/*
			 * Feature 0x001f: DVD read
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x1f;
			if (! s->NAME.inserted
			 || s->NAME.nTOCs == 0) {
			 	/* No Media or media empty. */
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x00; /* Additional Length */
			break;

		case 0x0020:
			/*
			 * Feature 0x0020: random writeable
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x20;
			s->NAME.buf[offset++] = (0 << 1) /* Persistent */
					| (0 << 0); /* Current */
			s->NAME.buf[offset++] = 0x0c; /* Additional Length */

			s->NAME.buf[offset++] = (0 >> 24) & 0xff; /* FIXME */
			s->NAME.buf[offset++] = (0 >> 16) & 0xff; /* FIXME */
			s->NAME.buf[offset++] = (0 >>  8) & 0xff; /* FIXME */
			s->NAME.buf[offset++] = (0 >>  0) & 0xff; /* FIXME */
			s->NAME.buf[offset++] = (2048 >> 24) & 0xff;
			s->NAME.buf[offset++] = (2048 >> 16) & 0xff;
			s->NAME.buf[offset++] = (2048 >>  8) & 0xff;
			s->NAME.buf[offset++] = (2048 >>  0) & 0xff;
			s->NAME.buf[offset++] = (0x10 >> 8) & 0xff; /* Correct? -- FIXME */
			s->NAME.buf[offset++] = (0x10 >> 0) & 0xff;
			s->NAME.buf[offset++] = 0x01; /* Error Recovery Page Present */
			s->NAME.buf[offset++] = 0x00;
			break;

		case 0x0021:
			/*
			 * Feature 0x0021: Incremental Streaming Writable
			 */
			/* Mandatory for CD-R and CD-RW */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x21;
			if (medium == CD_RW
			 || medium == CD_WO) {
			 	/* Writeable Media */
				s->NAME.buf[offset++] = (1 << 2) /* Version */
						| (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (1 << 2) /* Version */
						| (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x08; /* Additional Length */

			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			break;

		case 0x0026:
			/*
			 * Feature 0x0026: Restricted Overwrite
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x26;
			if (medium == CD_RW) {
				/* Rewritable Media */
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x00; /* Additional Length */
			break;

		case 0x002d:
			/*
			 * Feature 0x002d: CD Track at Once
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x2d;
			if (medium == CD_RW
			 || medium == CD_WO) {
				/* Writable Media */
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x04; /* Additional Length */
			
			s->NAME.buf[offset++] = (0 << 2) /* Test */
					| (1 << 1) /* CD-RW */
					| (0 << 0); /* R-W */
			s->NAME.buf[offset++] = 0x00; /* Reserved */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			s->NAME.buf[offset++] = 0x00; /* FIXME */
			break;

		case 0x002e:
			/*
			 * Feature 0x002e: CD Mastering
			 */
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = 0x2e;
			if (medium == CD_RW
			 || medium == CD_WO) {
				/* Writable Media */
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (1 << 0); /* Current */
			} else {
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
			}
			s->NAME.buf[offset++] = 0x04; /* Additional Length */
			
			s->NAME.buf[offset++] = (1 << 5) /* SAO */
					| (0 << 4) /* RAW-MS */
					| (0 << 3) /* RAW */
					| (0 << 2) /* Test */
					| (1 << 1) /* CD-RW */
					| (0 << 0); /* R-W */
			s->NAME.buf[offset++] = (1024 >> 16) & 0xff;
			s->NAME.buf[offset++] = (1024 >>  8) & 0xff;
			s->NAME.buf[offset++] = (1024 >>  0) & 0xff;
			break;

		case 0x0100:
			/*
			 * Feature 0x0100: Power Management
			 */
			s->NAME.buf[offset++] = 0x01;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 0x00; /* Additional Length */
			break;

		case 0x0105:
			/*
			 * Feature 0x0105: Time-out
			 */
			s->NAME.buf[offset++] = 0x01;
			s->NAME.buf[offset++] = 0x05;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 0x00; /* Additional Length */
			break;

		case 0x0107:
			/*
			 * Feature 0x0107: Real-Time Streaming
			 */
			s->NAME.buf[offset++] = 0x01;
			s->NAME.buf[offset++] = 0x07;
			s->NAME.buf[offset++] = (1 << 1) /* Persistent */
					| (1 << 0); /* Current */
			s->NAME.buf[offset++] = 0x00; /* Additional Length */
			break;

		default:
			if (rt == 2) {
				s->NAME.buf[offset++] = (starting_feature_number >> 8) & 0xff;
				s->NAME.buf[offset++] = (starting_feature_number >> 0) & 0xff;
				s->NAME.buf[offset++] = (0 << 1) /* Persistent */
						| (0 << 0); /* Current */
				s->NAME.buf[offset++] = 0x00; /* Additional Length */
			}
			break;
		}
		assert(offset % 4 == 0);
		if (rt == 2) {
			break;
		}
		starting_feature_number++;

		if (0x10000 - 64 < offset
		 || starting_feature_number == 0) {
			break;
		}
	}

	s->NAME.buf[0] = ((offset - 4) >> 24) & 0xff;
	s->NAME.buf[1] = ((offset - 4) >> 16) & 0xff;
	s->NAME.buf[2] = ((offset - 4) >>  8) & 0xff;
	s->NAME.buf[3] = ((offset - 4) >>  0) & 0xff;

	if (offset < allocation_length) {
		allocation_length = offset;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

#if CD_CHANGER_SUPPORT
/*
 * SCSI-3 MMC 25
 *
 * 0xa6, optional
 */
static void
NAME_(load_unload)(struct cpssp *s)
{
	fixme();
}
#endif

/*
 * SCSI-3 MMC 27
 *
 * 0xbd, mandatory
 */
static void
NAME_(mechanism_status)(struct cpssp *s)
{
	uint16_t allocation_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0xbd);
	/* s->NAME.cmd_buf[1]: Reserved */
	/* s->NAME.cmd_buf[2]: Reserved */
	/* s->NAME.cmd_buf[3]: Reserved */
	/* s->NAME.cmd_buf[4]: Reserved */
	/* s->NAME.cmd_buf[5]: Reserved */
	/* s->NAME.cmd_buf[6]: Reserved */
	/* s->NAME.cmd_buf[7]: Reserved */
	allocation_length = (s->NAME.cmd_buf[8] << 8) | (s->NAME.cmd_buf[9] << 0);
	/* s->NAME.cmd_buf[10]: Reserved */
	/* s->NAME.cmd_buf[11]: Control */

	/* FIXME VOSSI */
	s->NAME.buf[0] = (0 << 7)	/* Fault */
		| (0 << 5)		/* Changer State: Ready */
		| (0 << 0);		/* Current Slot (LSB): 0 */
	s->NAME.buf[1] = (0 << 5)	/* Mechanism State: Idle */
		| (0 << 4)		/* Door Open: No */
		| (0 << 3)		/* Reserved */
		| (0 << 0);		/* Current Slot (MSB): 0 */
	s->NAME.buf[2] = 0;		/* Current LBA (MSB): 0 */
	s->NAME.buf[3] = 0;		/* Current LBA      : 0 */
	s->NAME.buf[4] = 0;		/* Current LBA (LSB): 0 */
	s->NAME.buf[5] = 0;		/* Number of Slots: 0 */
	s->NAME.buf[6] = 0;		/* Length of Slot Table (MSB): 0 */
	s->NAME.buf[7] = 0;		/* Length of Slot Table (LSB): 0 */

	if (8 < allocation_length) {
		allocation_length = 8;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

#if CD_AUDIO_SUPPORT
/*
 * SCSI-3 MMC 30
 *
 * 0x4b, mandatory for audio
 */
static void
NAME_(pause_resume)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_AUDIO_SUPPORT
/*
 * SCSI-3 MMC 31
 *
 * 0x45, mandatory for audio
 */
static void
NAME_(play_audio_10)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_AUDIO_SUPPORT
/*
 * SCSI-3 MMC 32
 *
 * 0xa5, mandatory for audio
 */
static void
NAME_(play_audio_12)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_AUDIO_SUPPORT
/*
 * SCSI-3 MMC 33
 *
 * 0xa7, mandatory for audio
 */
static void
NAME_(play_audio_msf)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_PLAY_CD_SUPPORT
/*
 * SCSI-3 MMC 34
 *
 * 0xbc, optional
 */
static void
NAME_(play_cd)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_READ_CD_SUPPORT
/*
 * SCSI-3 MMC 36
 *
 * 0xbe, optional
 */
static void
NAME_(read_cd)(struct cpssp *s)
{
	assert(/* s->NAME.cmd_buf[1]  == 0 FIXME similang
		  && */ s->NAME.cmd_buf[2]  == 0
			&& s->NAME.cmd_buf[3]  == 0
			&& s->NAME.cmd_buf[4]  == 0
			&& s->NAME.cmd_buf[5]  == 0
			&& s->NAME.cmd_buf[6]  == 0
			&& s->NAME.cmd_buf[7]  == 0
			&& s->NAME.cmd_buf[8]  == 0
			&& s->NAME.cmd_buf[9]  == 0
			&& s->NAME.cmd_buf[10] == 0
			&& s->NAME.cmd_buf[11] == 0);
}
#endif

#if CD_READ_CD_SUPPORT
/*
 * SCSI-3 MMC 44
 *
 * 0xb9, optional
 */
static void
NAME_(read_cd_msf)(struct cpssp *s)
{
	fixme();
}
#endif

/*
 * SCSI-3 MMC 45
 *
 * 0x25, mandatory
 *
 * Return number (LBA) and size of last block.
 *
 * On a one-track read-once CD (Redhat-8.0 #1)
 * the Read-Recorded-Capacity command sends
 *
 * 00 05 08 1e 00 00 08 00
 *
 * Size of track is 675653632 bytes.
 */
static void
NAME_(read_cd_recorded_capacity)(struct cpssp *cpssp)
{
	int32_t lba;
	unsigned int i;

	if (cpssp->NAME.inserted == 0) {
		/* Removed Media */
		NAME_(medium_not_present)(cpssp);
		return;
	}

	lba = 0; /* In case disc is empty. */

	for (i = 0; i < cpssp->NAME.nTOCs; i++) {
		if (cpssp->NAME.TOC[i].track == 0xa2) {
			NAME_(msf100_to_lba)(&cpssp->NAME.TOC[i].pmin100,
					&lba);
			lba--; /* Return number of *last* block. */
		}
	}

	/* Logical Block Address */
	cpssp->NAME.buf[0] = (lba >> 24) & 0xff;
	cpssp->NAME.buf[1] = (lba >> 16) & 0xff;
	cpssp->NAME.buf[2] = (lba >>  8) & 0xff;
	cpssp->NAME.buf[3] = (lba >>  0) & 0xff;
	
	/* Block Length */
	cpssp->NAME.buf[4] = (2048 >> 24) & 0xff;
	cpssp->NAME.buf[5] = (2048 >> 16) & 0xff;
	cpssp->NAME.buf[6] = (2048 >>  8) & 0xff;
	cpssp->NAME.buf[7] = (2048 >>  0) & 0xff;

	NAME_(phase_data_in)(cpssp);
	NAME_(_send)(cpssp, 8);
}

#if 0 /* obsolete */
/*
 * SCSI-3 MMC 47
 *
 * 0x44, mandatory
 */
static void
NAME_(read_header)(struct cpssp *cpssp)
{
	fixme();
}
#endif

/*
 * SCSI-3 MMC 49
 *
 * 0x42, mandatory
 */
static void
NAME_(read_subchannel)(struct cpssp *s)
{
	unsigned int msf;
	unsigned int subq;
	unsigned int parameter_list;
	unsigned int offset = 0;
	uint16_t allocation_length;

	if (s->NAME.inserted == 0) {
		/* Removed Media */
		NAME_(medium_not_present)(s);
		return;
	}

	msf = (s->NAME.cmd_buf[1] >> 1) & 1;
	subq = (s->NAME.cmd_buf[2] >> 6) & 1;
	parameter_list = s->NAME.cmd_buf[3];
	allocation_length = (s->NAME.cmd_buf[7] << 8) | (s->NAME.cmd_buf[8] << 0);

	memset(s->NAME.buf, 0, allocation_length);

	/* prepare sub-q channel data header */

	s->NAME.buf[offset++] = 0; /* reserved */
	s->NAME.buf[offset++] = 0; /* audio status */
	s->NAME.buf[offset++] = 0; /* sub-channel data length msb */
	s->NAME.buf[offset++] = 0; /* sub-channel data length lsb */

#if CD_AUDIO_SUPPORT
	if (subq) {
		/* return sub-q data, too
		 * (only needed if audio is supported)
		 */
		fixme();
	}
#endif

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

static int
NAME_(read_toc_pma_atip_0)(
	struct cpssp *s,
	int msf,
	unsigned int first_reported_track
)
{
	unsigned int first_track_number;
	unsigned int last_track_number;
	uint8_t leadout_type;
	uint8_t leadout[4];
	unsigned int track;
	struct toc_entry *entry;
	unsigned int offset;

	if (! s->NAME.inserted
	 || s->NAME.nTOCs == 0) {
		/* Blank CD */
		NAME_(invalid_field_in_cdb)(s);
		return -1;
	}

	first_track_number = 0xff;
	last_track_number = 0;

	leadout_type = 0x00;
	leadout[0] = 0;
	leadout[1] = 0;
	leadout[2] = 0;
	leadout[3] = 0;

	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[2] later. */
	offset++;
	/* Patch s->NAME.buf[3] later. */
	offset++;
	/* Patch s->NAME.buf[4] later. */
	offset++;

	for (track = 0; track < s->NAME.nTOCs; track++) {
		entry = &s->NAME.TOC[track];

		switch (entry->track) {
		case 0xa0: /* First Track */
			break;
		case 0xa1: /* Last Track */
			break;
		case 0xa2: /* LEADOUT */
			if (leadout[0] < entry->pmin100
			 || (leadout[0] == entry->pmin100
			  && leadout[1] < entry->pmin)
			 || (leadout[0] == entry->pmin100
			  && leadout[1] == entry->pmin
			  && leadout[2] < entry->psec)
			 || (leadout[0] == entry->pmin100
			  && leadout[1] == entry->pmin
			  && leadout[2] == entry->psec
			  && leadout[3] < entry->pframe)) {
				/* Looking for *last* LEADOUT. */
				leadout_type = entry->type;
				leadout[0] = entry->pmin100;
				leadout[1] = entry->pmin;
				leadout[2] = entry->psec;
				leadout[3] = entry->pframe;
			}
			break;
		case 1 ... 99: /* Normal Track */
			if (entry->track < first_track_number) {
				first_track_number = entry->track;
			}
			if (last_track_number < entry->track) {
				last_track_number = entry->track;
			}
			if (entry->track < first_reported_track) {
				break;
			}

			s->NAME.buf[offset++] = 0x00; /* Reserved */
			s->NAME.buf[offset++] = entry->type; /* ADR/CONTROL */
			s->NAME.buf[offset++] = entry->track; /* Track */
			s->NAME.buf[offset++] = 0x00; /* Reserved */
			if (msf) {
				s->NAME.buf[offset++] = entry->pmin100; /* Reserved */
				s->NAME.buf[offset++] = entry->pmin;
				s->NAME.buf[offset++] = entry->psec;
				s->NAME.buf[offset++] = entry->pframe;
			} else {
				int32_t lba;

				NAME_(msf100_to_lba)(&entry->pmin100, &lba);
				s->NAME.buf[offset++] = (lba >> 24) & 0xff;
				s->NAME.buf[offset++] = (lba >> 16) & 0xff;
				s->NAME.buf[offset++] = (lba >>  8) & 0xff;
				s->NAME.buf[offset++] = (lba >>  0) & 0xff;
			}
			break;
		case 0xb0:
			/* Skip entry. */
			break;
		default:
			assert(0); /* FIXME */
		}
	}

	/* Add LEADOUT. */
	s->NAME.buf[offset++] = 0x00; /* Reserved */
	s->NAME.buf[offset++] = leadout_type; /* ADR/CONTROL */
	s->NAME.buf[offset++] = 0xaa; /* LEADOUT */
	s->NAME.buf[offset++] = 0x00; /* Reserved */
	if (msf) {
		s->NAME.buf[offset++] = leadout[0];
		s->NAME.buf[offset++] = leadout[1];
		s->NAME.buf[offset++] = leadout[2];
		s->NAME.buf[offset++] = leadout[3];
	} else {
		int32_t lba;

		NAME_(msf100_to_lba)(leadout, &lba);
		s->NAME.buf[offset++] = (lba >> 24) & 0xff;
		s->NAME.buf[offset++] = (lba >> 16) & 0xff;
		s->NAME.buf[offset++] = (lba >>  8) & 0xff;
		s->NAME.buf[offset++] = (lba >>  0) & 0xff;
	}

	/* Set Data Length. */
	s->NAME.buf[0] = ((offset - 2) >> 8) & 0xff;
	s->NAME.buf[1] = ((offset - 2) >> 0) & 0xff;

	/* Set First/Last Track Number. */
	s->NAME.buf[2] = first_track_number;
	s->NAME.buf[3] = last_track_number;

	return offset;
}

static unsigned int
NAME_(read_toc_pma_atip_1)(struct cpssp *s, int msf)
{
	unsigned int first_complete_session;
	unsigned int last_complete_session;
	unsigned int first_track_no;
	unsigned int first_track_index;
	unsigned int session;
	unsigned int start;
	unsigned int end;
	unsigned int i;
	unsigned int offset;

	if (! s->NAME.inserted
	 || s->NAME.nTOCs == 0) {
		/* Blank CD */
		NAME_(invalid_field_in_cdb)(s);
		return -1;
	}

	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[1] later. */
	offset++;

	first_complete_session = 1;
	last_complete_session = 1;

	session = 1;
	start = 0;
	while (start < s->NAME.nTOCs) {
                /*
                 * Calculate end of session.
                 */
                end = start;
                /* Scan tracks 0xa0-0xaf. */
                while (end < s->NAME.nTOCs
                    && 0xa0 <= s->NAME.TOC[end].track
                    && s->NAME.TOC[end].track <= 0xaf) {
                        end++;
                }
                /* Scan normal tracks. */
                while (end < s->NAME.nTOCs
                    && 1 <= s->NAME.TOC[end].track
                    && s->NAME.TOC[end].track <= 99) {
                        end++;
                }
                /* Scan tracks 0xb0-0xff. */
                while (end < s->NAME.nTOCs
                    && 0xb0 <= s->NAME.TOC[end].track
                    /* && s->NAME.TOC[end].track < 0xff */) {
                        end++;
                }

		/*
		 * Lookup first track in session.
		 */
		if (s->NAME.TOC[0].track == 0xa0) {
			first_track_no = s->NAME.TOC[0].pmin;
			for (i = 1; ; i++) {
				if (i == end) {
					/* Shouldn't happen... */
					first_track_no = 0;
					first_track_index = 0;
					break;
				}
				if (s->NAME.TOC[i].track == first_track_no) {
					first_track_index = i;
					break;
				}
			}
		} else {
			/* Shouldn't happen... */
			first_track_no = 0;
			first_track_index = 0;
		}

		last_complete_session = session;
		session++;
		start = end;
	}

	s->NAME.buf[offset++] = first_complete_session;
	s->NAME.buf[offset++] = last_complete_session;

	s->NAME.buf[offset++] = 0x00; /* Reserved */
	s->NAME.buf[offset++] = s->NAME.TOC[first_track_index].type;
	s->NAME.buf[offset++] = s->NAME.TOC[first_track_index].track;
	s->NAME.buf[offset++] = 0x00; /* Reserved */
	if (msf) {
		/* MSF of First Track */
		s->NAME.buf[offset++] = s->NAME.TOC[first_track_index].pmin100;
		s->NAME.buf[offset++] = s->NAME.TOC[first_track_index].pmin;
		s->NAME.buf[offset++] = s->NAME.TOC[first_track_index].psec;
		s->NAME.buf[offset++] = s->NAME.TOC[first_track_index].pframe;
	} else {
		/* LBA of First Track */
		int32_t lba;

		NAME_(msf100_to_lba)(&s->NAME.TOC[first_track_index].pmin100,
				&lba);
		s->NAME.buf[offset++] = (lba >> 24) & 0xff;
		s->NAME.buf[offset++] = (lba >> 16) & 0xff;
		s->NAME.buf[offset++] = (lba >>  8) & 0xff;
		s->NAME.buf[offset++] = (lba >>  0) & 0xff;
	}

	/* Set Data Length */
	s->NAME.buf[0] = ((offset - 2) >> 8) & 0xff;
	s->NAME.buf[1] = ((offset - 2) >> 0) & 0xff;

	return offset;
}

static unsigned int
NAME_(read_toc_pma_atip_2)(struct cpssp *s, unsigned int first_reported_track)
{
	unsigned int first_complete_session;
	unsigned int last_complete_session;
	unsigned int session;
	unsigned int start;
	unsigned int end;
	unsigned int i;
	unsigned int offset;

	if (! s->NAME.inserted
	 || s->NAME.nTOCs == 0) {
		/* Blank CD */
		NAME_(invalid_field_in_cdb)(s);
		return -1;
	}

	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[1] later. */
	offset++;

	/* Patch s->NAME.buf[2] later. */
	offset++;
	/* Patch s->NAME.buf[3] later. */
	offset++;

	first_complete_session = 1;
	last_complete_session = 1;

	session = 1;
	start = 0;
	while (start < s->NAME.nTOCs) {
		/*
		 * Calculate end of session.
		 */
		end = start;
		/* Scan tracks 0xa0-0xaf. */
		while (end < s->NAME.nTOCs
		    && 0xa0 <= s->NAME.TOC[end].track
		    && s->NAME.TOC[end].track <= 0xaf) {
			end++;
		}
		/* Scan normal tracks. */
		while (end < s->NAME.nTOCs
		    && s->NAME.TOC[end].track <= 99) {
			end++;
		}
		/* Scan tracks 0xb0-0xff. */
		while (end < s->NAME.nTOCs
		    && 0xb0 < s->NAME.TOC[end].track
		    /* && s->NAME.TOC[end].track < 0xff */) {
			end++;
		}

		/*
		 * Add entries to user buffer.
		 */
		for (i = start; i < end; i++) {
			s->NAME.buf[offset++] = session;
			s->NAME.buf[offset++] = s->NAME.TOC[i].type;
			s->NAME.buf[offset++] = 0x00;
			s->NAME.buf[offset++] = s->NAME.TOC[i].track;
			s->NAME.buf[offset++] = 0x00; /* Min */
			s->NAME.buf[offset++] = 0x00; /* Sec */
			s->NAME.buf[offset++] = 0x00; /* Frame */
			s->NAME.buf[offset++] = s->NAME.TOC[i].pmin100;
			s->NAME.buf[offset++] = s->NAME.TOC[i].pmin;
			s->NAME.buf[offset++] = s->NAME.TOC[i].psec;
			s->NAME.buf[offset++] = s->NAME.TOC[i].pframe;
		}

		last_complete_session = session;
		session++;
		start = end;
	}

	/* Set Data Length */
	s->NAME.buf[0] = ((offset - 2) >> 8) & 0xff;
	s->NAME.buf[1] = ((offset - 2) >> 0) & 0xff;

	/* Set First/Last Complete Session */
	s->NAME.buf[2] = first_complete_session;
	s->NAME.buf[3] = last_complete_session;

	return offset;
}

static unsigned int
NAME_(read_toc_pma_atip_3)(struct cpssp *s, int msf)
{
	fixme();

	return 0;
}

/*
 * MMC-2: page 232
 */
static unsigned int
NAME_(read_toc_pma_atip_4)(struct cpssp *s)
{
	struct cd_atip atip;
	unsigned int offset;

	if (! s->NAME.inserted
	 || NAME_(media_atip)(s, &atip) < 0) {
		/* Cannot read ATIP. */
		NAME_(invalid_field_in_cdb)(s); /* Correct? FIXME */
		return -1;
	}

	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[1] later. */
	offset++;

	/* Byte 2 */
	s->NAME.buf[offset++] = 0x00; /* Reserved */
	/* Byte 3 */
	s->NAME.buf[offset++] = 0x00; /* Reserved */

	/* Byte 0/4 */
	s->NAME.buf[offset++] = (1 << 7) /* Reserved */
			| (atip.writing_power << 4)
			| (0 << 3) /* Reserved */
			| (atip.reference_speed << 0);

	/* Byte 1/5 */
	s->NAME.buf[offset++] = (0 << 7) /* Reserved */
			| (atip.unrestricted_use << 6)
			| (0 << 0); /* Reserved */

	/* Byte 2/6 */
	s->NAME.buf[offset++] = (1 << 7) /* Reserved */
			| (atip.media_type << 6)
			| (0 << 3) /* Media Sub Type */
			| (1 << 2) /* Bytes 16-18 are valid */
			| (1 << 1) /* Bytes 20-22 are valid */
			| (1 << 0); /* Bytes 24-26 are valid */

	/* Byte 3/7 */
	s->NAME.buf[offset++] = 0x00; /* Reserved */

	/* Byte 4/8 - 6/10 */
	s->NAME.buf[offset++] = atip.start_of_leadin_m;
	s->NAME.buf[offset++] = atip.start_of_leadin_s;
	s->NAME.buf[offset++] = atip.start_of_leadin_f;

	/* Byte 7/11 */
	s->NAME.buf[offset++] = 0x00; /* Reserved */

	/* Byte 8/12 - 10/14 */
	s->NAME.buf[offset++] = atip.last_possible_start_of_leadout_m;
	s->NAME.buf[offset++] = atip.last_possible_start_of_leadout_s;
	s->NAME.buf[offset++] = atip.last_possible_start_of_leadout_f;

	/* Byte 11/15 */
	s->NAME.buf[offset++] = 0x00; /* Reserved */

	/* Byte 12/16 */
	s->NAME.buf[offset++] = (0 << 7) /* Reserved */
			| (1 << 4) /* Lowest Recording Speed 2x */
			| (0 << 3) /* FIXME */
			| (4 << 0);/* Highest Recording Speed 8x */

	/* Byte 13/17-23/27 */
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;
	s->NAME.buf[offset++] = 0x00;

	assert(offset == 28);

	/* Patch Data Length */
	s->NAME.buf[0] = ((offset - 2) >> 8) & 0xff;
	s->NAME.buf[1] = ((offset - 2) >> 0) & 0xff;

	return offset;
}

/*
 * SCSI-3 MMC 56
 *
 * 0x43, mandatory
 *
 * On a one-track read-once CD (Redhat-8.0 #1)
 * the Read-TOC-PMA-ATIP command sends
 *
 * Format 0:
 * 00 12 01 01
 * 00 14 01 00 00 00 02 00
 * 00 14 aa 00 00 49 12 3b
 *
 * Format 1:
 * 00 0a 01 01
 * 00 14 01 00 00 00 02 00
 *
 * Format 2:
 * 00 2e 01 01
 * 01 14 00 a0 00 00 00 00 01 00 00
 * 01 14 00 a1 00 00 00 00 01 00 00
 * 01 14 00 a2 00 00 00 00 49 12 3b
 * 01 14 00 01 00 00 00 00 00 02 00
 *
 * Format 3:
 * 00 02 00 00
 *
 * Format 4:
 * 00 1a 00 00
 * d0 00 98 00 61 1a 42 00 4f 3b 47 00 00 00 00 00 00 00 00 00 00 00 00 00
 *
 * Size of track is 675653632 bytes.
 */
static void
NAME_(read_toc_pma_atip)(struct cpssp *s)
{
	unsigned int msf;
	unsigned int format;
	unsigned int track_session;
	uint16_t allocation_length;
	int length;


	if (s->NAME.inserted == 0) {
		/* Removed Media */
		NAME_(medium_not_present)(s);
		return;
	}

	/*
	 * Get info from the CDB.
	 */
	msf = (s->NAME.cmd_buf[1] >> 1) & 1;
	format = (s->NAME.cmd_buf[2] >> 0) & 0xf;
	if (format == 0) {
		/* look for SFF8020, version 1.2 format code */
		format = (s->NAME.cmd_buf[9] >> 6) & 3;
	}
	track_session = s->NAME.cmd_buf[6];
	allocation_length = (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);

	switch (format) {
	case 0:
		length = NAME_(read_toc_pma_atip_0)(s, msf, track_session);
		break;
	case 1:
		length = NAME_(read_toc_pma_atip_1)(s, msf);
		break;
	case 2:
		length = NAME_(read_toc_pma_atip_2)(s, track_session);
		break;
	case 3:
		length = NAME_(read_toc_pma_atip_3)(s, msf);
		break;
	case 4:
		length = NAME_(read_toc_pma_atip_4)(s);
		break;
	default:
		NAME_(invalid_field_in_cdb)(s);
		length = -1;
		break;
	}
	if (length < 0) {
		return;
	}

	if (length < allocation_length) {
		allocation_length = length;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

#if CD_SCAN_CD_SUPPORT
/*
 * SCSI-3 MMC 66
 *
 * 0xba, optional
 */
static void
NAME_(scan)(struct cpssp *s)
{
	fixme();
}
#endif

/*
 * SCSI-3 MMC 69 / MMC-2 276
 *
 * 0xbb, mandatory for CD-R/RW
 */
static void
NAME_(set_cd_speed)(struct cpssp *s)
{
	uint16_t read_speed;
	uint16_t write_speed;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0xbb);
	/* s->NAME.cmd_buf[1]: Reserved */
	read_speed = (s->NAME.cmd_buf[2] << 8)
		| s->NAME.cmd_buf[3];
	write_speed = (s->NAME.cmd_buf[4] << 8)
		| s->NAME.cmd_buf[5];
	/* s->NAME.cmd_buf[6]: Reserved */
	/* s->NAME.cmd_buf[7]: Reserved */
	/* s->NAME.cmd_buf[8]: Reserved */
	/* s->NAME.cmd_buf[9]: Reserved */
	/* s->NAME.cmd_buf[10]: Reserved */
	/* s->NAME.cmd_buf[11]: Control */

	/* Nothing to do... */
}

#if CD_WRITER_SUPPORT
/*
 * SCSI-3 MMC 96 / MMC-2 131
 *
 * 0x5b; close track/session
 */
static void
NAME_(close_track_session)(struct cpssp *s)
{
	unsigned int immed;
	unsigned int track;
	unsigned int session;
	unsigned int track_no;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x5b);
	immed = (s->NAME.cmd_buf[1] >> 0) & 1;
	session = (s->NAME.cmd_buf[2] >> 1) & 1;
	track = (s->NAME.cmd_buf[2] >> 0) & 1;
	/* s->NAME.cmd_buf[3]: Reserved */
	track_no = (s->NAME.cmd_buf[4] << 8)
		| (s->NAME.cmd_buf[5] << 0);
	/* s->NAME.cmd_buf[6]: Reserved */
	/* s->NAME.cmd_buf[7]: Reserved */
	/* s->NAME.cmd_buf[8]: Reserved */
	/* s->NAME.cmd_buf[9]: Control */

	if (session == 0
	 && track == 1) {
		/* FIXME pad only to the minimum length of 4 seconds and only if incomplete */
		/* FIXME if partially recorded or empty reserved, the device shall pad the track */
		/* FIXME in case of  an empty track, the device shall write the track according
		 * to the write parameter page */
		fixme();
		/* FIXME close the track */

	} else if (session == 1
		&& track == 0) {
		/*
		 * Close Session
		 */
		struct cd_atip atip;
		unsigned int start;
		int32_t leadin;
		uint32_t leadin_size;
		int32_t leadout;
		uint32_t leadout_size;
		int32_t sector;
		unsigned int i;

		if (! s->NAME.incomplete_session) {
			/* Nothing to do... */
			return;
		}

		/* Get start of incomplete session. */
		start = 0;
		for (i = 0; i < s->NAME.nTOCs; i++) {
			if (s->NAME.TOC[i].track == 0xa0) {
				start = i;
			}
		}

		/* Get address of LEADIN and LEADOUT. */
		NAME_(media_atip)(s, &atip);
		leadin = NAME_(msf_to_lin)(&atip.start_of_leadin_m);
		leadin_size = -leadin;
		leadout = 0;
		leadout_size = 0;
		for (i = 0; i < s->NAME.nTOCs; i++) {
			if (s->NAME.TOC[i].track == 0xa2) {
				leadout = NAME_(msf100_to_lin)(&s->NAME.TOC[i].pmin100);
				if (leadout_size == 0) {
					/* First LEADOUT */
					leadout_size = 90 * 75;
				} else {
					/* Next LEADOUTs */
					leadout_size = 30 * 75;
				}
			} else if (s->NAME.TOC[i].track == 0xb0) {
				assert(s->NAME.TOC[i].pmin != 0xff);
				assert(s->NAME.TOC[i].psec != 0xff);
				assert(s->NAME.TOC[i].pframe != 0xff);
				leadin = NAME_(msf100_to_lin)(&s->NAME.TOC[i].pmin100);
				leadin -= 1 * 60 * 75;
				leadin_size = 1 * 60 * 75;
			}
		}

		/* Add 0xb0 pointer to incomplete session as requested. */
		switch (s->NAME.write_parameter_multi_session) {
		case 0:
			/* No 0xb0 pointer. */
			break;
		case 1:
			/* 0xb0 pointer with value 0xff:0xff:0xff. */
			s->NAME.TOC[s->NAME.nTOCs].type = 0x14; /* FIXME */
			s->NAME.TOC[s->NAME.nTOCs].track = 0xb0;
			s->NAME.TOC[s->NAME.nTOCs].pmin100 = 0x00;
			s->NAME.TOC[s->NAME.nTOCs].pmin = 0xff;
			s->NAME.TOC[s->NAME.nTOCs].psec = 0xff;
			s->NAME.TOC[s->NAME.nTOCs].pframe = 0xff;
			s->NAME.nTOCs++;
			break;
		case 3:
			/* Next session allowed. Create 0xb0 pointer. */
			/* Check for space for next session. FIXME */

			s->NAME.TOC[s->NAME.nTOCs].type = 0x14; /* FIXME */
			s->NAME.TOC[s->NAME.nTOCs].track = 0xb0;
			NAME_(lin_to_msf100)(leadout + leadout_size + leadin_size,
				&s->NAME.TOC[s->NAME.nTOCs].pmin100);
			s->NAME.nTOCs++;
			break;
		default:
			assert(0); /* Mustn't happen. */
			break;
		}

		/* Write LEADIN. */
#if 1
		fprintf(stderr, "Leadin at %d (%u), leadout at %d (%u)\n",
				leadin, leadin_size, leadout, leadout_size);
		for (i = 0; i < s->NAME.nTOCs; i++) {
			fprintf(stderr, "TOC: 0x%02x 0x%02x 0x%02x:0x%02x:0x%02x\n",
					s->NAME.TOC[i].type,
					s->NAME.TOC[i].track,
					s->NAME.TOC[i].pmin,
					s->NAME.TOC[i].psec,
					s->NAME.TOC[i].pframe);
		}
#endif
		i = start;
		for (sector = leadin;
		    sector < leadin + (int32_t) leadin_size;
		    sector++) {
			uint8_t data[2352];
			uint8_t psub[10];
			uint8_t qsub[10];

			memset(data, 0, sizeof(data));
			memset(psub, 0, sizeof(psub));
			qsub[0] = s->NAME.TOC[i].type;
			qsub[1] = 0x00;
			qsub[2] = NAME_(bin_to_bcd)(s->NAME.TOC[i].track);
			qsub[3] = 0x00;
			qsub[4] = 0x00;
			qsub[5] = 0x00;
			qsub[6] = NAME_(bin_to_bcd)(s->NAME.TOC[i].pmin100);
			qsub[7] = NAME_(bin_to_bcd)(s->NAME.TOC[i].pmin);
			qsub[8] = NAME_(bin_to_bcd)(s->NAME.TOC[i].psec);
			qsub[9] = NAME_(bin_to_bcd)(s->NAME.TOC[i].pframe);

			NAME_(media_write)(s, sector, data, psub, qsub);

			if (i < s->NAME.nTOCs - 1) {
				i++;
			} else {
				i = start;
			}
		}

		/* Write LEADOUT. */
		i = 0;
		for (sector = leadout; sector < leadout + leadout_size; sector++) {
			uint8_t data[2352];
			uint8_t psub[10];
			uint8_t qsub[10];

			memset(data, 0, sizeof(data));
			memset(psub, 0, sizeof(psub));
			qsub[0] = 0x14; /* FIXME */
			qsub[1] = 0xaa; /* LEADOUT */
			qsub[2] = 0x01; /* index */
			NAME_(lin_to_msf)(i, &qsub[3]); /* msf */
			qsub[6] = 0x00;
			NAME_(lin_to_msf)(sector, &qsub[7]); /* abs msf */

			NAME_(media_write)(s, sector, data, psub, qsub);

			i++;
		}

		s->NAME.incomplete_session = 0;
	}
}
#endif

#if CD_WRITER_RW_SUPPORT
/*
 * SCSI-3 MMC 94
 *
 * 0xa1, mandatory for CD-R/RW
 */
static void
NAME_(blank)(struct cpssp *s)
{
#if 1
	fixme();
#else
	uint8_t immed;
	uint8_t blank_type;
	uint32_t track;
	uint32_t i;
	int32_t lead_in_size;
	toc_entry *act_toc_line;
	char null[2352];
	memset(null, 0, sizeof(null));

	immed = (s->NAME.cmd_buf[1] >> 4) & 1;
	blank_type = (s->NAME.cmd_buf[1]) & 7;
	track = (s->NAME.cmd_buf[2] << 24)
		| (s->NAME.cmd_buf[3] << 16)
		| (s->NAME.cmd_buf[4] << 8)
		| (s->NAME.cmd_buf[5] << 0);

	if (! s->NAME.faum_image) {
		/* medium is write protected */
		NAME_(check_condition)(s, ILLEGAL_REQUEST, 0x27, 0x00);
		return;
	}

	if (s->NAME.media_desc.media_type != 1) {
		/* cannot format medium - incompatible medium */
		NAME_(check_condition)(s, ILLEGAL_REQUEST, 0x30, 0x06);
		return;
	}

	NAME_(msf_to_lba)((uint8_t *)&s->NAME.media_desc.start_of_leadin_m, &lead_in_size);
	lead_in_size *= -1;

	switch (blank_type) {
	case 6: /* erase session */
		/* FIXME with multisession-support, this should be implemented separately */
	case 0: /* blank the disc */
		memset(&s->NAME.toc, 0, sizeof(s->NAME.toc));

		s->NAME.media_desc.disc_status = 0;
		s->NAME.media_desc.last_session_status = 0;

		for (i = 0; i < s->NAME.media_desc.total_blocks; i++) {
			NAME_(media_open)(s);
			storage_read_write(IO_WRITE,
					&s->NAME.media[0],
					(char *)&null,
					/* (pos / blocksize) * 2532 = Offset im Image */
					s->NAME.media_desc.offset
					+ s->NAME.media_desc.toc_size
					+ lead_in_size
					+ 150 * 2352
					+ (i * sizeof(null)),
					sizeof(null));
		}

		break;

	case 1: /* minimally blank the disc */
		memset(&s->NAME.toc, 0, sizeof(s->NAME.toc));

		s->NAME.media_desc.disc_status = 0;
		s->NAME.media_desc.last_session_status = 0;

		break;
	case 2: /* blank a track */
		act_toc_line = &(s->NAME.toc.x01) + track - 1;

		for (i = 0; i < act_toc_line->blkcount; i++) {
			NAME_(media_open)(s);
			storage_read_write(IO_WRITE,
					&s->NAME.media[0],
					(char *)&null,
					/* (pos / blocksize) * 2532 = Offset im Image */
					s->NAME.media_desc.offset
					+ s->NAME.media_desc.toc_size
					+ lead_in_size
					+ 150 * 2352
					+ (i * sizeof(null)),
					sizeof(null));
		}

		break;

	case 3: /* unreserve a track */
		/* implement with reserve_track() */
		fixme();
	case 4: /* blank a track tail */
		/* only valid for packet recording */
		fixme();
	case 5: /* unclose the last session */
		/* erase lead-in of last session */
		/* FIXME B0-Pointer */
		memset(&s->NAME.toc, 0, sizeof(s->NAME.toc));
		s->NAME.media_desc.disc_status = 1;
		s->NAME.media_desc.last_session_status = 1;

		break;

	case 7: /* reserved */
		fixme();
	}

	NAME_(media_open)(s);
	storage_read_write(IO_WRITE,
			&s->NAME.media[0],
			(char *)&s->NAME.toc,
			s->NAME.media_desc.offset,
			sizeof(toc_session));
	storage_read_write(IO_WRITE,
			&s->NAME.media[0],
			(char *)&s->NAME.media_desc,
			0,
			sizeof(cd_image));
#endif
}

/*
 * SCSI-3 MMC 98
 *
 * 0x04, optional
 */
static void
NAME_(format_unit)(struct cpssp *s)
{
	fixme();
}
#endif

#if 0 /* obsolete */
/*
 * SCSI-3 MMC 101
 *
 * 0x5c, optional
 */
static void
NAME_(read_buffer_capacity)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_WRITER_SUPPORT
/*
 * SCSI-3 MMC 103
 *
 * 0x51, mandatory
 *
 * A blank Philips CD-R (700MB, 80min, 52x) returns
 *
 * 00 20 00 01 01 01 01 00 ff 00 00 00 00 00 00 00
 * 00 61 11 06 00 4f 3b 4a 00 00 00 00 00 00 00 00
 * 00 00
 *
 * Same CD-R written TAO with one track returns
 *
 * 00 20 0e 01 01 01 01 80 00 00 00 00 00 71 00 20
 * ff ff ff ff ff ff ff ff 00 00 00 00 00 00 00 00
 * 00 00
 *
 * Same CD-R written DAO(?) with one track returns
 *
 * 00 20 0e 01 01 01 01 00 00 00 00 00 00 00 00 00
 * ff ff ff ff ff ff ff ff 00 00 00 00 00 00 00 00
 * 00 00
 *
 * A blank DVD returns
 *
 * 00 20 00 01 01 01 01 20 00 00 00 00 00 00 00 00
 * 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 * 00 00
 */
static void
NAME_(read_disc_info)(struct cpssp *s)
{
	uint16_t allocation_length;
	struct cd_atip atip;
	unsigned int count_a2;
	unsigned int count_b0;
	unsigned int disc_status;
	unsigned int session_status;
	unsigned int number_of_first_track_on_disc;
	unsigned int number_of_sessions;
	unsigned int number_of_first_track_in_last_session;
	unsigned int number_of_last_track_in_last_session;
	uint8_t last_session_leadin_start_time_min;
	uint8_t last_session_leadin_start_time_sec;
	uint8_t last_session_leadin_start_time_frame;
	unsigned int start;
	unsigned int end;
	unsigned int i;
	unsigned int offset;
	unsigned int kbytes_per_second;

	/*
	 * Get parameter.
	 */
	assert(s->NAME.cmd_buf[0] == 0x51);
	/* s->NAME.cmd_buf[1]: Reserved */
	/* s->NAME.cmd_buf[2]: Reserved */
	/* s->NAME.cmd_buf[3]: Reserved */
	/* s->NAME.cmd_buf[4]: Reserved */
	/* s->NAME.cmd_buf[5]: Reserved */
	/* s->NAME.cmd_buf[6]: Reserved */
	allocation_length = (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control */

	/*
	 * Get CD info.
	 */
	if (NAME_(media_atip)(s, &atip) < 0) {
		atip.reference_speed = 0;
		atip.unrestricted_use = 0;
		atip.media_type = 0;
		atip.start_of_leadin_m = 0xff;
		atip.start_of_leadin_s = 0xff;
		atip.start_of_leadin_f = 0xff;
		atip.last_possible_start_of_leadout_m = 0xff;
		atip.last_possible_start_of_leadout_s = 0xff;
		atip.last_possible_start_of_leadout_f = 0xff;
	}

	/*
	 * Count 0xa2/0xb0 markers.
	 * Get number of first track on disc.
	 * Get number of first track in last session.
	 * Get number of last track in last session.
	 */
	count_a2 = 0;
	count_b0 = 0;
	number_of_first_track_on_disc = 0;
	number_of_first_track_in_last_session = 0;
	number_of_last_track_in_last_session = 0;
	last_session_leadin_start_time_min = 0xff;
	last_session_leadin_start_time_sec = 0xff;
	last_session_leadin_start_time_frame = 0xff;

	start = 0;
	while (start < s->NAME.nTOCs) {
		/*
		 * Calculate end of session.
		 */
		end = start;
                /* Scan tracks 0xa0-0xaf. */
                while (end < s->NAME.nTOCs
                    && 0xa0 <= s->NAME.TOC[end].track
                    && s->NAME.TOC[end].track <= 0xaf) {
                        end++;
                }
                /* Scan normal tracks. */
                while (end < s->NAME.nTOCs
                    && 1 <= s->NAME.TOC[end].track
                    && s->NAME.TOC[end].track <= 99) {
                        end++;
                }
                /* Scan tracks 0xb0-0xff. */
                while (end < s->NAME.nTOCs
                    && 0xb0 <= s->NAME.TOC[end].track
                    /* && s->NAME.TOC[end].track < 0xff */) {
                        end++;
                }

		for (i = start; i < end; i++) {
			switch (s->NAME.TOC[i].track) {
			case 0xa0:
				if (number_of_first_track_on_disc == 0) {
					number_of_first_track_on_disc = s->NAME.TOC[i].pmin;
				}
				number_of_first_track_in_last_session = s->NAME.TOC[i].pmin;
				break;
			case 0xa1:
				number_of_last_track_in_last_session = s->NAME.TOC[i].pmin;
				break;
			case 0xa2:
				count_a2++;
				break;
			case 1 ... 99:
				break;
			case 0xb0:
				if (s->NAME.TOC[i].pmin != 0xff
				 && s->NAME.TOC[i].psec != 0xff
				 && s->NAME.TOC[i].pframe != 0xff) {
					last_session_leadin_start_time_min
						= s->NAME.TOC[i].pmin - 1;
					last_session_leadin_start_time_sec
						= s->NAME.TOC[i].psec;
					last_session_leadin_start_time_frame
						= s->NAME.TOC[i].pframe;
					count_b0++;
				}
				break;
			default:
				assert(0);
			}
		}

		start = end;
	}

	/*
	 * Determine number of sessions.
	 */
	number_of_sessions = count_a2;

	/*
	 * Determine disc status and session status.
	 */
	if (count_a2 == 0
	 && count_b0 == 0) {
		disc_status = 0x0; /* Empty */
		session_status = 0x0; /* Empty */

	} else if (count_a2 == count_b0) {
		disc_status = 0x1; /* Incomplete/Appendable */
		session_status = 0x0; /* Empty */

	} else if (count_a2 - 1 == count_b0
		&& s->NAME.incomplete_session) {
		disc_status = 0x1; /* Incomplete/Appendable */
		session_status = 0x0; /* Incomplete */

	} else if (count_a2 - 1 == count_b0
		&& ! s->NAME.incomplete_session) {
		disc_status = 0x2; /* Complete */
		session_status = 0x3; /* Complete */

	} else {
		assert(0);
	}

	/*
	 * Fill info.
	 */
	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[1] later. */
	offset++;

	s->NAME.buf[offset++] = (0 << 5) /* Reserved */
		| (atip.media_type << 4) /* Erasable */
		| (session_status << 2) /* State of last Session */
		| (disc_status << 0); /* Disc Status */

	/* Number of First Track on Disc */
	s->NAME.buf[offset++] = number_of_first_track_on_disc;

	/* Number of Sessions (LSB) */
	s->NAME.buf[offset++] = (number_of_sessions >> 0) & 0xff;

	/* First Track Number in Last Session (LSB) */
	s->NAME.buf[offset++]
			= (number_of_first_track_in_last_session >> 0) & 0xff;

	/* Last Track Number in Last Session (LSB) */
	s->NAME.buf[offset++]
			= (number_of_last_track_in_last_session >> 0) & 0xff;

	/* DID_V, DBC_V, URU, Reserved */
	s->NAME.buf[offset++] = (0 << 7) /* DID_V */
			| (0 << 6) /* DBC_V */
			| (atip.unrestricted_use << 5) /* URU */
			| (0 << 0); /* Reserved */

	/* Disc Type */
	s->NAME.buf[offset++] = 0; /* CD-DA or CD-ROM Disc */

	/* Number of Sessions (MSB) */
	s->NAME.buf[offset++] = (number_of_sessions >> 8) & 0xff;

	/* First Track Number in Last Session (MSB) */
	s->NAME.buf[offset++]
			= (number_of_first_track_in_last_session >> 8) & 0xff;

	/* Last Track Number in Last Session (MSB) */
	s->NAME.buf[offset++]
			= (number_of_last_track_in_last_session >> 8) & 0xff;

	/* Disc Identification */
	/* Not set; see Disc-ID-Valid bit (DID_V) above. */
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;

	/* Last Session lead-in Start Time (MSF) */
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = last_session_leadin_start_time_min;
	s->NAME.buf[offset++] = last_session_leadin_start_time_sec;
	s->NAME.buf[offset++] = last_session_leadin_start_time_frame;

	/* Last Possible Start Time for Start of lead-out (MSF) */
	s->NAME.buf[offset++] = 0; /* reserved */
	s->NAME.buf[offset++] = atip.last_possible_start_of_leadout_m;
	s->NAME.buf[offset++] = atip.last_possible_start_of_leadout_s;
	s->NAME.buf[offset++] = atip.last_possible_start_of_leadout_f;

	/* Disc Bar Code */
	/* Not set; see Disc-Bar-Code-Valid bit (DBC_V) above. */
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;

	/* Reserved */
	s->NAME.buf[offset++] = 0;

	/* Number of OPC Table Entries */
	s->NAME.buf[offset++] = 1;

	/* OPC Table Entry 0 */
	/* Speed (kBytes per second) */
	kbytes_per_second = ((44100 * 4) << atip.reference_speed) / 1024;
	s->NAME.buf[offset++] = (kbytes_per_second >> 8) & 0xff;
	s->NAME.buf[offset++] = (kbytes_per_second >> 0) & 0xff;

	/* OPC Values */
	s->NAME.buf[offset++] = 1; /* Vendor specific */
	s->NAME.buf[offset++] = 2;
	s->NAME.buf[offset++] = 3;
	s->NAME.buf[offset++] = 4;
	s->NAME.buf[offset++] = 5;
	s->NAME.buf[offset++] = 6;

	assert(offset == 42);

	/* Set Data Length */
	s->NAME.buf[0] = ((offset - 2) >> 8) & 0xff;
	s->NAME.buf[1] = ((offset - 2) >> 0) & 0xff;

	if (offset < allocation_length) {
		allocation_length = offset;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}
#endif /* CD_WRITER_SUPPORT */

#if 0 /* obsolete */
/*
 * SCSI-3 MMC 108
 *
 * 0x59, optional
 */
static void
NAME_(read_master_cue)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_WRITER_SUPPORT
/*
 * SCSI-3 MMC-2 235
 *
 * 0x52, mandatory for CD-R/RW
 */
static void
NAME_(read_track_information)(struct cpssp *s)
{
	uint8_t address_type;
	uint32_t lba_track_number;
	uint16_t allocation_length;
	struct cd_atip atip;
	unsigned int start;
	int32_t start_lba;
	int32_t end_lba;
	int track_number;
	uint8_t track_mode = 0;
	uint8_t data_mode = 0;
	uint16_t session_number = 0;
	uint8_t nwa_v = 0;
	uint8_t lra_v = 0;
	uint8_t damage = 0;
	uint8_t copy = 0;
	uint8_t rt = 0;
	uint8_t packet = 0;
	uint8_t fp = 0;
	uint8_t blank = 0;
	int32_t track_start_address = 0;
	int32_t next_writable_address = 0;
	int32_t last_recorded_address = 0;
	uint32_t free_blocks = 0;
	uint32_t fixed_packet_size = 0;
	uint32_t track_size = 0;
	unsigned int i;
	unsigned int offset;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x52);
	/* (s->NAME.cmd_buf[1] >> 1) & 0x7f: Reserved */
	address_type = (s->NAME.cmd_buf[1] >> 0) & 3;
	lba_track_number = (s->NAME.cmd_buf[2] << 24)
		| (s->NAME.cmd_buf[3] << 16)
		| (s->NAME.cmd_buf[4] << 8)
		| (s->NAME.cmd_buf[5] << 0);
	/* s->NAME.cmd_buf[6]: Reserved */
	allocation_length = (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control Byte */

	switch (address_type)
	case 0: {
		/*
		 * Get Info for Track at LBA "lba_track_number"
		 */
		end_lba = 0;
		for (i = 0; ; i++) {
			if (i == s->NAME.nTOCs) {
				/* Track not found. */
				track_number = -1;
				break;
			}
			switch (s->NAME.TOC[i].track) {
			case 0xa0:
			case 0xa1:
				break;
			case 0xa2:
				NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
						&end_lba);
				break;
			case 1 ... 99:
				NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
						&start_lba);
				if (start_lba <= lba_track_number
				 && lba_track_number < end_lba) {
					track_number = s->NAME.TOC[i].track;
				}
				break;
			case 0xb0:
				break;
			default:
				assert(0); /* FIXME */
			}
		}
		break;

	case 1:
		/*
		 * Get info for track "lba_track_number".
		 */
		track_number = lba_track_number;
		break;

	case 2: {
		/*
		 * Get info for first track in session "lba_track_number".
		 */
		unsigned int session;

		session = 1;
		for (i = 0; ; i++) {
			if (i == s->NAME.nTOCs) {
				/* Session not found. */
				track_number = -1;
				break;
			}
			if (s->NAME.TOC[i].track == 0xa0
			 && session == lba_track_number) {
				track_number = s->NAME.TOC[i].pmin;
				break;
			}
			if (s->NAME.TOC[i].track == 0xa2) {
				session++;
			}
		}
		break;
	    }
	default:
		/*
		 * Reserved
		 */
		NAME_(invalid_field_in_cdb)(s); /* Correct? FIXME */
		return;
	}

	switch (track_number) {
	case 0x00:
		/*
		 * Get info for TOC.
		 *
		 * RedHat-8.0 track info:
		 *	Data Length: 00 22
		 *	Track Number (LSB): 00
		 *	Session Number (LSB): 00
		 *	Reserved: 00
		 *	Damage: 0
		 *	Copy: 0
		 *	Track Mode 4
		 *	RT: 0
		 *	Blank: 0
		 *	Packet/Inc: 0
		 *	Data Mode: 1
		 *	LRA_V: 0
		 *	NWA_V: 0
		 *	Track Start Address: 00 00 00 00
		 *	Next Writable Address: 00 00 00 00
		 *	Free Blocks: 00 00 00 00
		 *	Fixed Packet Size/Blocking Factor: 00 00 00 00
		 *	Track Size: 00 00 00 00
		 *	Last Recorded Address: 00 00 00 00
		 *	Track Number (MSB): 00
		 *	Session Number (MSB): 00
		 *	Reserved: 00 00
		 */
		track_number = 0;
		session_number = 0;
		damage = 0;
		copy = 0;
		track_mode = 4;
		rt = 0;
		blank = 0;
		packet = 0;
		data_mode = 1;
		lra_v = 0;
		nwa_v = 0;
		track_start_address = 0;
		next_writable_address = 0;
		free_blocks = 0;
		fixed_packet_size = 0;
		track_size = 0;
		last_recorded_address = 0;
		break;

	case 1 ... 99:
		/*
		 * Get info for standard track.
		 */
		/* Lookup track info. */
		end_lba = 0;
		session_number = 0;
		for (i = 0; ; i++) {
			if (i == s->NAME.nTOCs) {
				goto track_not_found;
			}
			if (s->NAME.TOC[i].track == 0xa2) {
				NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
						&end_lba);
				session_number++;
			}
			if (s->NAME.TOC[i].track == track_number) {
				NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
						&start_lba);
				break;
			}
		}
		if (i + 1 < s->NAME.nTOCs
		 && s->NAME.TOC[i + 1].track == track_number + 1) {
			NAME_(msf100_to_lba)(&s->NAME.TOC[i + 1].pmin100,
					&end_lba);
		}

		damage = 0;
		copy = 0;
		track_mode = s->NAME.TOC[i].type & 0xf;
		rt = 0;
		blank = 0;
		packet = 0;
		data_mode = 1; /* FIXME */
		lra_v = 0;
		nwa_v = 0;
		track_start_address = start_lba;
		next_writable_address = 0;
		free_blocks = 0;
		fixed_packet_size = 0;
		track_size = end_lba - start_lba;
		last_recorded_address = 0;
		break;

	case 0xff:
		/*
		 * Get info for invisible track.
		 */
		/* Lookup last session. */
		session_number = 0;
		start = 0;
		for (i = 0; i < s->NAME.nTOCs; i++) {
			if (s->NAME.TOC[i].track == 0xa0) {
				start = i;
				session_number++;
			}
		}

		if (session_number == 0) {
			/*
			 * Blank disc.
			 */
			session_number = 1;
			track_number = 1;
			start_lba = 0;

		} else if (s->NAME.incomplete_session) {
			/*
			 * Incomplete last session.
			 */
			assert(start + 3 + 1 <= s->NAME.nTOCs);

			/* Lookup track info. */
			track_number = -1;
			start_lba = 0;
			for (i = start; i < s->NAME.nTOCs; i++) {
				if (s->NAME.TOC[i].track == 0xa1) {
					track_number = s->NAME.TOC[i].pmin;
				}
				if (s->NAME.TOC[i].track == 0xa2) {
					/*
					 * Current start of LEADOUT will
					 * become start of invisible track.
					 */
					NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
							&start_lba);
				}
			}
			assert(track_number != -1);
			assert(start_lba != 0);

			track_number++;

		} else {
			/*
			 * Complete last session.
			 */
			/* Lookup track info. */
			track_number = 0;
			start_lba = 0;
			for (i = start; i < s->NAME.nTOCs; i++) {
				if (s->NAME.TOC[i].track == 0xa1) {
					track_number = s->NAME.TOC[i].pmin;
				}
				if (s->NAME.TOC[i].track == 0xb0
				 && s->NAME.TOC[i].pmin != 0xff
				 && s->NAME.TOC[i].psec != 0xff
				 && s->NAME.TOC[i].pframe != 0xff) {
					/*
					 * Start of next session will
					 * become start of invisible track.
					 */
					NAME_(msf100_to_lba)(&s->NAME.TOC[i].pmin100,
							&start_lba);
				}
			}

			if (start_lba == 0) {
				/*
				 * No 0xb0 pointer found.
				 * => Disc complete.
				 */
				NAME_(invalid_field_in_cdb)(s); /* FIXME */
				return;
			}

			session_number++;
			track_number++;
		}

		/* Lookup ATIP data to get end-of-disc value. */
		if (NAME_(media_atip)(s, &atip) < 0) {
			/* No ATIP data => no recordable disc. */
			NAME_(invalid_field_in_cdb)(s); /* FIXME */
			return;
		}
		NAME_(msf_to_lba)(&atip.last_possible_start_of_leadout_m,
				&end_lba);
		
		damage = 0;
		copy = s->NAME.write_parameter_copy;
		track_mode = s->NAME.write_parameter_track_mode;
		rt = 0;
		blank = ! s->NAME.is_writing;
		packet = s->NAME.write_parameter_fp;
		data_mode = (s->NAME.write_parameter_data_block_type <= 8) ? 1 : 2;
		lra_v = s->NAME.is_writing;
		nwa_v = 1;
		track_start_address = start_lba;
		next_writable_address = s->NAME.is_writing ? s->NAME.last_written_lba + 1 : track_start_address;
		free_blocks = end_lba - next_writable_address - 2;;
		fixed_packet_size = s->NAME.write_parameter_packet_size;
		track_size = end_lba - start_lba - 2;
		last_recorded_address = s->NAME.is_writing ? s->NAME.last_written_lba : 0;
		break;

	case -1:
	track_not_found:
		/*
		 * Track not found.
		 */
		assert(0); /* FIXME */
		break;

	default:
		assert(0); /* Cannot happen. */
	}

	/*
	 * Fill track information block.
	 */
	offset = 0;

	/* Patch s->NAME.buf[0] later. */
	offset++;
	/* Patch s->NAME.buf[1] later. */
	offset++;

	/* Track Number (LSB) */
	s->NAME.buf[offset++] = (track_number >> 0) & 0xff;

	/* Session Number (LSB) */
	s->NAME.buf[offset++] = (session_number >> 0) & 0xff;

	s->NAME.buf[offset++] = 0; /* Reserved */

	/* Damage, Copy, Track Mode */
	s->NAME.buf[offset++] = ((damage & 0x1)  << 5)
			| ((copy & 0x1) << 4)
			| ((track_mode & 0x0F) << 0);

	/* RT, Blank, Packet, FP, Data Mode */
	s->NAME.buf[offset++] = ((rt & 0x1) << 7)
			| ((blank & 0x1) << 6)
			| ((packet & 0x1) << 5)
			| ((fp & 0x1) << 4)
			| ((data_mode & 0x0F) << 0);

	/* LRA_V, NWA_V */
	s->NAME.buf[offset++] = ((lra_v & 0x1) << 1)
			| ((nwa_v & 0x1) << 0);

	/* Track Start Address */
	s->NAME.buf[offset++] = (track_start_address >> 24) & 0xff;
	s->NAME.buf[offset++] = (track_start_address >> 16) & 0xff;
	s->NAME.buf[offset++] = (track_start_address >>  8) & 0xff;
	s->NAME.buf[offset++] = (track_start_address >>  0) & 0xff;

	/* Next Writable Address */
	s->NAME.buf[offset++] = (next_writable_address >> 24) & 0xff;
	s->NAME.buf[offset++] = (next_writable_address >> 16) & 0xff;
	s->NAME.buf[offset++] = (next_writable_address >>  8) & 0xff;
	s->NAME.buf[offset++] = (next_writable_address >>  0) & 0xff;

	/* Free Blocks */
	s->NAME.buf[offset++] = (free_blocks >> 24) & 0xff;
	s->NAME.buf[offset++] = (free_blocks >> 16) & 0xff;
	s->NAME.buf[offset++] = (free_blocks >>  8) & 0xff;
	s->NAME.buf[offset++] = (free_blocks >>  0) & 0xff;

	/* Fixed Packet Size */
	s->NAME.buf[offset++] = (fixed_packet_size >> 24) & 0xff;
	s->NAME.buf[offset++] = (fixed_packet_size >> 16) & 0xff;
	s->NAME.buf[offset++] = (fixed_packet_size >>  8) & 0xff;
	s->NAME.buf[offset++] = (fixed_packet_size >>  0) & 0xff;

	/* Track Size */
	s->NAME.buf[offset++] = (track_size >> 24) & 0xff;
	s->NAME.buf[offset++] = (track_size >> 16) & 0xff;
	s->NAME.buf[offset++] = (track_size >>  8) & 0xff;
	s->NAME.buf[offset++] = (track_size >>  0) & 0xff;

	/* Last Recorded Address */
	s->NAME.buf[offset++] = (last_recorded_address >> 24) & 0xff;
	s->NAME.buf[offset++] = (last_recorded_address >> 16) & 0xff;
	s->NAME.buf[offset++] = (last_recorded_address >>  8) & 0xff;
	s->NAME.buf[offset++] = (last_recorded_address >>  0) & 0xff;

	/* Track Number (MSB) */
	s->NAME.buf[offset++] = (track_number >> 8) & 0xff;

	/* Session Number (MSB) */
	s->NAME.buf[offset++] = (session_number >> 8) & 0xff;

	/* reserved */
	s->NAME.buf[offset++] = 0;
	s->NAME.buf[offset++] = 0;

	assert(offset == 36);

	/* Fill Length */
	s->NAME.buf[0] = ((offset - 2) >> 8) & 0xff;
	s->NAME.buf[1] = ((offset - 2) >> 0) & 0xff;

	if (offset < allocation_length) {
		allocation_length = offset;
	}

	NAME_(phase_data_in)(s);
	NAME_(_send)(s, allocation_length);
}

/*
 * SCSI-3 MMC 117
 *
 * 0x53, mandatory for CD-R/RW
 */
static void
NAME_(reserve_track)(struct cpssp *cpssp)
{
	fixme();
	/* check if last track is already a reserved one */
	/* get last track number */

	/* create toc-entry and mark it as reserved */

	/* compute reservation size depending on write mode */
	switch (cpssp->NAME.write_parameter_write_type) {
	case WRITE_TYPE_PACKET:
		if (cpssp->NAME.write_parameter_fp) {
			/* FIXME start + (packet size  + 7) * reservation size / packet size - 5 */
			break;
		} /* variable packet shall behave as tao */
	case WRITE_TYPE_TAO:
		/* start of track + (pre-gap) + reservationsize + 2 */
		break;
	case WRITE_TYPE_SAO:
		NAME_(command_sequence_error)(cpssp);
		return;
	case WRITE_TYPE_RAW:
		break;
	default:
		fprintf(stderr, "CD: write type has reserved value.\n");
		fixme();
	}
	/* write to toc */
}

#if CD_WRITER_DAO_SUPPORT
/*
 * SCSI-3 MMC 119
 *
 * 0x5d, optional
 */
static void
NAME_(send_cue_sheet)(struct cpssp *s)
{
	uint32_t cue_sheet_size;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x5d);
	/* s->NAME.cmd_buf[1]: Reserved */
	/* s->NAME.cmd_buf[2]: Reserved */
	/* s->NAME.cmd_buf[3]: Reserved */
	/* s->NAME.cmd_buf[4]: Reserved */
	/* s->NAME.cmd_buf[5]: Reserved */
	cue_sheet_size = (s->NAME.cmd_buf[6] << 16)
		| (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control */

	/*
	 * Receive CUE sheet.
	 */
	NAME_(phase_data_out)(s);
	NAME_(_recv)(s, cue_sheet_size);

	NAME_(dump)("CUE sheet", s->NAME.buf, cue_sheet_size);
}
#endif

/*
 * SCSI-3 MMC 128 / MMC-2 274
 *
 * 0x54, optional
 */
static void
NAME_(send_opc_information)(struct cpssp *s)
{
	uint8_t doopc;
	uint16_t parameter_list_length;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x54);
	doopc = (s->NAME.cmd_buf[1] >> 0) & 1;
	/* s->NAME.cmd_buf[2]: Control Byte */
	/* s->NAME.cmd_buf[3]: Control Byte */
	/* s->NAME.cmd_buf[4]: Control Byte */
	/* s->NAME.cmd_buf[5]: Control Byte */
	/* s->NAME.cmd_buf[6]: Control Byte */
	parameter_list_length = (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control Byte */

	if (parameter_list_length) {
		NAME_(phase_data_in)(s);
		NAME_(_recv)(s, parameter_list_length);
	}

	/* FIXME shall I do something with this information? */
}
#endif /* CD_WRITER_SUPPORT */

#if CD_AUDIO_SUPPORT
/*
 * SCSI-3 MMC ???
 *
 * 0x4e, mandatory for audio
 */
static void
NAME_(stop_play_scan)(struct cpssp *s)
{
	fixme();
}
#endif

#if CD_WRITER_SUPPORT
/*
 * SCSI-3 MMC 130
 *
 * 0x35, mandatory for CD-R/RW
 */
static void
NAME_(synchronize_cache)(struct cpssp *s)
{
	unsigned int immed;
	unsigned int reladr;
	uint32_t lba;
	uint16_t count;
	int start;
	int track_number;
	int32_t leadout;
	int32_t start_lin;
	int32_t end_lin;
	unsigned int i;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x35);
	immed = (s->NAME.cmd_buf[1] >> 1) & 1;
	reladr = (s->NAME.cmd_buf[1] >> 0) & 1;
	lba = (s->NAME.cmd_buf[2] << 24)
		| (s->NAME.cmd_buf[3] << 16)
		| (s->NAME.cmd_buf[4] <<  8)
		| (s->NAME.cmd_buf[5] <<  0);
	/* s->NAME.cmd_buf[6]: Reserved */
	count = (s->NAME.cmd_buf[7] <<  8)
		| (s->NAME.cmd_buf[8] <<  0);
	/* s->NAME.cmd_buf[9]: Control */

	if (! s->NAME.is_writing) {
		return;
	}

#if 0
	toc_entry *act_toc_line = 0;
	uint8_t msf[3];
#endif

	s->NAME.is_writing = 0;

	switch (s->NAME.write_parameter_write_type) {
	case WRITE_TYPE_PACKET:
		fixme();
		/* fixed packet: pad the packet */
		/*
		 * variable packet: For CD, if insufficient space exists for
		 * another variable packet within a reserved track, pad the
		 * packet such that it fills the track. Otherwise, write
		 * run-out and link blocks. For DVD perform linking
		 */
		break;

	case WRITE_TYPE_TAO:
		/* Lookup track info. */
		track_number = 0xff;
		leadout = 0;
		start = 0;
		for (i = 0; i < s->NAME.nTOCs; i++) {
			if (s->NAME.TOC[i].track == 0xa0) {
				start = i;

			} else if (s->NAME.TOC[i].track == 0xa2) {
				leadout = NAME_(msf100_to_lin)(&s->NAME.TOC[i].pmin100);

			} else if (1 <= s->NAME.TOC[i].track
				&& s->NAME.TOC[i].track <= 99) {
				start_lin = NAME_(msf100_to_lin)(&s->NAME.TOC[i].pmin100);
				if (i + 1 < s->NAME.nTOCs
				 && s->NAME.TOC[i + 1].track == s->NAME.TOC[i].track + 1) {
					end_lin = NAME_(msf100_to_lin)(&s->NAME.TOC[i + 1].pmin100);
				} else {
					end_lin = leadout;
				}
				if (start_lin <= s->NAME.last_written_lba + 150
				 && s->NAME.last_written_lba + 150 < end_lin) {
					track_number = s->NAME.TOC[i].track;
					break;
				}
			}
		}

		if (track_number == 0xff) {
			/*
			 * Invisible Track
			 */
			/* Pad to minimum length. */
			/* FIXME */

			/* Add PMA entry. */
			if (s->NAME.nTOCs == 0) {
				start = 0;
				track_number = 1;
				start_lin = 150;

			} else if (s->NAME.incomplete_session) {
				start = -1;
				track_number = -1;
				start_lin = -1;
				for (i = 0; i < s->NAME.nTOCs; i++) {
					if (s->NAME.TOC[i].track == 0xa0) {
						start = i;
					} else if (s->NAME.TOC[i].track == 0xa1) {
						track_number = s->NAME.TOC[i].pmin + 1;
					} else if (s->NAME.TOC[i].track == 0xa2) {
						start_lin = NAME_(msf100_to_lin)(&s->NAME.TOC[i].pmin100);
					}
				}
				assert(start != -1);
				assert(track_number != -1);
				assert(start_lin != -1);

			} else {
				start = -1;
				track_number = -1;
				start_lin = -1;
				for (i = 0; i < s->NAME.nTOCs; i++) {
					if (s->NAME.TOC[i].track == 0xa0) {
						start = i;
					} else if (s->NAME.TOC[i].track == 0xa1) {
						track_number = s->NAME.TOC[i].pmin + 1;
					} else if (s->NAME.TOC[i].track == 0xb0
						&& s->NAME.TOC[i].pmin != 0xff
						&& s->NAME.TOC[i].psec != 0xff
						&& s->NAME.TOC[i].pframe != 0xff) {
						start_lin = NAME_(msf100_to_lin)(&s->NAME.TOC[i].pmin100);
					}
				}
				assert(start != -1);
				assert(track_number != -1);
				assert(start_lin != -1);
			}
			end_lin = 150 + s->NAME.last_written_lba + 1;

			if (! s->NAME.incomplete_session) {
				start = s->NAME.nTOCs;
				s->NAME.TOC[s->NAME.nTOCs].type = 0x14; /* FIXME */
				s->NAME.TOC[s->NAME.nTOCs].track = 0xa0;
				s->NAME.TOC[s->NAME.nTOCs].pmin = track_number;
				s->NAME.nTOCs++;
				s->NAME.TOC[s->NAME.nTOCs].type = 0x14; /* FIXME */
				s->NAME.TOC[s->NAME.nTOCs].track = 0xa1;
				s->NAME.TOC[s->NAME.nTOCs].pmin = track_number;
				s->NAME.nTOCs++;
				s->NAME.TOC[s->NAME.nTOCs].type = 0x14; /* FIXME */
				s->NAME.TOC[s->NAME.nTOCs].track = 0xa2;
				s->NAME.TOC[s->NAME.nTOCs].pmin100 = 0;
				s->NAME.TOC[s->NAME.nTOCs].pmin = 0;
				s->NAME.TOC[s->NAME.nTOCs].psec = 0;
				s->NAME.TOC[s->NAME.nTOCs].pframe = 0;
				s->NAME.nTOCs++;

				s->NAME.incomplete_session = 1;
			}

			assert(s->NAME.TOC[start + 0].track == 0xa0);
			assert(s->NAME.TOC[start + 1].track == 0xa1);
			assert(s->NAME.TOC[start + 2].track == 0xa2);

			/* Update 0xa1 entry. */
			s->NAME.TOC[start + 1].pmin = track_number;
			/* Update 0xa2 entry. */
			NAME_(lin_to_msf100)(end_lin,
					&s->NAME.TOC[start + 2].pmin100);

			/* Add new track entry. */
			s->NAME.TOC[s->NAME.nTOCs].type
				= (1 << 4) | s->NAME.write_parameter_track_mode;
			s->NAME.TOC[s->NAME.nTOCs].track = track_number;
			NAME_(lin_to_msf100)(start_lin,
					&s->NAME.TOC[s->NAME.nTOCs].pmin100);
			s->NAME.nTOCs++;

		} else {
			/*
			 * Reserved Track
			 */
			/* Pad to reserved length. */
			/* FIXME */
		}

#if 1
		for (i = 0; i < s->NAME.nTOCs; i++) {
			fprintf(stderr, "TOC: 0x%02x 0x%02x 0x%02x:0x%02x:0x%02x\n",
					s->NAME.TOC[i].type,
					s->NAME.TOC[i].track,
					s->NAME.TOC[i].pmin,
					s->NAME.TOC[i].psec,
					s->NAME.TOC[i].pframe);
		}
#endif
		break;

	case WRITE_TYPE_SAO:
		fixme();
#if 0
		/* generate lead-out */
		s->NAME.media_desc.disc_status = 2; /* incomplete/appendable */
		s->NAME.media_desc.last_session_status = 3; /* incomplete */
#endif
		break;

	case WRITE_TYPE_RAW:
		fixme();
		/*
		 * Write run-out and link blocks. Read the TOC and track
		 * information from the session just written and update
		 * the PMA. Assume that the the Lead-out was written.
		 */
		break;
	default:
		assert(0);
	}
#if 0
	NAME_(media_open)(s);
	storage_read_write(IO_WRITE,
			&s->NAME.media[0],
			(char *)&s->NAME.toc,
			s->NAME.media_desc.offset,
			sizeof(toc_session));
	storage_read_write(IO_WRITE,
			&s->NAME.media[0],
			(char *)&s->NAME.media_desc,
			0,
			sizeof(cd_image));
	}
#endif
}

/*
 * SCSI-3 MMC 131
 *
 * 0x2a, mandatory
 */
static void
NAME_(write_10)(struct cpssp *s)
{
	int dpo;
	int fua;
	int reladr;
	int32_t lba;
	uint16_t transfer_length;
	unsigned int block;

	/*
	 * Get parameters.
	 */
	assert(s->NAME.cmd_buf[0] == 0x2a);
	/* (s->NAME.cmd_buf[1] >> 5) & 0x7: Reserved */
	dpo = (s->NAME.cmd_buf[1] >> 4) & 1; /* Shall be zero */
	fua = (s->NAME.cmd_buf[1] >> 3) & 1;
	/* (s->NAME.cmd_buf[1] >> 1) & 0x3: Reserved */
	reladr = (s->NAME.cmd_buf[1] >> 0) & 1; /* Shall be zero */
	lba = (s->NAME.cmd_buf[2] << 24)
		| (s->NAME.cmd_buf[3] << 16)
		| (s->NAME.cmd_buf[4] << 8)
		| (s->NAME.cmd_buf[5] << 0);
	/* s->NAME.cmd_buf[6]: Reserved */
	transfer_length = (s->NAME.cmd_buf[7] << 8)
		| (s->NAME.cmd_buf[8] << 0);
	/* s->NAME.cmd_buf[9]: Control */

	if (dpo
	 || reladr) {
		NAME_(invalid_field_in_cdb)(s);
		return;
	}

#if 0
	/* Check if lba is next writable address of any track. */
	if (?) {
		/* medium is write protected */
		NAME_(check_condition)(s, ILLEGAL_REQUEST, 0x27, 0x00);
		return;
	}
#endif

	NAME_(phase_data_out)(s);

	for (block = 0; block < transfer_length; block++, lba++) {
		uint8_t data[2352];
		uint8_t psub[10];
		uint8_t qsub[10];

		/* Prepare data. */
		switch (s->NAME.write_parameter_data_block_type) {
		case DATA_BLOCK_TYPE_MODE1:
			NAME_(_recv)(s, 2048);
			memcpy(data, s->NAME.buf, 2048); /* FIXME */
			memset(data + 2048, 0x55, 2352 - 2048);
			break;
		case DATA_BLOCK_TYPE_MODE2_XA_FORM1:
			NAME_(_recv)(s, 2048);
			memcpy(data, s->NAME.buf, 2048); /* FIXME */
			memset(data + 2048, 0x55, 2352 - 2048);
			break;
		case DATA_BLOCK_TYPE_MODE2_XA:
			NAME_(_recv)(s, 2332);
			memcpy(data, s->NAME.buf, 2332); /* FIXME */
			memset(data + 2332, 0x55, 2352 - 2332);
			break;
		default:
			/* Shouldn't happen. */
			assert(0);
		}

		/* Prepare P-subchannel info. */
		memset(psub, 0xff, sizeof(psub));

		/* Prepare Q-subchannel info. */
		qsub[0] = (1 << 4)
			| (s->NAME.write_parameter_track_mode << 0);
		qsub[1] = 0x00; /* FIXME */
		qsub[2] = 0x00; /* FIXME */
		qsub[3] = 0x00; /* FIXME */
		qsub[4] = 0x00; /* FIXME */
		qsub[5] = 0x00; /* FIXME */
		qsub[6] = 0x00; /* FIXME */
		qsub[7] = 0x00; /* FIXME */
		qsub[8] = 0x00; /* FIXME */
		qsub[9] = 0x00; /* FIXME */

		/* Write block. */
		NAME_(media_write)(s, lba + 150, data, psub, qsub);

		s->NAME.last_written_lba = lba;
		s->NAME.is_writing = 1;
	}
}
#endif /* CD_WRITER_SUPPORT */

static int
NAME_(toc_less)(struct toc_entry *entry0, struct toc_entry *entry1) {
	if (0xa0 <= entry0->track && entry0->track <= 0xaf) {
		if (0xa0 <= entry1->track && entry1->track <= 0xaf) {
			return entry0->track < entry1->track;
		} else {
			return 1;
		}
	} else {
		if (0xa0 <= entry1->track && entry1->track <= 0xaf) {
			return 0;
		} else {
			return entry0->track < entry1->track;
		}
	}
}

static unsigned int
NAME_(read_toc)(
	struct cpssp *cpssp,
	int32_t start,
	int32_t end,
	struct toc_entry *toc
)
{
	uint8_t data[2352];
	uint8_t psub[10];
	uint8_t qsub[10];
	unsigned int ntocs;
	int32_t sector;
	unsigned int i;
	struct toc_entry *entry;
	int ret;

	/*
	 * Read TOC entries.
	 */
	ntocs = 0;
	for (sector = start; sector < end; sector++) {
		ret = NAME_(media_read)(cpssp, sector, data, psub, qsub);
		if (! ret) {
			break;
		}

		switch (qsub[2]) {
		case 0x01 ... 0x99: /* Normal Track */
		normal_track:;
			for (i = 0; ; i++) {
				entry = &toc[i];
				if (i == ntocs) {
					/* Entry Not Found */
					entry->type = qsub[0]; /* ADR/CONTROL */
					entry->track = NAME_(bcd_to_bin)(qsub[2]);
					entry->pmin100 = NAME_(bcd_to_bin)(qsub[6]);
					entry->pmin = NAME_(bcd_to_bin)(qsub[7]);
					entry->psec = NAME_(bcd_to_bin)(qsub[8]);
					entry->pframe = NAME_(bcd_to_bin)(qsub[9]);
					ntocs++;
					break;
				}
				if (entry->track == NAME_(bcd_to_bin)(qsub[2])
				 && entry->type == qsub[0]
				 && entry->pmin100 == NAME_(bcd_to_bin)(qsub[6])
				 && entry->pmin == NAME_(bcd_to_bin)(qsub[7])
				 && entry->psec == NAME_(bcd_to_bin)(qsub[8])
				 && entry->pframe == NAME_(bcd_to_bin)(qsub[9])) {
					/* Entry Found */
					break;
				}
			}
			break;
		case 0xa0: /* First Track */
		case 0xa1: /* Last Track */
		case 0xa2: /* LEADOUT */
			goto normal_track;
		case 0xb0:
			goto normal_track;
		default:
			fprintf(stderr, "0x%02x\n", qsub[2]);
			assert(0); /* FIXME */
		}
	}

	/*
	 * Sort TOC entries (bubblesort).
	 */
	if (2 <= ntocs) {
		int sorted;

		do {
			sorted = 1;

			for (i = 0; i < ntocs - 1; i++) {
				struct toc_entry *entry0;
				struct toc_entry *entry1;

				entry0 = &cpssp->NAME.TOC[i + 0];
				entry1 = &cpssp->NAME.TOC[i + 1];
				if (NAME_(toc_less)(entry1, entry0)) {
					/* Swap entries. */
					uint8_t type;
					uint8_t track;
					uint8_t pmin100;
					uint8_t pmin;
					uint8_t psec;
					uint8_t pframe;

					type = entry1->type;
					track = entry1->track;
					pmin100 = entry1->pmin100;
					pmin = entry1->pmin;
					psec = entry1->psec;
					pframe = entry1->pframe;
					entry1->type = entry0->type;
					entry1->track = entry0->track;
					entry1->pmin100 = entry0->pmin100;
					entry1->pmin = entry0->pmin;
					entry1->psec = entry0->psec;
					entry1->pframe = entry0->pframe;
					entry0->type = type;
					entry0->track = track;
					entry0->pmin100 = pmin100;
					entry0->pmin = pmin;
					entry0->psec = psec;
					entry0->pframe = pframe;

					sorted = 0;
				}
			}
		} while (! sorted);
	}

	return ntocs;
}

static void
NAME_(insert)(struct cpssp *cpssp)
{
	struct cd_atip atip;
	int32_t start; /* FIXME */
	int32_t end; /* FIXME */
	unsigned int count;

	cpssp->NAME.inserted = 1;

	/*
	 * Read PMA.
	 */
	cpssp->NAME.nPMAs = 0;
	if (NAME_(media_atip)(cpssp, &atip) == 0) {
		cpssp->NAME.nPMAs = NAME_(read_toc)(cpssp, -2*60*75, -1*60*75,
				&cpssp->NAME.PMA[0]);
	}

	cpssp->NAME.incomplete_session = 0; /* FIXME */

	/*
	 * Read TOC.
	 */
	cpssp->NAME.nTOCs = 0;

	/* Read TOC of first session. */
	count = NAME_(read_toc)(cpssp, -60*75, 0,
			&cpssp->NAME.TOC[0]);
	cpssp->NAME.nTOCs = count;

	while (0 < count
	    && cpssp->NAME.TOC[cpssp->NAME.nTOCs - 1].track == 0xb0
	    && cpssp->NAME.TOC[cpssp->NAME.nTOCs - 1].pmin != 0xff) {
		/* Read TOC of next session. */
		end = NAME_(msf_to_lin)(&cpssp->NAME.TOC[cpssp->NAME.nTOCs - 1].pmin);
		start = end - 60 * 75;

		count = NAME_(read_toc)(cpssp, start, end,
				&cpssp->NAME.TOC[cpssp->NAME.nTOCs]);
		cpssp->NAME.nTOCs += count;
	}
	
	cpssp->NAME.unit_attention = 1;
	cpssp->NAME.changed = 1;
}

static void
NAME_(remove)(struct cpssp *cpssp)
{
	cpssp->NAME.inserted = 0;
}

static void
NAME_(change)(struct cpssp *cpssp, const char *media)
{
	char name[1024];

	if (cpssp->NAME.locked) {
		fprintf(stderr, "%s: Medium is locked (maybe mounted).\n",
				progname);
		return;
	}

	/*
	 * Remove old media (if any).
	 */
	system_port_disconnect(cpssp->name, "media");
	NAME_(remove)(cpssp);

	if (*media == '\0') {
		return;
	}

	/*
	 * Insert new media (if any).
	 */
	name[0] = ':';
	strcpy(&name[1], media);
	system_port_connect(cpssp->name, "media", name, "connect");
	NAME_(insert)(cpssp);
}

static void
scsi_gen_cdrom_reset(struct cpssp *cpssp)
{
	cpssp->NAME.locked = 0;
	cpssp->NAME.unit_attention = 1;
	cpssp->NAME.sense_key = 0;
	cpssp->NAME.asc = 0;
	cpssp->NAME.ascq = 0;
	/* FIXME reset modepages */
}

static void
NAME_(power_set)(struct cpssp *cpssp, unsigned int val)
{
	if (! val) {
		/* Power-off Event */
		cpssp->NAME.locked = 0;
	}
}

static int
NAME_(phase_select)(struct cpssp *cpssp, uint32_t id)
{
	int retval;

	if (cpssp->NAME.id == id) {
		cpssp->NAME.selected = 1;
		sched_wakeup(&cpssp->NAME.process);
		retval = 1;
	} else {
		retval = 0;
	}

	return retval;
}

#if ! defined(ATAPI) && ! defined(USB)
static int
NAME_(phase_reselect)(struct cpssp *cpssp, uint32_t id)
{
	return 0;
}
#endif

static void
NAME_(atn_set)(struct cpssp *cpssp, unsigned int val)
{
	cpssp->NAME.state_atn = val;
}

static int
NAME_(send)(struct cpssp *cpssp, const uint8_t *buf, unsigned int bufsize)
{
	if (! cpssp->NAME.selected) {
		return 0;
	}

	assert(cpssp->NAME.head + bufsize <= cpssp->NAME.count);

	memcpy(&cpssp->NAME.buf[cpssp->NAME.head], buf, bufsize);
	cpssp->NAME.head += bufsize;

	if (cpssp->NAME.head == cpssp->NAME.count) {
		sched_wakeup(&cpssp->NAME.process);
	}

	return cpssp->NAME.count - cpssp->NAME.head;
}

static int
NAME_(recv)(struct cpssp *cpssp, uint8_t *buf, unsigned int bufsize)
{
	unsigned int count;

	if (! cpssp->NAME.selected) {
		return 0;
	}

	if (cpssp->NAME.tail + bufsize <= cpssp->NAME.count) {
		count = bufsize;
	} else {
		/* some (very few) OSes seem to read data words
		 * which are bigger than the available rest of
		 * the input buffer (e.g. do an inw when there's
		 * only one byte left). -> Read as many bytes
		 * as possible and fill the rest with zeros.
		 */
		assert(cpssp->NAME.count >= cpssp->NAME.tail);
		faum_log(FAUM_LOG_WARNING, __FUNCTION__, "",
				"cannot copy requested %u byte(s)\n", bufsize);
		count = cpssp->NAME.count - cpssp->NAME.tail;
		faum_log(FAUM_LOG_WARNING, __FUNCTION__, "",
				"-> copying %u byte(s) instead\n", count);
	}

	memcpy(buf, &cpssp->NAME.buf[cpssp->NAME.tail], count);
	memset(&buf[count], 0, bufsize-count);
	cpssp->NAME.tail += count;

	if (cpssp->NAME.tail == cpssp->NAME.count) {
		sched_wakeup(&cpssp->NAME.process);
	}

	return cpssp->NAME.count - cpssp->NAME.tail;
}

#if DEBUGPCOM
static void
printcmd_buf(struct cpssp *cpssp)
{
	unsigned int i;

	switch (cpssp->NAME.cmd_buf[0]) {
	/* winxp executes this every second... */
	case 0x00: fprintf(stderr, "TEST_UNIT_READY"); break;
	case 0x01: fprintf(stderr, "REZERO_UNIT"); break;
		   /* winxp executes this way to often... */
	case 0x03: fprintf(stderr, "REQUEST_SENSE"); break;
	case 0x12: fprintf(stderr, "INQUIRY"); break;
	case 0x1a: fprintf(stderr, "MODE_SENSE_6"); break;
	case 0x1b: fprintf(stderr, "START_STOP_UNIT"); break;
	case 0x1e: fprintf(stderr, "PREVENT_ALLOW_MEDIUM_REMOVAL"); break;
	case 0x25: fprintf(stderr, "READ_CD_RECORDED_CAPACITY"); break;
	case 0x28: fprintf(stderr, "READ_10"); break;
	case 0x2a: fprintf(stderr, "WRITE_10"); break;
	case 0x2b: fprintf(stderr, "SEEK_10"); break;
	case 0x35: fprintf(stderr, "SYNCHRONIZE_CACHE"); break;
	case 0x3c: fprintf(stderr, "READ_BUFFER"); break;
	case 0x42: fprintf(stderr, "READ_SUBCHANNEL"); break;
	case 0x43: fprintf(stderr, "READ_TOC_PMA_ATIP"); break;
	case 0x46: fprintf(stderr, "GET_CONFIGURATION"); break;
	case 0x51: fprintf(stderr, "READ_DISC_INFO"); break;
	case 0x52: fprintf(stderr, "READ_TRACK_INFORMATION"); break;
	case 0x54: fprintf(stderr, "SEND_OPC"); break;
	case 0x55: fprintf(stderr, "MODE_SELECT_10"); break;
	case 0x5a: fprintf(stderr, "MODE_SENSE_10"); break;
	case 0x5b: fprintf(stderr, "CLOSE_TRACK"); break;
	case 0x5c: fprintf(stderr, "READ_BUFFER_CAPACITY"); break;
	case 0x5d: fprintf(stderr, "SEND_CUE_SHEET"); break;
	case 0xa0: fprintf(stderr, "REPORT_LUN"); break;
	case 0xbb: fprintf(stderr, "SET_CD_SPEED"); break;
	default: fprintf(stderr, "0x%02x", cpssp->NAME.cmd_buf[0]); break;
	}
	for (i = 1; i < 12; i++) {
		fprintf(stderr, " 0x%02x", cpssp->NAME.cmd_buf[i]);
	}
	fprintf(stderr, "\n");
}
#endif

static void
NAME_(cmd)(struct cpssp *s)
{
	unsigned int lun;

#if DEBUGPCOM
	fprintf(stderr, "%s: ", __FUNCTION__);
	printcmd_buf(s);
#endif

	lun = (s->NAME.cmd_buf[1] >> 5) & 0x7;
	if (lun != 0 && s->NAME.cmd_buf[0] != GPCMD_INQUIRY) {
		fprintf(stderr, "CD: Error: No INQUIRY and not our lun: %i\n", lun);
		/* prepare sense commands */
		/* Correct error code? FIXME */
		s->NAME.sense_key = NOT_READY;
		s->NAME.asc       = 0x3a;
		s->NAME.ascq      = 0x00; /* FIXME */
		return;
	}

	if (s->NAME.cmd_buf[0] != GPCMD_INQUIRY && s->NAME.unit_attention) {
		if (s->NAME.changed == 1) {
			NAME_(medium_changed)(s);
			s->NAME.changed = 0;
		} else {
			/* power on, reset or bus device reset occured */
			NAME_(check_condition)(s, UNIT_ATTENTION, 0x29, 0x00);
		}
		s->NAME.unit_attention = 0;
		return;
	}

	if (s->NAME.cmd_buf[0] != GPCMD_REQUEST_SENSE) {
		/* Clear error info *before* executing command. */
		s->NAME.sense_key = 0;
		s->NAME.asc = 0;
		s->NAME.ascq = 0;
	}

	switch (s->NAME.cmd_buf[0]) {
	/*
	 * Commands for all devices.
	 */
	case GPCMD_REPORT_LUNS: /* 0xa0, mandatory(?) */
		/* SCSI-3 SPC, 6.21, 206 */
		NAME_(report_luns)(s);
		break;
	/*
	 * SCSI-3 MMC 11.0, page 24
	 * Commands for CD devices
	 */
	case GPCMD_INQUIRY: /* 0x12, mandatory */
		NAME_(inquiry)(s);
		break;
#if CD_CHANGER_SUPPORT
	case GPCMD_LOAD_UNLOAD: /* 0xa6, optional */
		NAME_(load_unload)(s);
		break;
#endif
	case GPCMD_MECHANISM_STATUS: /* 0xbd, mandatory */
		NAME_(mechanism_status)(s);
		break;

	case GPCMD_MODE_SELECT_6: /* 0x15, mandatory */
		NAME_(mode_select_6)(s);
		break;

	case GPCMD_MODE_SENSE_6: /* 0x1a, mandatory */
		NAME_(mode_sense_6)(s);
		break;

	case GPCMD_MODE_SENSE_10: /* 0x5a, mandatory */
		NAME_(mode_sense_10)(s);
		break;
#if CD_AUDIO_SUPPORT
	case GPCMD_PAUSE_RESUME: /* 0x4b, mandatory for audio */
		NAME_(pause_resume)(s);
		break;

	case GPCMD_PLAY_AUDIO_10: /* 0x45, mandatory for audio */
		NAME_(play_audio_10)(s);
		break;

	case GPCMD_PLAY_AUDIO_12: /* 0xa5, mandatory for audio */
		NAME_(play_audio_12)(s);
		break;

	case GPCMD_PLAY_AUDIO_MSF: /* 0xa7, mandatory for audio */
		NAME_(play_audio_msf)(s);
		break;
#endif
#if CD_PLAY_CD_SUPPORT
	case GPCMD_PLAY_CD: /* 0xbc, optional */
		NAME_(play_cd)(s);
		break;
#endif
	case GPCMD_PREVENT_ALLOW_MEDIUM_REMOVAL: /* 0x1e, mandatory */
		NAME_(prevent_allow_medium_removal)(s);
		break;

	case GPCMD_READ_10: /* 0x28, mandatory */
		NAME_(read_10)(s);
		break;

#if CD_READ_CD_SUPPORT
	case GPCMD_READ_CD: /* 0xbe, optional */
		NAME_(read_cd)(s);
		break;
#endif
#if CD_READ_CD_SUPPORT
	case GPCMD_READ_CD_MSF: /* 0xb9, optional */
		NAME_(read_cd_msf)(s);
		break;
#endif
	case GPCMD_READ_CD_RECORDED_CAPACITY: /* 0x25, mandatory */
		NAME_(read_cd_recorded_capacity)(s);
		break;

#if 0 /* obsolete */
	case GPCMD_READ_HEADER: /* 0x44, mandatory */
		NAME_(read_header)(s);
		break;
#endif

	case GPCMD_READ_SUBCHANNEL: /* 42, mandatory */
		NAME_(read_subchannel)(s);
		break;

	case GPCMD_READ_TOC_PMA_ATIP: /* 0x43, mandatory */
		NAME_(read_toc_pma_atip)(s);
		break;

	case GPCMD_RELEASE_10: /* 0x57, mandatory */
		NAME_(release_10)(s);
		break;

	case GPCMD_REQUEST_SENSE: /* 0x03, mandatory */
		NAME_(request_sense)(s);
		break;

	case GPCMD_RESERVE_10: /* 0x56, mandatory */
		NAME_(reserve_10)(s);
		break;
#if CD_SCAN_CD_SUPPORT
	case GPCMD_SCAN: /* 0xba, optional */
		NAME_(scan)(s);
		break;
#endif
	case GPCMD_SEEK_6: /* 0x0b, mandatory */
		NAME_(seek_6)(s);
		break;

	case GPCMD_SEEK_10: /* 0x2b, mandatory */
		NAME_(seek_10)(s);
		break;

	case GPCMD_SEND_DIAGNOSTIC: /* 0x1d, mandatory */
		NAME_(send_diagnostic)(s);
		break;

	case GPCMD_SET_CD_SPEED: /* 0xbb, mandatory for CD-R/RW */
		NAME_(set_cd_speed)(s);
		break;

	case GPCMD_START_STOP_UNIT: /* 0x1b, mandatory */
		NAME_(start_stop_unit)(s);
		break;
#if CD_AUDIO_SUPPORT
	case GPCMD_STOP_PLAY_SCAN: /* 0x4e, mandatory for audio */
		NAME_(stop_play_scan)(s);
		break;
#endif
	case GPCMD_TEST_UNIT_READY: /* 0x00, mandatory */
		NAME_(test_unit_ready)(s);
		break;

#if CD_WRITER_SUPPORT
		/*
		 * SCSI-3 MMC 11.0, page 93
		 * Commands for CD-R/RW devices
		 */
	case GPCMD_CLOSE_TRACK: /* 0x5b, mandatory for CD-R/RW */
		NAME_(close_track_session)(s);
		break;
#if CD_WRITER_RW_SUPPORT
	case GPCMD_BLANK: /* 0xa1, mandatory for CD-R/RW */
		NAME_(blank)(s);
		break;

	case GPCMD_FORMAT_UNIT: /* 0x04, optional */
		NAME_(format_unit)(s);
		break;
#endif
#if 0 /* obsolete */
	case GPCMD_READ_BUFFER_CAPACITY: /* 0x5c, optional */
		NAME_(read_buffer_capacity)(s);
		break;
#endif
	case GPCMD_READ_DISC_INFO: /* 0x51, mandatory */
		NAME_(read_disc_info)(s);
		break;
#if 0 /* obsolete */
	case GPCMD_READ_MASTER_CUE: /* 0x59, optional */
		NAME_(read_master_cue)(s);
		break;
#endif
	case GPCMD_READ_TRACK_INFORMATION: /* 0x52, mandatory */
		NAME_(read_track_information)(s);
		break;
	case GPCMD_RESERVE_TRACK: /* 0x53, mandatory */
		NAME_(reserve_track)(s);
		break;
#if CD_WRITER_DAO_SUPPORT
	case GPCMD_SEND_CUE_SHEET: /* 0x5d, optional */
		NAME_(send_cue_sheet)(s);
		break;
#endif
	case GPCMD_SEND_OPC: /* 0x54, optional */
		NAME_(send_opc_information)(s);
		break;
	case GPCMD_SYNCHRONIZE_CACHE: /* 0x35, mandatory */
		NAME_(synchronize_cache)(s);
		break;

	case GPCMD_WRITE_10: /* 0x2a, mandatory */
		NAME_(write_10)(s);
		break;
#endif

	case GPCMD_GET_CONFIGURATION: /* 0x46 */
		NAME_(get_configuration)(s);
		break;
	case GPCMD_MODE_SELECT_10: /* 0x55 */
		NAME_(mode_select_10)(s);
		break;

	default:
#if DEBUGPCOM
		fprintf(stderr, "unknown cmd_buf: 0x%02x\n", s->NAME.cmd_buf[0]);
#endif
		NAME_(invalid_command_operation_code)(s);
	}

	if (s->NAME.cmd_buf[0] == GPCMD_REQUEST_SENSE) {
		/* Clear error info *after* executing command. */
		s->NAME.sense_key = 0;
		s->NAME.asc = 0;
		s->NAME.ascq = 0;
	}
}

static void __attribute__((__noreturn__))
NAME_(process)(void *_cpssp)
{
	uint8_t skip_remaining = 0;
	struct cpssp *cpssp = (struct cpssp *) _cpssp;

	for (;;) {
		NAME_(phase_free)(cpssp);
		cpssp->NAME.selected = 0;
		sched_sleep();

		/* Message Out Phase */
		/* Message system description s2-r10l.pdf P.91 */
		NAME_(phase_msg_out)(cpssp);
		do {
			/* Receive Message */
			NAME_(_recv)(cpssp, 1);
			cpssp->NAME.msg_buf[0] = cpssp->NAME.buf[0];
			switch (cpssp->NAME.msg_buf[0]) {
			case 0x00:
			case 0x02 ... 0x1f:
			case 0x80 ... 0xff:
				/* One Byte Message */
				break;

			case 0x20 ... 0x2f:
				/* Two Byte Message */
				NAME_(_recv)(cpssp, 1);
				cpssp->NAME.msg_buf[1] = cpssp->NAME.buf[0];
				break;

			case 0x01:
				/* Extended Message */
				cpssp->NAME.msg_buf[1] = cpssp->NAME.buf[0];
				NAME_(_recv)(cpssp, cpssp->NAME.msg_buf[1]);
				memcpy(&cpssp->NAME.msg_buf[2], cpssp->NAME.buf,
						cpssp->NAME.msg_buf[1]);
				break;

			default:
				assert(0);
			}

			/* Process message... - FIXME */
			if (cpssp->NAME.msg_buf[0] == 0) {
				/* ??? Message */
				/* FIXME */

				/* see s2-r10l.pdf table 10 p.92ff */
			} else if (0x80 <= cpssp->NAME.msg_buf[0]) {
				/* IDENTIFY Message */
				cpssp->NAME.lun = cpssp->NAME.msg_buf[0] & 0x7;

			} else if (cpssp->NAME.msg_buf[0] == 0x01
					&& cpssp->NAME.msg_buf[1] == 0x01
					&& cpssp->NAME.msg_buf[2] == 0x00) {
				/* ??? Message */

			} else if (cpssp->NAME.msg_buf[0] == 0x01
					&& cpssp->NAME.msg_buf[1] == 0x01
					&& cpssp->NAME.msg_buf[2] == 0x03) {
				/* ??? Message */
				/* FIXME */

			} else if (cpssp->NAME.msg_buf[0] == 0x01
					&& cpssp->NAME.msg_buf[1] == 0x01
					&& cpssp->NAME.msg_buf[2] == 0x09) {
				/* ??? Message */

			} else if (cpssp->NAME.msg_buf[0] == 0x01
					&& cpssp->NAME.msg_buf[1] == 0x01
					&& cpssp->NAME.msg_buf[2] == 0x19) {
				/* ??? Message */

			} else if (cpssp->NAME.msg_buf[0] == 0x01
					&& cpssp->NAME.msg_buf[1] == 0x06
					&& cpssp->NAME.msg_buf[2] == 0x04) {
				/* Parallel Negotiation Message */
				/* FIXME */

			} else if (cpssp->NAME.msg_buf[0] == 0x01
					&& cpssp->NAME.msg_buf[1] == 0x03
					&& cpssp->NAME.msg_buf[2] == 0x01) {
				/* Synchron Mode Negotiation Message */
				/* FIXME */

			} else if (cpssp->NAME.msg_buf[0] == 0x06) {
#if DEBUGPCOM
				fprintf(stderr, "Received abort\n");
#endif
				/* Abort */
				skip_remaining = 1;
				break;

			} else if (cpssp->NAME.msg_buf[0] == 0x07) {
#if DEBUGPCOM
				fprintf(stderr, "Received message rejected\n");
#endif
				/* Message Rejected */
				fixme();

			} else if (cpssp->NAME.msg_buf[0] == 0x0c) {
#if DEBUGPCOM
				fprintf(stderr, "Received bus device reset message\n");
#endif
				/* Bus Device Reset Message */
				skip_remaining = 1;
				scsi_gen_cdrom_reset(cpssp); /* include unit_attention */
				break;

			} else {
				fprintf(stderr, "%s: message type 0x%02x/0x%02x/0x%02x unknown.\n",
						__FUNCTION__,
						cpssp->NAME.msg_buf[0],
						cpssp->NAME.msg_buf[1],
						cpssp->NAME.msg_buf[2]);
			}
		} while (cpssp->NAME.state_atn);

		if (skip_remaining == 1) {
			skip_remaining = 0;
			continue;
		}

		/* Command Phase */
		NAME_(phase_cmd)(cpssp);
#ifdef ATAPI
		NAME_(_recv)(cpssp, 12);
		memcpy(cpssp->NAME.cmd_buf, cpssp->NAME.buf, 12);
#else
		NAME_(_recv)(cpssp, 1);
		cpssp->NAME.cmd_buf[0] = cpssp->NAME.buf[0];
		switch (cpssp->NAME.cmd_buf[0]) {
		case 0x00 ... 0x1f: /* Group 0: 6 Bytes Command */
			NAME_(_recv)(cpssp, 6 - 1);
			memcpy(&cpssp->NAME.cmd_buf[1], cpssp->NAME.buf, 6 - 1);
			break;
		case 0x20 ... 0x3f: /* Group 1: 10 Bytes Command */
			NAME_(_recv)(cpssp, 10 - 1);
			memcpy(&cpssp->NAME.cmd_buf[1], cpssp->NAME.buf, 10 - 1);
			break;
		case 0x40 ... 0x5f: /* Group 2: 10 Bytes Command */
			NAME_(_recv)(cpssp, 10 - 1);
			memcpy(&cpssp->NAME.cmd_buf[1], cpssp->NAME.buf, 10 - 1);
			break;
		case 0x80 ... 0x9f: /* Group 4: 16 Bytes Command */
			NAME_(_recv)(cpssp, 16 - 1);
			memcpy(&cpssp->NAME.cmd_buf[1], cpssp->NAME.buf, 16 - 1);
			break;
		case 0xa0 ... 0xbf: /* Group 5: 12-bytes-cmd */
			NAME_(_recv)(cpssp, 12 - 1);
			memcpy(&cpssp->NAME.cmd_buf[1], cpssp->NAME.buf, 12 - 1);
			break;
		default:
			/* FIXME there could be vendor specific commands */
			fprintf(stderr, "%s: command 0x%02x unknown.\n",
					__FUNCTION__,
					cpssp->NAME.cmd_buf[0]);
		}
#endif
#if 0
		fprintf(stderr, "%s %d 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x 0x%02x\n", __FUNCTION__, __LINE__,
				cpssp->NAME.cmd_buf[0], cpssp->NAME.cmd_buf[1],
				cpssp->NAME.cmd_buf[2], cpssp->NAME.cmd_buf[3],
				cpssp->NAME.cmd_buf[4], cpssp->NAME.cmd_buf[5],
				cpssp->NAME.cmd_buf[6], cpssp->NAME.cmd_buf[7],
				cpssp->NAME.cmd_buf[8], cpssp->NAME.cmd_buf[9],
				cpssp->NAME.cmd_buf[10], cpssp->NAME.cmd_buf[11],
				cpssp->NAME.cmd_buf[12], cpssp->NAME.cmd_buf[13],
				cpssp->NAME.cmd_buf[14], cpssp->NAME.cmd_buf[15]);
#endif

		/* Execute Command */
		NAME_(cmd)(cpssp);

		/* Status Phase */
		NAME_(phase_status)(cpssp);
		if (cpssp->NAME.sense_key == 0) {
			cpssp->NAME.buf[0] = 0;
		} else {
			cpssp->NAME.buf[0] = 2;
		}
		NAME_(_send)(cpssp, 1);

		NAME_(phase_msg_in)(cpssp);
		switch (cpssp->NAME.cmd_buf[0]) {
		/* any not implemented command should go here */
		case 0xa0: /* REPORT_LUNS */
			/* reject command */
			/* FIXME should be 0x07 (waiting for helmi) */
			cpssp->NAME.buf[0] = 0x00;
			break;
		default: /* Completion Byte */
			/* send 0 here, because command completed and status sent */
			cpssp->NAME.buf[0] = 0x00;
		}
		NAME_(_send)(cpssp, 1);
	}
}

static void
NAME_(create)(struct cpssp *cpssp, const char *path, unsigned int id)
{
	cpssp->NAME.id = id;
	cpssp->NAME.inserted = 0;

	sched_process_init(&cpssp->NAME.process, NAME_(process), cpssp);
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
	/* Nothing to do... */
}

#endif /* BEHAVIOR */
