/***************************************************************************
                          FLTableDB.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLTABLEDB_H
#define FLTABLEDB_H

#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qsettings.h>

#include "FLWidgetTableDB.h"

class FLSqlCursor;
class FLDataTable;
class FLFieldMetaData;

/** PLUGIN que contiene una tabla de la base de datos.

    	Este objeto contiene todo lo necesario para manejar
    	los datos de una tabla. Adems de la funcionalidad de
    	busqueda en la tabla por un campo, mediante filtros.

    	Este plugin para que sea funcional debe tener como uno
    	de sus padres o antecesor a un objeto FLFormDB.

    	@author   Federico Albujer Zornoza
    	@version  0.4 */
class FLTableDB:public FLWidgetTableDB
{
  	Q_OBJECT
  	Q_PROPERTY (QCString tableName READ tableName WRITE setTableName)
 	Q_PROPERTY (QCString foreignField READ foreignField WRITE setForeignField)
       Q_PROPERTY (QCString fieldRelation READ fieldRelation WRITE setFieldRelation)

  	public:

	/** constructor */
  	FLTableDB (QWidget * parent = 0, const char *name = 0);

	/** destructor */
  	~FLTableDB ();

	/** Componente para visulazar los registros*/
  	FLDataTable *tableRecords;

  	/** Para obtener el cursor utilizado por el componente.

		return Objeto FLSqlCursor con el cursor que contiene los registros para ser utilizados en el formulario */
  	FLSqlCursor *cursor () const
  	{
    		return cursor_;
  	}
  	
	/** Para obtener el nombre de la tabla asociada.

      	@return	Nombre de la tabla asociado */
  	QCString tableName () const;

	/** Para establecer el nombre de la tabla asociada.

      	@param fT	Nombre de la tabla asociada*/
  	void setTableName (const QCString & fT);

	/** Para obtener el nombre del campo forneo.

      	@return	Nombre del campo */
  	QCString foreignField () const;

	/** Para establecer el nombre del campo forneo.

      	@param fN	Nombre del campo */
  	void setForeignField (const QCString & fN);

	/** Para obtener el nombre del campo relacionado.

      	@return	Nombre del campo */
  	QCString fieldRelation () const;

	/** Para establecer el nombre del campo relacionado.

      	@param fN	Nombre del campo */
  	void setFieldRelation(const QCString & fN);

  	private:

	/** Nombre de la tabla a la que esta asociado este componente.*/
  	QString tableName_;

	/** Nombre del campo forneo */
  	QString foreignField_;

	/** Nombre del campo de la relacin */
	QString fieldRelation_;

	/** Cursor con los datos de origen para el componente */
  	FLSqlCursor *cursor_;

	/** Cursor auxiliar de uso interno para almacenar los registros de la tabla
	    	relacionada con la de origen */
  	FLSqlCursor *cursorAux;

	/** Matiene la ventana padre */
	QWidget *topWidget;

	/** Indica que la ventana ya ha sido mostrada una vez, llamando al mtodo FLTableDB::show() */
	bool showed;
	
	/** Mantiene el contenido del campo de bsquedad utilizado para filtrar registros */
	QString filter;

      /** Almacena si el componente est en modo slo lectura */
      bool readonly_;

      /** Almacena los metadatos del campo por el que est actualmente ordenada la tabla */
      FLFieldMetaData * sortField_;

      /** Lista que almacena los anchos de las columnas de la tabla */
      QStringList columnsWidths;

  	public slots:
	
	/** Actualiza el conjunto de registros.

	   	Se le puede pasar una cadena con la que filtran los registros de la tabla,
	   	solo aquellos que cumplan el filtrado sern mostrados. */
	void refresh ();

  	/** Invoca al mtodo FLSqlCursor::insertRecord() */
  	void insertRecord ();

  	/** Invoca al mtodo FLSqlCursor::editRecord() */
  	void editRecord ();

  	/** Invoca al mtodo FLSqlCursor::browseRecord() */
	void browseRecord ();

	/** Invoca al mtodo FLSqlCursor::deleteRecord() */
  	void deleteRecord ();

	/** Inicia el cursor segun este campo sea de la tabla origen o de
      	una tabla relacionada */
  	void initCursor ();
  	
  	/** Redefinida por conveniencia */
  	void show();

       /** Modifica la lista de anchos de columnas de la tabla, FLTableDB::columnsWidths.

            Establece el valor del elemento "i" de la lista con el valor "newSize".

            @param  i   Posicin del elemento de la lista
            @param  oldSize No se utiliza, slo es para poder conectar la seal QHeader::sizeChange()
            @param  newSize Nuevo ancho asignado al elemento */
      void sizeChanged(int i, int oldSize, int newSize);

     /** Desconecta todas los puertos de las seales */
     void disconnectSignalSlots();

  	protected slots:
	
	/** Coloca la columna indicada como primera.

      	Este slot est conectado al cuadro combinado de busqueda
      	del componente. Cuando seleccionamos un campo este se coloca
      	como primera columna y se reordena la tabla con esta columna.
      	De esta manera siempre tendremos la tabla ordenada mediante
      	el campo en el que queremos buscar.

      	@param c	Numero de la columna en la tabla, esta columna intercambia
                			su posion con la primera columna. */
  	void putFirstCol (int c);

	/** Filtra los registros de la tabla utilizando el primer campo, segn el patrn dado.

      	Este slot est conectado al cuadro de texto de busqueda del componente,
      	tomando el contenido de este como patrn para el filtrado.

      	@param p	Cadena de caracteres con el patrn de filtrado. */
  	void filterRecords (const QString & p);       
};

#endif
