/***************************************************************************
                          FLFormRecordDB.h  -  description
                             -------------------
    begin                : Sat Jul 28 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLFORMRECORDDB_H
#define FLFORMRECORDDB_H

#include <qpushbutton.h>
#include <qsqlrecord.h>

#include "FLFormDB.h"

/** Subclase de FLFormDB pensada para editar registros.

    	Bsicamente esta clase hace lo mismo que su clase
    	base FLFormDB, lo nico que aade son dos botones
    	Aceptar y/o Cancelar para confirmar o cancelar
    	los cambios que se realizan en los componentes de
    	datos que contiene.

    	Esta clase es idnea para cargar los formularios de
    	edicin de registros definidos en los metadatos
    	( FLTableMetaData ).

    	@author   Federico Albujer Zornoza
    	@version  0.4 */
class FLFormRecordDB:public FLFormDB
{
	Q_OBJECT

  	public:
  
  	/** constructor.

      	Solo acepta que se le indique un cursor ya creado.

      	@param cursor	Objeto FLSqlCursor con el cursor con el que tratar.
		@param receiver	Objeto del tipo FLReceiver, que controlar y recibir seales
                        de este formulario. Este objeto pasa a ser propiedad del formulario,
                        y es l quien lo borra.
		@param showAcceptContinue Indica si se debe mostrar el botn de Aceptar y Continuar*/
  	FLFormRecordDB (FLSqlCursor * cursor, QWidget * parent = 0, FLReceiver * receiver=0,bool showAcceptContinue=true);

  	/** destructor */
  	~FLFormRecordDB ();

  	/** Reimplementado, aade un widget como principal del formulario */
  	void setMainWidget (QWidget * w);

  	protected:

  	/** Capa para botones Aceptar y Cancelar */
 	QHBoxLayout * layoutButtons;

  	/** Boton Aceptar */
  	QPushButton *pushButtonAccept;

    /** Boton Aceptar y continuar */
  	QPushButton *pushButtonAcceptContinue;

  	/** Boton Cancelar */
  	QPushButton *pushButtonCancel;

  	/** Captura del evento cerrar la ventana */
  	virtual void closeEvent(QCloseEvent * e);
  	
  	protected slots:

  	/** Se activa al pulsar el boton aceptar */
  	virtual void accept ();

    /** Se activa al pulsar el boton aceptar y contninuar */
  	virtual void acceptContinue ();

  	/** Se activa al pulsar el botn cancelar */
  	virtual void reject ();

  	private:

    /** Inicializacin */
    void init ();

  	/** Indica si se han aceptado los cambios */
  	bool accepted;

   /** Indica si se debe mostrar el botn Aceptar y Continuar */
   bool showAcceptContinue_;
   
   signals:

   /** Seal emitida justo antes de hacer el "commit" del registro actualmente en edicin */
   void beforeCommit();

   /** Seal emitida justo despues de hacer el "commit" del registro actualmente en edicin.

      @param  b   Se establece a TRUE si el "commit" tuvo xito, y FALSE en caso contrario*/
   void afterCommit(bool);

   /** Seal emitida justo antes de hacer el "rollback" del registro actualmente en edicin.

        Hay que notar que el rollback no se puede llevar a cabo por que el usuario tiene
        posibilidad de cancelarlo.*/
    void beforeRollback();

    /** Seal emitida justo despues de hacer el "rollback" del registro actualmente en edicin.

        @param  b   Se establece a TRUE si el "rollback" tuvo xito, y FALSE en caso contrario*/
    void afterRollback(bool);
};

#endif
