/*
 * Copyright  CNRS, INRIA, Universit Bordeaux 1
 * See COPYING in top-level directory.
 */

#include <sys/time.h>
#include <semaphore.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include <stdint.h>
#include <stdio.h>
#include <fcntl.h>

/* Number of iterations */
#define ITER 10
/* Number of threads */
#define NTH 2

typedef union {
        unsigned long long tick;
        struct {
                unsigned low;
                unsigned high;
        };
} tick_t;

int fd[2][2];
sem_t* thread_ready;

#define TICK_DIFF(t1, t2) \
           ((t2).tick - (t1).tick)

#define TIME_DIFF(t1, t2) \
        ((t2.tv_sec - t1.tv_sec) * 1000000 + (t2.tv_usec - t1.tv_usec))



/* Fake computation of usec microseconds */
void compute(int usec) {
        struct timeval tv1,tv2;
        gettimeofday(&tv1,NULL);
	do {
		gettimeofday(&tv2,NULL);
	}while(TIME_DIFF(tv1, tv2) < usec);	
}

void* f_thread(void* arg) {
  int my_id= *(int*)arg;

  /* Notify the main thread that we got the args */
  sem_post(thread_ready);

  printf("Running thread #%d\n", my_id);

  int buf = -1;

  int i;
  for(i=0; i<ITER; i++){
    /* Wait until the previous thread has finished his job */
    read(fd[my_id][0], &buf, sizeof(int));

    printf("[thread #%d] read %d\n", my_id, buf);

    /* compute for 1ms */
    compute(50000);

    buf++;
    /* Wake up the next thread */
    write(fd[(my_id+1)%2][1], &buf, sizeof(int));
    buf = 0;
  }

  printf("End of thread #%d\n", my_id);
  return NULL;
}

int main(int argc, char**argv)
{
  pthread_t tid[NTH];
  int i;

  if(pipe(fd[0]) || pipe(fd[1])) {
    fprintf(stderr, "error while calling pipe\n");
    return 1;
  }

  sem_unlink("ready");
  thread_ready = sem_open("ready", O_CREAT, 0666, 0);

  for(i=0;i<NTH; i++)
    {
      pthread_create(&tid[i], NULL, f_thread, &i);
      sem_wait(thread_ready);
    }
  sem_unlink("ready");
  i = 0;
  printf("Main thread writes %d\n", i);
  write(fd[0][1], &i, sizeof(int));
  for(i=0;i<NTH; i++)
    {
      pthread_join(tid[i], NULL);
    }

  return 0;
}

