/*
 * These are some constants for mdidentd that you can tweak to your
 * needs. The defaults should be fine for most people.
 *
 * These really ought to be command line options that you can give to
 * mdidentd, but since i'm lazy they will be here for a while.
 */

#ifndef __DEFS_H
#define __DEFS_H

/* 
 * How long do we wait on port 113 before the connector sends 
 * some text? (seconds)
 */

#define MAX_IDENT_WAIT_TIME 30 


/*
 * How to long wait for connections to the domain socket to send
 * their fake ident requests to us?
 * Please don't be too liberal. There is no reason a program should
 * sit there for minutes. All it needs to do is send the request
 * and close the socket. I've set the default to 6 seconds. There is no
 * reason it should even take that long.
 */
#define MAX_UNIX_WAIT_TIME 6


/* 
 * How long to fake ident requests live in memory? Should not be more
 * than 45 seconds. 15 might even be better
 */
#define FAKE_IDENT_LIFETIME 45

#endif
