
/*
 * Doubly-linked list. Not circular.
 *
 * (C) 1998-2000 Murat Deligonul
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#ifndef __LINKEDLIST_H
#define __LINKEDLIST_H

class __list_core 
{
    friend class __list_iter;    
private:
    struct node 
    {
        void * data;
        node * next;
        node * prev;
    } *_first, * _last;
    node * find_by_idx(int, int * = 0) const;
    int num_nodes;
    
public:
    __list_core(void * = 0);
    ~__list_core(void);
    
    int add(void * data);
    int insert(void *, int = 0);  
    void * get(int);
    void * remove(int);
    bool   remove(void *);
    
    void * first(void) { return (_first) ? _first->data : 0; }
    void * last(void) { return (_last) ? _last->data : 0; }

    int num() { return num_nodes; }
};  

class __list_iter
{
private:
    struct __list_core::node * current;
    const __list_core * list;
    
public:
    __list_iter(const __list_core * l) { list = l; current = l->_first; }
    void * get(int = 0);


    /* 
     * Postfix increment/decrement, save value of current->data, change value
     * of current, return saved value.
     */
    void * operator++(int)
    {
        void * save = (current) ? current->data : 0;
        return ((current) ? ((current = current->next), (save)) : (current = 0));
    }

    void * operator--(int )
    {
        void * save = (current) ? current->data : 0;
        return ((current) ? (current = current->prev), (save) : (current = 0));
    }
    
    void * operator++(void)
    {
        return (current && current->next) ? (current = current->next)->data : (current = 0);
    }

    void * operator--(void)
    {
        return (current && current->prev) ? (current = current->prev)->data : (current = 0);
    }

    /*
    * Set current pointer to ith item (0-based)
    */
    void * set(int i)
    {
        __list_core::node * n = list->find_by_idx(i);
        if (n)
            current = n;
        return (n) ? current->data : 0;
    }

};
    
template <class T> class list_iterator : public __list_iter
{
public:
    list_iterator(const __list_core * x) : __list_iter(x) { }
    T * operator++(int x) { return (T *) __list_iter::operator++(x); }
    T * operator--(int x) { return (T *) __list_iter::operator--(x); }
    T * operator++(void)  { return (T *) __list_iter::operator++(); }
    T * operator--(void)  { return (T *) __list_iter::operator--(); }
    T * get(void)       { return (T *) __list_iter::get(); }
    T * set(int x)      { return (T *) __list_iter::set(x); }

};
    
template <class T> class linkedlist : public __list_core
{    
public:
    linkedlist(T * xxx = 0) : __list_core::__list_core(xxx) { };
    
    int add(T *x) { return __list_core::add((void *) x); }
    int insert(T *x, int w) { return __list_core::insert((void *) x, w); }
    T * get(int idx) { return (T *) __list_core::get(idx); }
    T * remove(int idx) { return (T *) __list_core::remove(idx); }
    bool remove(T * d) { return __list_core::remove(d); }

    T * first(void) { return (T *) __list_core::first(); }
    T * last(void)  { return (T *) __list_core::last(); }

};

#endif
