#include <stdio.h>
#include <string.h>

#include <libbonobo.h>

#include "e-mail-remote-glue-utils.h"
#include "e-mail-remote-glue-folderinfo.h"

static void e_mail_remote_glue_folderinfo_class_init (EMailRemoteGlueFolderInfoClass *klass);
static void e_mail_remote_glue_folderinfo_init (EMailRemoteGlueFolderInfo *comp, EMailRemoteGlueFolderInfoClass *klass);
static void e_mail_remote_glue_folderinfo_finalize (GObject *object);

/*static guint e_mail_remote_signals[LAST_SIGNAL] = { 0 };*/

static GObjectClass *parent_class;

struct _EMailRemoteGlueFolderInfoPrivate {
  char* name;
  char* full_name;
  Bonobo_Unknown folder; /* Evolution_Mail_Folder */
};

/**
 * e_mail_remote_glue_folderinfo_get_type:
 *
 * Registers the #EMailRemoteGlueFolderInfo class if necessary, and returns the type ID
 * associated to it.
 *
 * Return value: The type ID of the #EMailRemoteGlueFolderInfo class.
 **/
GType
e_mail_remote_glue_folderinfo_get_type (void)
{
  static GType e_mail_remote_glue_folderinfo_type = 0;

  if (!e_mail_remote_glue_folderinfo_type) {
    static GTypeInfo info = {
      sizeof (EMailRemoteGlueFolderInfoClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) e_mail_remote_glue_folderinfo_class_init,
      NULL, NULL,
      sizeof (EMailRemoteGlueFolderInfo),
      0,
      (GInstanceInitFunc) e_mail_remote_glue_folderinfo_init
    };
    e_mail_remote_glue_folderinfo_type = g_type_register_static (G_TYPE_OBJECT, "EMailRemoteGlueFolderInfo", &info, 0);
  }

  return e_mail_remote_glue_folderinfo_type;
}

/* Class initialization function for the calendar-glue object */
static void
e_mail_remote_glue_folderinfo_class_init (EMailRemoteGlueFolderInfoClass *klass)
{
  GObjectClass *object_class;

  object_class = (GObjectClass *) klass;

  parent_class = g_type_class_peek_parent (klass);

  object_class->finalize = e_mail_remote_glue_folderinfo_finalize;
}

/* Object initialization function for the calendar-glue object */
static void
e_mail_remote_glue_folderinfo_init (EMailRemoteGlueFolderInfo *emrg_finfo, EMailRemoteGlueFolderInfoClass *klass)
{  
  emrg_finfo->priv = g_new0 (EMailRemoteGlueFolderInfoPrivate, 1);
}

/**
 * e_mail_remote_glue_folderinfo_new:
 *
 * Creates a new empty calendar-glue component object.  
 *
 * Return value: A newly-created calendar-glue component object.
 **/
EMailRemoteGlueFolderInfo *
e_mail_remote_glue_folderinfo_new (void)
{
  return E_MAIL_REMOTE_GLUE_FOLDERINFO (g_object_new (E_TYPE_MAIL_REMOTE_GLUE_FOLDERINFO, NULL));
}

/* Finalize handler for the calendar-glue component object */
static void
e_mail_remote_glue_folderinfo_finalize (GObject *object)
{
  EMailRemoteGlueFolderInfo *finfo;
  EMailRemoteGlueFolderInfoPrivate *priv;

  g_return_if_fail (object != NULL);
  g_return_if_fail (E_IS_MAIL_REMOTE_GLUE_FOLDERINFO (object));

  finfo = E_MAIL_REMOTE_GLUE_FOLDERINFO (object);
  priv = finfo->priv;
 
  if (priv) {
    g_free (priv->name);
    g_free (priv->full_name);
    bonobo_object_release_unref (priv->folder, NULL);

    priv->name = NULL;
    priv->full_name = NULL;
    priv->folder = NULL;
    
    g_free (priv);
    finfo->priv = NULL;
  }

  if (G_OBJECT_CLASS (parent_class)->finalize)
    (* G_OBJECT_CLASS (parent_class)->finalize) (object);
}

EMailRemoteGlueFolderInfo*
e_mail_remote_glue_folderinfo_new_clone (EMailRemoteGlueFolderInfo* info)
{
  EMailRemoteGlueFolderInfo* emrg_finfo = e_mail_remote_glue_folderinfo_new ();
  EMailRemoteGlueFolderInfoPrivate* priv = emrg_finfo->priv;
  CORBA_Environment ev = { 0 };

  priv->name = g_strdup (info->priv->name);
  priv->full_name = g_strdup (info->priv->full_name);
  priv->folder = bonobo_object_dup_ref (info->priv->folder, &ev);
  /* FIXME: Error handling */

  return emrg_finfo;
}


EMailRemoteGlueFolderInfo*
e_mail_remote_glue_folderinfo_new_from_EMFolderInfo (Evolution_Mail_FolderInfo info)
{
  EMailRemoteGlueFolderInfo* emrg_finfo = e_mail_remote_glue_folderinfo_new ();
  EMailRemoteGlueFolderInfoPrivate* priv = emrg_finfo->priv;
  CORBA_Environment ev = { 0 };

  priv->name = g_strdup (info.name);
  priv->full_name = g_strdup (info.full_name);
  priv->folder = bonobo_object_dup_ref (info.folder, &ev);
  /* FIXME: Error handling */

  return emrg_finfo;
}

char*
e_mail_remote_glue_folderinfo_peek_name (EMailRemoteGlueFolderInfo* finfo)
{
  g_return_val_if_fail (finfo != NULL, NULL);
  g_return_val_if_fail (finfo->priv != NULL, NULL);

  return finfo->priv->name;
}

char*
e_mail_remote_glue_folderinfo_peek_full_name (EMailRemoteGlueFolderInfo* finfo)
{
  g_return_val_if_fail (finfo != NULL, NULL);
  g_return_val_if_fail (finfo->priv != NULL, NULL);

  return finfo->priv->full_name;
}

Evolution_Mail_Folder
e_mail_remote_glue_folderinfo_peek_EMFolder (EMailRemoteGlueFolderInfo* finfo)
{
  g_return_val_if_fail (finfo != NULL, NULL);
  g_return_val_if_fail (finfo->priv != NULL, NULL);

  return finfo->priv->folder;
}

EMailRemoteGlueMsgIterator*
e_mail_remote_glue_folderinfo_get_messages (EMailRemoteGlueFolderInfo* emrg_finfo)
{
  EMailRemoteGlueFolderInfoPrivate* priv = emrg_finfo->priv;
  CORBA_Environment ev = { 0 };
  Evolution_Mail_MessageIterator iter;
  EMailRemoteGlueMsgIterator *emrg_msgiter = NULL;

  iter = Evolution_Mail_Folder_getMessages (priv->folder, "", &ev);

  if (ev._major != CORBA_NO_EXCEPTION) {
    e_mail_exception_dump(&ev, "getting messages");
    return emrg_msgiter;
  }

  emrg_msgiter = e_mail_remote_glue_msgiterator_new_from_EMMsgIterator (iter);

  return emrg_msgiter;
}

EMailRemoteGlueMsgStream*
e_mail_remote_glue_folderinfo_get_message (EMailRemoteGlueFolderInfo* finfo, 
				const char* uid)
{
  EMailRemoteGlueFolderInfoPrivate* priv = finfo->priv;
  EMailRemoteGlueMsgStream* emrg_msgstream = NULL;
  Evolution_Mail_MessageStream stream = NULL;
  CORBA_Environment ev = { 0 };

  stream = Evolution_Mail_Folder_getMessage (priv->folder, uid, &ev);

  if (ev._major != CORBA_NO_EXCEPTION) {
    e_mail_exception_dump(&ev, "getting messages");
    return emrg_msgstream;
  }

  emrg_msgstream = e_mail_remote_glue_msgstream_new_from_EMMsgStream (stream);

  return emrg_msgstream;
}
