/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libgpt.so
 *
 *   File: gpt.h
 */

#ifndef   GPT_HEADER
#define   GPT_HEADER 1

extern struct engine_functions_s       *EngFncs;
extern plugin_record_t                 *gpt_plugin_record_ptr;

#define my_plugin_record                gpt_plugin_record_ptr


/* Needed for CRC calculations */
#define  INITIAL_CRC 0xFFFFFFFFL


//
//  MSDOS Partition Table Info
//
#define SYS_IND(p)     (p->sys_ind)
#define BOOT_IND(p)    (p->boot_ind)

#define START_SECT(p)  (p->sector)
#define START_CYL(p)   (p->cyl)
#define START_HEADS(p) (p->head)

#define END_SECT(p)    (p->end_sector)
#define END_CYL(p)     (p->end_cyl)
#define END_HEADS(p)   (p->end_head)

#define NR_SECTS(p)    (p->nr_sects)
#define START_LBA(p)   (p->start_sect)

typedef struct partition_s {
    unsigned char boot_ind;     /* 0x80 - active */
    unsigned char head;         /* starting head */
    unsigned char sector;       /* starting sector */
    unsigned char cyl;          /* starting cylinder */
    unsigned char sys_ind;      /* What partition type */
    unsigned char end_head;     /* end head */
    unsigned char end_sector;   /* end sector */
    unsigned char end_cyl;      /* end cylinder */
    unsigned int start_sect;    /* starting sector counting from 0 */
    unsigned int nr_sects;      /* nr of sectors in partition */
} __attribute__((packed)) msdos_partition;


typedef struct _mbr_s {
char                reserved[446];
msdos_partition     partition_table[4];
u_int16_t           signature;
} master_boot_record;

#define MSDOS_DISKMAGIC    0xAA55

/* Some defines for the sys_ind field of the partition record */
#define GPT_PARTITION                      0xee
#define LINUX_LVM_PARTITION                0x8e
#define LINUX_EXT2_PARTITION               0x83
#define LINUX_SWAP_PARTITION               0x82
#define LINUX_EXTENDED_PARTITION           0x85
#define DOS_EXTENDED_PARTITION             0x05
#define WIN95_EXTENDED_PARTITION           0x0f
#define WIN98_EXTENDED_PARTITION           0x0f



//
//  GUID Partition Table Info
//

#define GPT_DISKMAGIC               0x5452415020494645ULL  // "EFI PART"
#define GPT_VERSION_1               0x00010000          // version 1.0.0
#define GPT_VERSION_1_2             0x00010200          // version 1.2.0
#define GPT_PNAME_SIZE              36                  // max size of unicode partition name
#define GPT_ESP_MAX_SECTOR_COUNT    204800              // max size for the ESP partition ... 100MB

typedef u_int64_t attribute_t;

typedef u_int16_t  utf16_char_t;

/* Globally Unique Identifier
 *
 * Reference: Wired For Management Baseline Specification, Version 1.1a
 *            Appendix J
 */
#define guid_version_mask     0xf000
#define guid_version_1        0x1000           // from version 1.1.a
#define guid_variant_mask     0xe0
#define guid_variant_default  0x80             // from version 1.1.a

typedef struct _guid_s {
    u_int32_t       time_low;              // timestamp - low order 32 bits
    u_int16_t       time_mid;              // timestamp - mid 16 bits
    u_int16_t       time_high;             // timestamp - high 16 bits
    u_int8_t        clock_seq_high;        // clock - high order 8 bits
    u_int8_t        clock_seq_low;         // clock - low order 8 bits
    u_int8_t        node[6];               // node - spatial reference - unique identification like
} __attribute__((packed)) guid_t;          //        the mac address of this systems network card.

typedef struct _gpt_partition_s {
    guid_t          type;                  // GUID - identifies partition type
    guid_t          id;                    // GUID - identifies this particular partition record
    lba_t           start;                 // LBA - address of 1st block of partition
    lba_t           end;                   // LBA - address of last block of partition
    attribute_t     attributes;            // BIT FIELD - reserved by efi spec
    utf16_char_t    name[GPT_PNAME_SIZE];  // UNICODE - name of the partition
} __attribute__((packed)) gpt_partition;

typedef struct _gpt_header_s {
    u_int64_t       signature;             // EFI compatible header signature
    u_int32_t       version;               // spec revision number
    u_int32_t       size;                  // size (bytes) of gpt header
    u_int32_t       crc;                   // CRC of gpt header
    u_int32_t       reserve;               // reserved by spec ... must be zero
    lba_t           my_lba;                // LBA of gpt header
    lba_t           alternate_lba;         // LBA of 2nd copy of gpt header
    lba_t           start_useable;         // LBA of 1st block of useable area on disk
    lba_t           end_useable;           // LBA of last block of useable area on disk
    guid_t          disk_id;               // GUID - identifies this disk
    lba_t           ptable_lba;            // LBA of the partition table
    u_int32_t       ptable_count;          // number of entries in the partition table
    u_int32_t       ptable_entry_size;     // size of a partition table entry
    u_int32_t       ptable_crc;            // CRC of the partition table
} gpt_header;


// gpt partition types
extern guid_t EFI_SYSTEM_PARTITION;
extern guid_t BASIC_DATA_PARTITION;
extern guid_t LEGACY_MBR_PARTITION;
extern guid_t GPT_SWAP_PARTITION;
extern guid_t MS_RESERVED_PARTITION;
extern guid_t MS_LDM_DATA_PARTITION;
extern guid_t MS_LDM_METADATA_PARTITION;

#define MAX_TYPENAME_SIZE 48  // max partition name field size
#define BASIC_DATA_PARTITION_STRING "basic data"
#define EFI_SYSTEM_PARTITION_STRING "efi system partition"
#define LEGACY_MBR_PARTITION_STRING "legacy mbr"
#define GPT_SWAP_PARTITION_STRING "swap"

typedef enum {
    unknown_partition         = 0,
    efi_system_partition      = 1,
    basic_data_partition      = 2,
    legacy_mbr_partition      = 3,
    swap_partition            = 4,
    ms_reserved_partition     = 5,
    ms_ldm_data_partition     = 6,
    ms_ldm_metadata_partition = 7
} partition_type_t;


#define  GPT_SEG_MGR_PDATA_SIGNATURE       0x47736567   /* Gseg */

#define  SEG_CFLAG_TOP_SEGMENT                  0x00000001
#define  DISK_HAS_MOVE_PENDING                  0x00000002
#define  DISK_HAS_CHANGES_PENDING               0x00000004

typedef struct disk_private_data_s {

    u_int32_t                   signature;                /* used to validate disk private data area      */

    void                       *key;                      /* search key, address of the LOGICALDISK       */

    u_int32_t                   flags;                    /* see DISK_HAS_xxxx flags above                */

    DISKSEG                    *md1;                      /* primary copy of metadata                     */

    DISKSEG                    *md2;                      /* alternate copy of metadata                   */

    u_int32_t                   vsectors_per_block;       /* disk hardsector size >> EVMS_VSECTOR_SIZE    */
    
    copy_job_t                 *copy_job;                 /* ptr to valid copy job if a segment move is in */
                                                          /* progress ... DISK_HAS_MOVE_PENDING should be */
                                                          /* set if this is the case.                     */

} DISK_PRIVATE_DATA;


typedef struct seg_private_data_s {

    u_int32_t          signature;            /* used to validate our private data area                      */

    u_int32_t          cflags;               /* common flag definitions                                     */

    //----------------- end of segment manager common area  -----------------------

    u_int32_t          minor;                /* minor number assigned to the partition                      */

    storage_object_t  *logical_disk;         /* storage object we found the GPT partitions on               */

    gpt_header        *gh;                   /* gpt header ptr ... really only used by metadata segments    */

    partition_type_t   type;                 /* what type of gpt partition ... esp, swap, etc.              */

    attribute_t        attributes;           /* BIT FIELD - reserved by efi spec                            */

    guid_t             guid_type;            /* guid used to identify partition type                        */

    guid_t             guid_id;              /* guid used to idenfity THIS partition                        */

    utf16_char_t       name[GPT_PNAME_SIZE]; /* UNICODE - name of the partition                             */
    
    DISKSEG           *move_target;          /* used when moving segments on the disk                       */

} SEG_PRIVATE_DATA;


#endif

