/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdrivelink.so
 *
 *   File: dl_sn.h
 */
#ifndef _DL_SN_HEADER_
#define _DL_SN_HEADER_ 1

/*
 *  Needing to generate unique 32 bit serial numbers, and not having a serial 
 *  number generator handy, we'll just corrupt the use of the engine API
 *  register_name() by passing a contrived char string that has the serial number
 *  embedded within it.
 *
 *  This is the structure used to generate 32 bit serial numbers
 */
typedef struct _PSN_ {
        char               prefix[4];            /* set to our PREFIX_STRING                             */
        u_int32_t          serial_number;        /* the actual serial number                             */
        char               suffix;               /* so we can NULL terminate the pseudo character string */
} sn_t;

#define PREFIX_STRING "SN_P"                     /* Prefix used when creating pseudo names               */

#define BAD_SERIAL_NUMBER 0                      /* we need a definition for a BAD serial number         */
                                                 /* ... so it can never be 0x00                          */


u_int32_t          dl_gen_parent_serial_number( u_int32_t  guess );

u_int32_t          dl_gen_child_serial_number( storage_object_t *drivelink );


/*
 *  Function: dl_unregister_serial_number
 *
 *  This routine un-registers serial numbers with the engine
 */
static inline int dl_unregister_serial_number( u_int32_t  serial_number )
{
        sn_t  sn = { PREFIX_STRING, serial_number, 0x00 };

        return ( EngFncs->unregister_name( (char *) &sn ) );
}


/*
 *  Function: dl_register_serial_number
 *
 *  This routine registers serial numbers with the engine
 */
static inline int dl_register_serial_number( u_int32_t  serial_number )
{
        sn_t  sn = { PREFIX_STRING, serial_number, 0x00 };

        if (serial_number == BAD_SERIAL_NUMBER) {
                return EINVAL;
        }

        return ( EngFncs->register_name(  (char *) &sn ) );
}

#endif
