/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

#include <glib.h>
#include <ncurses.h>
#include <panel.h>
#include <frontend.h>

#include "common.h"
#include "window.h"
#include "menu.h"

/**
 *	update_status: updates the status line with the return code for a command
 *	@command: the name of the command/operation
 *	@rc: the return code
 *
 *	This routine updates the status bar line with the outcome of a command.
 *	If the return code not for success or the cancel return code we attempt
 *	to get a message from g_strerror() to show.
 **/
inline void update_status(char *command, int rc)
{
	gchar *status;

	if (rc == 0) {
		status = g_strdup_printf("%s command was successful.", command);
	} else if (rc == E_CANCELED) {
		status = g_strdup_printf("%s command was cancelled.", command);
	} else {
		status = g_strdup_printf("%s failed. %s.", command, evms_strerror(ABS(rc)));
	}

	print_statusbar_text(status);
	g_free(status);
}
